-- Generated by Craft v2.5.2757 on 9 Feb 2016 22:02:23.

--
-- Disable foreign key checks and autocommit.
--

SET FOREIGN_KEY_CHECKS = 0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
SET NAMES utf8;


DROP TABLE IF EXISTS `craft_assetfiles`;


--
-- Schema for table `craft_assetfiles`
--
CREATE TABLE `craft_assetfiles` (
  `id` int(11) NOT NULL,
  `sourceId` int(11) DEFAULT NULL,
  `folderId` int(11) NOT NULL,
  `filename` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `kind` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'unknown',
  `width` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_assetfiles_filename_folderId_unq_idx` (`filename`,`folderId`),
  KEY `craft_assetfiles_sourceId_fk` (`sourceId`),
  KEY `craft_assetfiles_folderId_fk` (`folderId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_assetfiles`
--

INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('226', '5', '5', 'acupuncture_151208_142757.jpg', 'image', '1500', '1000', '62836', '2015-12-08 14:27:57', '2015-12-08 14:27:57', '2015-12-08 14:32:13', '849c5c30-37bc-43e5-9317-b27e283b66a2'),
 ('227', '5', '5', 'acupuncture2_151208_142759.jpg', 'image', '1500', '1000', '66614', '2015-12-08 14:27:59', '2015-12-08 14:27:59', '2015-12-08 14:32:10', '5616cb85-ef32-4396-aba6-ae45fedf96cc'),
 ('228', '5', '5', 'acupuncture3_151208_142800.jpg', 'image', '1500', '1000', '64966', '2015-12-08 14:28:00', '2015-12-08 14:28:00', '2015-12-08 14:32:10', 'fd621206-ed80-4e59-8db6-5ab39091b81c'),
 ('229', '5', '5', 'acupuncture4_151208_142802.jpg', 'image', '1500', '1000', '72400', '2015-12-08 14:28:02', '2015-12-08 14:28:02', '2015-12-08 14:32:11', '0c3b405c-2c08-41ad-be8e-25250202c6e7'),
 ('230', '5', '5', 'acupuncture5_151208_142803.jpg', 'image', '1500', '1000', '67964', '2015-12-08 14:28:03', '2015-12-08 14:28:03', '2015-12-08 14:32:12', '62809439-2b12-43db-8890-28e269f95f69'),
 ('231', '5', '5', 'acupuncture6_151208_142804.jpg', 'image', '1500', '1000', '74082', '2015-12-08 14:28:04', '2015-12-08 14:28:04', '2015-12-08 14:32:12', 'c0164b50-aa72-4924-a89a-600a42a2b668'),
 ('232', '5', '5', 'bone_151208_142806.jpg', 'image', '1500', '1000', '99365', '2015-12-08 14:28:06', '2015-12-08 14:28:06', '2015-12-08 14:32:16', '44330f74-f7e3-4066-a16b-03f1c08eb94a'),
 ('233', '5', '5', 'gym_151208_142808.jpg', 'image', '1500', '1000', '105915', '2015-12-08 14:28:09', '2015-12-08 14:28:09', '2015-12-08 14:32:19', '500f8640-47dc-4c3a-8dd9-63c7069b8d24'),
 ('234', '5', '5', 'newspaper_151208_142814.jpg', 'image', '1500', '1000', '165267', '2015-12-08 14:28:14', '2015-12-08 14:28:14', '2015-12-08 14:32:19', 'c4ce7276-c1fe-4228-bae2-89427de9d069'),
 ('235', '5', '5', 'office_151208_142816.jpg', 'image', '1500', '1000', '96025', '2015-12-08 14:28:16', '2015-12-08 14:28:16', '2015-12-08 14:32:20', 'c1b9d944-a962-444e-a66b-2f3ea6309d6f'),
 ('236', '5', '5', 'sarah-profile1_151208_142817.jpg', 'image', '1000', '1500', '85794', '2015-12-08 14:28:17', '2015-12-08 14:28:18', '2015-12-08 14:32:23', '8ae108f1-4db8-4fd0-a00c-6a97a646531b'),
 ('237', '5', '5', 'sarah-profile2_151208_142819.jpg', 'image', '1000', '1500', '78728', '2015-12-08 14:28:19', '2015-12-08 14:28:20', '2015-12-08 14:32:26', 'b8729313-8064-44f2-a160-fc362934abbf'),
 ('238', '5', '5', 'trampette_151208_142821.jpg', 'image', '1500', '1000', '130239', '2015-12-08 14:28:21', '2015-12-08 14:28:22', '2015-12-08 14:32:28', 'e8341a8f-209d-4249-9f37-dc4f3c315325'),
 ('239', '1', '1', 'Heart-Health.jpg', 'image', '1000', '750', '170952', '2015-12-06 21:35:01', '2015-12-08 14:31:37', '2015-12-08 14:31:37', '8589c6d0-998c-416b-b7ba-fdfb83ebdd91'),
 ('240', '1', '1', 'IMG_4041-copy.jpg', 'image', '3456', '5184', '2420093', '2015-12-06 21:06:28', '2015-12-08 14:31:38', '2015-12-08 14:31:38', '137f3e61-5e27-401b-ac02-36bb9b27d37c'),
 ('241', '1', '1', 'Joint-Pain.jpg', 'image', '576', '394', '165973', '2015-11-25 16:04:24', '2015-12-08 14:31:38', '2015-12-08 14:31:39', '8b4bc256-606e-49f0-be0e-03dece25d7a5'),
 ('242', '1', '1', 'Tennis-Elbow.jpg', 'image', '300', '221', '18836', '2015-11-25 16:04:24', '2015-12-08 14:31:39', '2015-12-08 14:31:39', '3c1f4664-4f6a-484f-b2d1-7e893d5585c5'),
 ('243', '1', '1', 'acupuncture.jpg', 'image', '1500', '1000', '62836', '2015-12-07 11:58:48', '2015-12-08 14:31:40', '2015-12-08 14:31:40', '60e7ea33-a0d3-4ea5-a40b-cf96cbffa83f'),
 ('244', '1', '1', 'acupuncture2.jpg', 'image', '1500', '1000', '66614', '2015-12-07 11:58:49', '2015-12-08 14:31:41', '2015-12-08 14:31:41', '97437d0c-2b43-48c2-9def-5b8a6d5904c5'),
 ('245', '1', '1', 'acupuncture4.jpg', 'image', '1500', '1000', '72400', '2015-12-07 11:58:53', '2015-12-08 14:31:41', '2015-12-08 14:31:41', 'ba09ea87-fbbf-42c0-98aa-3e87ddd522bf'),
 ('246', '1', '1', 'acupuncture3.jpg', 'image', '1500', '1000', '64966', '2015-12-07 11:58:51', '2015-12-08 14:31:42', '2015-12-08 14:31:42', '684ff84d-c71b-4454-9bf4-382576f4b14b'),
 ('247', '1', '1', 'acupuncture5.jpg', 'image', '1500', '1000', '67964', '2015-12-07 11:58:54', '2015-12-08 14:31:42', '2015-12-08 14:31:42', '562fce48-39b5-47be-8c9e-3cd9c04e1138'),
 ('248', '1', '1', 'acupuncture6.jpg', 'image', '1500', '1000', '74082', '2015-12-07 11:58:55', '2015-12-08 14:31:43', '2015-12-08 14:31:43', 'af8633ad-7dd7-489c-b7ff-1b941c90917a'),
 ('249', '1', '1', 'banner.png', 'image', '656', '292', '209646', '2015-11-25 16:04:24', '2015-12-08 14:31:44', '2015-12-08 14:31:44', '70da9495-4d56-4142-8f51-358367f9a02a'),
 ('250', '1', '1', 'back-pain.gif-437580.gif', 'image', '590', '350', '128726', '2015-11-25 16:04:20', '2015-12-08 14:31:45', '2015-12-08 14:31:45', '49404cbe-f05c-44e2-b120-2f35020a42d1'),
 ('251', '1', '1', 'bone.jpg', 'image', '1500', '1000', '99365', '2015-12-07 11:58:57', '2015-12-08 14:31:45', '2015-12-08 14:31:45', '34eafc5c-4ea4-4ecf-bfc3-87e2442516a2'),
 ('252', '1', '1', 'gym.jpg', 'image', '1500', '1000', '105915', '2015-12-07 11:58:58', '2015-12-08 14:31:46', '2015-12-08 14:31:46', '4c6831fb-b0f8-4c89-89ad-a05e7eccc6fd'),
 ('253', '1', '1', 'healthy-walking-signpost-77422_1920.jpg', 'image', '1280', '1920', '680653', '2015-12-07 13:00:31', '2015-12-08 14:31:46', '2015-12-08 14:31:47', '3c819f64-2234-449b-8294-bb0645b04e4f'),
 ('254', '1', '1', 'heartbeat-163709_1280.jpg', 'image', '1280', '720', '129366', '2015-12-07 13:02:57', '2015-12-08 14:31:47', '2015-12-08 14:31:47', 'd947abad-da0e-4e45-a08b-c701840c6ccf'),
 ('255', '1', '1', 'istock_rf_photo_of_arthritis_pain_in_hand.jpg', 'image', '405', '225', '74128', '2015-11-25 16:04:21', '2015-12-08 14:31:48', '2015-12-08 14:31:48', '81998aac-ca70-4306-b67f-b34aec942a90'),
 ('256', '1', '1', 'newspaper-866520_1920.jpg', 'image', '1920', '1280', '581804', '2015-12-07 13:07:21', '2015-12-08 14:31:48', '2015-12-08 14:31:48', 'ef86e387-0404-4e86-a1f8-324cabbfa558'),
 ('257', '1', '1', 'newspaper.jpg', 'image', '1500', '1000', '165267', '2015-12-07 11:59:02', '2015-12-08 14:31:49', '2015-12-08 14:31:49', '12fe907d-07eb-4de4-b555-3a29e2c76f72'),
 ('258', '1', '1', 'newspaper.png', 'image', '2000', '981', '400575', '2015-12-06 21:43:05', '2015-12-08 14:31:49', '2015-12-08 14:31:50', '43d24c98-33c9-400f-9418-5768721dd65b'),
 ('259', '1', '1', 'office.jpg', 'image', '1500', '1000', '96025', '2015-12-07 11:59:04', '2015-12-08 14:31:50', '2015-12-08 14:31:50', '9126587a-2a01-4030-9751-161c38b846b6'),
 ('260', '1', '1', 'sarah-profile1.jpg', 'image', '1000', '1500', '85794', '2015-12-07 11:59:06', '2015-12-08 14:31:50', '2015-12-08 14:31:51', 'c1c84cf5-bf19-4ccd-b86e-64cffebcc70b'),
 ('261', '1', '1', 'sarah-profile2.jpg', 'image', '1000', '1500', '78728', '2015-12-07 11:59:07', '2015-12-08 14:31:51', '2015-12-08 14:31:51', 'e83b947b-f4e8-455a-9159-9fc2a8959cfd'),
 ('262', '1', '1', 'spine-957249_1280.png', 'image', '675', '1280', '522085', '2015-12-07 15:57:07', '2015-12-08 14:31:52', '2015-12-08 14:31:52', '9b9e63c3-ada1-495b-8e0b-b23a0c897e92'),
 ('263', '1', '1', 'trampette.jpg', 'image', '1500', '1000', '130239', '2015-12-07 11:59:11', '2015-12-08 14:31:52', '2015-12-08 14:31:52', 'd73aa5e8-acef-4d29-975a-ae31b1fb617a'),
 ('264', '1', '1', 'sports-injury-2.jpg', 'image', '412', '232', '42497', '2015-11-25 16:04:24', '2015-12-08 14:31:53', '2015-12-08 14:31:53', '37423593-2371-4034-b840-887c479c2090'),
 ('265', '1', '1', 'ultrasound.jpg', 'image', '1000', '1500', '105663', '2015-12-07 11:59:15', '2015-12-08 14:31:53', '2015-12-08 14:31:53', '46ab6d65-3778-4ee8-b7a0-2a34dffe686c'),
 ('266', '2', '2', 'lifetime-couple.jpg', 'image', '265', '262', '96280', '2015-11-25 16:04:26', '2015-12-08 14:31:54', '2015-12-08 14:31:54', 'd4028749-a7e9-4ff0-a91b-3f764a18b091'),
 ('267', '2', '2', 'sport-woman.jpg', 'image', '254', '252', '83428', '2015-11-25 16:04:26', '2015-12-08 14:31:55', '2015-12-08 14:31:55', '60a8b03d-4684-4dd1-a02f-c882b9ff7aa3'),
 ('268', '2', '2', 'work-man.jpg', 'image', '261', '263', '69570', '2015-11-25 16:04:27', '2015-12-08 14:31:55', '2015-12-08 14:31:55', 'd104b683-e119-45fc-8bba-5105a65dfcac'),
 ('269', '4', '4', '6f14d766-8edf-4b3c-b385-96bfed558d4c.jpg', 'image', '500', '469', '24683', '2015-11-25 16:03:39', '2015-12-08 14:31:57', '2015-12-08 14:31:57', '0103d244-215e-4fb1-b6bf-154b07e2a424'),
 ('270', '4', '4', 'BMAS-footer.png', 'image', '1666', '1995', '528848', '2015-11-25 16:03:53', '2015-12-08 14:31:58', '2015-12-08 14:31:58', '94d79f8c-26dd-405f-a7ed-378efd59138c'),
 ('271', '4', '4', 'BMAS.png', 'image', '1666', '1995', '1151507', '2015-11-25 16:04:02', '2015-12-08 14:31:58', '2015-12-08 14:31:59', '163e147d-f686-4adc-877e-2d6be0ceb21a'),
 ('272', '4', '4', 'BMAS-logo.jpg', 'image', '1666', '1995', '846047', '2015-11-25 16:03:48', '2015-12-08 14:31:59', '2015-12-08 14:32:00', '958293f3-97fd-430d-a986-4c19ccf76a43'),
 ('273', '4', '4', 'MACP_logo.png', 'image', '1582', '771', '85351', '2015-12-01 17:09:58', '2015-12-08 14:32:00', '2015-12-08 14:32:00', '26363f0a-8594-4be5-8c3f-d0dfa2158c78'),
 ('274', '4', '4', 'MACP_logo_reverse.png', 'image', '1582', '771', '77283', '2015-12-01 17:09:59', '2015-12-08 14:32:01', '2015-12-08 14:32:01', 'd7d7a8f1-de12-40bf-abb7-7887e3d115d5'),
 ('275', '4', '4', 'csp-footer.png', 'image', '295', '171', '202337', '2015-11-25 16:04:01', '2015-12-08 14:32:02', '2015-12-08 14:32:02', '61471153-b8a8-4de2-a1cd-65d329e93b5e'),
 ('276', '4', '4', 'hpc-footer.png', 'image', '300', '217', '261092', '2015-11-25 16:04:06', '2015-12-08 14:32:02', '2015-12-08 14:32:02', 'e25d92e0-189c-4a9e-8824-77884b46f202'),
 ('277', '4', '4', 'csp.png', 'image', '295', '171', '202337', '2015-11-25 16:04:05', '2015-12-08 14:32:03', '2015-12-08 14:32:03', '601746d3-dc4e-4984-a05c-9bdd17fc13cf'),
 ('278', '4', '4', 'hpc-logo-registered.jpg', 'image', '300', '217', '30673', '2015-11-25 16:04:06', '2015-12-08 14:32:03', '2015-12-08 14:32:03', 'c1eaefe7-9ce5-4ba1-98cb-c96d3c8d6246'),
 ('279', '4', '4', 'hpc.png', 'image', '300', '217', '261092', '2015-11-25 16:04:14', '2015-12-08 14:32:03', '2015-12-08 14:32:03', 'b38dfd25-7ed7-451f-bc9a-ce9220a5ecb7'),
 ('280', '4', '4', 'physio-first.png', 'image', '500', '469', '151355', '2015-11-25 16:04:08', '2015-12-08 14:32:04', '2015-12-08 14:32:04', '87569dfa-dd71-4bdd-a4c3-0e6766f0fed0'),
 ('281', '4', '4', 'imgres.png', 'image', '295', '171', '16517', '2015-11-25 16:04:06', '2015-12-08 14:32:04', '2015-12-08 14:32:04', '808a7568-b08b-4330-b6b9-f28cc223b783'),
 ('282', '4', '4', 'physio-footer.png', 'image', '500', '469', '133399', '2015-11-25 16:04:10', '2015-12-08 14:32:04', '2015-12-08 14:32:05', '9512af8e-0a3c-44b2-ac1f-81627b2ac634'),
 ('283', '4', '4', 'physiofirst-footer.png', 'image', '500', '469', '940040', '2015-11-25 16:04:19', '2015-12-08 14:32:05', '2015-12-08 14:32:05', 'd3aabc13-a79d-4837-b536-8174b7884650'),
 ('284', '5', '5', 'IMG_3984-copy.jpg', 'image', '5184', '3456', '2438751', '2015-12-04 16:09:41', '2015-12-08 14:32:06', '2015-12-08 14:32:06', 'cac6cb01-1723-4ee5-be8c-13fd14ff34bb'),
 ('285', '5', '5', 'IMG_4041-copy.jpg', 'image', '3456', '5184', '2420093', '2015-12-06 22:08:20', '2015-12-08 14:32:07', '2015-12-08 14:32:07', '54894aeb-c141-481f-b252-c7d14f5096a9'),
 ('286', '5', '5', 'IMG_4028-copy.jpg', 'image', '5184', '3456', '3253383', '2015-12-06 22:48:52', '2015-12-08 14:32:07', '2015-12-08 14:32:08', '7a273466-ccca-47fd-982a-3e4d43758c38'),
 ('287', '5', '5', 'acupuncture.jpg', 'image', '1500', '1000', '62836', '2015-12-07 11:57:00', '2015-12-08 14:32:08', '2015-12-08 14:32:08', '5642adaa-69ed-41c1-b430-2405a4f7c95f'),
 ('288', '5', '5', 'IMG_4053-copy.jpg', 'image', '5184', '3456', '2534522', '2015-12-06 22:10:16', '2015-12-08 14:32:08', '2015-12-08 14:32:09', '2e949d9b-7bcb-4ff4-8573-8436d9301165'),
 ('289', '5', '5', 'acupuncture2.jpg', 'image', '1500', '1000', '66614', '2015-12-07 11:57:01', '2015-12-08 14:32:09', '2015-12-08 14:32:09', 'be342034-1b16-4a0e-b09e-27d4ca6ec8f4'),
 ('290', '5', '5', 'acupuncture3.jpg', 'image', '1500', '1000', '64966', '2015-12-07 11:57:03', '2015-12-08 14:32:10', '2015-12-08 14:32:10', 'd16699e9-ac90-4514-bcb5-8c31e571085c'),
 ('291', '5', '5', 'acupuncture4.jpg', 'image', '1500', '1000', '72400', '2015-12-07 11:57:04', '2015-12-08 14:32:11', '2015-12-08 14:32:11', '8d239858-a139-45c6-9ae9-b6dfc2eef13d'),
 ('292', '5', '5', 'acupuncture5.jpg', 'image', '1500', '1000', '67964', '2015-12-07 11:57:05', '2015-12-08 14:32:11', '2015-12-08 14:32:11', '4b9f38e0-a717-4905-b779-c670ab09e7fc'),
 ('293', '5', '5', 'acupuncture6.jpg', 'image', '1500', '1000', '74082', '2015-12-07 11:57:07', '2015-12-08 14:32:12', '2015-12-08 14:32:12', '6d62e6dd-a55b-4974-9d09-6217a908333c'),
 ('294', '5', '5', 'bone_151207_115708.jpg', 'image', '1500', '1000', '99365', '2015-12-07 11:57:08', '2015-12-08 14:32:14', '2015-12-08 14:32:14', 'b48a7507-8b0f-4fd3-9180-a70ae7b4254e'),
 ('295', '5', '5', 'bone_151206_231008.jpg', 'image', '5184', '3456', '3253383', '2015-12-06 23:10:08', '2015-12-08 14:32:15', '2015-12-08 14:32:15', '0c12c32f-6c2b-4512-8a37-88b789166639'),
 ('296', '5', '5', 'cont-interior.jpg', 'image', '5184', '3456', '1389988', '2015-12-04 16:10:22', '2015-12-08 14:32:17', '2015-12-08 14:32:17', '4462799f-5dbf-4541-8370-3851f8ccc9db'),
 ('297', '5', '5', 'bone.jpg', 'image', '5184', '3456', '3253383', '2015-12-06 22:56:06', '2015-12-08 14:32:17', '2015-12-08 14:32:18', '4f8cc54f-acdd-4d5b-8cd0-714934d5d504'),
 ('298', '5', '5', 'gym.jpg', 'image', '1500', '1000', '105915', '2015-12-07 11:57:11', '2015-12-08 14:32:18', '2015-12-08 14:32:18', '0b155891-50ec-4b02-8506-1c538fc8878e'),
 ('299', '5', '5', 'newspaper.jpg', 'image', '1500', '1000', '165267', '2015-12-07 11:57:16', '2015-12-08 14:32:19', '2015-12-08 14:32:19', 'f45a4027-9398-44a2-85f5-6c1de87ac688'),
 ('300', '5', '5', 'office.jpg', 'image', '1500', '1000', '96025', '2015-12-07 11:57:18', '2015-12-08 14:32:19', '2015-12-08 14:32:19', '893d3e1c-177d-4098-b4f4-d346358402d2'),
 ('301', '5', '5', 'sarah-profile1.jpg', 'image', '1000', '1500', '85794', '2015-12-07 11:57:20', '2015-12-08 14:32:21', '2015-12-08 14:32:21', 'f16dfc6b-3ded-4742-88dd-3071590f81b0'),
 ('302', '5', '5', 'sarah-profile.png', 'image', '208', '196', '87149', '2015-11-25 16:03:38', '2015-12-08 14:32:21', '2015-12-08 14:32:21', '89ccb92d-99c8-444f-9435-7fb08b183b2e'),
 ('303', '5', '5', 'sarah-profile2.jpg', 'image', '1000', '1500', '78728', '2015-12-07 11:57:22', '2015-12-08 14:32:23', '2015-12-08 14:32:24', 'a9d142fc-c95c-4eff-a807-597566c13091'),
 ('304', '5', '5', 'trampette.jpg', 'image', '5184', '3456', '3082710', '2015-12-04 20:57:31', '2015-12-08 14:32:24', '2015-12-08 14:32:25', '9b9a154d-e686-4b49-8860-07f7d6d3ce2f'),
 ('305', '5', '5', 'trampette_151204_210703.jpg', 'image', '5184', '3456', '3082710', '2015-12-04 21:07:03', '2015-12-08 14:32:25', '2015-12-08 14:32:26', 'e4e806f2-d391-414b-ac05-f9f65584f38f'),
 ('306', '5', '5', 'trampette_151204_212322.jpg', 'image', '5184', '3456', '3082710', '2015-12-04 21:23:23', '2015-12-08 14:32:27', '2015-12-08 14:32:27', '028853f6-a147-486f-9274-a8066446697d'),
 ('307', '5', '5', 'trampette_151207_115724.jpg', 'image', '1500', '1000', '130239', '2015-12-07 11:57:24', '2015-12-08 14:32:28', '2015-12-08 14:32:28', '6cf425d6-4203-42fd-9fd2-660180c67b5b'),
 ('308', '5', '5', 'ultrasound.jpg', 'image', '1000', '1500', '105663', '2015-12-07 11:57:26', '2015-12-08 14:32:29', '2015-12-08 14:32:29', '4592c261-4301-4232-be56-5f5bc5916a72'),
 ('309', '5', '5', 'wZGX_w9OUblVAajGCKA_uVWPWyL6HkG_jN0-gWjOUi4PvDzBhTAFO1L9eafkc8sWHdBTdK2xjDQUrDgK7sjl8A.jpg', 'image', '1066', '1600', '103930', '2015-12-01 17:09:58', '2015-12-08 14:32:29', '2015-12-08 14:32:29', 'c858edb7-a224-472c-836a-686398690ccd'),
 ('310', '5', '5', 'trampette_151204_221047.jpg', 'image', '5184', '3456', '3082710', '2015-12-04 22:10:47', '2015-12-08 14:32:30', '2015-12-08 14:32:30', '1762424d-7ac4-411f-9f20-9e071952b8e5'),
 ('311', '6', '6', 'IMG_3984-copy.jpg', 'image', '5184', '3456', '2438751', '2015-12-04 16:09:41', '2015-12-08 14:32:31', '2015-12-08 14:32:32', '5b898988-5695-4ed6-ad98-73b9b5693baf'),
 ('312', '6', '6', 'IMG_4041-copy.jpg', 'image', '3456', '5184', '2420093', '2015-12-06 22:08:20', '2015-12-08 14:32:33', '2015-12-08 14:32:34', '2e3cf3fe-6878-4b81-8b7b-8485a3ef1c42'),
 ('313', '6', '6', 'IMG_4028-copy.jpg', 'image', '5184', '3456', '3253383', '2015-12-06 22:48:52', '2015-12-08 14:32:34', '2015-12-08 14:32:35', 'cd965f75-e1c8-4fd1-a455-36848e64b6c4'),
 ('314', '6', '6', 'acupuncture.jpg', 'image', '1500', '1000', '62836', '2015-12-07 11:57:00', '2015-12-08 14:32:35', '2015-12-08 14:32:35', 'e3e4f113-4f9d-47ce-927e-4d64e10c66cb'),
 ('315', '6', '6', 'IMG_4053-copy.jpg', 'image', '5184', '3456', '2534522', '2015-12-06 22:10:16', '2015-12-08 14:32:36', '2015-12-08 14:32:36', 'e131bc86-d2f1-4a07-bddf-760429b678ab'),
 ('316', '6', '6', 'acupuncture2_151208_142759.jpg', 'image', '1500', '1000', '66614', '2015-12-08 14:27:59', '2015-12-08 14:32:38', '2015-12-08 14:32:38', '1c8a0f84-72a6-47ef-a1a4-41b6fb205ae0'),
 ('317', '6', '6', 'acupuncture3.jpg', 'image', '1500', '1000', '64966', '2015-12-07 11:57:03', '2015-12-08 14:32:38', '2015-12-08 14:32:38', '5d6c004e-944d-401b-b713-6f96d30604d3'),
 ('318', '6', '6', 'acupuncture2.jpg', 'image', '1500', '1000', '66614', '2015-12-07 11:57:01', '2015-12-08 14:32:38', '2015-12-08 14:32:39', 'f2493241-f883-483b-8059-c5a94871d3d1'),
 ('319', '6', '6', 'acupuncture3_151208_142800.jpg', 'image', '1500', '1000', '64966', '2015-12-08 14:28:00', '2015-12-08 14:32:39', '2015-12-08 14:32:39', 'd68178e0-ba2a-4991-a14d-d3fcbe772202'),
 ('320', '6', '6', 'acupuncture5.jpg', 'image', '1500', '1000', '67964', '2015-12-07 11:57:05', '2015-12-08 14:32:40', '2015-12-08 14:32:40', '793a38ed-fe95-4426-865a-238aa0cdc79c'),
 ('321', '6', '6', 'acupuncture4_151208_142802.jpg', 'image', '1500', '1000', '72400', '2015-12-08 14:28:02', '2015-12-08 14:32:41', '2015-12-08 14:32:41', 'ffa45be1-1e18-4347-99ca-c8b09542bcb7'),
 ('322', '6', '6', 'acupuncture4.jpg', 'image', '1500', '1000', '72400', '2015-12-07 11:57:04', '2015-12-08 14:32:41', '2015-12-08 14:32:41', '10ec9168-63c3-4998-af10-b23658f1921c'),
 ('323', '6', '6', 'acupuncture5_151208_142803.jpg', 'image', '1500', '1000', '67964', '2015-12-08 14:28:03', '2015-12-08 14:32:42', '2015-12-08 14:32:42', 'cd1b8e33-ce07-401f-a79a-c32e9fc37879'),
 ('324', '6', '6', 'acupuncture6.jpg', 'image', '1500', '1000', '74082', '2015-12-07 11:57:07', '2015-12-08 14:32:42', '2015-12-08 14:32:42', '377c5090-6ca1-4ad5-b921-0e7370aca78e'),
 ('325', '6', '6', 'acupuncture6_151208_142804.jpg', 'image', '1500', '1000', '74082', '2015-12-08 14:28:04', '2015-12-08 14:32:43', '2015-12-08 14:32:43', '75b66164-957a-4224-885f-c5d6732f5640');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('326', '6', '6', 'acupuncture_151208_142757.jpg', 'image', '1500', '1000', '62836', '2015-12-08 14:27:57', '2015-12-08 14:32:43', '2015-12-08 14:32:43', 'e02a07c1-b4c5-421f-803f-f229c345576e'),
 ('327', '6', '6', 'bone.jpg', 'image', '5184', '3456', '3253383', '2015-12-06 22:56:06', '2015-12-08 14:32:44', '2015-12-08 14:32:45', 'f01fa6b8-2b59-4bac-aa71-4fbfbab0369a'),
 ('328', '6', '6', 'bone_151206_231008.jpg', 'image', '5184', '3456', '3253383', '2015-12-06 23:10:08', '2015-12-08 14:32:45', '2015-12-08 14:32:46', '0abb1ba9-8608-4f63-8531-df1f5cbb015f'),
 ('329', '6', '6', 'bone_151207_115708.jpg', 'image', '1500', '1000', '99365', '2015-12-07 11:57:08', '2015-12-08 14:32:46', '2015-12-08 14:32:46', 'd1e5ca74-f5fb-48b7-8396-3fa000f0785c'),
 ('330', '6', '6', 'bone_151208_142806.jpg', 'image', '1500', '1000', '99365', '2015-12-08 14:28:06', '2015-12-08 14:32:46', '2015-12-08 14:32:47', '9d501786-d10c-4e2c-8b4d-6368c3bd1c5f'),
 ('331', '6', '6', 'gym.jpg', 'image', '1500', '1000', '105915', '2015-12-07 11:57:11', '2015-12-08 14:32:47', '2015-12-08 14:32:47', '07f1ace7-b97b-4159-9d50-7c5c7a380964'),
 ('332', '6', '6', 'cont-interior.jpg', 'image', '5184', '3456', '1389988', '2015-12-04 16:10:22', '2015-12-08 14:32:48', '2015-12-08 14:32:48', '0fbb8fcc-5a78-44bd-abaa-9a0def6a143e'),
 ('333', '6', '6', 'newspaper.jpg', 'image', '1500', '1000', '165267', '2015-12-07 11:57:16', '2015-12-08 14:32:48', '2015-12-08 14:32:48', 'a3b1c87d-8113-4922-a178-657ae9378aac'),
 ('334', '6', '6', 'gym_151208_142808.jpg', 'image', '1500', '1000', '105915', '2015-12-08 14:28:09', '2015-12-08 14:32:49', '2015-12-08 14:32:49', '860cefbb-6fd9-49a2-a506-bfe9be86d330'),
 ('335', '6', '6', 'newspaper_151208_142814.jpg', 'image', '1500', '1000', '165267', '2015-12-08 14:28:14', '2015-12-08 14:32:49', '2015-12-08 14:32:49', '5ff15599-3299-4d2d-a77c-68ab6eccb4d0'),
 ('336', '6', '6', 'office.jpg', 'image', '1500', '1000', '96025', '2015-12-07 11:57:18', '2015-12-08 14:32:50', '2015-12-08 14:32:50', 'a0e2c190-a108-4190-b8af-149852a67980'),
 ('337', '6', '6', 'office_151208_142816.jpg', 'image', '1500', '1000', '96025', '2015-12-08 14:28:16', '2015-12-08 14:32:50', '2015-12-08 14:32:50', '8557e1ad-326f-4771-b8fc-2d4fc06bc9d6'),
 ('338', '6', '6', 'sarah-profile.png', 'image', '208', '196', '87149', '2015-11-25 16:03:38', '2015-12-08 14:32:51', '2015-12-08 14:32:52', '481ab46c-c5ed-408b-af06-8559d05bf320'),
 ('339', '6', '6', 'sarah-profile1.jpg', 'image', '1000', '1500', '85794', '2015-12-07 11:57:20', '2015-12-08 14:32:52', '2015-12-08 14:32:52', 'e906ba60-39dd-4d36-ab4e-62ee909179f9'),
 ('340', '6', '6', 'sarah-profile2.jpg', 'image', '1000', '1500', '78728', '2015-12-07 11:57:22', '2015-12-08 14:32:52', '2015-12-08 14:32:52', '4bfdb01a-7c32-4ba9-a666-1f9be24b21d5'),
 ('341', '6', '6', 'sarah-profile1_151208_142817.jpg', 'image', '1000', '1500', '85794', '2015-12-08 14:28:17', '2015-12-08 14:32:53', '2015-12-08 14:32:53', 'ee9c8139-84ad-4545-b305-d7f2caef5c74'),
 ('342', '6', '6', 'sarah-profile2_151208_142819.jpg', 'image', '1000', '1500', '78728', '2015-12-08 14:28:19', '2015-12-08 14:32:53', '2015-12-08 14:32:53', 'ab5f13e4-6bdb-43ca-a263-dfdeea207f8b'),
 ('343', '6', '6', 'trampette.jpg', 'image', '5184', '3456', '3082710', '2015-12-04 20:57:31', '2015-12-08 14:32:54', '2015-12-08 14:32:54', '96f028a8-55d3-43bd-9038-32de0ebbe0ff'),
 ('344', '6', '6', 'trampette_151204_210703.jpg', 'image', '5184', '3456', '3082710', '2015-12-04 21:07:03', '2015-12-08 14:32:54', '2015-12-08 14:32:55', '9898221b-92a2-4f59-a62a-d565138b061d'),
 ('345', '6', '6', 'trampette_151204_212322.jpg', 'image', '5184', '3456', '3082710', '2015-12-04 21:23:23', '2015-12-08 14:32:55', '2015-12-08 14:32:56', '315adc19-eac1-4a4f-be9a-1d0e85664ee9'),
 ('346', '6', '6', 'trampette_151204_221047.jpg', 'image', '5184', '3456', '3082710', '2015-12-04 22:10:47', '2015-12-08 14:32:56', '2015-12-08 14:32:57', 'c60f743c-4068-42bf-8eda-2cef2cf56500'),
 ('347', '6', '6', 'trampette_151208_142821.jpg', 'image', '1500', '1000', '130239', '2015-12-08 14:28:21', '2015-12-08 14:32:57', '2015-12-08 14:32:57', '619b16b7-bbdc-491a-b084-0b48e49cb3d5'),
 ('348', '6', '6', 'trampette_151207_115724.jpg', 'image', '1500', '1000', '130239', '2015-12-07 11:57:24', '2015-12-08 14:32:57', '2015-12-08 14:32:57', '5ae21da5-309a-4fbc-a532-9990ce041ce9'),
 ('349', '6', '6', 'wZGX_w9OUblVAajGCKA_uVWPWyL6HkG_jN0-gWjOUi4PvDzBhTAFO1L9eafkc8sWHdBTdK2xjDQUrDgK7sjl8A.jpg', 'image', '1066', '1600', '103930', '2015-12-01 17:09:58', '2015-12-08 14:32:58', '2015-12-08 14:32:58', '0802cb40-ff9d-4908-aac0-bc9198736f86'),
 ('350', '6', '6', 'ultrasound.jpg', 'image', '1000', '1500', '105663', '2015-12-07 11:57:26', '2015-12-08 14:32:59', '2015-12-08 14:32:59', 'e642b3c3-b18e-4cd8-b346-d79c95e53d30'),
 ('352', '1', '1', 'logo.png', 'image', '144', '84', '8565', '2015-12-10 21:24:14', '2015-12-10 21:24:14', '2015-12-10 21:24:14', 'c7adede4-3682-4aa7-adc4-8c5bede637b5'),
 ('355', '1', '1', 'savings.jpeg', 'image', '640', '560', '123604', '2016-01-07 12:01:20', '2016-01-07 12:01:20', '2016-01-07 12:01:20', 'c5f7d949-5979-4b18-bf72-41eea3e1a6e6'),
 ('358', '1', '1', 'naturel-spa.jpg', 'image', '700', '408', '57721', '2016-01-12 11:35:42', '2016-01-12 11:35:42', '2016-01-12 11:35:42', 'f2be3f07-312e-415a-b380-18ce7f09905d'),
 ('359', '1', '1', 'exeter-living.png', 'image', '400', '400', '275418', '2016-01-12 21:13:04', '2016-01-12 21:13:04', '2016-01-12 21:13:04', '4c9f02a9-f7b3-445d-8c1e-9e50ff8803f7'),
 ('361', '1', '1', 'bupa-logo.png', 'image', '400', '400', '19161', '2016-02-09 21:47:20', '2016-02-09 21:33:48', '2016-02-09 21:47:25', 'afb3d2d5-d64f-4ca1-a1f6-66a69bd32daf'),
 ('362', '1', '1', 'WPA.jpg', 'image', '308', '253', '43889', '2016-02-09 21:33:55', '2016-02-09 21:33:55', '2016-02-09 21:33:55', '7f2fd5e2-7cc6-414a-b76b-089f6825cacb'),
 ('363', '1', '1', 'VitalityHealth-logo.png', 'image', '230', '100', '11066', '2016-02-09 21:34:04', '2016-02-09 21:34:05', '2016-02-09 21:34:05', '689f68a1-f8e0-4227-a3bc-0db5b58cde5d'),
 ('364', '1', '1', 'mdg_logo-web2.jpg', 'image', '217', '74', '5084', '2016-02-09 21:34:14', '2016-02-09 21:34:14', '2016-02-09 21:34:14', '4a9eb940-662d-4c5f-bcd8-8f79bfcf660b'),
 ('365', '1', '1', 'private-health-insurance.jpg', 'image', '2800', '1867', '2095508', '2016-02-09 21:43:41', '2016-02-09 21:43:41', '2016-02-09 21:43:41', '11557076-e2c0-4814-86e3-f43852c366f1');



DROP TABLE IF EXISTS `craft_assetfolders`;


--
-- Schema for table `craft_assetfolders`
--
CREATE TABLE `craft_assetfolders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parentId` int(11) DEFAULT NULL,
  `sourceId` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_assetfolders_name_parentId_sourceId_unq_idx` (`name`,`parentId`,`sourceId`),
  KEY `craft_assetfolders_parentId_fk` (`parentId`),
  KEY `craft_assetfolders_sourceId_fk` (`sourceId`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_assetfolders`
--

INSERT INTO `craft_assetfolders` (`id`, `parentId`, `sourceId`, `name`, `path`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', NULL, '1', 'News Images', '', '2015-11-13 12:07:01', '2015-11-13 12:07:01', 'dcc4c854-7c89-4f71-9a71-82fb38a61fa4'),
 ('2', NULL, '2', 'Treatment Images', '', '2015-11-13 12:10:07', '2015-11-13 12:10:07', 'e9fbf936-671b-4980-8af5-5b874e4dee57'),
 ('4', NULL, '4', 'Accreditation images', '', '2015-11-25 13:46:10', '2015-11-25 13:46:10', '4ee9bda3-5295-44e3-8423-f162afe1242f'),
 ('5', NULL, '5', 'Clinic Photos', '', '2015-12-04 15:30:16', '2015-12-04 15:30:16', '32af47e2-4811-4f7b-8042-9986cbfc4583'),
 ('6', NULL, '6', 'About Us Images', '', '2015-12-04 16:36:37', '2015-12-04 16:36:37', '0ff5cb92-38e9-4b18-82c0-db675c70c20b');



DROP TABLE IF EXISTS `craft_assetindexdata`;


--
-- Schema for table `craft_assetindexdata`
--
CREATE TABLE `craft_assetindexdata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sessionId` varchar(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sourceId` int(10) NOT NULL,
  `offset` int(10) NOT NULL,
  `uri` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `size` int(10) DEFAULT NULL,
  `recordId` int(10) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_assetindexdata_sessionId_sourceId_offset_unq_idx` (`sessionId`,`sourceId`,`offset`),
  KEY `craft_assetindexdata_sourceId_fk` (`sourceId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_assetsources`;


--
-- Schema for table `craft_assetsources`
--
CREATE TABLE `craft_assetsources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `settings` text COLLATE utf8_unicode_ci,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `fieldLayoutId` int(10) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_assetsources_name_unq_idx` (`name`),
  UNIQUE KEY `craft_assetsources_handle_unq_idx` (`handle`),
  KEY `craft_assetsources_fieldLayoutId_fk` (`fieldLayoutId`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_assetsources`
--

INSERT INTO `craft_assetsources` (`id`, `name`, `handle`, `type`, `settings`, `sortOrder`, `fieldLayoutId`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', 'News Images', 'newsImages', 'Local', '{\"path\":\"assets\\/uploads\\/news-images\\/\",\"url\":\"\\/assets\\/uploads\\/news-images\\/\"}', '1', '125', '2015-11-13 12:07:01', '2015-12-04 10:22:08', '62160689-fc39-4ace-911a-fdf233b50a06'),
 ('2', 'Treatment Images', 'treatmentImages', 'Local', '{\"path\":\"assets\\/uploads\\/treatment-images\\/\",\"url\":\"\\/assets\\/uploads\\/treatment-images\\/\"}', '2', '126', '2015-11-13 12:10:07', '2015-12-04 10:22:16', '8d815068-711f-4c1a-8087-4642a3558f1f'),
 ('4', 'Accreditation images', 'accreditationImages', 'Local', '{\"path\":\"assets\\/uploads\\/accreditation-images\\/\",\"url\":\"\\/assets\\/uploads\\/accreditation-images\\/\"}', '4', '128', '2015-11-25 13:46:10', '2015-12-04 10:22:32', '062714fb-b415-43c5-bd83-3f6fc5bda171'),
 ('5', 'Clinic Photos', 'clinicPhotos', 'Local', '{\"path\":\"assets\\/uploads\\/about-us-images\\/\",\"url\":\"\\/assets\\/uploads\\/about-us-images\\/\"}', '5', '132', '2015-12-04 15:30:16', '2015-12-04 15:30:16', '4ae0961f-09ea-4ab3-a0d9-2a5cd029e892'),
 ('6', 'About Us Images', 'aboutUsImages', 'Local', '{\"path\":\"assets\\/uploads\\/about-us-images\\/\",\"url\":\"\\/assets\\/uploads\\/about-us-images\\/\"}', '6', '141', '2015-12-04 16:36:37', '2015-12-04 16:36:37', 'a53d3eac-f35d-4789-8a4b-f92883f54269');



DROP TABLE IF EXISTS `craft_assettransformindex`;


--
-- Schema for table `craft_assettransformindex`
--
CREATE TABLE `craft_assettransformindex` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fileId` int(11) NOT NULL,
  `filename` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `format` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sourceId` int(11) DEFAULT NULL,
  `fileExists` tinyint(1) DEFAULT NULL,
  `inProgress` tinyint(1) DEFAULT NULL,
  `dateIndexed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_assettransformindex_sourceId_fileId_location_idx` (`sourceId`,`fileId`,`location`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_assettransforms`;


--
-- Schema for table `craft_assettransforms`
--
CREATE TABLE `craft_assettransforms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mode` enum('stretch','fit','crop') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'crop',
  `position` enum('top-left','top-center','top-right','center-left','center-center','center-right','bottom-left','bottom-center','bottom-right') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'center-center',
  `height` int(10) DEFAULT NULL,
  `width` int(10) DEFAULT NULL,
  `format` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quality` int(10) DEFAULT NULL,
  `dimensionChangeTime` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_assettransforms_name_unq_idx` (`name`),
  UNIQUE KEY `craft_assettransforms_handle_unq_idx` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_assettransforms`
--

INSERT INTO `craft_assettransforms` (`id`, `name`, `handle`, `mode`, `position`, `height`, `width`, `format`, `quality`, `dimensionChangeTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', 'Square Large', 'squareLarge', 'crop', 'center-center', '250', '250', NULL, NULL, '2015-11-13 12:12:15', '2015-11-13 12:12:15', '2015-11-13 12:12:15', 'faced37a-ea05-47fd-a070-94eccd5d4b0f'),
 ('2', 'Square Thumb', 'squareThumb', 'crop', 'center-center', '75', '75', NULL, NULL, '2015-11-13 12:13:09', '2015-11-13 12:13:09', '2015-11-13 12:13:09', 'd25e0ea0-5622-497b-815e-43e3befd4c49'),
 ('3', 'Square Medium', 'squareMedium', 'crop', 'center-center', '135', '135', NULL, NULL, '2015-11-13 12:14:04', '2015-11-13 12:14:04', '2015-11-13 12:14:04', 'acc03a18-e0f0-4ead-8f6f-09868f07cd34'),
 ('4', 'Accred Large', 'accredLarge', 'fit', 'center-center', '100', NULL, NULL, '82', '2015-11-25 14:43:26', '2015-11-25 13:50:11', '2015-12-02 08:59:09', '6f931167-2d9f-4084-9dc5-60b819dc1957'),
 ('5', 'Accred Small', 'accredSmall', 'fit', 'center-center', '60', NULL, NULL, '82', '2015-11-25 14:43:34', '2015-11-25 13:51:56', '2015-12-02 08:59:09', 'cb48b7ce-90d0-4868-875b-d1ab41c36013'),
 ('6', 'Page Photos', 'pagePhotos', 'crop', 'center-center', '404', '612', NULL, NULL, '2015-12-07 15:33:15', '2015-12-07 15:30:49', '2015-12-08 14:21:50', '41f77c98-23e9-4325-b585-92753608c1b7');



DROP TABLE IF EXISTS `craft_categories`;


--
-- Schema for table `craft_categories`
--
CREATE TABLE `craft_categories` (
  `id` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_categories_groupId_fk` (`groupId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_categorygroups`;


--
-- Schema for table `craft_categorygroups`
--
CREATE TABLE `craft_categorygroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `hasUrls` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `template` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_categorygroups_name_unq_idx` (`name`),
  UNIQUE KEY `craft_categorygroups_handle_unq_idx` (`handle`),
  KEY `craft_categorygroups_structureId_fk` (`structureId`),
  KEY `craft_categorygroups_fieldLayoutId_fk` (`fieldLayoutId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_categorygroups_i18n`;


--
-- Schema for table `craft_categorygroups_i18n`
--
CREATE TABLE `craft_categorygroups_i18n` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `urlFormat` text COLLATE utf8_unicode_ci,
  `nestedUrlFormat` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_categorygroups_i18n_groupId_locale_unq_idx` (`groupId`,`locale`),
  KEY `craft_categorygroups_i18n_locale_fk` (`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_content`;


--
-- Schema for table `craft_content`
--
CREATE TABLE `craft_content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_telephone` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_email` text COLLATE utf8_unicode_ci,
  `field_twitter` text COLLATE utf8_unicode_ci,
  `field_mainHeading` text COLLATE utf8_unicode_ci,
  `field_introParagraph` text COLLATE utf8_unicode_ci,
  `field_facebook` text COLLATE utf8_unicode_ci,
  `field_treatmentName` text COLLATE utf8_unicode_ci,
  `field_treatmentDescription` text COLLATE utf8_unicode_ci,
  `field_initialAssessment` text COLLATE utf8_unicode_ci,
  `field_subsequentTreatments` text COLLATE utf8_unicode_ci,
  `field_metaCanonical` text COLLATE utf8_unicode_ci,
  `field_metaDescription` varchar(160) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_metaRobots` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'INDEX, FOLLOW',
  `field_metaTitle` varchar(55) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_article` text COLLATE utf8_unicode_ci,
  `field_headline` varchar(120) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_articleIntro` text COLLATE utf8_unicode_ci,
  `field_googleAnalytics` text COLLATE utf8_unicode_ci,
  `field_references` text COLLATE utf8_unicode_ci,
  `field_initialAssess` text COLLATE utf8_unicode_ci,
  `field_subsequentTreat` text COLLATE utf8_unicode_ci,
  `field_sidebarDisplay` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_linksSection` text COLLATE utf8_unicode_ci,
  `field_imagesPosition` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_content_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_content_title_idx` (`title`),
  KEY `craft_content_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=306 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_content`
--

INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `field_initialAssess`, `field_subsequentTreat`, `field_sidebarDisplay`, `field_linksSection`, `field_imagesPosition`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '1', 'en_gb', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-04 11:36:29', '2015-11-04 11:36:29', 'cdc2e64a-5488-46b9-8ed8-d3861d90f7a1'),
 ('2', '2', 'en_gb', 'Homepage', NULL, NULL, NULL, 'Experienced Exeter Physio\r\n18+ Years Delivering Excellence', 'Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. ', NULL, NULL, NULL, NULL, NULL, '', 'We treat a wide range of problems through musculoskeletal physiotherapy and our pricing is competitive. Call 01392 434832', 'INDEX, FOLLOW', 'Exeter Physio - Cathedral Physiotherapy, Devon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-04 11:36:32', '2016-01-15 09:33:11', '3f42a854-4694-4ba3-94d7-7b332833e272'),
 ('4', '4', 'en_gb', 'About', NULL, NULL, NULL, 'Providing the best care', 'Excellence, experience and enthusiasm – three qualities delivered by Cathedral Physiotherapy.\r\n\r\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.', NULL, NULL, NULL, NULL, NULL, '', 'Find out about Sarah Moore - highly qualified and enthusiastic physiotherapist with over 18 years experience of treating a range of complex conditions.', 'INDEX, FOLLOW', ' Exeter physio with 18 years of experience', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-10 16:22:36', '2015-12-08 17:18:10', '194338b9-92e7-443c-b027-8961c156d05b'),
 ('5', '5', 'en_gb', 'Accreditations', NULL, NULL, NULL, 'Accreditations', 'To ensure your safety, Cathedral Physiotherapy is regulated and governed by the following bodies.', NULL, NULL, NULL, NULL, NULL, '', 'Accredited and regulated by the Chartered Society of Physiotherapy and other professional bodies to ensure your safety and well being.', 'INDEX, FOLLOW', 'Full accredited Exeter Physio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-10 16:24:52', '2015-12-08 17:18:33', 'd406bb17-d4f1-424d-81b6-fec342d537cf'),
 ('7', '7', 'en_gb', NULL, '01392 434832', 'enquiries@cathedralphysiotherapy.co.uk', '@cathedralphysio', NULL, NULL, 'https://www.facebook.com/cathedralphysiotherapy', NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, 'UA-70464796-1', NULL, '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, '0', '2015-11-10 16:28:51', '2015-12-04 22:09:30', '08a821e4-a54c-4754-aaa5-f6be184083fb'),
 ('8', '8', 'en_gb', 'Find Us', NULL, NULL, NULL, 'Find Us', 'Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \r\n\r\nDirections: From Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\r\n\r\nParking: There is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\r\n\r\nBuses: We are a 5-10 minute walk from the central bus station.', NULL, NULL, NULL, NULL, NULL, '', 'Find us in beautiful Southernhay, located close to the centre of Exeter only a short distance from the historic Exeter Cathedral.', 'INDEX, FOLLOW', 'Exeter, Devon based physio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 09:37:14', '2015-12-08 17:19:00', 'b3da8417-3590-4281-a0fe-9abbff806514'),
 ('9', '9', 'en_gb', 'Treatments', NULL, NULL, NULL, 'Treatments', 'Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a ‘whole person’ approach to health and wellbeing, which includes the patient’s general lifestyle. At the core is the patient’s involvement in their own care, through education, awareness, empowerment and participation in their treatment. \r\n\r\nClick the categories below to see how we can help you.', NULL, NULL, NULL, NULL, NULL, '', 'Our treatments are based on a science-based approach that looks at the whole person, ensuring that the patient is involved in their own care.', 'INDEX, FOLLOW', 'Expert treatments from experienced Exeter Physio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 09:37:54', '2015-12-08 17:22:58', 'a893733d-7057-4f7c-a679-d7e2622d4c1c'),
 ('14', '14', 'en_gb', 'Fractures', NULL, NULL, NULL, NULL, NULL, NULL, 'Fractures', 'Following a broken bone, the joints around the area will often become stiff and painful, the muscles weak and balance poor. This is easily improved with the advice, manual therapy and exercises provided by Cathedral Physiotherapy.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:49:40', '2015-12-03 00:12:04', '01e49b58-78fa-4430-91a2-733e5780822f'),
 ('15', '15', 'en_gb', 'Children’s Injuries', NULL, NULL, NULL, NULL, NULL, NULL, 'Children’s Injuries', 'Although many children bounce back quickly after injury, if they are particularly sporty, or have lost their confidence after a sprain, strain or fracture they may need some reassurance and treatment / exercises to return to their previous level of care-free fitness.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:50:05', '2015-12-03 00:11:34', 'c3e419bc-59d3-4df2-a779-4cd0ad9a62ae'),
 ('16', '16', 'en_gb', 'Young adult hip pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Young adult hip pain', 'Hip pain in young adults can be caused by a number of issues from muscle imbalance around the hip, cartilage problems within the joint, bony anatomical issues or referred pain from the back or pelvis. The excellent clinical reasoning found at Cathedral Physiotherapy will help to differentiate the causes and formulate a treatment plan or onward referral as required. I have worked closely with the Royal Devon and Exeter NHS Hospital hip consultants with patients with femoral acetabular impingement in particular, including being involved in research, and so am at the cutting edge of treating this group of patients.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:51:14', '2015-12-03 00:11:05', '7b83d3d0-838f-45b9-9c9b-ee2a7979300d'),
 ('17', '17', 'en_gb', 'Sports Injuries', NULL, NULL, NULL, NULL, NULL, NULL, 'Sports Injuries', 'Whether you are after prevention or cure, Cathedral Physiotherapy can help you. Excellent assessment will ensure that you receive the treatment you require, be it a combination of functional exercise, manual therapy, ultrasound, taping or acupuncture. We have a small exercise area in the clinic, but can also adapt your training program for your to rehabilitate at your own gym / pool.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:51:34', '2015-12-04 17:02:16', 'ee09166b-3e8b-4106-9518-66b2c6046616'),
 ('18', '18', 'en_gb', 'Haemophilia', NULL, NULL, NULL, NULL, NULL, NULL, 'Haemophilia', 'For those individuals diagnosed with haemophilia, early access to physiotherapy is crucial following a bleed. This is a niche area that Sarah has worked in as the designated haemophilia physiotherapy specialist at the Royal Devon and Exeter hospital over the last few years, so you can be assured that you are in safe hands', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:51:51', '2015-12-03 00:09:38', '36a32843-d4b7-443b-8e03-6dc45bc23720'),
 ('19', '19', 'en_gb', 'Work-related pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Work-related pain', 'Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health, 2008).', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:53:14', '2015-12-03 00:12:12', 'ccd1d574-9934-4d27-a886-081e8d1302bf'),
 ('20', '20', 'en_gb', 'Sprains and Strains', NULL, NULL, NULL, NULL, NULL, NULL, 'Sprains and Strains', 'Minor sprains and strains can be managed with PRICE therapy:\r\nProtect the area using a support temporarily, Rest the are for the first 48-72 hrs, apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin), Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow and remove the bandage before sleep, Elevate the injured area, supported on a pillow, to reduce the swelling. Ultrasound and taping can also promote healing. Following this we will help rehabilitate you range of movement, strength and balance so that you return to your full function.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:53:29', '2015-12-03 00:12:37', '12d2c043-a149-4963-b6a0-8f2a3e68ebd7'),
 ('21', '21', 'en_gb', 'Back Pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Back Pain', 'Low back pain is reported by 80% of people at sometime in their life. A large percentage of this will improve with basic advice and exercises, but some people need more specific treatment (work-related advice, functional exercises, manual therapy, or acupuncture). Come and be assessed today so that we can help you on your road to recovery, and to help prevent recurrence.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:53:48', '2015-12-03 00:12:47', '09348420-db42-4916-981a-7fe3a098f909'),
 ('22', '22', 'en_gb', 'Neck Pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Neck Pain', 'Neck pain is common but most cases aren’t caused by a serious problem. Some people get it after an accident or injury, whilst others find it appears if they are stressed, or inactive, or it can be related to age-related changes in the structures of the neck. Commonly felt locally in the neck, it can also refer to the shoulder / arm, and sometimes may cause pins and needles / numbness. With good advice, reassurance, specific exercises and sometimes manual therapy, the majority of neck pain improved within about six weeks.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:54:01', '2015-12-03 00:12:55', 'afb94a30-3336-4faf-a80b-2184c231de13'),
 ('23', '23', 'en_gb', 'Shoulder / Elbow / Wrist pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Shoulder / Elbow / Wrist pain', 'Whether your pain is work or hobby related it is important to get the correct advice early to prevent chronicity. An excellent assessment will differentiate the problem and help you to manage and improve your symptoms.\r\n\r\nArm pain can be referred from the neck, but is more commonly related to impingement of the tendons, or tears of the muscle, but can also be due to ‘frozen shoulder’. \r\n\r\nElbow complaints include tennis elbow, golfers elbow, or nerve irritation. \r\n\r\nWrist pain is commonly related to the position of the wrist at work or during hobbies, but can be due to stiffness post fracture, or carpal tunnel syndrome. \r\n', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:54:15', '2015-12-07 13:12:43', '63ca38ce-1fe7-4381-a748-8af618eb8ca2'),
 ('24', '24', 'en_gb', 'Hip / Knee / Ankle pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Hip / Knee / Ankle pain', 'Hip pain - Problems with cartilage, early osteoarthritis, tendonopathy, sprains and muscle imbalances can all cause hip pain, but it can also be referred from the back. Accurate assessment is crucial to ensure you have the right treatment to improve your problem.\r\n\r\nKnee pain – Be it local pain, swelling or stiffness secondary to an acute injury to the ligaments of the joint, more insidious in nature, or referred pain, once diagnosed, the majority of problems will significantly improve with a specific functional exercise program, but if necessary it can also be treated with manual therapy, ultrasound, taping or acupuncture too.\r\n\r\nAnkle pain – The majority of people have sustained a sprained ankle at some point, and we can offer acute treatment for this with ultrasound, soft tissie therapy, taping and exercises. However, we rely on our legs heavily, and the key is to prevent it recurring again through specific rehabilitation, so that you can stay as fit and active as you wish.', '£45 for 1 hour', '£35 fo 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:54:33', '2015-12-03 00:04:47', '66bcb9ee-7ba1-42fc-89aa-88521de2358a'),
 ('25', '25', 'en_gb', 'Orthopaedic post operative care', NULL, NULL, NULL, NULL, NULL, NULL, 'Orthopaedic post operative care', 'Come to Cathedral Physiotherapy for your post operative care. Be it following a fracture, ligament reconstruction, hip arthroscopy, or joint replacement we can help you regain your independence. Having worked at the Royal Devon and Exeter hospital for the last 11 years I have strong links with the orthopaedic teams there.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:55:27', '2015-12-03 00:13:52', '5fa90a10-3b26-4d61-9109-778cba1fb806'),
 ('26', '26', 'en_gb', 'Post fracture rehabilitation', NULL, NULL, NULL, NULL, NULL, NULL, 'Post fracture rehabilitation', 'It is quite common to have on-going problems with pain, swelling and stiffness in the joints surrounding the area where you have fractured. However the real issue, is that people often lose their confidence too. Let us rehabilitate you back to your previous level of function or fitness allowing you to live your life to the full.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:55:43', '2015-12-03 00:04:51', '2f78381e-15a0-45f5-859c-cdf61f95f01a'),
 ('27', '27', 'en_gb', 'Non specific arm pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Non specific arm pain', 'Characterised by ongoing pain, altered sensations in the hand / arm and sometime feelings of weakness, this can be a frustrating condition to have, particularly as commonly many objective medical test are negative. Often, modifications to posture, work stations, gaining an understanding of pain mechanisms, and local tissues techniques can improve symptoms and function.', '£45 for 1 hour', '£35 fo 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:55:55', '2015-12-03 00:04:55', '4a41efc2-0eb2-47ed-a296-e3dc4bbe6fef'),
 ('28', '28', 'en_gb', 'Thoracic Outlet Syndrome', NULL, NULL, NULL, NULL, NULL, NULL, 'Thoracic Outlet Syndrome', 'Characterised by neck / shoulder / arm pain, feelings of weakness in the arm (particularly with overhead activities), and possible discolouration of the hand, this condition can be debilitating. With good quality conservative physiotherapy, symptoms and function can be significantly improved, thereby improving your quality of life.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:56:08', '2015-12-03 00:04:59', 'b3a7fcae-32f9-4da3-bcf5-0c01dbdef7ef'),
 ('29', '29', 'en_gb', 'Headaches and Dizziness', NULL, NULL, NULL, NULL, NULL, NULL, 'Headaches and Dizziness', 'Benign headaches can be caused by tension in the muscles, stiffness in the neck or muscle imbalance. Often characterised by being one-sided, or in a band around the head, and associated with neck pain, or certain movements, symptoms can be improved significantly with a combination of exercise, manual therapy, acupuncture and an understanding of pain pathways.\r\n\r\nDizziness can be generated from the neck, the inner ear or the brain, and accurate differential diagnosis is crucial for appropriate treatment.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:56:26', '2015-12-07 11:15:05', '53c523b7-a916-40ac-9018-751b8d28b01f'),
 ('30', '30', 'en_gb', 'Pregnancy related pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Pregnancy related pain', 'Pregnancy related pelvic girdle pain is common and affects 1 in 5 women during their pregnancy. There are a wide range of symptoms, some of which improve naturally during the course of the pregnancy as your body adapts, some which need advice and /or treatment early on to keep you as active as possible. Don’t suffer in silence, get help early.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:56:42', '2015-12-03 00:05:05', '06133882-461d-4777-b514-1408d93a492e'),
 ('31', '31', 'en_gb', 'Management of long term conditions', NULL, NULL, NULL, NULL, NULL, NULL, 'Management of long term conditions', 'Some people are diagnosed with long term conditions, be it persistent pain generated by the nervous system, or on-going musculoskeletal problems following a car crash. At Cathedral Physiotherapy we believe in working with you to assist you to maximise your physical potential. ', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:56:55', '2015-12-02 23:43:36', '85693cb4-1852-437d-8c78-10da2ce56a3d'),
 ('32', '32', 'en_gb', 'Rheumatological conditions', NULL, NULL, NULL, NULL, NULL, NULL, 'Rheumatological conditions', 'Although consisting of a variety of diagnoses, for instance Rheumatoid Arthritis, Ankylosing Spondylitis, Psoriatic Arthritis etc, many of these diseases follow a period of flare and recovery. At Cathedral Physiotherapy we can help you not to be defined by your diagnosis, assist you through your flares, and maximise your return to function so that you continue to lead and full and fruitful life.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:57:11', '2015-12-06 22:21:35', '6b403b34-56fe-4245-9fe8-2d1269d1413d'),
 ('33', '33', 'en_gb', 'Osteoarthritis', NULL, NULL, NULL, NULL, NULL, NULL, 'Osteoarthritis', 'Osteoarthritis is a common type of arthritis, a painful condition which can affect the joints especially the hips, knees, neck, lower back, hand or feet. Although it can occur at any age, it is more likely to appear between the ages of 45-75 years, and often in women more than men. There is much evidence showing that a combination of non steroidal anti-inflammatories and exercise or physiotherapy will help to reduce the symptoms of pain and stiffness, allowing you not to be restricted by your symptoms.', '£45 for one hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:57:28', '2015-12-02 23:43:03', 'a92238a8-39c4-4849-b694-fccb83ff4090'),
 ('34', '34', 'en_gb', 'Joint Replacements', NULL, NULL, NULL, NULL, NULL, NULL, 'Joint Replacements', 'Following total or partial knee replacement, hip replacement or shoulder replacement, good quality regular physiotherapy is important to decrease swelling and pain and increase range of movement, muscle power and function. We are a lower ground premises, therefore you need to be able to complete one flight of stairs, however if access is an issue, contact us and we will discuss the possibility of a domiciliary visit.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:57:39', '2015-12-02 23:42:46', '2491d6c8-906e-4c71-82ee-ded09473bfb0'),
 ('35', '35', 'en_gb', 'Osteoporosis', NULL, NULL, NULL, NULL, NULL, NULL, 'Osteoporosis', 'Having been the principle investigator for Exeter on the PROVE trial (2014-16) looking into rehabilitation of patients with osteoporosis who have vertebral fractures, I am well qualified to help you manage your condition, and to keep you as fit and active as possible.', '£45 for one hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:57:51', '2015-12-02 23:42:19', '99629008-2494-480f-833b-1d3a95cc1571'),
 ('36', '36', 'en_gb', 'Post Cancer Rehabilitation', NULL, NULL, NULL, NULL, NULL, NULL, 'Post Cancer Rehabilitation', 'Most people are so relieved to have stopped the active stage of their treatment, be it radiotherapy or chemotherapy, that they are happy to live with compromises in function for a time. However, it is common to become frustrated with these compromises once your energy returns. We passionately  believe that you should not be defined by your diagnosis, and will work hard with you to facilitate and maximise your return to function; be it to improve your shoulder range of movement post breast surgery so that you can reach the top cupboards, or return to tennis and swimming again.', '£45 for one hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:58:03', '2015-12-02 23:42:25', '940d275b-aaff-4f6b-bca1-de3fc58fa9d5'),
 ('37', '37', 'en_gb', 'Mild Continence Issues', NULL, NULL, NULL, NULL, NULL, NULL, 'Mild Continence Issues', 'Bladder or bowel continence issues can be embarrassing, but when it is only a mild issue much can be done with pelvic floor exercises and fluid intake management. We can happily treat mild continence issues e.g. post pregnancy, or stress incontinence related to respiratory problems. If we feel your continence issues need further input, then we will refer you on to the appropriate practitioner.', '£45 for 1 hour', '£35 for 1/2 hour', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 11:58:20', '2015-12-02 23:41:18', '381d3c68-044e-4cc4-9807-a7c130d8d5c5'),
 ('39', '43', 'en_gb', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 12:54:44', '2015-12-04 17:02:38', '5bd69d99-8707-4fbe-8e8b-7128d8e66e25'),
 ('40', '47', 'en_gb', 'News', NULL, NULL, NULL, 'Latest News', 'Welcome to our news page which includes information from self-help advice for what to do as soon as you’ve hurt yourself, and clips to watch, to topical items in the news. If something isn’t here that you would like to see, then please email us at enquiries@cathedralphysiotherapy.co.uk and we will do our best to respond to your suggestions.', NULL, NULL, NULL, NULL, NULL, '', 'Get the latest news about what\'s happening at the practice, as well as get additional information and a wealth of self-help advice.', 'INDEX, FOLLOW', 'Latest Physio News, Discussion and Advice', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-13 14:41:24', '2015-12-08 17:19:50', '1bd8b52e-56e8-49ab-ba79-dfee0d7e1185'),
 ('46', '57', 'en_gb', 'Pricing', NULL, NULL, NULL, 'Pricing', 'At Cathedral Physiotherapy Exeter, we like to keep things simple. Therefore we only have two prices, regardless of the treatment you are having at the clinic: \r\n\r\nNew appointments last an hour and cost £45\r\nFollow up appointments last ½ an hour and cost £35.', NULL, NULL, NULL, NULL, NULL, '', 'Learn more about our clear, simple and transparent pricing structure for all our treatments at the clinic.', 'INDEX, FOLLOW', 'Physio treatment costs', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-17 14:07:49', '2015-12-08 17:20:33', 'd9c4f205-6bbe-4e6f-adc3-42f5b00f7d60'),
 ('47', '58', 'en_gb', 'Testimonials', NULL, NULL, NULL, 'Testimonials', 'Don\'t take our word for it, hear from our clients what they think about us...', NULL, NULL, NULL, NULL, NULL, '', 'Read about what our clients think about us at Cathedral Physiotherapy. Our testimonials page will give you the information you need.', 'INDEX, FOLLOW', 'Reviews for Cathedral Physiotherapy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-17 14:17:42', '2015-12-08 19:25:19', '043de98f-b546-4b71-a24c-4a72dd1d000b'),
 ('48', '61', 'en_gb', 'Work and Social', NULL, NULL, NULL, 'Work & Social', 'Balancing busy jobs and a home life is difficult enough, let alone trying to keep fit and healthy, so it doesn\'t take much to upset the equilibrium. However getting pain associated with your job, or preventing you from exercising easily can disrupt those scales making it harder to achieve everything you need to do. At Cathedral Physiotherapy we are here to help you improve any symptoms you may have so that you can get back to being superhuman! \r\n\r\nClick on the links below for examples of what we can help you with.', NULL, NULL, NULL, NULL, NULL, '', 'Pain can curb both your working and social life. We are help to improve your symptoms, so you can get on and enjoy your daily life.', 'INDEX, FOLLOW', 'Physio for Work and Social', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-11-17 16:40:59', '2015-12-08 17:23:50', '35e51c3d-61de-4721-b440-ffbee5b8b87a'),
 ('49', '62', 'en_gb', 'Young and Active', NULL, NULL, NULL, 'Young / Active', 'We\'ve all done it... Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it’s occurred. \r\n\r\nClick on the links below for examples of what we can offer at Cathedral Physiotherapy.', NULL, NULL, NULL, NULL, NULL, '', 'Even if you are young and active, injury can strike. We are here to help improve the situation and get you moving again.', 'INDEX, FOLLOW', 'Physio for Young and Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[{\"col1\":\"The benefits of exercise - 23 1\\/2 hours\",\"col2\":\"https:\\/\\/youtu.be\\/aUaInS6HIGo\"}]', '0', '2015-11-17 16:41:18', '2016-01-07 11:47:24', '5e05d991-b3ca-4130-b355-5cc6bde7c0d0'),
 ('50', '63', 'en_gb', 'Lifetime Support', NULL, NULL, NULL, 'Lifetime Support', 'Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy in Exeter we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \r\n\r\nClick on the conditions below for examples of what we can offer.', NULL, NULL, NULL, NULL, NULL, '', 'Our lifetime support means that, whatever your age or needs, we can give you the personalised treatment that you require to function better.', 'INDEX, FOLLOW', 'Physio for Lifetime Support', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[{\"col1\":\"Access self-help exercise leaflets from the Arthritis Research Council and CSP\",\"col2\":\"http:\\/\\/www.csp.org.uk\\/publications\\/exercise-advice-leaflets\"}]', '0', '2015-11-17 16:41:32', '2015-12-08 17:19:19', '94c3355b-4f81-42a5-a813-22cd9c11d33d'),
 ('79', '99', 'en_gb', 'Ouch…I’ve hurt my back…', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'Back pain can seriously impact your life. Learn what you need to know and what you should do when back pain strikes.', 'INDEX, FOLLOW', 'How to help back pain', '', 'Ouch…I’ve hurt my back…', 'Getting the low down on what to do when you’ve hurt your back…', NULL, 'References: O’Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.', NULL, NULL, '[\"true\"]', NULL, '0', '2015-11-26 13:59:16', '2015-12-08 21:26:01', '4fc7a609-9ae8-4c22-96a5-17bec33cb807'),
 ('80', '109', 'en_gb', 'Media comment: November', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'Take a long term approach to improving your health through taking up exercise and fitting it into your own lifestyle.', 'INDEX, FOLLOW', 'Physio Exeter advice on fitness', '', 'Media comment: November', 'As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded ‘New Year Resolutions’. Why not take a longer term approach to your health rather than the ‘boom and bust’ which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!', NULL, '', NULL, NULL, '', '[{\"col1\":\"Related BBC News Article\",\"col2\":\" http:\\/\\/www.bbc.co.uk\\/news\\/health-34764693\"},{\"col1\":\"Related Daily Mail Article\",\"col2\":\"http:\\/\\/www.dailymail.co.uk\\/health\\/article-3311222\\/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html\"},{\"col1\":\"Related Guardian Article\",\"col2\":\"http:\\/\\/www.theguardian.com\\/uk-news\\/2015\\/nov\\/09\\/strong-legs-healthier-brain-in-old-age\"},{\"col1\":\"NHS fitness guide for adults\",\"col2\":\"http:\\/\\/www.nhs.uk\\/Livewell\\/fitness\\/Pages\\/physical-activity-guidelines-for-adults.aspx\"}]', '0', '2015-11-30 09:23:57', '2015-12-08 21:25:20', 'f6ed7a91-644a-4806-823f-16ee6bd65c9b'),
 ('84', '124', 'en_gb', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-12-01 17:25:21', '2015-12-01 17:35:02', '3529005f-4c1e-4c72-a19e-5b1b127c6b2d'),
 ('85', '125', 'en_gb', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-12-02 09:07:26', '2015-12-02 09:07:26', 'f556914e-8241-4870-ae00-4d774051faed'),
 ('95', '141', 'en_gb', 'Sprains and Strains', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'Learn how to treat sprains and strains, quickly and effectively, in order to limit the pain and inconvenience.', 'INDEX, FOLLOW', 'Acupuncture Exeter', NULL, 'Sprains and Strains', 'What to do when you strain or sprain yourself', NULL, '', NULL, NULL, '[\"true\"]', NULL, '1', '2015-12-04 22:25:11', '2015-12-08 21:24:19', '77d19100-aead-49db-90dc-75663fc98824'),
 ('167', '226', 'en_gb', 'Acupuncture', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:27:57', '2015-12-08 14:32:13', 'ea433e47-6674-4324-abe3-4c485c096e3b'),
 ('168', '227', 'en_gb', 'Acupuncture2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:27:59', '2015-12-08 14:32:10', '1f1d5e69-4acf-4947-973e-e2c94bbf3492'),
 ('169', '228', 'en_gb', 'Acupuncture3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:28:00', '2015-12-08 14:32:10', '147d1ca4-d36c-43c4-aec7-1ef5599b686a'),
 ('170', '229', 'en_gb', 'Acupuncture4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:28:02', '2015-12-08 14:32:11', '7c2fafb9-e104-450d-9578-7a6694e7badf'),
 ('171', '230', 'en_gb', 'Acupuncture5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:28:03', '2015-12-08 14:32:12', '8c16132e-dfc5-40a9-890b-3a890790845d'),
 ('172', '231', 'en_gb', 'Acupuncture6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:28:04', '2015-12-08 14:32:12', '74594c9e-2e95-4898-ac12-738492cb259d'),
 ('173', '232', 'en_gb', 'Bone', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:28:06', '2015-12-08 14:32:16', '5f88194f-4a74-4d2b-9e66-bf6558014076'),
 ('174', '233', 'en_gb', 'Gym', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:28:09', '2015-12-08 14:32:18', 'e5f6b2d9-0124-4c8b-90de-05ecd3359094'),
 ('175', '234', 'en_gb', 'Newspaper', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:28:14', '2015-12-08 14:32:19', 'd3adabd6-4eac-48bb-896a-037ba471de23'),
 ('176', '235', 'en_gb', 'Office', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:28:16', '2015-12-08 14:32:20', 'b756d019-8e40-41a6-87d0-726911c0797e'),
 ('177', '236', 'en_gb', 'Sarah Profile1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:28:18', '2015-12-08 14:32:23', 'cedbd20a-2c88-4e5b-83be-daf61cd874d7'),
 ('178', '237', 'en_gb', 'Sarah Profile2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:28:20', '2015-12-08 14:32:26', 'bd0f71c1-e2e5-4b07-bed4-a5a307ad34ac'),
 ('179', '238', 'en_gb', 'Trampette', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:28:21', '2015-12-08 14:32:28', '90e6d504-db00-48e3-9945-868ccda42128'),
 ('180', '239', 'en_gb', 'Heart  Health', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:36', '2015-12-08 14:31:37', '15dda192-b1cf-4368-b87f-7a7b3367c0c6'),
 ('181', '240', 'en_gb', 'Img 4041 Copy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:38', '2015-12-08 14:31:38', 'd08e3241-439d-49a2-895b-7c4c5ff74620'),
 ('182', '241', 'en_gb', 'Joint  Pain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:38', '2015-12-08 14:31:39', '85c36568-80d5-4c1d-8464-6fe33148743f'),
 ('183', '242', 'en_gb', 'Tennis  Elbow', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:39', '2015-12-08 14:31:39', 'cbee6438-a462-462f-919e-885b5be0f5b0'),
 ('184', '243', 'en_gb', 'Acupuncture', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:40', '2015-12-08 14:31:40', 'cf444f74-24a4-4cd0-b239-a44737a25487'),
 ('185', '244', 'en_gb', 'Acupuncture2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:41', '2015-12-08 14:31:41', 'e8844604-5577-422d-b300-fc2e47d5dfc9'),
 ('186', '245', 'en_gb', 'Acupuncture4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:41', '2015-12-08 14:31:41', '8defbb77-5507-4e64-a615-eb4932972530'),
 ('187', '246', 'en_gb', 'Acupuncture3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:42', '2015-12-08 14:31:42', 'b6272d2b-509e-4e6c-9d3e-48bdebaab9bf'),
 ('188', '247', 'en_gb', 'Acupuncture5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:42', '2015-12-08 14:31:42', '32afadec-089f-4130-86a1-25332949e7c5'),
 ('189', '248', 'en_gb', 'Acupuncture6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:43', '2015-12-08 14:31:43', '26bb8ac9-fa45-494f-a86b-40c5f003381a'),
 ('190', '249', 'en_gb', 'Banner', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:43', '2015-12-08 14:31:44', '859b3231-f695-4b5a-9671-cc1c049f347a'),
 ('191', '250', 'en_gb', 'Back Pain Gif 437580', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:44', '2015-12-08 14:31:45', '4b2adae1-9ff2-40dc-8dd1-ff4fe8165b23'),
 ('192', '251', 'en_gb', 'Bone', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:45', '2015-12-08 14:31:45', 'af5592b3-c367-4220-a9f6-19124c0eee4d'),
 ('193', '252', 'en_gb', 'Gym', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:46', '2015-12-08 14:31:46', 'c60b8680-5d5b-451a-a39f-ce91db03574c'),
 ('194', '253', 'en_gb', 'Healthy Walking Signpost 77422 1920', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:46', '2015-12-08 14:31:47', 'fe6f20b1-022e-4515-a619-3e97f6a40f09'),
 ('195', '254', 'en_gb', 'Heartbeat 163709 1280', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:47', '2015-12-08 14:31:47', '0754264c-77b4-44f8-8f56-38e857e8a66f'),
 ('196', '255', 'en_gb', 'Istock Rf Photo Of Arthritis Pain In Hand', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:48', '2015-12-08 14:31:48', '9b7c7c28-a518-4b48-a661-43fd0b9c04fd'),
 ('197', '256', 'en_gb', 'Newspaper 866520 1920', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:48', '2015-12-08 14:31:48', '7c6f8981-6856-4144-8d29-a72e83176812'),
 ('198', '257', 'en_gb', 'Newspaper', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:49', '2015-12-08 14:31:49', 'e14f70d9-a21c-4654-bf6a-f56b4f383bf3'),
 ('199', '258', 'en_gb', 'Newspaper', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:49', '2015-12-08 14:31:50', '7ff53c95-4e4d-4825-9204-9ef36d2cfd73'),
 ('200', '259', 'en_gb', 'Office', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:50', '2015-12-08 14:31:50', 'a729f3d3-b766-4f57-976d-d8b3f36c89d6'),
 ('201', '260', 'en_gb', 'Sarah Profile1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:50', '2015-12-08 14:31:51', '018d7736-fc05-4f5d-87df-a9a3814a318f'),
 ('202', '261', 'en_gb', 'Sarah Profile2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:51', '2015-12-08 14:31:51', '91978392-737c-4a16-9dc8-fb023e5bc6ea'),
 ('203', '262', 'en_gb', 'Spine 957249 1280', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:52', '2015-12-08 14:31:52', '0a24f7fa-ff72-4add-ac6e-4602971293d3'),
 ('204', '263', 'en_gb', 'Trampette', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:52', '2015-12-08 14:31:52', '093313e4-0d7e-4335-8e55-742efb3bd181'),
 ('205', '264', 'en_gb', 'Sports Injury 2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:53', '2015-12-08 14:31:53', '948ddbc4-e57e-4863-904c-40f718520d51'),
 ('206', '265', 'en_gb', 'Ultrasound', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:53', '2015-12-08 14:31:53', 'd0fc201e-e2e6-4f3c-8e2d-7e0f2fc13335'),
 ('207', '266', 'en_gb', 'Lifetime Couple', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:54', '2015-12-08 14:31:54', '2e4701f8-7ac6-40aa-a1f0-ffc0a3a35fcf'),
 ('208', '267', 'en_gb', 'Sport Woman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:55', '2015-12-08 14:31:55', '96ab249a-59af-43c5-8114-46980512b993'),
 ('209', '268', 'en_gb', 'Work Man', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:55', '2015-12-08 14:31:55', 'f4677ec7-6209-43fb-9499-f0fccf8f0225'),
 ('210', '269', 'en_gb', '6f14d766 8edf 4b3c B385 96bfed558d4c', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:57', '2015-12-08 14:31:57', '52fbf945-e2a0-41a2-9ec5-5a431e71ad92'),
 ('211', '270', 'en_gb', 'Bmas Footer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:58', '2015-12-08 14:31:58', '8928fe55-b8dc-4541-99a2-0688dacc75b4'),
 ('212', '271', 'en_gb', 'Bmas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:58', '2015-12-08 14:31:59', '2c580334-950b-4e58-a2fd-fa62c9a57eed'),
 ('213', '272', 'en_gb', 'Bmas Logo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:31:59', '2015-12-08 14:31:59', '35d19be9-b49b-4584-841c-61190fb40b60'),
 ('214', '273', 'en_gb', 'Macp Logo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:00', '2015-12-08 14:32:00', 'e45e314f-de6f-46c8-a5ab-afcb9cafa8e0'),
 ('215', '274', 'en_gb', 'Macp Logo Reverse', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:01', '2015-12-08 14:32:01', 'cb97cd75-b079-4958-8935-1358ab6790b1'),
 ('216', '275', 'en_gb', 'Csp Footer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:01', '2015-12-08 14:32:02', '0a0f6b69-091c-4320-99a7-7483fa93ee08'),
 ('217', '276', 'en_gb', 'Hpc Footer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:02', '2015-12-08 14:32:02', '8d4f97ed-895c-4deb-a81a-b590a18298ba'),
 ('218', '277', 'en_gb', 'Csp', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:02', '2015-12-08 14:32:03', 'ddf0f308-d60d-4581-83ef-c3e5a7d79949'),
 ('219', '278', 'en_gb', 'Hpc Logo Registered', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:03', '2015-12-08 14:32:03', 'c223c10f-9c0a-4150-9f34-83e3d8938538'),
 ('220', '279', 'en_gb', 'Hpc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:03', '2015-12-08 14:32:03', '578fb2af-fefc-424f-9ee7-e86729cdbfb5'),
 ('221', '280', 'en_gb', 'Physio First', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:04', '2015-12-08 14:32:04', '77c9f0fb-a6fe-4891-8b19-ed50de9c33de'),
 ('222', '281', 'en_gb', 'Imgres', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:04', '2015-12-08 14:32:04', '1861f704-73c7-4a03-92e8-37acd8d1fef2'),
 ('223', '282', 'en_gb', 'Physio Footer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:04', '2015-12-08 14:32:05', '6ebdb6a8-f143-480d-9b0e-4e39f629f12f');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `field_initialAssess`, `field_subsequentTreat`, `field_sidebarDisplay`, `field_linksSection`, `field_imagesPosition`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('224', '283', 'en_gb', 'Physiofirst Footer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:05', '2015-12-08 14:32:05', '9403678c-50f5-4a3e-9f87-5a126f047e95'),
 ('225', '284', 'en_gb', 'Img 3984 Copy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:06', '2015-12-08 14:32:06', '2e280edc-5f0b-4bb4-aa35-085409fae0b5'),
 ('226', '285', 'en_gb', 'Img 4041 Copy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:07', '2015-12-08 14:32:07', '4aa93bf6-bd96-4e3a-990f-5037223482f8'),
 ('227', '286', 'en_gb', 'Img 4028 Copy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:07', '2015-12-08 14:32:08', '86bda902-4363-4d21-bdcc-affd0e038974'),
 ('228', '287', 'en_gb', 'Acupuncture', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:08', '2015-12-08 14:32:08', '30769af0-fffa-42d3-a341-b1b1443bea2d'),
 ('229', '288', 'en_gb', 'Img 4053 Copy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:08', '2015-12-08 14:32:09', 'bbc5f10b-e128-4106-8fac-e568243da1e3'),
 ('230', '289', 'en_gb', 'Acupuncture2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:09', '2015-12-08 14:32:09', '693ad61a-2609-4013-8ea1-bd0d94690b21'),
 ('231', '290', 'en_gb', 'Acupuncture3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:09', '2015-12-08 14:32:10', 'aa16d130-edcb-4043-b470-5505904a8431'),
 ('232', '291', 'en_gb', 'Acupuncture4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:10', '2015-12-08 14:32:11', '2a3e04d8-cbeb-4cad-883c-01f7323345a0'),
 ('233', '292', 'en_gb', 'Acupuncture5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:11', '2015-12-08 14:32:11', 'ff1feaeb-cf1f-4222-bf94-e96ab2b81076'),
 ('234', '293', 'en_gb', 'Acupuncture6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:12', '2015-12-08 14:32:12', '4458ed3b-e615-4a4a-967c-7432ffa670d6'),
 ('235', '294', 'en_gb', 'Bone 151207 115708', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:14', '2015-12-08 14:32:14', 'ea906a72-88ce-497d-9e63-5aa5b001fda8'),
 ('236', '295', 'en_gb', 'Bone 151206 231008', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:14', '2015-12-08 14:32:15', 'f3f9fe38-9efc-44f2-86d9-e647395f5f47'),
 ('237', '296', 'en_gb', 'Cont Interior', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:17', '2015-12-08 14:32:17', 'f8fb76d4-6e45-4ee1-a6d0-eaf535722144'),
 ('238', '297', 'en_gb', 'Bone', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:17', '2015-12-08 14:32:18', 'd8fb7961-d339-4df3-b9ce-1b033b59c162'),
 ('239', '298', 'en_gb', 'Gym', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:18', '2015-12-08 14:32:18', '3789f1d0-87bd-458a-b9e0-3cb26454760d'),
 ('240', '299', 'en_gb', 'Newspaper', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:19', '2015-12-08 14:32:19', '072deaa1-1ba6-4713-a246-6c2adfc75408'),
 ('241', '300', 'en_gb', 'Office', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:19', '2015-12-08 14:32:19', '42b91d0b-1828-4b5e-9c6b-8adc5d5be62b'),
 ('242', '301', 'en_gb', 'Sarah Profile1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:21', '2015-12-08 14:32:21', 'f5e6c032-84ad-487d-b582-2e279881a95a'),
 ('243', '302', 'en_gb', 'Sarah Profile', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:21', '2015-12-08 14:32:21', 'cb8eecd7-4e0a-4e0c-aca5-9e12cafc553e'),
 ('244', '303', 'en_gb', 'Sarah Profile2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:23', '2015-12-08 14:32:24', 'f9908b8d-6dd9-42fc-a061-7bea20f9e3ed'),
 ('245', '304', 'en_gb', 'Trampette', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:24', '2015-12-08 14:32:25', '1eaf6860-e92d-423c-bb64-82a96d177770'),
 ('246', '305', 'en_gb', 'Trampette 151204 210703', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:25', '2015-12-08 14:32:26', 'dc21ce7b-ea01-496a-a91e-6a8ed2a34eb6'),
 ('247', '306', 'en_gb', 'Trampette 151204 212322', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:26', '2015-12-08 14:32:27', 'cb652ac8-dc8f-4897-824b-bf183820ed9b'),
 ('248', '307', 'en_gb', 'Trampette 151207 115724', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:28', '2015-12-08 14:32:28', '05ccfaf1-1ecd-4b58-82f9-282bc4041d81'),
 ('249', '308', 'en_gb', 'Ultrasound', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:29', '2015-12-08 14:32:29', '763a21b9-2c61-4fa7-be70-e04d3c1cdd3f'),
 ('250', '309', 'en_gb', 'W Zgx W9 Oubl Vaaj Gcka U Vwpwy L6 Hk G J N0 G Wj Oui4 Pv Dz Bh Tafo1 L9eafkc8s Whd Btd K2xj Dqur Dg K7sjl8 A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:29', '2015-12-08 14:32:29', 'fd8d796d-a9ae-474e-b9f0-ee01bf57082a'),
 ('251', '310', 'en_gb', 'Trampette 151204 221047', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:30', '2015-12-08 14:32:30', '3835f96f-aabe-4833-9a0b-6ff7c4464861'),
 ('252', '311', 'en_gb', 'Img 3984 Copy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:31', '2015-12-08 14:32:31', 'abede597-886c-4702-925b-0c27cbf27b52'),
 ('253', '312', 'en_gb', 'Img 4041 Copy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:33', '2015-12-08 14:32:34', '436739fe-e501-4321-bbf2-46ebf9beca22'),
 ('254', '313', 'en_gb', 'Img 4028 Copy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:34', '2015-12-08 14:32:35', '319cca97-7d10-45ab-80f4-e8d0a3c5536b'),
 ('255', '314', 'en_gb', 'Acupuncture', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:35', '2015-12-08 14:32:35', 'dfe6266f-5461-48bb-90ae-d6741d3bcef4'),
 ('256', '315', 'en_gb', 'Img 4053 Copy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:36', '2015-12-08 14:32:36', 'c0b22d11-0c24-4ce8-8cfa-f660f6498ece'),
 ('257', '316', 'en_gb', 'Acupuncture2 151208 142759', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:37', '2015-12-08 14:32:38', 'd5be3e51-87cd-4dd5-99fd-adca39f1ab67'),
 ('258', '317', 'en_gb', 'Acupuncture3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:38', '2015-12-08 14:32:38', 'ea44ec6e-7040-4fe8-af0c-a39c236f754f'),
 ('259', '318', 'en_gb', 'Acupuncture2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:38', '2015-12-08 14:32:38', 'b7fcd74b-b0bc-4b71-af94-aee431f2e709'),
 ('260', '319', 'en_gb', 'Acupuncture3 151208 142800', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:39', '2015-12-08 14:32:39', '1f34c9ec-a36a-4e19-8910-70f4cafd475b'),
 ('261', '320', 'en_gb', 'Acupuncture5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:40', '2015-12-08 14:32:40', '83373d5f-59a9-4757-96a9-886574fdd6b1'),
 ('262', '321', 'en_gb', 'Acupuncture4 151208 142802', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:41', '2015-12-08 14:32:41', '3b9c75ca-d030-4545-910c-86b433fe083f'),
 ('263', '322', 'en_gb', 'Acupuncture4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:41', '2015-12-08 14:32:41', 'c314c317-40d5-4415-85b4-a2e08de1baff'),
 ('264', '323', 'en_gb', 'Acupuncture5 151208 142803', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:42', '2015-12-08 14:32:42', '3ab38d32-9066-4cb5-839d-3dbdf72c9977'),
 ('265', '324', 'en_gb', 'Acupuncture6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:42', '2015-12-08 14:32:42', 'ab82315f-bef6-409a-8b1b-e073f78dcd43'),
 ('266', '325', 'en_gb', 'Acupuncture6 151208 142804', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:42', '2015-12-08 14:32:43', '1523263c-3b0f-45c1-b00b-6631c0186842'),
 ('267', '326', 'en_gb', 'Acupuncture 151208 142757', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:43', '2015-12-08 14:32:43', '9ea6e067-673e-4ea2-822d-e679368d6ea9'),
 ('268', '327', 'en_gb', 'Bone', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:44', '2015-12-08 14:32:44', 'efa10924-16f6-44d1-8b42-0344ee4a6e1a'),
 ('269', '328', 'en_gb', 'Bone 151206 231008', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:45', '2015-12-08 14:32:46', 'd1372acf-4aa9-4dfc-b8d8-0c02cb0a941d'),
 ('270', '329', 'en_gb', 'Bone 151207 115708', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:46', '2015-12-08 14:32:46', 'beb845d3-f65f-495e-a05b-67ec7a4a0252'),
 ('271', '330', 'en_gb', 'Bone 151208 142806', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:46', '2015-12-08 14:32:47', 'b5343f19-99e9-4c85-9918-dd7ef33e90be'),
 ('272', '331', 'en_gb', 'Gym', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:47', '2015-12-08 14:32:47', '331594fb-cd94-4882-9705-c3360ba63212'),
 ('273', '332', 'en_gb', 'Cont Interior', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:47', '2015-12-08 14:32:48', '72358b8c-c42f-4f3b-beba-701aa89de9b6'),
 ('274', '333', 'en_gb', 'Newspaper', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:48', '2015-12-08 14:32:48', '0df20ba7-e046-44b2-8b55-dbd313430b0d'),
 ('275', '334', 'en_gb', 'Gym 151208 142808', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:48', '2015-12-08 14:32:49', 'e4fe8c4e-973a-450b-af75-f894670125fb'),
 ('276', '335', 'en_gb', 'Newspaper 151208 142814', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:49', '2015-12-08 14:32:49', '42c06e6d-1494-4d64-aa0b-7b8f72a6b928'),
 ('277', '336', 'en_gb', 'Office', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:50', '2015-12-08 14:32:50', '659009ee-0597-43e3-acd5-3c08f7d65a8f'),
 ('278', '337', 'en_gb', 'Office 151208 142816', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:50', '2015-12-08 14:32:50', '5f415cef-607b-4cb8-9d68-de006885bb25'),
 ('279', '338', 'en_gb', 'Sarah Profile', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:51', '2015-12-08 14:32:52', 'd46a3a09-d4d3-44ba-bc61-37a4e289272e'),
 ('280', '339', 'en_gb', 'Sarah Profile1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:52', '2015-12-08 14:32:52', '8c49d00d-28a2-417b-9d8d-964006f7a528'),
 ('281', '340', 'en_gb', 'Sarah Profile2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:52', '2015-12-08 14:32:52', '787480e5-29d3-4984-91a3-0615288d2aad'),
 ('282', '341', 'en_gb', 'Sarah Profile1 151208 142817', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:53', '2015-12-08 14:32:53', '27162e3b-e256-449b-8c2a-3c272d2493d9'),
 ('283', '342', 'en_gb', 'Sarah Profile2 151208 142819', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:53', '2015-12-08 14:32:53', '2287f321-a5b9-4b36-b16d-08de54970f61'),
 ('284', '343', 'en_gb', 'Trampette', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:53', '2015-12-08 14:32:54', '75ab1e8e-b698-49bc-86b9-91bd0649eb7d'),
 ('285', '344', 'en_gb', 'Trampette 151204 210703', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:54', '2015-12-08 14:32:55', '88ad7742-acb3-45a3-a90f-d69f1138d606'),
 ('286', '345', 'en_gb', 'Trampette 151204 212322', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:55', '2015-12-08 14:32:56', 'd1d30246-407a-4260-814a-d620af95912e'),
 ('287', '346', 'en_gb', 'Trampette 151204 221047', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:56', '2015-12-08 14:32:57', 'bf988507-e182-4540-a5e7-a408d86e6a94'),
 ('288', '347', 'en_gb', 'Trampette 151208 142821', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:57', '2015-12-08 14:32:57', '15574327-4ddd-4742-a87b-fe52c763b239'),
 ('289', '348', 'en_gb', 'Trampette 151207 115724', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:57', '2015-12-08 14:32:57', '9926fe43-0ca2-43d8-bcb6-06712c863eb6'),
 ('290', '349', 'en_gb', 'W Zgx W9 Oubl Vaaj Gcka U Vwpwy L6 Hk G J N0 G Wj Oui4 Pv Dz Bh Tafo1 L9eafkc8s Whd Btd K2xj Dqur Dg K7sjl8 A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:58', '2015-12-08 14:32:58', 'f9a6e601-2509-4373-9955-14f26fc9c926'),
 ('291', '350', 'en_gb', 'Ultrasound', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-08 14:32:59', '2015-12-08 14:32:59', 'a97a86f4-eafc-45fa-a6b1-6e55bdbe048e'),
 ('292', '352', 'en_gb', 'Logo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2015-12-10 21:24:14', '2015-12-10 21:24:14', '04e85fae-bc56-40c9-8a61-f5a87707776e'),
 ('294', '355', 'en_gb', 'Savings', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2016-01-07 12:01:20', '2016-01-07 12:01:20', 'f4d1d11f-8b4c-4ec9-8e4d-aed361b9281a'),
 ('295', '356', 'en_gb', '10% Discount on initial assessments', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, '10% Discount on initial assessments', 'Cathedral Physiotherapy is pleased to announce that members of the Spa Naturel Fitness at The Mercure Southgate Hotel are eligible to receive a 10% discount off their initial assessment. To receive the discount follow the instructions below.', NULL, '', NULL, NULL, '', NULL, '0', '2016-01-07 12:08:51', '2016-01-12 11:35:55', 'c9768f66-e2c5-454f-828f-d529e7d3ddf2'),
 ('296', '358', 'en_gb', 'Naturel Spa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2016-01-12 11:35:42', '2016-01-12 11:35:42', '97805323-1a58-459b-b0b4-351188555f28'),
 ('297', '359', 'en_gb', 'Exeter Living', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2016-01-12 21:13:04', '2016-01-12 21:13:04', '7d962d2a-e6da-4fc4-8891-58760bdba215'),
 ('298', '360', 'en_gb', 'Recent Advertorial in Exeter Living Jan 2016', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, 'Recent Advertorial in Exeter Living Jan 2016', 'Cathedral Physiotherapy has recently featured in an advertorial in Exeter Living. Click link below to read, page 28.', NULL, '', NULL, NULL, '', '[{\"col1\":\"Exeter Living advertorial\",\"col2\":\"http:\\/\\/flickread.com\\/edition\\/PensordFreeLibrary\\/5669c3398db6c\\/\"}]', '0', '2016-01-12 21:18:32', '2016-01-12 21:20:52', '3fda2ab3-173d-4f1b-bd5b-ca9c9ec44dae'),
 ('299', '361', 'en_gb', 'Bupa Logo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2016-02-09 21:33:47', '2016-02-09 21:47:25', 'adb47dfa-897e-4f01-a6ae-503229bb75ba'),
 ('300', '362', 'en_gb', 'Wpa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2016-02-09 21:33:55', '2016-02-09 21:33:55', 'e88b3f23-a593-4466-a414-83a22ae46471'),
 ('301', '363', 'en_gb', 'Vitality Health Logo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2016-02-09 21:34:04', '2016-02-09 21:34:04', '2616c94a-f5f4-4889-9b6e-ef20e54b725f'),
 ('302', '364', 'en_gb', 'Mdg Logo Web2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2016-02-09 21:34:14', '2016-02-09 21:34:14', '370935c4-3fc4-4b17-b14d-1afc68e496d3'),
 ('303', '365', 'en_gb', 'Private Health Insurance', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[]', NULL, '0', '2016-02-09 21:43:41', '2016-02-09 21:43:41', '2bf3da0e-ef25-40a8-98d4-991c24c6f0ef'),
 ('305', '367', 'en_gb', 'Private Health Insurance', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, 'Private Health Insurance', 'Cathedral Physiotherapy has \'Approved Provider\' status for various private health insurance companies', NULL, '', NULL, NULL, '', '[{\"col1\":\"\",\"col2\":\"\"}]', '0', '2016-02-09 22:01:40', '2016-02-09 22:01:54', '44493971-31d4-47fb-bf3b-6c786e6a99d6');



DROP TABLE IF EXISTS `craft_deprecationerrors`;


--
-- Schema for table `craft_deprecationerrors`
--
CREATE TABLE `craft_deprecationerrors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fingerprint` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lastOccurrence` datetime NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `line` smallint(6) unsigned NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `method` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `templateLine` smallint(6) unsigned DEFAULT NULL,
  `message` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `traces` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_deprecationerrors_key_fingerprint_unq_idx` (`key`,`fingerprint`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_elementindexsettings`;


--
-- Schema for table `craft_elementindexsettings`
--
CREATE TABLE `craft_elementindexsettings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `settings` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_elementindexsettings_type_unq_idx` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_elementindexsettings`
--

INSERT INTO `craft_elementindexsettings` (`id`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', 'Entry', '{\"sources\":{\"singles\":{\"tableAttributes\":{\"1\":\"link\",\"2\":\"postDate\",\"3\":\"dateCreated\"}}}}', '2015-12-02 09:00:57', '2015-12-02 09:00:57', 'c6517caa-8d2a-4052-bbf6-368d476d258b');



DROP TABLE IF EXISTS `craft_elements`;


--
-- Schema for table `craft_elements`
--
CREATE TABLE `craft_elements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `archived` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_elements_type_idx` (`type`),
  KEY `craft_elements_enabled_idx` (`enabled`),
  KEY `craft_elements_archived_dateCreated_idx` (`archived`,`dateCreated`)
) ENGINE=InnoDB AUTO_INCREMENT=372 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_elements`
--

INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', 'User', '1', '0', '2015-11-04 11:36:29', '2015-11-04 11:36:29', 'd3cb7d89-fd5c-4f18-8487-f8774c62b2af'),
 ('2', 'Entry', '1', '0', '2015-11-04 11:36:32', '2016-01-15 09:33:11', '7de79665-1e51-4ea9-8482-c5427b3965c5'),
 ('4', 'Entry', '1', '0', '2015-11-10 16:22:36', '2015-12-08 17:18:10', '2153f411-6a2a-4523-9fc9-8a52434333bf'),
 ('5', 'Entry', '1', '0', '2015-11-10 16:24:52', '2015-12-08 17:18:33', 'f1a1f413-56fe-4c1b-a893-bbd25abc6a90'),
 ('7', 'GlobalSet', '1', '0', '2015-11-10 16:28:51', '2015-12-04 22:09:30', '4e655f9d-7f0c-4db6-8c4f-fa15ac91d707'),
 ('8', 'Entry', '1', '0', '2015-11-13 09:37:14', '2015-12-08 17:19:00', '6b26386f-9dec-4c8e-b268-a02f99c644f3'),
 ('9', 'Entry', '1', '0', '2015-11-13 09:37:54', '2015-12-08 17:22:58', '3b165632-afba-41a1-8ee7-d449ad15ed26'),
 ('14', 'Entry', '1', '0', '2015-11-13 11:49:40', '2015-12-03 00:12:03', '71d17424-be16-4761-b8cc-899bc7928d44'),
 ('15', 'Entry', '1', '0', '2015-11-13 11:50:05', '2015-12-03 00:11:34', 'e3d0a78a-88cc-42dd-9860-5b10d096f7e5'),
 ('16', 'Entry', '1', '0', '2015-11-13 11:51:14', '2015-12-03 00:11:05', '6b5f272f-9af4-46c0-890a-d20283de0878'),
 ('17', 'Entry', '1', '0', '2015-11-13 11:51:34', '2015-12-04 17:02:16', '14c0a3a2-cd9f-4a41-bfea-abbe61af8d68'),
 ('18', 'Entry', '1', '0', '2015-11-13 11:51:51', '2015-12-03 00:09:38', '41799bb8-ed04-44fa-b299-26acf5f49c4f'),
 ('19', 'Entry', '1', '0', '2015-11-13 11:53:14', '2015-12-03 00:12:12', 'b5bf655a-cf16-409f-be02-953d780f4f99'),
 ('20', 'Entry', '1', '0', '2015-11-13 11:53:29', '2015-12-03 00:12:37', 'b755b202-2d39-499f-9b6e-5948fe2ffe0b'),
 ('21', 'Entry', '1', '0', '2015-11-13 11:53:48', '2015-12-03 00:12:47', 'fda1a574-9e0f-47fa-ba9b-6edb21c23871'),
 ('22', 'Entry', '1', '0', '2015-11-13 11:54:01', '2015-12-03 00:12:55', '9b2af7f0-19c7-4b65-83be-bfece196b909'),
 ('23', 'Entry', '1', '0', '2015-11-13 11:54:15', '2015-12-07 13:12:43', '8b1e8ba6-9b23-4e5e-8ebf-c184350761af'),
 ('24', 'Entry', '1', '0', '2015-11-13 11:54:33', '2015-12-03 00:04:47', '324e1e29-fb40-43e4-b12a-9f859e490c19'),
 ('25', 'Entry', '1', '0', '2015-11-13 11:55:27', '2015-12-03 00:13:52', '0a0e31a5-a163-4940-a738-1735637bcc5e'),
 ('26', 'Entry', '1', '0', '2015-11-13 11:55:43', '2015-12-03 00:04:51', '2e290be7-a46c-499c-8154-d41976e82a65'),
 ('27', 'Entry', '1', '0', '2015-11-13 11:55:55', '2015-12-03 00:04:55', '9d88aeed-ddd3-4f27-b283-4255c225497c'),
 ('28', 'Entry', '1', '0', '2015-11-13 11:56:08', '2015-12-03 00:04:59', '18896305-5a70-499f-82b9-c8b0321e333c'),
 ('29', 'Entry', '1', '0', '2015-11-13 11:56:26', '2015-12-07 11:15:05', 'c1bca228-d7df-447b-ae6e-1b4a6d8abd1f'),
 ('30', 'Entry', '1', '0', '2015-11-13 11:56:42', '2015-12-03 00:05:05', '21e0e064-3e75-4426-84ca-58f3d69ccbde'),
 ('31', 'Entry', '1', '0', '2015-11-13 11:56:55', '2015-12-02 23:43:36', 'c1a082bc-3112-4abd-ac0c-994cf02386f2'),
 ('32', 'Entry', '1', '0', '2015-11-13 11:57:11', '2015-12-06 22:21:35', '5c78c24c-0c27-40ad-943a-395897510404'),
 ('33', 'Entry', '1', '0', '2015-11-13 11:57:28', '2015-12-02 23:43:03', '9e87781d-35b9-4527-8be0-23c73a328613'),
 ('34', 'Entry', '1', '0', '2015-11-13 11:57:39', '2015-12-02 23:42:46', '7cc0a69c-4310-4ff2-a0ae-2e80cf752ad2'),
 ('35', 'Entry', '1', '0', '2015-11-13 11:57:51', '2015-12-02 23:42:19', '5e7fe080-26b5-46f9-a25f-215b77691ffc'),
 ('36', 'Entry', '1', '0', '2015-11-13 11:58:03', '2015-12-02 23:42:25', '7f73df69-23b9-4ff3-a092-6a6cc2dedbf4'),
 ('37', 'Entry', '1', '0', '2015-11-13 11:58:20', '2015-12-02 23:41:18', '19ae12b3-10ec-4ea1-a92d-19cf915f90f8'),
 ('42', 'MatrixBlock', '1', '0', '2015-11-13 12:54:30', '2015-12-04 22:09:30', 'bc5c14fc-f155-48c2-8a6f-5fb9ac66a5ab'),
 ('43', 'GlobalSet', '1', '0', '2015-11-13 12:54:44', '2015-12-04 17:02:38', '732b31f4-193e-4d74-877a-96bf1c2b7999'),
 ('44', 'MatrixBlock', '1', '0', '2015-11-13 12:57:48', '2015-12-04 17:02:38', 'fa597e40-0a47-4d34-b28b-810bfc0a7af0'),
 ('45', 'MatrixBlock', '1', '0', '2015-11-13 12:57:48', '2015-12-04 17:02:38', '68db6c8a-0281-4ed2-ac5b-7a8666ecf869'),
 ('46', 'MatrixBlock', '1', '0', '2015-11-13 12:57:48', '2015-12-04 17:02:38', '534f5673-2912-435b-aae5-0c33de8a5a15'),
 ('47', 'Entry', '1', '0', '2015-11-13 14:41:24', '2015-12-08 17:19:50', 'b943207e-c47b-4d0b-b745-396182e0cddb'),
 ('52', 'MatrixBlock', '1', '0', '2015-11-17 11:20:23', '2015-12-08 17:18:10', '5aa38e5e-9dcf-4790-8f91-69eee2103624'),
 ('53', 'MatrixBlock', '1', '0', '2015-11-17 11:20:23', '2015-12-08 17:18:10', '5ddeb920-d4c4-4bcc-826f-479232eab327'),
 ('54', 'MatrixBlock', '1', '0', '2015-11-17 11:20:23', '2015-12-08 17:18:10', 'c1a1a9b8-a6ef-441b-870f-2e2b59c329c1'),
 ('55', 'MatrixBlock', '1', '0', '2015-11-17 11:20:23', '2015-12-08 17:18:10', '7c14eeb4-ebc1-4010-94ea-bf02705140df'),
 ('57', 'Entry', '1', '0', '2015-11-17 14:07:49', '2015-12-08 17:20:33', '41bcaea2-aa0f-4c1f-a6f6-1a0520e010a4'),
 ('58', 'Entry', '1', '0', '2015-11-17 14:17:42', '2015-12-08 19:25:19', '00202e9c-5e91-4f33-853d-7c7411f2d0cd'),
 ('59', 'MatrixBlock', '1', '0', '2015-11-17 15:45:10', '2015-12-08 19:25:20', '4c73d7c8-2093-4c54-9009-6baa2f4d18d3'),
 ('60', 'MatrixBlock', '1', '0', '2015-11-17 15:45:10', '2015-12-08 19:25:20', '4bd19695-af28-480a-ac96-6c8ff7190346'),
 ('61', 'Entry', '1', '0', '2015-11-17 16:40:59', '2015-12-08 17:23:50', '988b7487-9b18-43cf-9f89-5e8b6bbdde62'),
 ('62', 'Entry', '1', '0', '2015-11-17 16:41:18', '2016-01-07 11:47:24', '9bf30a7c-d17c-485c-b560-b463aad508c6'),
 ('63', 'Entry', '1', '0', '2015-11-17 16:41:32', '2015-12-08 17:19:19', '16bcba56-9bfd-4d43-8273-9e59ed03b406'),
 ('74', 'MatrixBlock', '1', '0', '2015-11-24 16:38:18', '2015-12-08 19:25:20', '9ccd9403-22a8-4966-ab3f-3aef7748d74f'),
 ('75', 'MatrixBlock', '1', '0', '2015-11-24 16:38:18', '2015-12-08 19:25:20', '91f1a88f-230a-4c94-9b0a-e55c0dab5352'),
 ('85', 'MatrixBlock', '1', '0', '2015-11-25 14:09:00', '2015-12-08 17:18:33', '07ec00de-34a3-4b98-942b-5092dfa81fd2'),
 ('86', 'MatrixBlock', '1', '0', '2015-11-25 14:09:00', '2015-12-08 17:18:33', '4ec157e7-4d29-418e-b8a5-54a3d1c72c75'),
 ('87', 'MatrixBlock', '1', '0', '2015-11-25 14:09:00', '2015-12-08 17:18:33', '720eaa7c-3dc3-4673-80c3-75657c2bfb5f'),
 ('88', 'MatrixBlock', '1', '0', '2015-11-25 14:09:00', '2015-12-08 17:18:33', 'a4fc1a66-d3d2-4cf3-a3e5-005c0df0aded'),
 ('98', 'MatrixBlock', '1', '0', '2015-11-26 11:46:49', '2015-12-08 17:18:33', 'a7177564-5b54-4c83-b6e5-15bec1acc1f3'),
 ('99', 'Entry', '1', '0', '2015-11-26 13:59:16', '2015-12-08 21:26:01', '5e0efe1f-72ff-42db-b9f4-87337c49dc16'),
 ('101', 'MatrixBlock', '1', '0', '2015-11-26 14:30:34', '2015-12-08 21:26:01', '0bf1f069-62da-40ff-93ba-ecea2e374bd8'),
 ('102', 'MatrixBlock', '1', '0', '2015-11-26 14:30:34', '2015-12-08 21:26:02', '16cdab91-0b00-4fee-9709-eaef76ca3b05'),
 ('103', 'MatrixBlock', '1', '0', '2015-11-26 14:30:34', '2015-12-08 21:26:02', '215f7a51-ef1f-4079-8e51-32bf9431c868'),
 ('104', 'MatrixBlock', '1', '0', '2015-11-26 14:30:34', '2015-12-08 21:26:02', '261d7b17-ae01-4f2d-a1e7-3b576ff7b3ad'),
 ('105', 'MatrixBlock', '1', '0', '2015-11-26 14:46:03', '2015-12-08 21:26:02', '1675ab71-bdf5-497c-bb41-f10fa118e85e'),
 ('106', 'MatrixBlock', '1', '0', '2015-11-26 14:46:03', '2015-12-08 21:26:02', '9977d52e-7779-4900-95e3-c2c0a6ef0646'),
 ('107', 'MatrixBlock', '1', '0', '2015-11-26 14:46:03', '2015-12-08 21:26:02', '4bc0982c-6053-4dc7-a615-5c7b3b9c5ca7'),
 ('108', 'MatrixBlock', '1', '0', '2015-11-26 14:46:03', '2015-12-08 21:26:02', 'f025b70d-bd37-47d7-bebc-3dc4850157c0'),
 ('109', 'Entry', '1', '0', '2015-11-30 09:23:57', '2015-12-08 21:25:20', '8a404c7b-4e2d-4dce-a58f-943ada7c27e5'),
 ('110', 'MatrixBlock', '1', '0', '2015-11-30 09:23:58', '2015-12-08 21:25:20', '52cade5f-19ec-4835-ae65-8a410e9fced4'),
 ('111', 'MatrixBlock', '1', '0', '2015-11-30 09:23:58', '2015-12-08 21:25:20', '433de69b-4e70-491e-aee2-a9ba21660cea'),
 ('121', 'MatrixBlock', '1', '0', '2015-12-01 09:52:45', '2015-12-08 17:19:19', 'a5dd084b-f094-4ec4-9ab9-414912f8b9de'),
 ('122', 'MatrixBlock', '1', '0', '2015-12-01 09:52:45', '2015-12-08 17:19:19', '3d0c34bb-44b9-4c1b-9c3c-e2fa4ed28127'),
 ('123', 'MatrixBlock', '1', '0', '2015-12-01 09:52:45', '2015-12-08 17:19:19', 'f0de715f-f68f-440e-9cf3-3fbb2ed98783'),
 ('124', 'User', '1', '0', '2015-12-01 17:25:21', '2015-12-01 17:35:02', '024978ed-a4f4-4e68-9a23-d2879c400acf'),
 ('125', 'User', '1', '0', '2015-12-02 09:07:26', '2015-12-02 09:07:26', 'c00ee87d-1578-45b9-9161-bae37096caae'),
 ('126', 'MatrixBlock', '1', '0', '2015-12-02 11:49:33', '2015-12-08 17:23:51', '50a428af-fb72-4583-8ad1-362c572763ca'),
 ('127', 'MatrixBlock', '1', '0', '2015-12-02 11:50:18', '2015-12-08 17:23:51', '4702b08e-bcba-462b-8f50-3deb07f98bbb'),
 ('128', 'MatrixBlock', '1', '0', '2015-12-02 11:50:18', '2015-12-08 17:23:51', '1068f51c-0847-4f61-a280-d6dc3b04208a'),
 ('129', 'MatrixBlock', '1', '0', '2015-12-02 11:51:02', '2016-01-07 11:47:24', '4c7368a4-3275-469a-b2a0-e277c5db94ad'),
 ('130', 'MatrixBlock', '1', '0', '2015-12-02 11:51:02', '2016-01-07 11:47:25', '27689785-88f4-46b0-9447-c99e1ef4f1e9'),
 ('131', 'MatrixBlock', '1', '0', '2015-12-02 11:51:02', '2016-01-07 11:47:25', '1e1793b0-0175-4dac-bd28-5919d679587d'),
 ('141', 'Entry', '1', '0', '2015-12-04 22:25:11', '2015-12-08 21:24:19', 'cc1d9132-a05a-4e0a-aa12-97ddaa840878'),
 ('142', 'MatrixBlock', '1', '0', '2015-12-04 22:25:11', '2015-12-08 21:24:19', '5aff4274-83f3-49ce-9407-4280d45d97d0'),
 ('143', 'MatrixBlock', '1', '0', '2015-12-04 22:25:11', '2015-12-08 21:24:19', '826ce2cc-eb75-41ce-8065-0a0b206d8ae3'),
 ('144', 'MatrixBlock', '1', '0', '2015-12-04 22:25:11', '2015-12-08 21:24:20', '71d39ef2-51c2-49ab-b2e2-ccb4180d5b81'),
 ('145', 'MatrixBlock', '1', '0', '2015-12-04 22:25:11', '2015-12-08 21:24:20', '58904b15-774a-4835-8eb0-dd830067ef11'),
 ('146', 'MatrixBlock', '1', '0', '2015-12-04 22:25:11', '2015-12-08 21:24:21', '8477c386-06b6-43b6-9aa6-e02207f3bc53'),
 ('147', 'MatrixBlock', '1', '0', '2015-12-04 22:25:11', '2015-12-08 21:24:21', 'b65d3c56-141d-4d6c-ba17-78f0e60545b6'),
 ('148', 'MatrixBlock', '1', '0', '2015-12-04 22:25:11', '2015-12-08 21:24:21', '998d48f7-116a-415e-92e1-02891f89afd9'),
 ('191', 'MatrixBlock', '1', '0', '2015-12-07 14:53:05', '2015-12-08 21:24:20', '81721678-2a5a-4a80-a492-5f078802becf'),
 ('192', 'MatrixBlock', '1', '0', '2015-12-07 14:53:05', '2015-12-08 21:24:20', '6a6ef8e1-e225-4ae7-a8bb-bfa1b29b0e0e'),
 ('225', 'MatrixBlock', '1', '0', '2015-12-07 17:03:11', '2015-12-08 19:25:20', '39bd5b91-3554-46e6-924b-814793f00930'),
 ('226', 'Asset', '1', '0', '2015-12-08 14:27:57', '2015-12-08 14:32:13', '23827d86-6bde-4c1a-b227-6aeb5800e3e9'),
 ('227', 'Asset', '1', '0', '2015-12-08 14:27:59', '2015-12-08 14:32:10', 'e35909e3-fd20-480a-a94e-b58b4c9df203'),
 ('228', 'Asset', '1', '0', '2015-12-08 14:28:00', '2015-12-08 14:32:10', '5f5dce22-8b57-42dd-bfec-dc8a9c5081c6'),
 ('229', 'Asset', '1', '0', '2015-12-08 14:28:02', '2015-12-08 14:32:11', '56ae314e-a16a-4ac6-aee8-e629c114b999'),
 ('230', 'Asset', '1', '0', '2015-12-08 14:28:03', '2015-12-08 14:32:12', '93be67d4-fe47-4239-b890-434d764b0733'),
 ('231', 'Asset', '1', '0', '2015-12-08 14:28:04', '2015-12-08 14:32:12', '1d3b9f8c-27e5-4d16-a2ce-9d55340a5a2c'),
 ('232', 'Asset', '1', '0', '2015-12-08 14:28:06', '2015-12-08 14:32:16', '869b0a1a-f43c-4492-b6c4-41b47d4f84c0'),
 ('233', 'Asset', '1', '0', '2015-12-08 14:28:09', '2015-12-08 14:32:18', 'c21d16c7-fcc2-4712-9a31-29ce352e4f78'),
 ('234', 'Asset', '1', '0', '2015-12-08 14:28:14', '2015-12-08 14:32:19', '1578d1a9-bdc5-41fb-aaeb-aae19d2f1e7c'),
 ('235', 'Asset', '1', '0', '2015-12-08 14:28:16', '2015-12-08 14:32:20', 'db9d288b-e85b-4981-bdee-f7ba36754ed9'),
 ('236', 'Asset', '1', '0', '2015-12-08 14:28:18', '2015-12-08 14:32:23', 'c8a7b1bb-efd1-4d85-bc87-3c2d249b00ff');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('237', 'Asset', '1', '0', '2015-12-08 14:28:20', '2015-12-08 14:32:26', '1da7da88-3d32-4a17-a92e-60467f468ebe'),
 ('238', 'Asset', '1', '0', '2015-12-08 14:28:21', '2015-12-08 14:32:28', '6e0f17e2-8a35-4847-8c67-c89f741985af'),
 ('239', 'Asset', '1', '0', '2015-12-08 14:31:36', '2015-12-08 14:31:37', 'fd0c0ebf-cb99-401d-a60c-467b7b86cb80'),
 ('240', 'Asset', '1', '0', '2015-12-08 14:31:38', '2015-12-08 14:31:38', 'a239c135-6771-40f7-a687-607558d0bc3a'),
 ('241', 'Asset', '1', '0', '2015-12-08 14:31:38', '2015-12-08 14:31:39', 'ee771257-026e-45c8-95b0-f8ced6bede24'),
 ('242', 'Asset', '1', '0', '2015-12-08 14:31:39', '2015-12-08 14:31:39', '6182c4d4-a7ec-41b8-b63d-f4c377318ccc'),
 ('243', 'Asset', '1', '0', '2015-12-08 14:31:40', '2015-12-08 14:31:40', 'fc156da3-37b0-43aa-a2cc-55dfd8bbd5d8'),
 ('244', 'Asset', '1', '0', '2015-12-08 14:31:41', '2015-12-08 14:31:41', '4fd8d8b8-221c-4ef9-be7f-663b2bc08e8c'),
 ('245', 'Asset', '1', '0', '2015-12-08 14:31:41', '2015-12-08 14:31:41', '64a7e8ae-f45b-463d-9327-1d5c090556c8'),
 ('246', 'Asset', '1', '0', '2015-12-08 14:31:42', '2015-12-08 14:31:42', '067b461f-d649-4b9a-8588-fa21f5684b64'),
 ('247', 'Asset', '1', '0', '2015-12-08 14:31:42', '2015-12-08 14:31:42', '4e16187e-7256-46f7-a988-1ce6a59ca6e8'),
 ('248', 'Asset', '1', '0', '2015-12-08 14:31:43', '2015-12-08 14:31:43', '1d44e968-9d93-47ab-a7ca-d3dfbf335c00'),
 ('249', 'Asset', '1', '0', '2015-12-08 14:31:43', '2015-12-08 14:31:44', '954f18f8-702b-42f4-b965-96fea4d17b83'),
 ('250', 'Asset', '1', '0', '2015-12-08 14:31:44', '2015-12-08 14:31:45', '0022aedd-8570-489b-8f17-d26587fab2f6'),
 ('251', 'Asset', '1', '0', '2015-12-08 14:31:45', '2015-12-08 14:31:45', 'b2796187-0b3c-4200-a27e-f1c73202f3d7'),
 ('252', 'Asset', '1', '0', '2015-12-08 14:31:46', '2015-12-08 14:31:46', '7270e2d3-6bdb-451a-819e-700b5e5627ab'),
 ('253', 'Asset', '1', '0', '2015-12-08 14:31:46', '2015-12-08 14:31:47', '8ed6a356-d43d-4b67-af0d-f4b5f2371804'),
 ('254', 'Asset', '1', '0', '2015-12-08 14:31:47', '2015-12-08 14:31:47', '160f2430-b9e0-4671-8069-6cf5ca398708'),
 ('255', 'Asset', '1', '0', '2015-12-08 14:31:48', '2015-12-08 14:31:48', '2475339e-4b98-4c00-9cf3-59f5f6532be5'),
 ('256', 'Asset', '1', '0', '2015-12-08 14:31:48', '2015-12-08 14:31:48', 'eda53ec5-f58e-4a7b-8849-fd338104260b'),
 ('257', 'Asset', '1', '0', '2015-12-08 14:31:49', '2015-12-08 14:31:49', 'a1c26556-ff30-44cc-b179-f18627b5a515'),
 ('258', 'Asset', '1', '0', '2015-12-08 14:31:49', '2015-12-08 14:31:50', 'fee051bd-afd4-4360-8444-d9d400bcd94d'),
 ('259', 'Asset', '1', '0', '2015-12-08 14:31:50', '2015-12-08 14:31:50', 'ef6ce573-132e-472e-aa30-449ba415186f'),
 ('260', 'Asset', '1', '0', '2015-12-08 14:31:50', '2015-12-08 14:31:51', 'b6ece7e5-db20-45ca-b690-6cea917fe94a'),
 ('261', 'Asset', '1', '0', '2015-12-08 14:31:51', '2015-12-08 14:31:51', 'f0937fc2-4b87-43b9-92e8-6f699c39ae00'),
 ('262', 'Asset', '1', '0', '2015-12-08 14:31:51', '2015-12-08 14:31:52', '21cc0874-0739-4240-9185-8d6cb19d2131'),
 ('263', 'Asset', '1', '0', '2015-12-08 14:31:52', '2015-12-08 14:31:52', '197f0212-1037-4c10-9385-fe6098dbc97f'),
 ('264', 'Asset', '1', '0', '2015-12-08 14:31:53', '2015-12-08 14:31:53', 'df8be2c7-5110-4b27-8275-81d08f6158ab'),
 ('265', 'Asset', '1', '0', '2015-12-08 14:31:53', '2015-12-08 14:31:53', '7e9f4240-2a95-49a3-a581-85f78f9051be'),
 ('266', 'Asset', '1', '0', '2015-12-08 14:31:54', '2015-12-08 14:31:54', '35fb6c95-8d33-4642-be88-03694c7403aa'),
 ('267', 'Asset', '1', '0', '2015-12-08 14:31:55', '2015-12-08 14:31:55', '75bd3feb-446a-4e56-8f84-0bf0f041f8bb'),
 ('268', 'Asset', '1', '0', '2015-12-08 14:31:55', '2015-12-08 14:31:55', '4f96fb4f-7222-49da-8670-0bcc4ae1efbe'),
 ('269', 'Asset', '1', '0', '2015-12-08 14:31:57', '2015-12-08 14:31:57', 'a4f9b5bf-cc4d-4dd9-bb9a-142b521f4f10'),
 ('270', 'Asset', '1', '0', '2015-12-08 14:31:58', '2015-12-08 14:31:58', '75775a14-9a94-4606-af4a-7610bc34b770'),
 ('271', 'Asset', '1', '0', '2015-12-08 14:31:58', '2015-12-08 14:31:59', '48563731-f834-4d89-b95c-1520b24db395'),
 ('272', 'Asset', '1', '0', '2015-12-08 14:31:59', '2015-12-08 14:31:59', '3a9c9f9f-5783-47f8-b859-449601b0c746'),
 ('273', 'Asset', '1', '0', '2015-12-08 14:32:00', '2015-12-08 14:32:00', '18da6c4a-12da-4c71-9c78-1972cc9c4241'),
 ('274', 'Asset', '1', '0', '2015-12-08 14:32:01', '2015-12-08 14:32:01', '0460884d-c765-49df-a0cb-da0e96b515a4'),
 ('275', 'Asset', '1', '0', '2015-12-08 14:32:01', '2015-12-08 14:32:02', '4484a9aa-891b-4362-9d17-1d3958d665a8'),
 ('276', 'Asset', '1', '0', '2015-12-08 14:32:02', '2015-12-08 14:32:02', 'a2a13539-bd01-47f4-b297-c2340eed9c4b'),
 ('277', 'Asset', '1', '0', '2015-12-08 14:32:02', '2015-12-08 14:32:03', '2f2356c9-b683-4e27-a6e8-307f2c8db5e1'),
 ('278', 'Asset', '1', '0', '2015-12-08 14:32:03', '2015-12-08 14:32:03', '5c29fd8a-531c-42bf-9cf3-393763c9548e'),
 ('279', 'Asset', '1', '0', '2015-12-08 14:32:03', '2015-12-08 14:32:03', '3862aab2-c5e2-4478-8813-ed5c02e7731c'),
 ('280', 'Asset', '1', '0', '2015-12-08 14:32:04', '2015-12-08 14:32:04', 'a5c6a940-3aef-42b4-bb26-5169d185d286'),
 ('281', 'Asset', '1', '0', '2015-12-08 14:32:04', '2015-12-08 14:32:04', 'a6190f35-f89a-48c0-aa81-ac1038f86968'),
 ('282', 'Asset', '1', '0', '2015-12-08 14:32:04', '2015-12-08 14:32:05', 'db7cbb90-171b-4ab0-82af-833679125c46'),
 ('283', 'Asset', '1', '0', '2015-12-08 14:32:05', '2015-12-08 14:32:05', 'ad527d2e-0ab8-4bc9-bfd5-8b921fc45643'),
 ('284', 'Asset', '1', '0', '2015-12-08 14:32:06', '2015-12-08 14:32:06', 'ce93c96d-ce44-4e23-b866-b8f3b0bdd787'),
 ('285', 'Asset', '1', '0', '2015-12-08 14:32:07', '2015-12-08 14:32:07', '3621e928-1000-446e-a4a3-6946a7b98f50'),
 ('286', 'Asset', '1', '0', '2015-12-08 14:32:07', '2015-12-08 14:32:08', '271ed8c3-0ef6-44cf-852c-eaf9788d78b9'),
 ('287', 'Asset', '1', '0', '2015-12-08 14:32:08', '2015-12-08 14:32:08', '9e5320bc-99be-4fc0-ab0d-ce74ee7b08a7'),
 ('288', 'Asset', '1', '0', '2015-12-08 14:32:08', '2015-12-08 14:32:09', 'efa82432-8e99-405f-82b9-aa31279281b0'),
 ('289', 'Asset', '1', '0', '2015-12-08 14:32:09', '2015-12-08 14:32:09', '10c2572f-a17b-4e13-a6a5-6f17d7992dcf'),
 ('290', 'Asset', '1', '0', '2015-12-08 14:32:09', '2015-12-08 14:32:10', '33b9c76b-bff1-41e2-ae48-a6d33a3bdc1d'),
 ('291', 'Asset', '1', '0', '2015-12-08 14:32:10', '2015-12-08 14:32:11', '1ef2afd0-1611-4eab-861c-cdfe8850c907'),
 ('292', 'Asset', '1', '0', '2015-12-08 14:32:11', '2015-12-08 14:32:11', 'df8d6420-8274-485e-a00c-93ae6cdd6970'),
 ('293', 'Asset', '1', '0', '2015-12-08 14:32:12', '2015-12-08 14:32:12', '34bafa98-590f-45a0-9e98-7937d311f74b'),
 ('294', 'Asset', '1', '0', '2015-12-08 14:32:14', '2015-12-08 14:32:14', 'c9fbd2a6-e1ce-4129-a5f1-ed21b6828cb5'),
 ('295', 'Asset', '1', '0', '2015-12-08 14:32:14', '2015-12-08 14:32:15', 'fc09c4a6-5bb5-43e6-a533-495961397933'),
 ('296', 'Asset', '1', '0', '2015-12-08 14:32:17', '2015-12-08 14:32:17', '7941b17a-8c5c-4bdc-8b38-7fbbd1f4a613'),
 ('297', 'Asset', '1', '0', '2015-12-08 14:32:17', '2015-12-08 14:32:18', 'af48763a-eeda-4210-884b-44357f5ebf4a'),
 ('298', 'Asset', '1', '0', '2015-12-08 14:32:18', '2015-12-08 14:32:18', '21bc489b-2800-45f7-90df-1a52f4b2d0c9'),
 ('299', 'Asset', '1', '0', '2015-12-08 14:32:19', '2015-12-08 14:32:19', 'abd72a43-6e45-4da8-a277-4e95bdcbbe60'),
 ('300', 'Asset', '1', '0', '2015-12-08 14:32:19', '2015-12-08 14:32:19', '8673d256-11ed-47af-911d-b546467ff285'),
 ('301', 'Asset', '1', '0', '2015-12-08 14:32:21', '2015-12-08 14:32:21', '23ea38c0-2ec1-4add-b0e3-f71982f8325c'),
 ('302', 'Asset', '1', '0', '2015-12-08 14:32:21', '2015-12-08 14:32:21', '92643fae-5b4b-43ac-b2dc-bbf5b42a6db4'),
 ('303', 'Asset', '1', '0', '2015-12-08 14:32:23', '2015-12-08 14:32:24', 'a4112ac6-a494-46c2-8c02-6dfe984c7a16'),
 ('304', 'Asset', '1', '0', '2015-12-08 14:32:24', '2015-12-08 14:32:25', '39075f6e-850a-4512-b27e-74d442c156dc'),
 ('305', 'Asset', '1', '0', '2015-12-08 14:32:25', '2015-12-08 14:32:26', '46c6a145-a7e8-4d40-82ee-9609c6333253'),
 ('306', 'Asset', '1', '0', '2015-12-08 14:32:26', '2015-12-08 14:32:27', '66ce36c7-6be9-4c41-9468-2a97c4e638c2'),
 ('307', 'Asset', '1', '0', '2015-12-08 14:32:28', '2015-12-08 14:32:28', '2d08f405-26a4-4724-a0be-ad97eb0b7087'),
 ('308', 'Asset', '1', '0', '2015-12-08 14:32:29', '2015-12-08 14:32:29', '21471f3d-ae65-4f7f-a278-6af391293c42'),
 ('309', 'Asset', '1', '0', '2015-12-08 14:32:29', '2015-12-08 14:32:29', 'fbb19f7c-1070-4e7f-9531-1619f423d1d5'),
 ('310', 'Asset', '1', '0', '2015-12-08 14:32:30', '2015-12-08 14:32:30', '474cbc5f-183a-4225-ac46-06ff1bcd076b'),
 ('311', 'Asset', '1', '0', '2015-12-08 14:32:31', '2015-12-08 14:32:31', '79f4e55d-6fba-469a-a200-a27430677e38'),
 ('312', 'Asset', '1', '0', '2015-12-08 14:32:33', '2015-12-08 14:32:34', '31501513-38e9-484d-937b-4cf81a8e9ef8'),
 ('313', 'Asset', '1', '0', '2015-12-08 14:32:34', '2015-12-08 14:32:35', '97527097-e0c8-456f-83de-e151c665333f'),
 ('314', 'Asset', '1', '0', '2015-12-08 14:32:35', '2015-12-08 14:32:35', 'fd364b73-c184-4705-a880-9abd062f6a0c'),
 ('315', 'Asset', '1', '0', '2015-12-08 14:32:36', '2015-12-08 14:32:36', '0011a151-f3a0-4bad-a36b-5db69d6f3102'),
 ('316', 'Asset', '1', '0', '2015-12-08 14:32:37', '2015-12-08 14:32:38', '82e4c5d4-1b68-4ca4-837e-09d46a7830a4'),
 ('317', 'Asset', '1', '0', '2015-12-08 14:32:38', '2015-12-08 14:32:38', '7764daf9-7cda-4af0-bb90-728b5e6f2223'),
 ('318', 'Asset', '1', '0', '2015-12-08 14:32:38', '2015-12-08 14:32:38', 'babfc6ab-9ef6-44e8-96d0-93e2fc946af0'),
 ('319', 'Asset', '1', '0', '2015-12-08 14:32:39', '2015-12-08 14:32:39', '93a270ed-75e0-4b2f-a4dc-a03e18337c70'),
 ('320', 'Asset', '1', '0', '2015-12-08 14:32:40', '2015-12-08 14:32:40', 'e4c6b82c-1d53-4ab2-b781-582462362ee7'),
 ('321', 'Asset', '1', '0', '2015-12-08 14:32:40', '2015-12-08 14:32:41', '48bc5e9d-ab88-4eba-9987-9241f73abaa3'),
 ('322', 'Asset', '1', '0', '2015-12-08 14:32:41', '2015-12-08 14:32:41', '5e008d6f-0960-439b-8579-4ee582023a0e'),
 ('323', 'Asset', '1', '0', '2015-12-08 14:32:42', '2015-12-08 14:32:42', 'b93599f6-97ba-4aac-8a77-ba095ecff4d3'),
 ('324', 'Asset', '1', '0', '2015-12-08 14:32:42', '2015-12-08 14:32:42', 'd1bc1d6c-6cfe-468a-a34e-d362ec6eb0cf'),
 ('325', 'Asset', '1', '0', '2015-12-08 14:32:42', '2015-12-08 14:32:43', '85d1be6a-c86a-4f02-b29d-9f0237c1e75b'),
 ('326', 'Asset', '1', '0', '2015-12-08 14:32:43', '2015-12-08 14:32:43', 'a073e646-2c9c-47c4-b980-317d1dbf344e'),
 ('327', 'Asset', '1', '0', '2015-12-08 14:32:44', '2015-12-08 14:32:44', '6f7aad83-231a-49f0-9488-df34e9e6f292'),
 ('328', 'Asset', '1', '0', '2015-12-08 14:32:45', '2015-12-08 14:32:46', '993a6a36-ffe0-4eff-ac88-948473d8ad27'),
 ('329', 'Asset', '1', '0', '2015-12-08 14:32:46', '2015-12-08 14:32:46', '07f5f5c9-5826-4931-84ba-d7a7d047d8d2'),
 ('330', 'Asset', '1', '0', '2015-12-08 14:32:46', '2015-12-08 14:32:47', '4943dc49-4aa3-4e59-9653-5cbf213410a6'),
 ('331', 'Asset', '1', '0', '2015-12-08 14:32:47', '2015-12-08 14:32:47', 'ed1f323e-831c-4da9-b7e2-4b52dfa3f772'),
 ('332', 'Asset', '1', '0', '2015-12-08 14:32:47', '2015-12-08 14:32:48', '8c015877-9bed-4650-ad3a-b756429ee341'),
 ('333', 'Asset', '1', '0', '2015-12-08 14:32:48', '2015-12-08 14:32:48', '25563712-4c85-44d8-88b9-b3dfa11de29a'),
 ('334', 'Asset', '1', '0', '2015-12-08 14:32:48', '2015-12-08 14:32:49', '2dd2fcd1-85b5-44fc-b814-de55810c0e6d'),
 ('335', 'Asset', '1', '0', '2015-12-08 14:32:49', '2015-12-08 14:32:49', '1ba26796-0985-4e52-b65c-f0a97871ca3f'),
 ('336', 'Asset', '1', '0', '2015-12-08 14:32:50', '2015-12-08 14:32:50', '93086a85-55c7-4e80-81dd-5631aa18ab8f');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('337', 'Asset', '1', '0', '2015-12-08 14:32:50', '2015-12-08 14:32:50', 'c2f0f8ca-d13f-47ae-aeba-4e4eba64b989'),
 ('338', 'Asset', '1', '0', '2015-12-08 14:32:51', '2015-12-08 14:32:52', '142d41aa-8d2d-4587-be04-ef5f8d5d09a9'),
 ('339', 'Asset', '1', '0', '2015-12-08 14:32:52', '2015-12-08 14:32:52', 'b96b8759-2cae-4032-bc86-78eb77be2874'),
 ('340', 'Asset', '1', '0', '2015-12-08 14:32:52', '2015-12-08 14:32:52', 'e6ecd08e-95da-4aee-91d3-b2ab63a00d2a'),
 ('341', 'Asset', '1', '0', '2015-12-08 14:32:53', '2015-12-08 14:32:53', '075a5203-c2c3-43d6-9ead-088549f0380c'),
 ('342', 'Asset', '1', '0', '2015-12-08 14:32:53', '2015-12-08 14:32:53', '1285020b-a602-4d98-9c3e-3bc53ff9015a'),
 ('343', 'Asset', '1', '0', '2015-12-08 14:32:53', '2015-12-08 14:32:54', 'f827e403-17ad-4cbd-ac00-8a65aeb4d5e2'),
 ('344', 'Asset', '1', '0', '2015-12-08 14:32:54', '2015-12-08 14:32:55', '674e977a-d846-43e4-943b-fc11c741a89f'),
 ('345', 'Asset', '1', '0', '2015-12-08 14:32:55', '2015-12-08 14:32:56', 'bac7ad3b-1853-4b0e-8153-2631d1211271'),
 ('346', 'Asset', '1', '0', '2015-12-08 14:32:56', '2015-12-08 14:32:57', '6295acb9-2c24-4945-aff9-eb9f6bd0c9aa'),
 ('347', 'Asset', '1', '0', '2015-12-08 14:32:57', '2015-12-08 14:32:57', 'a04ee94d-1a36-4e54-9786-48f99a65ecf5'),
 ('348', 'Asset', '1', '0', '2015-12-08 14:32:57', '2015-12-08 14:32:57', '2f9c3c22-ef70-4e6e-9152-6be9fad87d64'),
 ('349', 'Asset', '1', '0', '2015-12-08 14:32:58', '2015-12-08 14:32:58', '93f5c576-5f51-4e42-99a2-1018efe25544'),
 ('350', 'Asset', '1', '0', '2015-12-08 14:32:59', '2015-12-08 14:32:59', '0cf70a64-aa83-41c5-b6d4-abcad50ee14c'),
 ('351', 'MatrixBlock', '1', '0', '2015-12-08 19:13:43', '2015-12-08 19:25:20', 'ab9313fe-467a-4f1d-a60f-7653f70d2b1d'),
 ('352', 'Asset', '1', '0', '2015-12-10 21:24:14', '2015-12-10 21:24:14', '9287efd5-f2dc-4909-a1ae-76851cb725e9'),
 ('355', 'Asset', '1', '0', '2016-01-07 12:01:20', '2016-01-07 12:01:20', 'c7a9b649-3f44-4bad-b572-1c8324e226b7'),
 ('356', 'Entry', '1', '0', '2016-01-07 12:08:51', '2016-01-12 11:35:55', '5b340427-c306-4e83-b53c-230426d6ab19'),
 ('357', 'MatrixBlock', '1', '0', '2016-01-07 12:08:51', '2016-01-12 11:35:55', '99601b47-a9b8-4dba-bc34-61082cd859dd'),
 ('358', 'Asset', '1', '0', '2016-01-12 11:35:42', '2016-01-12 11:35:42', 'e8df6ef7-e762-4c8c-aaef-e365b6cc558d'),
 ('359', 'Asset', '1', '0', '2016-01-12 21:13:04', '2016-01-12 21:13:04', 'eb83b46e-8e22-4448-badf-4a4050c28e20'),
 ('360', 'Entry', '1', '0', '2016-01-12 21:18:32', '2016-01-12 21:20:52', '9e8d7907-696d-4c2c-9bee-890f7e221e2e'),
 ('361', 'Asset', '1', '0', '2016-02-09 21:33:47', '2016-02-09 21:47:25', 'dec85e1f-8c64-4d05-80a6-eaf9ac826dfa'),
 ('362', 'Asset', '1', '0', '2016-02-09 21:33:55', '2016-02-09 21:33:55', 'eb03a94a-d378-4795-8ce6-25bc5b774998'),
 ('363', 'Asset', '1', '0', '2016-02-09 21:34:04', '2016-02-09 21:34:04', '71f89a5c-f011-44ee-808d-7934f9891a95'),
 ('364', 'Asset', '1', '0', '2016-02-09 21:34:14', '2016-02-09 21:34:14', 'f712107c-4857-4f04-b548-3c54449eddfe'),
 ('365', 'Asset', '1', '0', '2016-02-09 21:43:41', '2016-02-09 21:43:41', '9532140f-6bec-4626-b4c3-2cfa18b3443c'),
 ('367', 'Entry', '1', '0', '2016-02-09 22:01:40', '2016-02-09 22:01:54', '893d1bfc-56cb-4bdb-85e6-4e49b276b3ae'),
 ('368', 'MatrixBlock', '1', '0', '2016-02-09 22:01:41', '2016-02-09 22:01:55', '3409106f-5f6c-4f67-a06d-2bf83f2477f0'),
 ('369', 'MatrixBlock', '1', '0', '2016-02-09 22:01:41', '2016-02-09 22:01:55', '4ede3d50-8f17-4aa3-9b0c-16afeeecb396'),
 ('370', 'MatrixBlock', '1', '0', '2016-02-09 22:01:41', '2016-02-09 22:01:55', '6a5df80f-1b89-48c2-abea-d41bd1cdb125'),
 ('371', 'MatrixBlock', '1', '0', '2016-02-09 22:01:41', '2016-02-09 22:01:55', '97a0128f-e716-43d4-9b2f-dc94c75ae853');



DROP TABLE IF EXISTS `craft_elements_i18n`;


--
-- Schema for table `craft_elements_i18n`
--
CREATE TABLE `craft_elements_i18n` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uri` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_elements_i18n_elementId_locale_unq_idx` (`elementId`,`locale`),
  UNIQUE KEY `craft_elements_i18n_uri_locale_unq_idx` (`uri`,`locale`),
  KEY `craft_elements_i18n_slug_locale_idx` (`slug`,`locale`),
  KEY `craft_elements_i18n_enabled_idx` (`enabled`),
  KEY `craft_elements_i18n_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=370 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_elements_i18n`
--

INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '1', 'en_gb', '', NULL, '1', '2015-11-04 11:36:29', '2015-11-04 11:36:29', 'fe0fb403-bfbf-4246-b251-ac233cf19f81'),
 ('2', '2', 'en_gb', 'homepage', '__home__', '1', '2015-11-04 11:36:32', '2016-01-15 09:33:11', 'd3a34750-2aa9-4128-9e37-ee07c29d59ad'),
 ('4', '4', 'en_gb', 'about', 'about', '1', '2015-11-10 16:22:36', '2015-12-08 17:18:10', '188e8eff-fd0b-4aae-9ee2-b7d557d4f13e'),
 ('5', '5', 'en_gb', 'accreditations', 'accreditations', '1', '2015-11-10 16:24:52', '2015-12-08 17:18:33', 'a20d9fc7-70ee-4455-9f2a-09c76b3c69b5'),
 ('7', '7', 'en_gb', '', NULL, '1', '2015-11-10 16:28:51', '2015-12-04 22:09:30', '4331e16c-2712-45b5-ba01-1dfb39ee410e'),
 ('8', '8', 'en_gb', 'find-us', 'find-us', '1', '2015-11-13 09:37:14', '2015-12-08 17:19:00', '9f6168e2-1ac0-4088-86ee-9b30ef8cdcc9'),
 ('9', '9', 'en_gb', 'treatments', 'treatments', '1', '2015-11-13 09:37:54', '2015-12-08 17:22:58', '13e0fd10-42cd-42e2-b831-588873938bab'),
 ('12', '14', 'en_gb', 'fractures', NULL, '1', '2015-11-13 11:49:40', '2015-12-03 00:12:04', 'd05dc1c2-7403-4c0d-a4b8-2201582a15e5'),
 ('13', '15', 'en_gb', 'childrens-injuries', NULL, '1', '2015-11-13 11:50:05', '2015-12-03 00:11:34', '654131a7-2aad-4728-9544-2512565a611d'),
 ('14', '16', 'en_gb', 'young-adult-hip-pain', NULL, '1', '2015-11-13 11:51:14', '2015-12-03 00:11:05', '84350d41-ed44-439e-8b84-154196168ec2'),
 ('15', '17', 'en_gb', 'sports-injuries', NULL, '1', '2015-11-13 11:51:34', '2015-12-04 17:02:16', '0c75bf83-fd7e-421a-b973-ca7a84d51657'),
 ('16', '18', 'en_gb', 'haemophilia', NULL, '1', '2015-11-13 11:51:51', '2015-12-03 00:09:39', 'b8204c62-d917-4b9f-94e1-6997311d19f3'),
 ('17', '19', 'en_gb', 'work-related-pain', NULL, '1', '2015-11-13 11:53:14', '2015-12-03 00:12:12', 'd083aee2-cfb1-457c-be91-d1b563cfe766'),
 ('18', '20', 'en_gb', 'sprains-and-strains', NULL, '1', '2015-11-13 11:53:29', '2015-12-03 00:12:37', '7894410a-18d1-4b3a-9356-2ea99e8cb0ce'),
 ('19', '21', 'en_gb', 'back-pain', NULL, '1', '2015-11-13 11:53:48', '2015-12-03 00:12:47', '99844747-ef12-4337-bc22-5cf5b6fb8a6f'),
 ('20', '22', 'en_gb', 'neck-pain', NULL, '1', '2015-11-13 11:54:01', '2015-12-03 00:12:55', '4f208e09-6751-490d-8ace-13a9410f677e'),
 ('21', '23', 'en_gb', 'shoulder-elbow-wrist-pain', NULL, '1', '2015-11-13 11:54:15', '2015-12-07 13:12:43', '71e96065-89b6-45f6-8e85-775a53ab16eb'),
 ('22', '24', 'en_gb', 'hip-knee-ankle-pain', NULL, '1', '2015-11-13 11:54:33', '2015-12-03 00:04:47', '620280d5-8ba3-4724-bb63-e305da8e1207'),
 ('23', '25', 'en_gb', 'orthopaedic-post-operative-care', NULL, '1', '2015-11-13 11:55:27', '2015-12-03 00:13:52', 'c2f1ba8a-6c46-4c26-8f6b-49c48c75e21a'),
 ('24', '26', 'en_gb', 'post-fracture-rehabilitation', NULL, '1', '2015-11-13 11:55:43', '2015-12-03 00:04:51', '08140f9c-8732-4d69-8578-9bf239c885d9'),
 ('25', '27', 'en_gb', 'non-specific-arm-pain', NULL, '1', '2015-11-13 11:55:55', '2015-12-03 00:04:55', '68087e30-09a9-42f3-a583-84cdd365c26f'),
 ('26', '28', 'en_gb', 'thoracic-outlet-syndrome', NULL, '1', '2015-11-13 11:56:08', '2015-12-03 00:04:59', '8441a83b-0762-4d04-ad53-11ac3e59f262'),
 ('27', '29', 'en_gb', 'headaches-and-dizziness', NULL, '1', '2015-11-13 11:56:26', '2015-12-07 11:15:05', 'ff314287-0417-4f76-8465-1a1688fef19f'),
 ('28', '30', 'en_gb', 'pregnancy-related-pain', NULL, '1', '2015-11-13 11:56:42', '2015-12-03 00:05:06', 'ae176d45-3ddd-4946-b445-383db057417e'),
 ('29', '31', 'en_gb', 'management-of-long-term-conditions', NULL, '1', '2015-11-13 11:56:55', '2015-12-02 23:43:36', 'b13aba3b-c055-46e6-a50a-c0c1c1b072bd'),
 ('30', '32', 'en_gb', 'rheumatological-conditions', NULL, '1', '2015-11-13 11:57:11', '2015-12-06 22:21:35', 'd57bc165-bfe6-4b7d-94ab-d10e87a682d9'),
 ('31', '33', 'en_gb', 'osteoarthritis', NULL, '1', '2015-11-13 11:57:28', '2015-12-02 23:43:03', '1c2a34e8-d4a0-437f-a882-9cd7d26dcbbf'),
 ('32', '34', 'en_gb', 'joint-replacements', NULL, '1', '2015-11-13 11:57:39', '2015-12-02 23:42:46', 'a5b0b63c-c12d-4e8d-9af6-898a547504ae'),
 ('33', '35', 'en_gb', 'osteoporosis', NULL, '1', '2015-11-13 11:57:51', '2015-12-02 23:42:19', '3079c60a-fa61-4bcc-9d45-f5758ce135ec'),
 ('34', '36', 'en_gb', 'post-cancer-rehabilitation', NULL, '1', '2015-11-13 11:58:03', '2015-12-02 23:42:25', '44208633-8abd-48a4-b968-d0541edd6797'),
 ('35', '37', 'en_gb', 'mild-continence-issues', NULL, '1', '2015-11-13 11:58:20', '2015-12-02 23:41:18', '751d482f-ce59-4ff6-bcbc-1373a463b619'),
 ('40', '42', 'en_gb', '', NULL, '1', '2015-11-13 12:54:30', '2015-12-04 22:09:30', '133e59ca-512a-45d4-b2ec-469479c57bee'),
 ('41', '43', 'en_gb', '', NULL, '1', '2015-11-13 12:54:44', '2015-12-04 17:02:38', '5f5c080f-32ba-4565-bc13-3c65d2ab3d19'),
 ('42', '44', 'en_gb', '', NULL, '1', '2015-11-13 12:57:48', '2015-12-04 17:02:38', '48da588a-2fa4-4bb7-aaf0-1c1177692402'),
 ('43', '45', 'en_gb', '', NULL, '1', '2015-11-13 12:57:48', '2015-12-04 17:02:38', '64b34c86-dbef-493a-8d7b-c6a2a0ecc232'),
 ('44', '46', 'en_gb', '', NULL, '1', '2015-11-13 12:57:48', '2015-12-04 17:02:38', 'a0b20da0-a9a6-460f-833c-e2fd3df266fb'),
 ('45', '47', 'en_gb', 'news', 'news', '1', '2015-11-13 14:41:24', '2015-12-08 17:19:51', '848b90a3-a763-4983-83d0-077ffa8c3fc3'),
 ('50', '52', 'en_gb', '', NULL, '1', '2015-11-17 11:20:23', '2015-12-08 17:18:10', '63f84c95-4460-49ee-9d31-662bca5eb0f7'),
 ('51', '53', 'en_gb', '', NULL, '1', '2015-11-17 11:20:23', '2015-12-08 17:18:10', '7e58d466-02b5-4dd7-8912-c5ab14b6007e'),
 ('52', '54', 'en_gb', '', NULL, '1', '2015-11-17 11:20:23', '2015-12-08 17:18:10', 'd3321025-3547-4b07-a342-cf4c1045afc3'),
 ('53', '55', 'en_gb', '', NULL, '1', '2015-11-17 11:20:23', '2015-12-08 17:18:10', '6b765181-1957-4512-b126-83d641618ac7'),
 ('55', '57', 'en_gb', 'pricing', 'pricing', '1', '2015-11-17 14:07:49', '2015-12-08 17:20:34', '0726211e-ee23-4016-ba2e-ea162badf251'),
 ('56', '58', 'en_gb', 'testimonialspg', 'testimonials', '1', '2015-11-17 14:17:42', '2015-12-08 19:25:20', '8325643a-2230-4eba-afca-ed61e467f71e'),
 ('57', '59', 'en_gb', '', NULL, '1', '2015-11-17 15:45:10', '2015-12-08 19:25:20', 'a78f04a5-fefe-4a88-aa5d-5cb73888d98e'),
 ('58', '60', 'en_gb', '', NULL, '1', '2015-11-17 15:45:10', '2015-12-08 19:25:20', '5d0b14ae-da42-44b6-8cf3-5c15f4dbe49e'),
 ('59', '61', 'en_gb', 'work-and-social', 'treatments/work-and-social', '1', '2015-11-17 16:40:59', '2015-12-08 17:23:51', 'ec10499e-975d-4104-ac5f-880a96704ea5'),
 ('60', '62', 'en_gb', 'young-and-active', 'treatments/young-and-active', '1', '2015-11-17 16:41:18', '2016-01-07 11:47:24', '2e4337da-ea53-4c29-9a87-b1f91bef8229'),
 ('61', '63', 'en_gb', 'lifetime-support', 'treatments/lifetime-support', '1', '2015-11-17 16:41:32', '2015-12-08 17:19:19', '264183b7-06a7-414f-8c3b-012f356e2677'),
 ('72', '74', 'en_gb', '', NULL, '1', '2015-11-24 16:38:18', '2015-12-08 19:25:20', 'cfce861a-31b5-49b7-8a82-16d960f570dc'),
 ('73', '75', 'en_gb', '', NULL, '1', '2015-11-24 16:38:18', '2015-12-08 19:25:20', '269ff801-8554-4959-9c2c-0c52cba34151'),
 ('83', '85', 'en_gb', '', NULL, '1', '2015-11-25 14:09:00', '2015-12-08 17:18:33', 'f98feffb-2e6f-444d-8b38-b84f7c7fe0f6'),
 ('84', '86', 'en_gb', '', NULL, '1', '2015-11-25 14:09:00', '2015-12-08 17:18:33', '64a4c382-ad4f-4045-9a73-b5455a5e999f'),
 ('85', '87', 'en_gb', '', NULL, '1', '2015-11-25 14:09:00', '2015-12-08 17:18:33', '28d875f1-f6c4-4f14-a8c8-7c66bd81a57a'),
 ('86', '88', 'en_gb', '', NULL, '1', '2015-11-25 14:09:00', '2015-12-08 17:18:33', '2e9df92a-8882-41b5-b5d6-759c0dfbdea7'),
 ('96', '98', 'en_gb', '', NULL, '1', '2015-11-26 11:46:49', '2015-12-08 17:18:33', '5b9f28a2-975e-48ed-9fb4-b857e02555e4'),
 ('97', '99', 'en_gb', 'ouch-ive-hurt-my-back', 'news/2015/ouch-ive-hurt-my-back', '1', '2015-11-26 13:59:16', '2015-12-08 21:26:01', 'da24d3f1-5e6f-4cb7-8bb1-4b9809f83d76'),
 ('99', '101', 'en_gb', '', NULL, '1', '2015-11-26 14:30:34', '2015-12-08 21:26:02', '18f24f3c-9281-4463-9291-5e735bcc2d59'),
 ('100', '102', 'en_gb', '', NULL, '1', '2015-11-26 14:30:34', '2015-12-08 21:26:02', 'dbfcc0b7-60a0-48ef-a6be-76acb1ee4f71'),
 ('101', '103', 'en_gb', '', NULL, '1', '2015-11-26 14:30:34', '2015-12-08 21:26:02', '640f4ee2-f8fc-4fa9-907e-edb67c523cbf'),
 ('102', '104', 'en_gb', '', NULL, '1', '2015-11-26 14:30:34', '2015-12-08 21:26:02', '90cf59b8-ab9c-44a2-8ba1-91ed0b5735ab'),
 ('103', '105', 'en_gb', '', NULL, '1', '2015-11-26 14:46:03', '2015-12-08 21:26:02', '4e565b71-36c7-4cb0-a823-fb9512eef030'),
 ('104', '106', 'en_gb', '', NULL, '1', '2015-11-26 14:46:03', '2015-12-08 21:26:02', 'ad3c7045-deb8-4568-88ac-f2eb3c9f107d'),
 ('105', '107', 'en_gb', '', NULL, '1', '2015-11-26 14:46:03', '2015-12-08 21:26:02', 'de9b161f-9396-4c8a-80c9-77a0c977f4bc'),
 ('106', '108', 'en_gb', '', NULL, '1', '2015-11-26 14:46:03', '2015-12-08 21:26:02', 'f12d7d01-45a3-470b-abdc-d162b557ecae'),
 ('107', '109', 'en_gb', 'media-comment-november', 'news/2015/media-comment-november', '1', '2015-11-30 09:23:58', '2015-12-08 21:25:20', '173fae39-954b-4398-bbb2-e7924344e50d'),
 ('108', '110', 'en_gb', '', NULL, '1', '2015-11-30 09:23:58', '2015-12-08 21:25:20', '90677dce-94e9-4a63-b9ba-beb7db5531e5'),
 ('109', '111', 'en_gb', '', NULL, '1', '2015-11-30 09:23:58', '2015-12-08 21:25:20', '33a9ce03-9de7-4277-baed-d340760e91cd'),
 ('119', '121', 'en_gb', '', NULL, '1', '2015-12-01 09:52:45', '2015-12-08 17:19:19', '5fb0062e-1fc4-47b1-8d74-92c6a8332f16'),
 ('120', '122', 'en_gb', '', NULL, '1', '2015-12-01 09:52:45', '2015-12-08 17:19:19', '494d3a1d-44e5-4313-a729-3e394bb278a7'),
 ('121', '123', 'en_gb', '', NULL, '1', '2015-12-01 09:52:45', '2015-12-08 17:19:19', '3099a892-f11d-423d-ad94-c7236927524c'),
 ('122', '124', 'en_gb', '', NULL, '1', '2015-12-01 17:25:21', '2015-12-01 17:35:02', '58a30103-de50-4b70-8ce9-936bff45dd37'),
 ('123', '125', 'en_gb', '', NULL, '1', '2015-12-02 09:07:26', '2015-12-02 09:07:26', 'e79d21f4-0a7a-4808-8212-f93d40341951'),
 ('124', '126', 'en_gb', '', NULL, '1', '2015-12-02 11:49:33', '2015-12-08 17:23:51', '129492ae-9e3b-4bff-8057-94c773cc24fb'),
 ('125', '127', 'en_gb', '', NULL, '1', '2015-12-02 11:50:18', '2015-12-08 17:23:51', '92231986-05de-4dc8-9aba-f10037d13894'),
 ('126', '128', 'en_gb', '', NULL, '1', '2015-12-02 11:50:18', '2015-12-08 17:23:51', '0d656446-6db1-425d-aff9-44bc8a693d72'),
 ('127', '129', 'en_gb', '', NULL, '1', '2015-12-02 11:51:02', '2016-01-07 11:47:25', '5b6e37a6-e6d9-4c7e-aabf-5ff18904a56f'),
 ('128', '130', 'en_gb', '', NULL, '1', '2015-12-02 11:51:02', '2016-01-07 11:47:25', 'da403fcc-8f33-4c10-9b5a-cafcc232bff8'),
 ('129', '131', 'en_gb', '', NULL, '1', '2015-12-02 11:51:02', '2016-01-07 11:47:25', '0a4a368b-3f75-4372-a695-9118e1494433'),
 ('139', '141', 'en_gb', 'sprains-and-strains', 'news/2015/sprains-and-strains', '1', '2015-12-04 22:25:11', '2015-12-08 21:24:19', 'c9d39162-5af7-4589-b43f-92cabba6873e'),
 ('140', '142', 'en_gb', '', NULL, '1', '2015-12-04 22:25:11', '2015-12-08 21:24:19', '4b85bba5-1e5c-448b-9777-55de1549261c'),
 ('141', '143', 'en_gb', '', NULL, '1', '2015-12-04 22:25:11', '2015-12-08 21:24:20', '0afbfda7-9de1-4610-9ca9-11ba006646f2'),
 ('142', '144', 'en_gb', '', NULL, '1', '2015-12-04 22:25:11', '2015-12-08 21:24:20', '0c69e2ed-b1cf-4543-a68a-4f387ae6fb2c'),
 ('143', '145', 'en_gb', '', NULL, '1', '2015-12-04 22:25:11', '2015-12-08 21:24:20', '83cd775c-964a-4fd9-9490-8b1b1f1757a0'),
 ('144', '146', 'en_gb', '', NULL, '1', '2015-12-04 22:25:11', '2015-12-08 21:24:21', '59c335f4-4dac-4dab-a568-c095468bc453'),
 ('145', '147', 'en_gb', '', NULL, '1', '2015-12-04 22:25:11', '2015-12-08 21:24:21', '4aa96248-a8c5-4884-8ce0-ebec8f607481'),
 ('146', '148', 'en_gb', '', NULL, '1', '2015-12-04 22:25:11', '2015-12-08 21:24:21', 'fb5a2475-ddc7-46ae-b501-c153e961eac8'),
 ('189', '191', 'en_gb', '', NULL, '1', '2015-12-07 14:53:05', '2015-12-08 21:24:20', 'f030c912-28dc-4e50-9ae3-fa3746071ca9'),
 ('190', '192', 'en_gb', '', NULL, '1', '2015-12-07 14:53:05', '2015-12-08 21:24:20', '0fc84c1c-3559-4c46-a82e-759da91daab7'),
 ('223', '225', 'en_gb', '', NULL, '1', '2015-12-07 17:03:11', '2015-12-08 19:25:20', '8906dedb-ba41-4f07-b792-d9a7c36a7a1a'),
 ('224', '226', 'en_gb', 'acupuncture', NULL, '1', '2015-12-08 14:27:57', '2015-12-08 14:32:13', '35ff9fb1-0076-41c4-9dae-a40a3fd8747f'),
 ('225', '227', 'en_gb', 'acupuncture2', NULL, '1', '2015-12-08 14:27:59', '2015-12-08 14:32:10', '52f4b709-3813-4919-a2ef-26f39bc172db'),
 ('226', '228', 'en_gb', 'acupuncture3', NULL, '1', '2015-12-08 14:28:00', '2015-12-08 14:32:10', 'e72519c9-f8d1-44dc-b75b-c893f23e7289'),
 ('227', '229', 'en_gb', 'acupuncture4', NULL, '1', '2015-12-08 14:28:02', '2015-12-08 14:32:11', '7a38a11d-fa06-40a9-85e6-2c50e54c4f7d'),
 ('228', '230', 'en_gb', 'acupuncture5', NULL, '1', '2015-12-08 14:28:03', '2015-12-08 14:32:12', '6ec5f557-fbea-45d1-b647-d6a61b614775'),
 ('229', '231', 'en_gb', 'acupuncture6', NULL, '1', '2015-12-08 14:28:04', '2015-12-08 14:32:12', '0f09c9e1-af6d-4b1e-a284-e1ba863ee5e0'),
 ('230', '232', 'en_gb', 'bone', NULL, '1', '2015-12-08 14:28:06', '2015-12-08 14:32:16', 'a0afa694-880d-42e7-96fc-e43279cb4673'),
 ('231', '233', 'en_gb', 'gym', NULL, '1', '2015-12-08 14:28:09', '2015-12-08 14:32:19', '6cf69b80-d1f8-4aec-a791-59ceeff1331d'),
 ('232', '234', 'en_gb', 'newspaper', NULL, '1', '2015-12-08 14:28:14', '2015-12-08 14:32:19', 'f4043484-7967-4fe6-bf8f-23824e065072'),
 ('233', '235', 'en_gb', 'office', NULL, '1', '2015-12-08 14:28:16', '2015-12-08 14:32:20', 'd38ae9fa-0e1a-423c-9160-050b548803b0'),
 ('234', '236', 'en_gb', 'sarah-profile1', NULL, '1', '2015-12-08 14:28:18', '2015-12-08 14:32:23', '42a77a0d-504c-4d97-ae39-b7184eba09d8');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('235', '237', 'en_gb', 'sarah-profile2', NULL, '1', '2015-12-08 14:28:20', '2015-12-08 14:32:26', '21a4826e-f08d-4546-8e08-aaf698086b67'),
 ('236', '238', 'en_gb', 'trampette', NULL, '1', '2015-12-08 14:28:22', '2015-12-08 14:32:28', '8da216ec-2b50-4ed0-8e3c-2a80425b69ca'),
 ('237', '239', 'en_gb', 'heart-health', NULL, '1', '2015-12-08 14:31:36', '2015-12-08 14:31:37', '3f4c3e44-527d-4f4e-a418-9d6233d4feb5'),
 ('238', '240', 'en_gb', 'img-4041-copy', NULL, '1', '2015-12-08 14:31:38', '2015-12-08 14:31:38', 'a5ea1f91-5cf1-43ce-abca-1bc3257a788a'),
 ('239', '241', 'en_gb', 'joint-pain', NULL, '1', '2015-12-08 14:31:38', '2015-12-08 14:31:39', '51ecc271-8c52-4793-9762-3cf564c3c9a2'),
 ('240', '242', 'en_gb', 'tennis-elbow', NULL, '1', '2015-12-08 14:31:39', '2015-12-08 14:31:39', '04c8fffb-8cf4-46d3-88c6-332c80edc8f6'),
 ('241', '243', 'en_gb', 'acupuncture', NULL, '1', '2015-12-08 14:31:40', '2015-12-08 14:31:40', '082d14ab-ce9d-4e0d-8956-660a40925f21'),
 ('242', '244', 'en_gb', 'acupuncture2', NULL, '1', '2015-12-08 14:31:41', '2015-12-08 14:31:41', 'd285b9b3-4bc1-4999-9d25-0f8b59f542ed'),
 ('243', '245', 'en_gb', 'acupuncture4', NULL, '1', '2015-12-08 14:31:41', '2015-12-08 14:31:41', '2698d992-42b3-4544-b528-1043bfa7227e'),
 ('244', '246', 'en_gb', 'acupuncture3', NULL, '1', '2015-12-08 14:31:42', '2015-12-08 14:31:42', 'b082076d-3a05-4927-a5e5-aa0e52914495'),
 ('245', '247', 'en_gb', 'acupuncture5', NULL, '1', '2015-12-08 14:31:42', '2015-12-08 14:31:42', 'f1c98cbb-5011-471e-8443-12aad68bdc63'),
 ('246', '248', 'en_gb', 'acupuncture6', NULL, '1', '2015-12-08 14:31:43', '2015-12-08 14:31:43', '4e8d78b7-f802-49f7-851f-79e41d7d2501'),
 ('247', '249', 'en_gb', 'banner', NULL, '1', '2015-12-08 14:31:44', '2015-12-08 14:31:44', '27c3675a-ce26-4dd1-b0d8-930509c1365f'),
 ('248', '250', 'en_gb', 'back-pain-gif-437580', NULL, '1', '2015-12-08 14:31:45', '2015-12-08 14:31:45', '4d9c9599-fb0a-4a1b-8b39-f8a88838140a'),
 ('249', '251', 'en_gb', 'bone', NULL, '1', '2015-12-08 14:31:45', '2015-12-08 14:31:45', 'ed7bc382-53e3-4b1f-a185-6a2c46168ca3'),
 ('250', '252', 'en_gb', 'gym', NULL, '1', '2015-12-08 14:31:46', '2015-12-08 14:31:46', '05248a50-6e92-45ca-9244-35cf42b26899'),
 ('251', '253', 'en_gb', 'healthy-walking-signpost-77422-1920', NULL, '1', '2015-12-08 14:31:46', '2015-12-08 14:31:47', 'c32f48bc-edad-4d43-b6b0-97868cef81d9'),
 ('252', '254', 'en_gb', 'heartbeat-163709-1280', NULL, '1', '2015-12-08 14:31:47', '2015-12-08 14:31:47', 'a232d870-5a10-459b-a399-b695ec120d69'),
 ('253', '255', 'en_gb', 'istock-rf-photo-of-arthritis-pain-in-hand', NULL, '1', '2015-12-08 14:31:48', '2015-12-08 14:31:48', 'eee71b9c-0567-4de0-8d14-409aa053ffef'),
 ('254', '256', 'en_gb', 'newspaper-866520-1920', NULL, '1', '2015-12-08 14:31:48', '2015-12-08 14:31:48', '57b2f6c6-4f30-4aa5-84bb-e49c08c51e27'),
 ('255', '257', 'en_gb', 'newspaper', NULL, '1', '2015-12-08 14:31:49', '2015-12-08 14:31:49', '8f0c6daf-99c7-49e5-827f-24d6cd4da621'),
 ('256', '258', 'en_gb', 'newspaper', NULL, '1', '2015-12-08 14:31:49', '2015-12-08 14:31:50', '2cd2cb99-a2d9-4ebc-8a07-69053f658a0c'),
 ('257', '259', 'en_gb', 'office', NULL, '1', '2015-12-08 14:31:50', '2015-12-08 14:31:50', 'ceb4d9ab-f35e-4e8a-b98a-258f423f0af6'),
 ('258', '260', 'en_gb', 'sarah-profile1', NULL, '1', '2015-12-08 14:31:50', '2015-12-08 14:31:51', '8403fcfa-6fa3-4b9d-a3f1-c1bc7f9c989c'),
 ('259', '261', 'en_gb', 'sarah-profile2', NULL, '1', '2015-12-08 14:31:51', '2015-12-08 14:31:51', 'fb149272-6621-4a85-a9e1-8dc909410184'),
 ('260', '262', 'en_gb', 'spine-957249-1280', NULL, '1', '2015-12-08 14:31:52', '2015-12-08 14:31:52', 'fd18c14f-2b3e-4d90-9a42-a79069eab472'),
 ('261', '263', 'en_gb', 'trampette', NULL, '1', '2015-12-08 14:31:52', '2015-12-08 14:31:52', '28309872-f25a-430c-8164-7c278e5f5b9f'),
 ('262', '264', 'en_gb', 'sports-injury-2', NULL, '1', '2015-12-08 14:31:53', '2015-12-08 14:31:53', '0df389e7-bf1b-4851-8f1d-05aa242c5654'),
 ('263', '265', 'en_gb', 'ultrasound', NULL, '1', '2015-12-08 14:31:53', '2015-12-08 14:31:53', '057f090f-51ec-44da-8c2a-bfca7c5accfc'),
 ('264', '266', 'en_gb', 'lifetime-couple', NULL, '1', '2015-12-08 14:31:54', '2015-12-08 14:31:54', '1a08ad0e-bf55-4e5d-8370-bc38645b3814'),
 ('265', '267', 'en_gb', 'sport-woman', NULL, '1', '2015-12-08 14:31:55', '2015-12-08 14:31:55', '941f885b-9372-4118-8993-f40717b24bc7'),
 ('266', '268', 'en_gb', 'work-man', NULL, '1', '2015-12-08 14:31:55', '2015-12-08 14:31:55', 'f9be3a78-bcaa-4c50-b238-58ed1357ed09'),
 ('267', '269', 'en_gb', '6f14d766-8edf-4b3c-b385-96bfed558d4c', NULL, '1', '2015-12-08 14:31:57', '2015-12-08 14:31:57', '974d2be3-e8e9-4a63-90c0-b640702f4de3'),
 ('268', '270', 'en_gb', 'bmas-footer', NULL, '1', '2015-12-08 14:31:58', '2015-12-08 14:31:58', '0de2a126-9d25-4d6c-9a47-b4f95559c475'),
 ('269', '271', 'en_gb', 'bmas', NULL, '1', '2015-12-08 14:31:58', '2015-12-08 14:31:59', 'd4290802-772e-44b9-9a22-e43dece360fb'),
 ('270', '272', 'en_gb', 'bmas-logo', NULL, '1', '2015-12-08 14:31:59', '2015-12-08 14:32:00', '15c2441e-8dfa-42e9-a126-5429b9ec34ae'),
 ('271', '273', 'en_gb', 'macp-logo', NULL, '1', '2015-12-08 14:32:00', '2015-12-08 14:32:00', '43a3c504-a9a6-4195-86bb-2969991c44a2'),
 ('272', '274', 'en_gb', 'macp-logo-reverse', NULL, '1', '2015-12-08 14:32:01', '2015-12-08 14:32:01', 'db5d9ca2-5ae3-4f4c-b3d8-6ecf57d8a20a'),
 ('273', '275', 'en_gb', 'csp-footer', NULL, '1', '2015-12-08 14:32:02', '2015-12-08 14:32:02', '11e3fd26-0ad8-4706-8cc3-f836efceb76d'),
 ('274', '276', 'en_gb', 'hpc-footer', NULL, '1', '2015-12-08 14:32:02', '2015-12-08 14:32:02', 'd315c788-db88-463f-9a33-fe38f598f901'),
 ('275', '277', 'en_gb', 'csp', NULL, '1', '2015-12-08 14:32:02', '2015-12-08 14:32:03', '2593b5ca-a5e0-40b1-85c7-70ee686e428c'),
 ('276', '278', 'en_gb', 'hpc-logo-registered', NULL, '1', '2015-12-08 14:32:03', '2015-12-08 14:32:03', 'e0ee0804-f824-4aa0-9454-af2995d96353'),
 ('277', '279', 'en_gb', 'hpc', NULL, '1', '2015-12-08 14:32:03', '2015-12-08 14:32:03', 'e9439017-855a-402d-98e4-aa7986d90406'),
 ('278', '280', 'en_gb', 'physio-first', NULL, '1', '2015-12-08 14:32:04', '2015-12-08 14:32:04', 'd6136012-62e0-436b-9a0b-ef5f4916e732'),
 ('279', '281', 'en_gb', 'imgres', NULL, '1', '2015-12-08 14:32:04', '2015-12-08 14:32:04', 'dd510b10-005a-4fef-91d9-c051b29cca9f'),
 ('280', '282', 'en_gb', 'physio-footer', NULL, '1', '2015-12-08 14:32:04', '2015-12-08 14:32:05', 'fdf4044b-b49b-4dd7-b1f5-179da86b43e6'),
 ('281', '283', 'en_gb', 'physiofirst-footer', NULL, '1', '2015-12-08 14:32:05', '2015-12-08 14:32:05', 'cc494127-ba07-418b-aef9-950adc6740e2'),
 ('282', '284', 'en_gb', 'img-3984-copy', NULL, '1', '2015-12-08 14:32:06', '2015-12-08 14:32:06', 'eca20dff-ea52-4cf5-8ea5-ed6edb482096'),
 ('283', '285', 'en_gb', 'img-4041-copy', NULL, '1', '2015-12-08 14:32:07', '2015-12-08 14:32:07', '081e3a03-5640-45de-adeb-6be737ce0b85'),
 ('284', '286', 'en_gb', 'img-4028-copy', NULL, '1', '2015-12-08 14:32:07', '2015-12-08 14:32:08', '84a1969b-79f4-40f8-bebc-75ba3f2669a8'),
 ('285', '287', 'en_gb', 'acupuncture', NULL, '1', '2015-12-08 14:32:08', '2015-12-08 14:32:08', 'f0e0d295-4c13-4768-aa7a-0e1e10627afd'),
 ('286', '288', 'en_gb', 'img-4053-copy', NULL, '1', '2015-12-08 14:32:08', '2015-12-08 14:32:09', '02b47c65-3b2b-4e5b-9ea2-ecc11a88063d'),
 ('287', '289', 'en_gb', 'acupuncture2', NULL, '1', '2015-12-08 14:32:09', '2015-12-08 14:32:09', '45b7986e-a322-4937-b5c1-f540d1562b63'),
 ('288', '290', 'en_gb', 'acupuncture3', NULL, '1', '2015-12-08 14:32:10', '2015-12-08 14:32:10', 'c27ecd04-825c-456e-9f8d-daf7057cea98'),
 ('289', '291', 'en_gb', 'acupuncture4', NULL, '1', '2015-12-08 14:32:11', '2015-12-08 14:32:11', '60a09e0b-dcbb-4400-b810-914fd6f5b368'),
 ('290', '292', 'en_gb', 'acupuncture5', NULL, '1', '2015-12-08 14:32:11', '2015-12-08 14:32:11', 'bfffc9a5-932b-4627-8fb6-35abc59fbb4d'),
 ('291', '293', 'en_gb', 'acupuncture6', NULL, '1', '2015-12-08 14:32:12', '2015-12-08 14:32:12', '11f754e2-55b0-47aa-acc9-1481116724bd'),
 ('292', '294', 'en_gb', 'bone-151207-115708', NULL, '1', '2015-12-08 14:32:14', '2015-12-08 14:32:14', 'd84fc94c-961f-48d3-9460-80ee4973bc8d'),
 ('293', '295', 'en_gb', 'bone-151206-231008', NULL, '1', '2015-12-08 14:32:15', '2015-12-08 14:32:15', '4d55154a-f281-4443-af13-f0240bcbb7cd'),
 ('294', '296', 'en_gb', 'cont-interior', NULL, '1', '2015-12-08 14:32:17', '2015-12-08 14:32:17', 'e222994f-f101-43cf-99ef-6749742b4a1c'),
 ('295', '297', 'en_gb', 'bone', NULL, '1', '2015-12-08 14:32:17', '2015-12-08 14:32:18', '76096cb4-9b40-4b7a-bd2f-a58e1c2afab1'),
 ('296', '298', 'en_gb', 'gym', NULL, '1', '2015-12-08 14:32:18', '2015-12-08 14:32:18', '08866736-b4fd-4fc2-b678-058055036426'),
 ('297', '299', 'en_gb', 'newspaper', NULL, '1', '2015-12-08 14:32:19', '2015-12-08 14:32:19', '262c0b1b-13a0-41c9-928c-a4cfff69ee6c'),
 ('298', '300', 'en_gb', 'office', NULL, '1', '2015-12-08 14:32:19', '2015-12-08 14:32:19', '58973caa-3317-45fe-a315-080ce06c5b63'),
 ('299', '301', 'en_gb', 'sarah-profile1', NULL, '1', '2015-12-08 14:32:21', '2015-12-08 14:32:21', '81396cc0-976e-4d40-a546-b06f6fc6a408'),
 ('300', '302', 'en_gb', 'sarah-profile', NULL, '1', '2015-12-08 14:32:21', '2015-12-08 14:32:21', '13344723-8494-4610-8f29-fa29259a98de'),
 ('301', '303', 'en_gb', 'sarah-profile2', NULL, '1', '2015-12-08 14:32:23', '2015-12-08 14:32:24', '815f8fdf-2e64-40c6-8791-808e96b9cd2e'),
 ('302', '304', 'en_gb', 'trampette', NULL, '1', '2015-12-08 14:32:24', '2015-12-08 14:32:25', '322cc23a-0b3d-4d66-b0a6-d5f4cc450521'),
 ('303', '305', 'en_gb', 'trampette-151204-210703', NULL, '1', '2015-12-08 14:32:25', '2015-12-08 14:32:26', '6ba7efcd-9f22-41dc-9281-dc71d8c616ad'),
 ('304', '306', 'en_gb', 'trampette-151204-212322', NULL, '1', '2015-12-08 14:32:27', '2015-12-08 14:32:27', 'c4a2f2ea-abb8-44f0-a891-80f42e8a133f'),
 ('305', '307', 'en_gb', 'trampette-151207-115724', NULL, '1', '2015-12-08 14:32:28', '2015-12-08 14:32:28', 'ee5975d6-c1b8-4090-a974-a4d0d32b4600'),
 ('306', '308', 'en_gb', 'ultrasound', NULL, '1', '2015-12-08 14:32:29', '2015-12-08 14:32:29', '185fbcce-4f8f-48f4-a8c6-475a23740176'),
 ('307', '309', 'en_gb', 'w-zgx-w9-oubl-vaaj-gcka-u-vwpwy-l6-hk-g-j-n0-g-wj-oui4-pv-dz-bh-tafo1-l9eafkc8s-whd-btd-k2xj-dqur-dg-k7sjl8-a', NULL, '1', '2015-12-08 14:32:29', '2015-12-08 14:32:29', 'b65f4917-5356-49bc-b392-f460a02b1018'),
 ('308', '310', 'en_gb', 'trampette-151204-221047', NULL, '1', '2015-12-08 14:32:30', '2015-12-08 14:32:30', 'd7f792fd-0010-4ec0-bc4d-8c1450294914'),
 ('309', '311', 'en_gb', 'img-3984-copy', NULL, '1', '2015-12-08 14:32:31', '2015-12-08 14:32:31', '26a6b5b8-7bf1-481b-96ef-2523b1382537'),
 ('310', '312', 'en_gb', 'img-4041-copy', NULL, '1', '2015-12-08 14:32:33', '2015-12-08 14:32:34', 'c414aa3f-6e72-431e-80a0-39cf89cbcf41'),
 ('311', '313', 'en_gb', 'img-4028-copy', NULL, '1', '2015-12-08 14:32:34', '2015-12-08 14:32:35', '8495b396-0a37-4e54-95fe-e973fe08c629'),
 ('312', '314', 'en_gb', 'acupuncture', NULL, '1', '2015-12-08 14:32:35', '2015-12-08 14:32:35', '5dde71f7-d9c2-4e2b-9be6-c8c361371e42'),
 ('313', '315', 'en_gb', 'img-4053-copy', NULL, '1', '2015-12-08 14:32:36', '2015-12-08 14:32:36', '9d7fa67a-6fbe-4ee6-b105-ea9e0b1a966f'),
 ('314', '316', 'en_gb', 'acupuncture2-151208-142759', NULL, '1', '2015-12-08 14:32:38', '2015-12-08 14:32:38', '18ab4505-2c9f-42eb-a5d9-da6ecda44ec2'),
 ('315', '317', 'en_gb', 'acupuncture3', NULL, '1', '2015-12-08 14:32:38', '2015-12-08 14:32:38', 'dce7a1d9-76a5-451f-a636-ed034b9a6182'),
 ('316', '318', 'en_gb', 'acupuncture2', NULL, '1', '2015-12-08 14:32:38', '2015-12-08 14:32:38', '25fa896e-dc7a-4975-8b32-eb9a7be299ea'),
 ('317', '319', 'en_gb', 'acupuncture3-151208-142800', NULL, '1', '2015-12-08 14:32:39', '2015-12-08 14:32:39', '6e82536a-71f3-4ce6-a7a6-e4ec6c14704d'),
 ('318', '320', 'en_gb', 'acupuncture5', NULL, '1', '2015-12-08 14:32:40', '2015-12-08 14:32:40', 'e66b391a-142d-45cf-a1aa-bc7620323889'),
 ('319', '321', 'en_gb', 'acupuncture4-151208-142802', NULL, '1', '2015-12-08 14:32:41', '2015-12-08 14:32:41', '4fc01bf7-fdf1-4b5c-9aa9-660ae993d832'),
 ('320', '322', 'en_gb', 'acupuncture4', NULL, '1', '2015-12-08 14:32:41', '2015-12-08 14:32:41', '601cade6-bec6-4c9d-814f-80821f326a4a'),
 ('321', '323', 'en_gb', 'acupuncture5-151208-142803', NULL, '1', '2015-12-08 14:32:42', '2015-12-08 14:32:42', '42602351-5478-4b53-9bb5-1e432eccfb7c'),
 ('322', '324', 'en_gb', 'acupuncture6', NULL, '1', '2015-12-08 14:32:42', '2015-12-08 14:32:42', 'd1f1567e-4a3a-4976-aacf-3f48f36ac686'),
 ('323', '325', 'en_gb', 'acupuncture6-151208-142804', NULL, '1', '2015-12-08 14:32:42', '2015-12-08 14:32:43', 'a2bfdc4d-6a02-4b43-9850-4bad7f071128'),
 ('324', '326', 'en_gb', 'acupuncture-151208-142757', NULL, '1', '2015-12-08 14:32:43', '2015-12-08 14:32:43', '0f9ad000-5503-402f-a720-aa49f0307e7f'),
 ('325', '327', 'en_gb', 'bone', NULL, '1', '2015-12-08 14:32:44', '2015-12-08 14:32:44', 'c2421be5-0427-4b00-ba00-38f7a8f0294e'),
 ('326', '328', 'en_gb', 'bone-151206-231008', NULL, '1', '2015-12-08 14:32:45', '2015-12-08 14:32:46', '40ebc2d5-adc5-4516-85aa-2036a9623e1a'),
 ('327', '329', 'en_gb', 'bone-151207-115708', NULL, '1', '2015-12-08 14:32:46', '2015-12-08 14:32:46', 'cfe86601-6a62-469c-9571-83004f5ea569'),
 ('328', '330', 'en_gb', 'bone-151208-142806', NULL, '1', '2015-12-08 14:32:46', '2015-12-08 14:32:47', 'd04d8459-9f18-4ada-afca-b27cd405ad12'),
 ('329', '331', 'en_gb', 'gym', NULL, '1', '2015-12-08 14:32:47', '2015-12-08 14:32:47', 'c853413a-1752-489f-adb9-bd034481f228'),
 ('330', '332', 'en_gb', 'cont-interior', NULL, '1', '2015-12-08 14:32:48', '2015-12-08 14:32:48', 'fa34e7b0-e0fe-4230-9e52-e3501bfbc25c'),
 ('331', '333', 'en_gb', 'newspaper', NULL, '1', '2015-12-08 14:32:48', '2015-12-08 14:32:48', 'b4be7bcd-2bfd-459d-9966-e309ed4f494e'),
 ('332', '334', 'en_gb', 'gym-151208-142808', NULL, '1', '2015-12-08 14:32:49', '2015-12-08 14:32:49', 'e8b254e5-412c-46a8-b953-19f74e45b1e9'),
 ('333', '335', 'en_gb', 'newspaper-151208-142814', NULL, '1', '2015-12-08 14:32:49', '2015-12-08 14:32:49', '4dda6edc-8e23-4b0b-bb51-d1db94c64833'),
 ('334', '336', 'en_gb', 'office', NULL, '1', '2015-12-08 14:32:50', '2015-12-08 14:32:50', 'a81155f0-7747-4ba2-9d66-2dc303adf375');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('335', '337', 'en_gb', 'office-151208-142816', NULL, '1', '2015-12-08 14:32:50', '2015-12-08 14:32:50', '928165c1-02e5-4a42-9c14-c51c417604cd'),
 ('336', '338', 'en_gb', 'sarah-profile', NULL, '1', '2015-12-08 14:32:51', '2015-12-08 14:32:52', '59072b96-c028-4b5a-8e65-7a1b48ab4580'),
 ('337', '339', 'en_gb', 'sarah-profile1', NULL, '1', '2015-12-08 14:32:52', '2015-12-08 14:32:52', '661ac482-098c-47de-829f-378fe18d5dde'),
 ('338', '340', 'en_gb', 'sarah-profile2', NULL, '1', '2015-12-08 14:32:52', '2015-12-08 14:32:52', 'b0677480-f524-4e92-8013-2179327ff15f'),
 ('339', '341', 'en_gb', 'sarah-profile1-151208-142817', NULL, '1', '2015-12-08 14:32:53', '2015-12-08 14:32:53', '1329b440-8eeb-4190-8284-5d108e65217a'),
 ('340', '342', 'en_gb', 'sarah-profile2-151208-142819', NULL, '1', '2015-12-08 14:32:53', '2015-12-08 14:32:53', '59ce7242-30da-4af6-b7e0-6eadfe068440'),
 ('341', '343', 'en_gb', 'trampette', NULL, '1', '2015-12-08 14:32:53', '2015-12-08 14:32:54', '6f864331-447b-4508-bfec-b37029bbaa48'),
 ('342', '344', 'en_gb', 'trampette-151204-210703', NULL, '1', '2015-12-08 14:32:54', '2015-12-08 14:32:55', '56793d03-4e1b-43ce-bb0a-1b0da6f15b7d'),
 ('343', '345', 'en_gb', 'trampette-151204-212322', NULL, '1', '2015-12-08 14:32:55', '2015-12-08 14:32:56', 'caa02ebd-7bca-4226-8e5a-899fd04332a7'),
 ('344', '346', 'en_gb', 'trampette-151204-221047', NULL, '1', '2015-12-08 14:32:56', '2015-12-08 14:32:57', '7dcb91d0-5ff8-48f0-b405-300a12a8f1cc'),
 ('345', '347', 'en_gb', 'trampette-151208-142821', NULL, '1', '2015-12-08 14:32:57', '2015-12-08 14:32:57', '8f432960-f59f-4618-9233-b5859f5e3e8b'),
 ('346', '348', 'en_gb', 'trampette-151207-115724', NULL, '1', '2015-12-08 14:32:57', '2015-12-08 14:32:57', '514af6ee-cfcf-4255-9e42-19d27f11940b'),
 ('347', '349', 'en_gb', 'w-zgx-w9-oubl-vaaj-gcka-u-vwpwy-l6-hk-g-j-n0-g-wj-oui4-pv-dz-bh-tafo1-l9eafkc8s-whd-btd-k2xj-dqur-dg-k7sjl8-a', NULL, '1', '2015-12-08 14:32:58', '2015-12-08 14:32:58', 'fd607a60-b08c-46e9-99d6-ec25b74b8a7c'),
 ('348', '350', 'en_gb', 'ultrasound', NULL, '1', '2015-12-08 14:32:59', '2015-12-08 14:32:59', 'd2abf122-4a5e-40e7-9a0a-b1b6b564d50e'),
 ('349', '351', 'en_gb', '', NULL, '1', '2015-12-08 19:13:43', '2015-12-08 19:25:20', 'e926d6fd-edd2-4e35-aa9e-2a97d2a7acd5'),
 ('350', '352', 'en_gb', 'logo', NULL, '1', '2015-12-10 21:24:14', '2015-12-10 21:24:14', 'b688b58d-c1f6-4bda-a097-eeedce290068'),
 ('353', '355', 'en_gb', 'savings', NULL, '1', '2016-01-07 12:01:20', '2016-01-07 12:01:20', '1e1e8be5-4d40-4f33-9329-cb88ed732e92'),
 ('354', '356', 'en_gb', '10-discount-on-initial-assessments', 'news/2016/10-discount-on-initial-assessments', '1', '2016-01-07 12:08:51', '2016-01-12 11:35:55', '56b96466-14bc-4521-acba-6427f5fcdd66'),
 ('355', '357', 'en_gb', '', NULL, '1', '2016-01-07 12:08:52', '2016-01-12 11:35:55', 'ab5efa48-7129-4df2-a644-b1d7a67b5100'),
 ('356', '358', 'en_gb', 'naturel-spa', NULL, '1', '2016-01-12 11:35:42', '2016-01-12 11:35:42', 'ec567f4f-8230-4377-ae65-70465b1628e5'),
 ('357', '359', 'en_gb', 'exeter-living', NULL, '1', '2016-01-12 21:13:04', '2016-01-12 21:13:04', 'a1fdf3b9-f92b-42e7-82fe-6de77ef88b0c'),
 ('358', '360', 'en_gb', 'recent-advertorial-in-exeter-living-jan-2016', 'news/2016/recent-advertorial-in-exeter-living-jan-2016', '1', '2016-01-12 21:18:33', '2016-01-12 21:20:52', '8102cf29-aae7-4ed5-b8a2-576eb08837fe'),
 ('359', '361', 'en_gb', 'bupa-logo', NULL, '1', '2016-02-09 21:33:48', '2016-02-09 21:47:25', 'c8f48632-e792-4b65-b259-dd385351d1db'),
 ('360', '362', 'en_gb', 'wpa', NULL, '1', '2016-02-09 21:33:55', '2016-02-09 21:33:55', 'ad6775ba-9d00-4737-8c02-f537850af9bf'),
 ('361', '363', 'en_gb', 'vitality-health-logo', NULL, '1', '2016-02-09 21:34:05', '2016-02-09 21:34:05', '15533ce9-29f7-410b-921b-52de1107027e'),
 ('362', '364', 'en_gb', 'mdg-logo-web2', NULL, '1', '2016-02-09 21:34:14', '2016-02-09 21:34:14', '64c167b3-0cdd-48e7-b7b7-f0dceef245f7'),
 ('363', '365', 'en_gb', 'private-health-insurance', NULL, '1', '2016-02-09 21:43:41', '2016-02-09 21:43:41', '73a9f31f-a1e1-4b29-a926-5ce684bbdae9'),
 ('365', '367', 'en_gb', 'private-health-insurance', 'news/2016/private-health-insurance', '1', '2016-02-09 22:01:41', '2016-02-09 22:01:54', '682deba0-54f0-4966-8747-67d3db37b3f3'),
 ('366', '368', 'en_gb', '', NULL, '1', '2016-02-09 22:01:41', '2016-02-09 22:01:55', '1b458398-0883-4e93-a7d5-3579284ecfcd'),
 ('367', '369', 'en_gb', '', NULL, '1', '2016-02-09 22:01:41', '2016-02-09 22:01:55', 'ecb954f6-b0c4-4e16-8487-8fd9d3ec3ae2'),
 ('368', '370', 'en_gb', '', NULL, '1', '2016-02-09 22:01:41', '2016-02-09 22:01:55', '30d08111-d1f8-49ff-818c-5b0cf0d6114e'),
 ('369', '371', 'en_gb', '', NULL, '1', '2016-02-09 22:01:41', '2016-02-09 22:01:55', '5991f2b2-59ea-4edc-aedc-9d4910d13cd4');



DROP TABLE IF EXISTS `craft_emailmessages`;


--
-- Schema for table `craft_emailmessages`
--
CREATE TABLE `craft_emailmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` char(150) COLLATE utf8_unicode_ci NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(1000) COLLATE utf8_unicode_ci NOT NULL,
  `body` text COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_emailmessages_key_locale_unq_idx` (`key`,`locale`),
  KEY `craft_emailmessages_locale_fk` (`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_entries`;


--
-- Schema for table `craft_entries`
--
CREATE TABLE `craft_entries` (
  `id` int(11) NOT NULL,
  `sectionId` int(11) NOT NULL,
  `typeId` int(11) DEFAULT NULL,
  `authorId` int(11) DEFAULT NULL,
  `postDate` datetime DEFAULT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_entries_sectionId_idx` (`sectionId`),
  KEY `craft_entries_typeId_idx` (`typeId`),
  KEY `craft_entries_postDate_idx` (`postDate`),
  KEY `craft_entries_expiryDate_idx` (`expiryDate`),
  KEY `craft_entries_authorId_fk` (`authorId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_entries`
--

INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('2', '1', '1', NULL, '2015-11-13 14:09:08', NULL, '2015-11-04 11:36:32', '2016-01-15 09:33:12', '37f00e0b-ad76-4f8e-98e8-87717b78c5e0'),
 ('4', '3', NULL, NULL, '2015-11-10 16:22:36', NULL, '2015-11-10 16:22:36', '2015-12-08 17:18:10', 'bc8ed318-9257-47f3-a0ec-df84e74658b1'),
 ('5', '5', NULL, NULL, '2015-11-10 16:24:52', NULL, '2015-11-10 16:24:52', '2015-12-08 17:18:33', 'df5adf6c-5c47-4ce4-9a44-c147c2fd68a0'),
 ('8', '9', '9', NULL, '2015-11-17 14:20:25', NULL, '2015-11-13 09:37:14', '2015-12-08 17:19:00', '38d88ab5-c288-4c5a-ada5-839a727d8a6c'),
 ('9', '10', NULL, NULL, '2015-11-13 09:37:53', NULL, '2015-11-13 09:37:54', '2015-12-08 17:22:58', '44a70d79-9ddb-4cc1-9f55-45ef9edda6a5'),
 ('14', '11', '11', '1', '2015-11-13 11:49:00', NULL, '2015-11-13 11:49:40', '2015-12-03 00:12:04', 'a4627bbf-25a1-4ba5-bbe8-7a1b750537a5'),
 ('15', '11', '11', '1', '2015-11-13 11:50:00', NULL, '2015-11-13 11:50:05', '2015-12-03 00:11:34', '5e7782d2-81c4-4222-a39f-286d9f3f9398'),
 ('16', '11', '11', '1', '2015-11-13 11:51:00', NULL, '2015-11-13 11:51:14', '2015-12-03 00:11:05', '13791278-d2db-476d-a976-24f67f5a5076'),
 ('17', '11', '11', '1', '2015-11-13 11:51:00', NULL, '2015-11-13 11:51:34', '2015-12-04 17:02:16', '3b1e8305-e38f-4824-bc35-b8ebd4379292'),
 ('18', '11', '11', '1', '2015-11-13 11:51:00', NULL, '2015-11-13 11:51:51', '2015-12-03 00:09:38', '9debfa59-55f6-4132-b776-351e54d2f2b1'),
 ('19', '11', '11', '1', '2015-11-13 11:53:00', NULL, '2015-11-13 11:53:14', '2015-12-03 00:12:12', '51946f4a-ec74-4c84-98ed-6cecd4ae935b'),
 ('20', '11', '11', '1', '2015-11-13 11:53:00', NULL, '2015-11-13 11:53:29', '2015-12-03 00:12:37', 'bbbd3be5-da9f-48d7-b044-ce4edb3e809b'),
 ('21', '11', '11', '1', '2015-11-13 11:53:00', NULL, '2015-11-13 11:53:48', '2015-12-03 00:12:47', '57d82c6a-2d97-4849-83d8-c4ea16782723'),
 ('22', '11', '11', '1', '2015-11-13 11:54:00', NULL, '2015-11-13 11:54:01', '2015-12-03 00:12:55', '65f07460-1c85-436c-83ff-1f678b1a0acd'),
 ('23', '11', '11', '1', '2015-11-13 11:54:00', NULL, '2015-11-13 11:54:15', '2015-12-07 13:12:43', '32219bb8-9dca-444d-8f73-5b726c6cad57'),
 ('24', '11', '11', '1', '2015-11-13 11:54:00', NULL, '2015-11-13 11:54:33', '2015-12-03 00:04:47', 'e80cf0b7-231a-4521-83d3-ce39c9ba11d6'),
 ('25', '11', '11', '1', '2015-11-13 11:55:00', NULL, '2015-11-13 11:55:27', '2015-12-03 00:13:52', '957af59c-7969-4b67-80e7-7925f738def7'),
 ('26', '11', '11', '1', '2015-11-13 11:55:43', NULL, '2015-11-13 11:55:43', '2015-12-03 00:04:51', '712c19e7-389b-4c01-8028-78aefc65f299'),
 ('27', '11', '11', '1', '2015-11-13 11:55:55', NULL, '2015-11-13 11:55:55', '2015-12-03 00:04:55', '2e8da2c7-16a3-4c08-a935-f7cf658f327a'),
 ('28', '11', '11', '1', '2015-11-13 11:56:08', NULL, '2015-11-13 11:56:08', '2015-12-03 00:04:59', '3db75c4a-04eb-4f01-a549-5996e1cc554a'),
 ('29', '11', '11', '1', '2015-11-13 11:56:00', NULL, '2015-11-13 11:56:26', '2015-12-07 11:15:05', 'cab373a5-c0e8-4a6e-a5ae-9f857ed87f14'),
 ('30', '11', '11', '1', '2015-11-13 11:56:42', NULL, '2015-11-13 11:56:42', '2015-12-03 00:05:06', 'ea3905bd-7221-4a96-be71-c2ea68ac4ddc'),
 ('31', '11', '11', '1', '2015-11-13 11:56:55', NULL, '2015-11-13 11:56:55', '2015-12-02 23:43:36', 'c8823b30-5624-4a05-9ef6-ea3736a06ed2'),
 ('32', '11', '11', '1', '2015-11-13 11:57:00', NULL, '2015-11-13 11:57:11', '2015-12-06 22:21:35', '00c79fa8-eba3-482d-9afe-47cb1d511404'),
 ('33', '11', '11', '1', '2015-11-13 11:57:28', NULL, '2015-11-13 11:57:28', '2015-12-02 23:43:03', '9bd0b37e-82f8-4fc1-8081-bd056cb996d9'),
 ('34', '11', '11', '1', '2015-11-13 11:57:39', NULL, '2015-11-13 11:57:39', '2015-12-02 23:42:46', 'bb664290-99e6-4a1d-8fa8-fc6bcf8b405c'),
 ('35', '11', '11', '1', '2015-11-13 11:57:50', NULL, '2015-11-13 11:57:51', '2015-12-02 23:42:19', '03eac07e-6679-4434-8a59-ecfc5af74fca'),
 ('36', '11', '11', '1', '2015-11-13 11:58:03', NULL, '2015-11-13 11:58:03', '2015-12-02 23:42:25', '04ee8bd0-0e1e-4058-b98b-93f496f4c803'),
 ('37', '11', '11', '1', '2015-11-13 11:58:20', NULL, '2015-11-13 11:58:20', '2015-12-02 23:41:18', '77a472e1-745c-47c0-8c7a-e680098c7ac0'),
 ('47', '12', NULL, NULL, '2015-11-13 14:41:24', NULL, '2015-11-13 14:41:24', '2015-12-08 17:19:51', '2fffaae5-e6a1-4898-b2b5-06b2e3f9fa2a'),
 ('57', '8', '8', NULL, '2015-11-17 14:16:28', NULL, '2015-11-17 14:07:49', '2015-12-08 17:20:34', 'f8a17d8f-c494-45bc-b20f-91c21868d0f4'),
 ('58', '13', '13', NULL, '2015-11-17 14:19:11', NULL, '2015-11-17 14:17:42', '2015-12-08 19:25:20', 'b0a7586b-1e4b-4d09-ac6b-6b0595247baf'),
 ('61', '14', '14', NULL, '2015-11-23 10:25:46', NULL, '2015-11-17 16:40:59', '2015-12-08 17:23:51', '89851005-353a-40d5-a31b-7d3778c957cb'),
 ('62', '15', '15', NULL, '2015-11-23 10:26:03', NULL, '2015-11-17 16:41:18', '2016-01-07 11:47:25', '23e31da4-7fca-41fb-811d-4c838b55d2fc'),
 ('63', '16', '16', NULL, '2015-11-23 10:26:14', NULL, '2015-11-17 16:41:32', '2015-12-08 17:19:20', '288edf0c-844d-47c1-baeb-b5243ad36b21'),
 ('99', '2', '2', '1', '2015-11-26 13:59:00', NULL, '2015-11-26 13:59:16', '2015-12-08 21:26:02', 'c0da62f4-4167-423d-a44a-81e7a16ea75c'),
 ('109', '2', '2', '1', '2015-11-30 09:23:00', NULL, '2015-11-30 09:23:58', '2015-12-08 21:25:21', 'da6d1eab-186f-448d-b967-faa8d1dd625b'),
 ('141', '2', '2', '124', '2015-12-04 22:25:00', NULL, '2015-12-04 22:25:11', '2015-12-08 21:24:21', 'bcba6249-288f-47cd-afc5-66592785fbcd'),
 ('356', '2', '2', '124', '2016-01-07 12:08:00', NULL, '2016-01-07 12:08:52', '2016-01-12 11:35:55', '7c9da90e-f17a-491a-a13b-ccc2a384c860'),
 ('360', '2', '2', '125', '2016-01-12 21:18:00', NULL, '2016-01-12 21:18:33', '2016-01-12 21:20:52', 'decf13c9-5157-4f24-9147-5e6f50c48dac'),
 ('367', '2', '2', '125', '2016-02-09 22:01:00', NULL, '2016-02-09 22:01:41', '2016-02-09 22:01:56', 'b8394a14-9eb3-4f28-b909-bb943f44c5a4');



DROP TABLE IF EXISTS `craft_entrydrafts`;


--
-- Schema for table `craft_entrydrafts`
--
CREATE TABLE `craft_entrydrafts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entryId` int(11) NOT NULL,
  `sectionId` int(11) NOT NULL,
  `creatorId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci,
  `data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_entrydrafts_entryId_locale_idx` (`entryId`,`locale`),
  KEY `craft_entrydrafts_sectionId_fk` (`sectionId`),
  KEY `craft_entrydrafts_creatorId_fk` (`creatorId`),
  KEY `craft_entrydrafts_locale_fk` (`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_entrytypes`;


--
-- Schema for table `craft_entrytypes`
--
CREATE TABLE `craft_entrytypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sectionId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `hasTitleField` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `titleLabel` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'Title',
  `titleFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_entrytypes_name_sectionId_unq_idx` (`name`,`sectionId`),
  UNIQUE KEY `craft_entrytypes_handle_sectionId_unq_idx` (`handle`,`sectionId`),
  KEY `craft_entrytypes_sectionId_fk` (`sectionId`),
  KEY `craft_entrytypes_fieldLayoutId_fk` (`fieldLayoutId`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_entrytypes`
--

INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '1', '59', 'Homepage', 'homepage', '0', NULL, '{ section.name|raw }', NULL, '2015-11-04 11:36:32', '2015-11-13 15:24:22', '1eaa4667-96cf-421f-be46-3a7b9f6d9a42'),
 ('2', '2', '143', 'News', 'news', '0', NULL, '{headline}', NULL, '2015-11-04 11:36:32', '2015-12-07 12:25:59', '098a32c3-aaab-4533-9809-d6c2af03fdca'),
 ('3', '3', '140', 'About', 'about', '0', NULL, '{section.name|raw}', NULL, '2015-11-10 16:22:36', '2015-12-04 15:50:57', 'f2eeb8f8-b73b-4aa6-8fb3-41706caedb29'),
 ('5', '5', '104', 'Accreditations', 'accreditations', '0', NULL, '{section.name|raw}', NULL, '2015-11-10 16:24:52', '2015-11-25 13:58:40', '950d84fd-5426-454a-b8df-29dfe25dab04'),
 ('8', '8', '139', 'Pricing', 'pricing', '0', NULL, '{ section.name|raw }', NULL, '2015-11-10 16:25:52', '2015-12-04 15:50:26', 'e807ad21-3fb6-47f9-9321-b29a0202cd28'),
 ('9', '9', '138', 'Find Us', 'findUs', '0', NULL, '{section.name|raw}', NULL, '2015-11-13 09:37:14', '2015-12-04 15:49:57', '218c4bac-24d3-4e4b-ba08-54171d3a4e39'),
 ('10', '10', '97', 'Treatments', 'treatments', '0', NULL, '{section.name|raw}', NULL, '2015-11-13 09:37:53', '2015-11-23 16:51:51', '87238f0c-7fa0-47ad-b6d9-8f9f9dc3c574'),
 ('11', '11', '51', 'Treatments List', 'treatmentsList', '0', NULL, '{treatmentName}', NULL, '2015-11-13 11:16:57', '2015-11-13 14:48:14', '01dad867-e177-4b9b-b84d-7c1cc7c52c03'),
 ('12', '12', '92', 'News', 'news', '0', NULL, '{section.name|raw}', NULL, '2015-11-13 14:41:24', '2015-11-23 16:50:06', '18bb3021-f070-42c7-b3ba-9dc3a7f817d5'),
 ('13', '13', '107', 'Testimonialspg', 'testimonialspg', '0', NULL, '{section.name|raw}', NULL, '2015-11-17 14:17:42', '2015-11-25 15:15:43', 'a16e3429-048b-441b-b952-35d55b9569d8'),
 ('14', '14', '136', 'Work and Social', 'workAndSocial', '0', NULL, '{section.name|raw}', NULL, '2015-11-17 16:40:59', '2015-12-04 15:45:00', 'bc57e26c-08d2-4984-8f23-05188fd5deb1'),
 ('15', '15', '135', 'Young and Active', 'youngAndActive', '0', NULL, '{section.name|raw}', NULL, '2015-11-17 16:41:18', '2015-12-04 15:44:43', '48d48ccf-0b09-4276-bda8-a23de0b829cd'),
 ('16', '16', '137', 'Lifetime Support', 'lifetimeSupport', '0', NULL, '{section.name|raw}', NULL, '2015-11-17 16:41:32', '2015-12-04 15:45:12', 'db2747a8-dba3-4d64-9706-48548aa26167');



DROP TABLE IF EXISTS `craft_entryversions`;


--
-- Schema for table `craft_entryversions`
--
CREATE TABLE `craft_entryversions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entryId` int(11) NOT NULL,
  `sectionId` int(11) NOT NULL,
  `creatorId` int(11) DEFAULT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `num` smallint(6) unsigned NOT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci,
  `data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_entryversions_entryId_locale_idx` (`entryId`,`locale`),
  KEY `craft_entryversions_sectionId_fk` (`sectionId`),
  KEY `craft_entryversions_creatorId_fk` (`creatorId`),
  KEY `craft_entryversions_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=388 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_entryversions`
--

INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '4', '3', '1', 'en_gb', '1', NULL, '{\"typeId\":\"3\",\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-10 16:22:36', '2015-11-10 16:22:36', 'fe869c08-47b1-4933-bfea-c552ec9e38f7'),
 ('2', '5', '5', '1', 'en_gb', '1', NULL, '{\"typeId\":\"5\",\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-10 16:24:52', '2015-11-10 16:24:52', '4103521d-5f03-4abe-b047-1d39d9b5ef73'),
 ('4', '8', '9', '1', 'en_gb', '1', NULL, '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447407434,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-13 09:37:14', '2015-11-13 09:37:14', '404cf88d-f367-4355-8dc7-9af7d892f75b'),
 ('5', '9', '10', '1', 'en_gb', '1', NULL, '{\"typeId\":\"10\",\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-13 09:37:54', '2015-11-13 09:37:54', '2469b5ce-0473-473f-bfa5-44bfb2c7b936'),
 ('12', '14', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Fractures\",\"slug\":\"fractures\",\"postDate\":1447415380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\\u00a375.00\",\"24\":\"\\u00a330.00\",\"22\":\"Following a broken bone, the joints around the area will often become stiff and painful, the muscles weak and balance poor. This is easily improved with the advice, manual therapy and exercises provided by Cathedral Physiotherapy.\",\"21\":\"Fractures\"}}', '2015-11-13 11:49:40', '2015-11-13 11:49:40', '9c0b55ea-b11e-489b-a658-afc99be3ad0a'),
 ('13', '15', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Children\\u2019s Injuries\",\"slug\":\"childrens-injuries\",\"postDate\":1447415405,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Although many children bounce back quickly after injury, if they are particularly sporty, or have lost their confidence after a sprain, strain or fracture they may need some reassurance and treatment \\/ exercises to return to their previous level of care-free fitness.\",\"21\":\"Children\\u2019s Injuries\"}}', '2015-11-13 11:50:05', '2015-11-13 11:50:05', '142f5aa6-978e-402f-b849-0bf6c33cbfea'),
 ('14', '14', '11', '1', 'en_gb', '2', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Fractures\",\"slug\":\"fractures\",\"postDate\":1447415340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\\u00a375.00\",\"24\":\"\\u00a330.00\",\"22\":\"Following a broken bone, the joints around the area will often become stiff and painful, the muscles weak and balance poor. This is easily improved with the advice, manual therapy and exercises provided by Cathedral Physiotherapy.\",\"21\":\"Fractures\"}}', '2015-11-13 11:50:50', '2015-11-13 11:50:50', '62803b09-b988-4007-afd3-5d1fcaa32b28'),
 ('15', '15', '11', '1', 'en_gb', '2', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Children\\u2019s Injuries\",\"slug\":\"childrens-injuries\",\"postDate\":1447415400,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Although many children bounce back quickly after injury, if they are particularly sporty, or have lost their confidence after a sprain, strain or fracture they may need some reassurance and treatment \\/ exercises to return to their previous level of care-free fitness.\",\"21\":\"Children\\u2019s Injuries\"}}', '2015-11-13 11:50:54', '2015-11-13 11:50:54', '7e0f4b9a-97c6-4e3c-8f1a-813129a12ea3'),
 ('16', '16', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Young adult hip pain\",\"slug\":\"young-adult-hip-pain\",\"postDate\":1447415474,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Hip pain in young adults can be caused by a number of issues from muscle imbalance around the hip, cartilage problems within the joint, bony anatomical issues or referred pain from the back or pelvis. The excellent clinical reasoning found at Cathedral Physiotherapy will help to differentiate the causes and formulate a treatment plan or onward referral as required. I have worked closely with the Royal Devon and Exeter NHS Hospital hip consultants with patients with femoral acetabular impingement in particular, including being involved in research, and so am at the cutting edge of treating this group of patients.\",\"21\":\"Young adult hip pain\"}}', '2015-11-13 11:51:14', '2015-11-13 11:51:14', '33395604-25bc-4063-bb60-35599b81bc06'),
 ('17', '17', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Sports Injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447415494,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Whether you are after prevention or cure, Cathedral Physiotherapy can help you. Excellent assessment will ensure that you receive the treatment you require, be it a combination of functional exercise, manual therapy, ultrasound, taping or acupuncture. We have a small exercise area in the clinic, but can also adapt your training program for your to rehabilitate at your own gym \\/ pool.\",\"21\":\"Sports Injuries\"}}', '2015-11-13 11:51:34', '2015-11-13 11:51:34', '2a87a3d8-0b0d-445c-8f77-41426fab36b8'),
 ('18', '18', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Haemophilia\",\"slug\":\"haemophilia\",\"postDate\":1447415511,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"For those individuals diagnosed with haemophilia, early access to physiotherapy is crucial following a bleed. This is a niche area that Sarah has worked in as the designated haemophilia physiotherapy specialist at the Royal Devon and Exeter hospital over the last few years, so you can be assured that you are in safe hands\",\"21\":\"Haemophilia\"}}', '2015-11-13 11:51:51', '2015-11-13 11:51:51', '8c04501e-a9a6-440f-a860-f6c9b3af5eb0'),
 ('19', '19', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Work-related pain\",\"slug\":\"work-related-pain\",\"postDate\":1447415594,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health, 2008).\",\"21\":\"Work-related pain\"}}', '2015-11-13 11:53:14', '2015-11-13 11:53:14', 'f4296810-8484-4537-9573-493e648ff2f3'),
 ('20', '20', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1447415609,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Minor sprains and strains can be managed with PRICE therapy:\\r\\nProtect the area using a support temporarily, Rest the are for the first 48-72 hrs, apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin), Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow and remove the bandage before sleep, Elevate the injured area, supported on a pillow, to reduce the swelling. Ultrasound and taping can also promote healing. Following this we will help rehabilitate you range of movement, strength and balance so that you return to your full function.\",\"21\":\"Sprains and Strains\"}}', '2015-11-13 11:53:29', '2015-11-13 11:53:29', '702edaed-3122-4a05-a20a-9ebc5b12471c'),
 ('21', '21', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Back Pain\",\"slug\":\"back-pain\",\"postDate\":1447415628,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Low back pain is reported by 80% of people at sometime in their life. A large percentage of this will improve with basic advice and exercises, but some people need more specific treatment (work-related advice, functional exercises, manual therapy, or acupuncture). Come and be assessed today so that we can help you on your road to recovery, and to help prevent recurrence.\",\"21\":\"Back Pain\"}}', '2015-11-13 11:53:48', '2015-11-13 11:53:48', 'd28920ae-0b6a-4035-8ed0-07f07ce065af'),
 ('22', '22', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Neck Pain\",\"slug\":\"neck-pain\",\"postDate\":1447415641,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Neck pain is common but most cases aren\\u2019t caused by a serious problem. Some people get it after an accident or injury, whilst others find it appears if they are stressed, or inactive, or it can be related to age-related changes in the structures of the neck. Commonly felt locally in the neck, it can also refer to the shoulder \\/ arm, and sometimes may cause pins and needles \\/ numbness. With good advice, reassurance, specific exercises and sometimes manual therapy, the majority of neck pain improved within about six weeks.\",\"21\":\"Neck Pain\"}}', '2015-11-13 11:54:01', '2015-11-13 11:54:01', 'f6c72ade-7fa8-444d-909a-ea1a1b5b4b9d'),
 ('23', '23', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Shoulder \\/ Elbow \\/ Wrist pain\",\"slug\":\"shoulder-elbow-wrist-pain\",\"postDate\":1447415655,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Whether your pain is work or hobby related it is important to get the correct advice early to prevent chronicity. Arm pain can be referred from the neck, but is more commonly related to impingement of the tendons, or tears of the muscle, but can also be due to \\u2018frozen shoulder\\u2019. Elbow complaints include tennis elbow, golfers elbow, or nerve irritation. Wrist pain is commonly related to the position of the wrist at work or during hobbies, but can be due to stiffness post fracture, or carpal tunnel syndrome. An excellent assessment will differentiate the problem and help you to manage and improve your symptoms.\",\"21\":\"Shoulder \\/ Elbow \\/ Wrist pain\"}}', '2015-11-13 11:54:15', '2015-11-13 11:54:15', '5b928936-a492-4773-a31b-28a4c64fbf82'),
 ('24', '24', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Hip \\/ Knee \\/ Ankle pain\",\"slug\":\"hip-knee-ankle-pain\",\"postDate\":1447415673,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Hip pain - Problems with cartilage, early osteoarthritis, tendonopathy, sprains and muscle imbalances can all cause hip pain, but it can also be referred from the back. Accurate assessment is crucial to ensure you have the right treatment to improve your problem.\",\"21\":\"Hip \\/ Knee \\/ Ankle pain\"}}', '2015-11-13 11:54:33', '2015-11-13 11:54:33', 'b17bf898-d7bc-403f-ad16-f10c1979fadd'),
 ('25', '24', '11', '1', 'en_gb', '2', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Hip \\/ Knee \\/ Ankle pain\",\"slug\":\"hip-knee-ankle-pain\",\"postDate\":1447415640,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Hip pain - Problems with cartilage, early osteoarthritis, tendonopathy, sprains and muscle imbalances can all cause hip pain, but it can also be referred from the back. Accurate assessment is crucial to ensure you have the right treatment to improve your problem.\\r\\n\\r\\nKnee pain \\u2013 Be it local pain, swelling or stiffness secondary to an acute injury to the ligaments of the joint, more insidious in nature, or referred pain, once diagnosed, the majority of problems will significantly improve with a specific functional exercise program, but if necessary it can also be treated with manual therapy, ultrasound, taping or acupuncture too.\\r\\n\\r\\nAnkle pain \\u2013 The majority of people have sustained a sprained ankle at some point, and we can offer acute treatment for this with ultrasound, soft tissie therapy, taping and exercises. However, we rely on our legs heavily, and the key is to prevent it recurring again through specific rehabilitation, so that you can stay as fit and active as you wish.\",\"21\":\"Hip \\/ Knee \\/ Ankle pain\"}}', '2015-11-13 11:55:11', '2015-11-13 11:55:11', 'ea7b859f-92af-4f03-bf48-f6c585ecf72a'),
 ('26', '25', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Orthopaedic post operative care\",\"slug\":\"orthopaedic-post-operative-care\",\"postDate\":1447415727,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Come to Cathedral Physiotherapy for your post operative care. Be it following a fracture, ligament reconstruction, hip arthroscopy, or joint replacement we can help you regain your independence. Having worked at the Royal Devon and Exeter hospital for the last 11 years I have strong links with the orthopaedic teams there.\",\"21\":\"Orthopaedic post operative care\"}}', '2015-11-13 11:55:27', '2015-11-13 11:55:27', 'ccd4c3eb-b2d1-457e-badb-74fb6a799587'),
 ('27', '26', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Post fracture rehabilitation\",\"slug\":\"post-fracture-rehabilitation\",\"postDate\":1447415743,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"It is quite common to have on-going problems with pain, swelling and stiffness in the joints surrounding the area where you have fractured. However the real issue, is that people often lose their confidence too. Let us rehabilitate you back to your previous level of function or fitness allowing you to live your life to the full.\",\"21\":\"Post fracture rehabilitation\"}}', '2015-11-13 11:55:43', '2015-11-13 11:55:43', '3d3f1be6-222c-4617-b922-5e72551a6baf'),
 ('28', '27', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Non specific arm pain\",\"slug\":\"non-specific-arm-pain\",\"postDate\":1447415755,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Characterised by ongoing pain, altered sensations in the hand \\/ arm and sometime feelings of weakness, this can be a frustrating condition to have, particularly as commonly many objective medical test are negative. Often, modifications to posture, work stations, gaining an understanding of pain mechanisms, and local tissues techniques can improve symptoms and function.\",\"21\":\"Non specific arm pain\"}}', '2015-11-13 11:55:55', '2015-11-13 11:55:55', 'd2401347-ebce-478b-a373-ed6333d916a8'),
 ('29', '28', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Thoracic Outlet Syndrome\",\"slug\":\"thoracic-outlet-syndrome\",\"postDate\":1447415768,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Characterised by neck \\/ shoulder \\/ arm pain, feelings of weakness in the arm (particularly with overhead activities), and possible discolouration of the hand, this condition can be debilitating. With good quality conservative physiotherapy, symptoms and function can be significantly improved, thereby improving your quality of life.\",\"21\":\"Thoracic Outlet Syndrome\"}}', '2015-11-13 11:56:08', '2015-11-13 11:56:08', '020dc947-b96f-43ea-8ef8-bc2fd13dc577'),
 ('30', '29', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Headaches and Dizziness\",\"slug\":\"headaches-and-dizziness\",\"postDate\":1447415786,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Benign headaches can be caused by tension in the muscles, stiffness in the neck or muscle imbalance. Often characterised by being one-sided, or in a band around the head, and associated with neck pain, or certain movements, symptoms can be improved significantly with a combination of exercise, manual therapy, acupuncture and an understanding of pain pathways.\\r\\n\\r\\nDizziness can be generated from the neck, the inner ear or the brain, and accurate differential diagnosis is crucial for appropriate treatment.\",\"21\":\"Headaches and Dizziness\"}}', '2015-11-13 11:56:26', '2015-11-13 11:56:26', '8ebd44c9-7d44-45b9-8c57-96b5f260211d'),
 ('31', '30', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Pregnancy related pain\",\"slug\":\"pregnancy-related-pain\",\"postDate\":1447415802,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Pregnancy related pelvic girdle pain is common and affects 1 in 5 women during their pregnancy. There are a wide range of symptoms, some of which improve naturally during the course of the pregnancy as your body adapts, some which need advice and \\/or treatment early on to keep you as active as possible. Don\\u2019t suffer in silence, get help early.\",\"21\":\"Pregnancy related pain\"}}', '2015-11-13 11:56:42', '2015-11-13 11:56:42', 'd1cf87a7-daae-495a-9de6-26ee84bedb8c'),
 ('32', '31', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Management of long term conditions\",\"slug\":\"management-of-long-term-conditions\",\"postDate\":1447415815,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Some people are diagnosed with long term conditions, be it persistent pain generated by the nervous system, or on-going musculoskeletal problems following a car crash. At Cathedral Physiotherapy we believe in working with you to assist you to maximise your physical potential. \",\"21\":\"Management of long term conditions\"}}', '2015-11-13 11:56:55', '2015-11-13 11:56:55', '7e2b9bf1-23a3-42ea-a3b3-828788211214'),
 ('33', '32', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Rheumatological conditions\",\"slug\":\"rheumatological-conditions\",\"postDate\":1447415831,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Although consisting of a variety of diagnosis, for instance Rheumatoid Arthritis, Ankylosing Spondylitis, Psoriatic Arthritis etc, many of these diseases follow a period of flare and recovery. At Cathedral Physiotherapy we can help you not to be defined by your diagnosis, assist you through your flares, and maximise your return to function so that you continue to lead and full and fruitful life.\",\"21\":\"Rheumatological conditions\"}}', '2015-11-13 11:57:11', '2015-11-13 11:57:11', '34195ca3-b586-493a-90e6-85d960fcf541'),
 ('34', '33', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Osteoarthritis\",\"slug\":\"osteoarthritis\",\"postDate\":1447415848,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Osteoarthritis is a common type of arthritis, a painful condition which can affect the joints especially the hips, knees, neck, lower back, hand or feet. Although it can occur at any age, it is more likely to appear between the ages of 45-75 years, and often in women more than men. There is much evidence showing that a combination of non steroidal anti-inflammatories and exercise or physiotherapy will help to reduce the symptoms of pain and stiffness, allowing you not to be restricted by your symptoms.\",\"21\":\"Osteoarthritis\"}}', '2015-11-13 11:57:28', '2015-11-13 11:57:28', '2594fb7b-0ac8-4663-b723-42ccfa15b329'),
 ('35', '34', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Joint Replacements\",\"slug\":\"joint-replacements\",\"postDate\":1447415859,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Following total or partial knee replacement, hip replacement or shoulder replacement, good quality regular physiotherapy is important to decrease swelling and pain and increase range of movement, muscle power and function. We are a lower ground premises, therefore you need to be able to complete one flight of stairs, however if access is an issue, contact us and we will discuss the possibility of a domiciliary visit.\",\"21\":\"Joint Replacements\"}}', '2015-11-13 11:57:39', '2015-11-13 11:57:39', 'e88f1c88-303b-490a-98e4-531e08e489ab'),
 ('36', '35', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Osteoporosis\",\"slug\":\"osteoporosis\",\"postDate\":1447415870,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Having been the principle investigator for Exeter on the PROVE trial (2014-16) looking into rehabilitation of patients with osteoporosis who have vertebral fractures, I am well qualified to help you manage your condition, and to keep you as fit and active as possible.\",\"21\":\"Osteoporosis\"}}', '2015-11-13 11:57:51', '2015-11-13 11:57:51', 'eea9fb71-e882-493e-9b3d-1762b77d93cd'),
 ('37', '36', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Post Cancer Rehabilitation\",\"slug\":\"post-cancer-rehabilitation\",\"postDate\":1447415883,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Most people are so relieved to have stopped the active stage of their treatment, be it radiotherapy or chemotherapy, that they are happy to live with compromises in function for a time. However, it is common to become frustrated with these compromises once your energy returns. We passionately  believe that you should not be defined by your diagnosis, and will work hard with you to facilitate and maximise your return to function; be it to improve your shoulder range of movement post breast surgery so that you can reach the top cupboards, or return to tennis and swimming again.\",\"21\":\"Post Cancer Rehabilitation\"}}', '2015-11-13 11:58:03', '2015-11-13 11:58:03', '3b90e2bb-fe59-4891-bc02-8e0158e162fc'),
 ('38', '37', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Mild Continence Issues\",\"slug\":\"mild-continence-issues\",\"postDate\":1447415900,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Bladder or bowel continence issues can be embarrassing, but when it is only a mild issue much can be done with pelvic floor exercises and fluid intake management. We can happily treat mild continence issues e.g. post pregnancy, or stress incontinence related to respiratory problems. If we feel your continence issues need further input, then we will refer you on to the appropriate practitioner.\",\"21\":\"Mild Continence Issues\"}}', '2015-11-13 11:58:20', '2015-11-13 11:58:20', '31fcb91e-0c6e-4a40-9801-9e4958bdb4fd'),
 ('39', '9', '10', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"26\":{\"new2\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Young & Active\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"17\",\"16\",\"15\"]}},\"new1\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Work and Social\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"28\",\"29\",\"30\"]}},\"new3\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Lifetime Support\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"31\",\"33\",\"34\",\"35\",\"36\",\"37\"]}}}}}', '2015-11-13 12:31:57', '2015-11-13 12:31:57', '9a1ac544-7735-4678-a204-4d03c753f536'),
 ('40', '9', '10', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Treatments\",\"26\":{\"38\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Young & Active\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"17\",\"16\",\"15\"],\"treatmentImage\":[\"41\"]}},\"39\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Work and Social\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"treatmentImage\":[\"41\"]}},\"40\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Lifetime Support\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"31\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"treatmentImage\":[\"41\"]}}}}}', '2015-11-13 12:49:45', '2015-11-13 12:49:45', '3fb9a614-c5f2-4b3b-8bab-f3eef77b420a'),
 ('43', '2', '1', '1', 'en_gb', '1', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-13 14:09:26', '2015-11-13 14:09:26', '017e37be-e896-471e-ab23-df1fcd3bec9c'),
 ('44', '47', '12', '1', 'en_gb', '1', NULL, '{\"typeId\":\"12\",\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-13 14:41:24', '2015-11-13 14:41:24', '719fd1b0-10b0-45a5-86a6-fe2290c0ad50'),
 ('46', '4', '3', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities which represents cathedral physiotherapy.\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy, who is passionate about providing the best possible care. \",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:27:55', '2015-11-13 15:27:55', '6dfd25d3-a20c-4dd4-9041-2ec141f18c57'),
 ('47', '5', '5', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:29:11', '2015-11-13 15:29:11', 'e623a286-65a2-4369-a095-a7c6dcbfa3ff'),
 ('48', '8', '9', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447407434,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:29:43', '2015-11-13 15:29:43', '49785071-0f14-4f4e-b6a5-3ba3505e459d'),
 ('49', '2', '1', '1', 'en_gb', '2', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment:\",\"6\":\"We stand for Excellence, Experience and Enthusiasm \",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:30:09', '2015-11-13 15:30:09', 'ce6b17b1-db33-4896-b274-41b929b9227d'),
 ('50', '47', '12', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:30:57', '2015-11-13 15:30:57', '1686940d-bdc6-4606-8143-8ed2584f998c'),
 ('51', '9', '10', '1', 'en_gb', '4', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"26\":{\"38\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Young & Active\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"17\",\"16\",\"15\"],\"treatmentImage\":[\"41\"]}},\"39\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Work and Social\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"treatmentImage\":[\"41\"]}},\"40\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Lifetime Support\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"31\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"treatmentImage\":[\"41\"]}}}}}', '2015-11-13 15:32:11', '2015-11-13 15:32:11', '835ef35c-8b6f-482c-b6ff-6b0ccba054f9'),
 ('54', '9', '10', '1', 'en_gb', '5', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"26\":{\"38\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Young & Active\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"17\",\"16\",\"15\"],\"treatmentImage\":[\"41\"]}},\"39\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Work & Social\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"treatmentImage\":[\"41\"]}},\"40\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Lifetime Support\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"31\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"treatmentImage\":[\"41\"]}}}}}', '2015-11-16 16:59:48', '2015-11-16 16:59:48', '8ee0bf74-bf4a-4f20-84e5-ebd62406eab8'),
 ('55', '4', '3', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities which represents cathedral physiotherapy.\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy, who is passionate about providing the best possible care. \",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"new1\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"new2\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. Currently her time is split between working as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, where she has been working for the last 12 years, and running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"new3\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. Sarah is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"new1\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute fo rHealth Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and audit a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-11-17 11:20:23', '2015-11-17 11:20:23', '6abf630d-61cd-4427-adf9-f6b05109fd50'),
 ('56', '4', '3', '1', 'en_gb', '4', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities which represents cathedral physiotherapy.\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy, who is passionate about providing the best possible care. \",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. Currently her time is split between working as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, where she has been working for the last 12 years, and running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. Sarah is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"56\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute fo rHealth Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and audit a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-11-17 12:00:42', '2015-11-17 12:00:42', '4d1bff0b-1af2-4188-8bfe-f4afcdc92814'),
 ('59', '57', '8', '1', 'en_gb', '1', NULL, '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769269,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 14:07:49', '2015-11-17 14:07:49', '45004983-11c3-43da-8f45-5c1914f7a0d6'),
 ('60', '57', '8', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769269,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for pricing page intro paragraph.\",\"6\":\"Heading for pricing placeholder\"}}', '2015-11-17 14:09:38', '2015-11-17 14:09:38', '1565a0b4-83c8-4acc-962c-02631f1353d5'),
 ('61', '57', '8', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769269,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for pricing page intro paragraph.\",\"6\":\"Heading for pricing placeholder\"}}', '2015-11-17 14:14:16', '2015-11-17 14:14:16', '7e29dda1-570c-46bd-9f57-e1184c76fe78'),
 ('62', '58', '13', '1', 'en_gb', '1', NULL, '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonialspg\",\"slug\":\"testimonialspg\",\"postDate\":1447769862,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 14:17:42', '2015-11-17 14:17:42', '5459c343-8685-4bf1-9643-264b44e90805'),
 ('63', '58', '13', '1', 'en_gb', '2', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 14:21:47', '2015-11-17 14:21:47', 'c283b5d7-6a1d-4438-b7c2-deb88482c3cf'),
 ('64', '58', '13', '1', 'en_gb', '3', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder heading for testimonials\",\"6\":\"Placeholder text for testimonials intro paragraph\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-17 14:23:17', '2015-11-17 14:23:17', '6ed79e46-51fb-4e8f-b579-7b76c43f543a'),
 ('65', '58', '13', '1', 'en_gb', '4', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder heading for testimonials\",\"6\":\"Placeholder text for testimonials intro paragraph\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"new1\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerforename\":\"James\",\"location\":\"Exeter\",\"quote\":\"Sarah treated a knee injury I couldn\'t shake off. Now I\'m completely pain free and back playing football.\"}},\"new2\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerforename\":\"Andy\",\"location\":\"Exeter\",\"quote\":\"I got injured just before a big table tennis game, but Sarah treated my arm just in time - unfortunately I still lost!\"}}}}}', '2015-11-17 15:45:10', '2015-11-17 15:45:10', '96dda8e2-68c4-4df8-bcdb-24dc1bf47227'),
 ('66', '61', '14', '1', 'en_gb', '1', NULL, '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1447778459,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 16:40:59', '2015-11-17 16:40:59', '779807a7-bdc0-4d20-8500-486375ddfb45'),
 ('67', '62', '15', '1', 'en_gb', '1', NULL, '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1447778478,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 16:41:18', '2015-11-17 16:41:18', 'a06942b5-a78c-4ce9-ab29-0f58e002f81a'),
 ('68', '63', '16', '1', 'en_gb', '1', NULL, '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1447778492,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 16:41:32', '2015-11-17 16:41:32', '16dda47c-8dad-4f7f-ae54-d85415e73e8b'),
 ('69', '61', '14', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1447778459,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-11-17 16:51:00', '2015-11-17 16:51:00', '02255c85-9036-4645-a9bf-1a181cf1ab77'),
 ('70', '62', '15', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1447778478,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"17\",\"16\",\"15\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec.\",\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-11-17 16:51:31', '2015-11-17 16:51:31', '3209a607-4a4c-467c-9715-2e6d64896cdf'),
 ('71', '63', '16', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1447778492,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-11-17 16:52:15', '2015-11-17 16:52:15', 'de8c148b-8420-4924-8109-5524b8a9ae77'),
 ('78', '61', '14', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1447778459,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-11-19 14:53:06', '2015-11-19 14:53:06', '51e0d10c-481c-4760-b5f1-6ad3f51376d0'),
 ('79', '19', '11', '1', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Work-related pain\",\"slug\":\"work-related-pain\",\"postDate\":1447415594,\"expiryDate\":null,\"enabled\":\"1\",\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health,).\",\"21\":\"Work-related pain\"}}', '2015-11-19 14:53:46', '2015-11-19 14:53:46', 'bc719e73-a03e-4d72-a7c9-b5a646bd21ab'),
 ('80', '19', '11', '1', 'en_gb', '3', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Work-related pain\",\"slug\":\"work-related-pain\",\"postDate\":1447415580,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health, 2008).\",\"21\":\"Work-related pain\"}}', '2015-11-19 14:54:28', '2015-11-19 14:54:28', '30d3b945-4b78-428c-83e9-6dc4598317b6'),
 ('88', '9', '10', '1', 'en_gb', '6', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment. Please look through the lists below and see how we can help you. \",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:02:49', '2015-11-23 11:02:49', 'ae22f698-a792-46e9-9d96-b730e1e0ddb9'),
 ('89', '47', '12', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Welcome to our news page which includes information from self-help advice for what to do as soon as you\\u2019ve hurt yourself, to topical items in the news, and copies of our monthly news letter. There are also a number of useful links to u-tube clips which we feel are useful. If there is something that isn\\u2019t here and you would like to see, then please email us as enquiries@cathedralphysiotherapy.co.uk and we will do our best to respond to your suggestions.\",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:03:29', '2015-11-23 11:03:29', '42f8d12b-38e4-4e00-98f8-0cd07bf5b104'),
 ('99', '58', '13', '1', 'en_gb', '5', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"James\",\"location\":\"Exeter\",\"quote\":\"Sarah treated a knee injury I couldn\'t shake off. Now I\'m completely pain free and back playing football.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Andy\",\"location\":\"Exeter\",\"quote\":\"I got injured just before a big table tennis game, but Sarah treated my arm just in time - unfortunately I still lost!\"}}}}}', '2015-11-24 16:29:06', '2015-11-24 16:29:06', '546ac5c1-6ce4-4cec-8365-545a26993870'),
 ('100', '58', '13', '1', 'en_gb', '6', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"I had some treatment at Cathedral Physiotherapy and it was brilliant!\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"I had some treatment at Cathedral Physiotherapy and it was brilliant!\"}},\"new1\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"I had some treatment at Cathedral Physiotherapy and it was brilliant!\"}},\"new2\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"I had some treatment at Cathedral Physiotherapy and it was brilliant!\"}}}}}', '2015-11-24 16:38:18', '2015-11-24 16:38:18', 'ab5a2861-690c-4e4e-beb2-088ad61cdd61'),
 ('101', '58', '13', '1', 'en_gb', '7', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"The physiotherapists and office staff all provide a very personal service and seem to ensure that the atmosphere is calming, professional and friendly. My physiotherapist was incredibly approachable which definitely made me feel more positive and relaxed about my recovery. Things were explained in a much more comprehensive but understandable way at Cathedral Physiotherapy.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Great Team of staff with excellent knowledge, care and professionalism\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"After seven years of suffering with arm pain, I went to Sarah to see if there was anything he could do to relieve it. Now three months on, all I can say is a HUGE Thank You, as I am completely clear of all arm and neck pain. For the first time in years I can do \\u2018normal\\u2019 things\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Quickly diagnosed the problem, clearly explained the body\'s reaction and devised an effective remedy both in session and through exercises. All in all I am delighted.\"}}}}}', '2015-11-24 17:18:04', '2015-11-24 17:18:04', '351798b3-6a14-4460-9224-2112592fab41'),
 ('102', '61', '14', '1', 'en_gb', '4', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"77\"]}}', '2015-11-25 12:05:56', '2015-11-25 12:05:56', 'ec7dd785-6b0c-4751-96ac-13f47b78ee59'),
 ('103', '63', '16', '1', 'en_gb', '3', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-11-25 12:06:16', '2015-11-25 12:06:16', 'e8135dfe-19b1-406b-9c22-6185e5cd77c6'),
 ('104', '5', '5', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"new1\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"80\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \"}},\"new2\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"82\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \"}},\"new3\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"79\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \"}},\"new4\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"78\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \"}}}}}', '2015-11-25 14:09:00', '2015-11-25 14:09:00', '7eb566b3-4e1d-4601-934a-9866543cabb1'),
 ('105', '5', '5', '1', 'en_gb', '4', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"80\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"82\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"79\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"91\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"78\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-11-25 14:21:28', '2015-11-25 14:21:28', '1f0575f0-2d50-4568-b5fb-0d714cd2b1fa'),
 ('106', '5', '5', '1', 'en_gb', '5', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"95\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"94\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"96\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"91\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"97\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-11-25 15:13:25', '2015-11-25 15:13:25', 'bb70985c-5ea1-422f-8312-2c5e1868d332'),
 ('107', '58', '13', '1', 'en_gb', '8', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"The physiotherapists and office staff all provide a very personal service and seem to ensure that the atmosphere is calming, professional and friendly. My physiotherapist was incredibly approachable which definitely made me feel more positive and relaxed about my recovery. Things were explained in a much more comprehensive but understandable way at Cathedral Physiotherapy.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Great Team of staff with excellent knowledge, care and professionalism\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"After seven years of suffering with arm pain, I went to Sarah to see if there was anything she could do to relieve it. Now three months on, all I can say is a HUGE Thank You, as I am completely clear of all arm and neck pain. For the first time in years I can do \\u2018normal\\u2019 things\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Quickly diagnosed the problem, clearly explained the body\'s reaction and devised an effective remedy both in session and through exercises. All in all I am delighted.\"}}}}}', '2015-11-25 15:14:48', '2015-11-25 15:14:48', '02da1a96-c13f-4137-9861-7c5a157bba72'),
 ('108', '15', '11', '1', 'en_gb', '3', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Children\\u2019s Injuries\",\"slug\":\"childrens-injuries\",\"postDate\":1447415400,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"50.00\",\"24\":\"50.00\",\"22\":\"Although many children bounce back quickly after injury, if they are particularly sporty, or have lost their confidence after a sprain, strain or fracture they may need some reassurance and treatment \\/ exercises to return to their previous level of care-free fitness.\",\"21\":\"Children\\u2019s Injuries\"}}', '2015-11-26 11:08:24', '2015-11-26 11:08:24', '95bdde56-c2f8-476e-8bac-aaf5cbc718d7'),
 ('109', '15', '11', '1', 'en_gb', '4', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Children\\u2019s Injuries\",\"slug\":\"childrens-injuries\",\"postDate\":1447415400,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"50\",\"24\":\"50\",\"22\":\"Although many children bounce back quickly after injury, if they are particularly sporty, or have lost their confidence after a sprain, strain or fracture they may need some reassurance and treatment \\/ exercises to return to their previous level of care-free fitness.\",\"21\":\"Children\\u2019s Injuries\"}}', '2015-11-26 11:10:39', '2015-11-26 11:10:39', '0ab30a6a-b4d5-4feb-8487-1a0f7f77cfb0'),
 ('110', '5', '5', '1', 'en_gb', '6', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"You can be assured that the clinic is regulated and governed by the following bodies for your safety.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"95\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"94\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"96\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"91\"]}},\"new1\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":\"\",\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":\"\"}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"97\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-11-26 11:46:49', '2015-11-26 11:46:49', '85f90279-77b0-48ad-8bf3-057712ea8ce4'),
 ('111', '57', '8', '1', 'en_gb', '4', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: New appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Heading for pricing placeholder\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-26 11:48:25', '2015-11-26 11:48:25', '75125982-c9aa-4010-9ac3-dba6c331d1d2'),
 ('112', '99', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546356,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nWhat have I done?\\r\\n\\r\\nYour back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nDo I need a scan?\\r\\n\\r\\nThe current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\\r\\n\\r\\nShould I see a doctor?\\r\\n\\r\\nThe majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\\r\\n\\r\\nReferences: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-26 13:59:16', '2015-11-26 13:59:16', 'b0131c27-8440-42d1-b08b-6f2321591b55'),
 ('113', '99', '2', '1', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nWhat have I done?\\r\\n\\r\\nYour back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nDo I need a scan?\\r\\n\\r\\nThe current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\\r\\n\\r\\nShould I see a doctor?\\r\\n\\r\\nThe majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\\r\\n\\r\\nReferences: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-26 14:18:10', '2015-11-26 14:18:10', 'a0288cf1-72e9-4101-b561-b23cdc5754b0'),
 ('114', '99', '2', '1', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nWhat have I done?\\r\\n\\r\\nYour back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nDo I need a scan?\\r\\n\\r\\nThe current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\\r\\n\\r\\nShould I see a doctor?\\r\\n\\r\\nThe majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\\r\\n\\r\\nReferences: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"100\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-26 14:19:57', '2015-11-26 14:19:57', '901a40bc-1465-4eef-9c7c-ac6f25c798ea'),
 ('115', '99', '2', '1', 'en_gb', '4', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nWhat have I done?\\r\\n\\r\\nYour back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nDo I need a scan?\\r\\n\\r\\nThe current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\\r\\n\\r\\nShould I see a doctor?\\r\\n\\r\\nThe majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\\r\\n\\r\\nReferences: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":\"\",\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-26 14:20:07', '2015-11-26 14:20:07', '806fbc1c-bbe9-441b-8968-e1639e5879c6'),
 ('116', '99', '2', '1', 'en_gb', '5', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nWhat have I done?\\r\\n\\r\\nYour back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nDo I need a scan?\\r\\n\\r\\nThe current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\\r\\n\\r\\nShould I see a doctor?\\r\\n\\r\\nThe majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\\r\\n\\r\\nReferences: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\"}},\"new2\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\"}},\"new3\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\"}},\"new4\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"66\":\"\"}}', '2015-11-26 14:30:34', '2015-11-26 14:30:34', '51c77d86-fe81-4a9e-ac6f-22da84dab529'),
 ('117', '99', '2', '1', 'en_gb', '6', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"66\":{\"new1\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"new2\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"new3\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"new4\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-11-26 14:46:03', '2015-11-26 14:46:03', '388ba72d-5239-49e5-86c7-d8b02693fb76'),
 ('118', '99', '2', '1', 'en_gb', '7', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-11-26 15:00:31', '2015-11-26 15:00:31', '40ecfbdf-8795-4ec4-bc56-54364a8cbd24'),
 ('119', '58', '13', '1', 'en_gb', '9', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Great Team of staff with excellent knowledge, care and professionalism\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"After seven years of suffering with arm pain, I went to Sarah to see if there was anything she could do to relieve it. Now three months on, all I can say is a HUGE Thank You, as I am completely clear of all arm and neck pain. For the first time in years I can do \\u2018normal\\u2019 things\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Quickly diagnosed the problem, clearly explained the body\'s reaction and devised an effective remedy both in session and through exercises. All in all I am delighted.\"}}}}}', '2015-11-30 09:13:29', '2015-11-30 09:13:29', '02da1f97-5ed0-4cc2-b028-c9cede286ff2'),
 ('120', '109', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Media comment: November\",\"slug\":\"media-comment-november\",\"postDate\":1448875437,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"\",\"38\":\"\",\"54\":\"As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded \\u2018New Year Resolutions\\u2019. Why not take a longer term approach to your health rather than the \\u2018boom and bust\\u2019 which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"This November an article was published in Gerontology, reported in the media (http:\\/\\/www.dailymail.co.uk\\/health\\/article-3311222\\/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html; http:\\/\\/www.bbc.co.uk\\/news\\/health-34764693; http:\\/\\/www.theguardian.com\\/uk-news\\/2015\\/nov\\/09\\/strong-legs-healthier-brain-in-old-age), which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect \\u2013 is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \\r\\n\\r\\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways \\u2013 heart, lungs, blood pressure, mental health, bone strength\\u2026.. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point (http:\\/\\/www.nhs.uk\\/Livewell\\/fitness\\/Pages\\/physical-activity-guidelines-for-adults.aspx). \\r\\n\\r\\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on\\u2026.give the family an exercise make over this year\\u2026..who knows, you might be reaping the benefits on those crosswords in years to come!\"}},\"new2\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\"}}},\"37\":\"Media comment: November\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"66\":\"\"}}', '2015-11-30 09:23:58', '2015-11-30 09:23:58', 'b5c7db18-0132-4977-9d23-cc41dee088ef'),
 ('125', '4', '3', '1', 'en_gb', '5', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities which represents cathedral physiotherapy.\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy, who is passionate about providing the best possible care. \",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. Currently her time is split between working as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, where she has been working for the last 12 years, and running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. Sarah is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"118\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute fo rHealth Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and audit a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-11-30 11:27:40', '2015-11-30 11:27:40', '243c6230-2eda-4da4-8849-404c279b4879'),
 ('126', '2', '1', '1', 'en_gb', '3', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment:\",\"6\":\"Delivering Excellence, Experience and Enthusiasm \",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-30 12:00:24', '2015-11-30 12:00:24', '70da80c3-4ad6-49ce-b5ae-c2983c38774b'),
 ('127', '57', '8', '1', 'en_gb', '5', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: New appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Heading for pricing placeholder\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-30 12:20:27', '2015-11-30 12:20:27', '80a9d15b-e31e-4ec5-970f-f5baa6403931'),
 ('128', '5', '5', '1', 'en_gb', '7', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"You can be assured that the clinic is regulated and governed by the following bodies for your safety.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"95\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"94\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"96\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"91\"]}},\"98\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"120\"],\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":[\"119\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"97\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-12-01 09:37:28', '2015-12-01 09:37:28', '7623e56d-41b1-4c2c-adc1-3f03802e8f88'),
 ('129', '63', '16', '1', 'en_gb', '4', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"70\":{\"new1\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionheading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"new2\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionheading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"new3\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionheading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"53\":[\"76\"]}}', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '87d4afe2-7f4e-4400-8d1f-784549d92739'),
 ('130', '57', '8', '1', 'en_gb', '6', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: New appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-01 17:22:07', '2015-12-01 17:22:07', '8f93ca96-2388-4863-b40d-88eb45c19992'),
 ('131', '63', '16', '1', 'en_gb', '5', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial Assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-02 11:49:31', '2015-12-02 11:49:31', '3ba79319-9c69-4747-9c05-dff50d4690bb'),
 ('132', '61', '14', '1', 'en_gb', '5', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"new1\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial Assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}}},\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"77\"]}}', '2015-12-02 11:49:33', '2015-12-02 11:49:33', '4f8e005e-c987-4028-b32d-ef9f8f465b89'),
 ('133', '61', '14', '1', 'en_gb', '6', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial Assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"new1\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"new2\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"77\"]}}', '2015-12-02 11:50:18', '2015-12-02 11:50:18', 'd59072e5-485b-4eb1-8077-c8f83b13bb1d'),
 ('134', '62', '15', '1', 'en_gb', '3', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\"],\"70\":{\"new1\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial Assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"new2\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"new3\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec.\",\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-12-02 11:51:02', '2015-12-02 11:51:02', '18e1d46a-5ce3-49be-a020-9c5fa5f8310f'),
 ('135', '63', '16', '1', 'en_gb', '6', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-02 11:52:38', '2015-12-02 11:52:38', 'dc05da36-a81f-4f65-8786-1fe77f33b8c9'),
 ('136', '61', '14', '1', 'en_gb', '7', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"127\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"128\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"77\"]}}', '2015-12-02 11:52:54', '2015-12-02 11:52:54', 'fe7a008a-7708-42fd-b365-ea27eee53af9'),
 ('137', '62', '15', '1', 'en_gb', '4', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec.\",\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-12-02 11:54:02', '2015-12-02 11:54:02', '54c96e00-c9b1-412b-869d-59b2fa66f4ab'),
 ('138', '37', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Mild Continence Issues\",\"slug\":\"mild-continence-issues\",\"postDate\":1447415900,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Bladder or bowel continence issues can be embarrassing, but when it is only a mild issue much can be done with pelvic floor exercises and fluid intake management. We can happily treat mild continence issues e.g. post pregnancy, or stress incontinence related to respiratory problems. If we feel your continence issues need further input, then we will refer you on to the appropriate practitioner.\",\"21\":\"Mild Continence Issues\"}}', '2015-12-02 23:41:18', '2015-12-02 23:41:18', '3c3f653f-17cb-41d0-8ca2-cbe97d6f6ee2'),
 ('139', '36', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Post Cancer Rehabilitation\",\"slug\":\"post-cancer-rehabilitation\",\"postDate\":1447415883,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for one hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Most people are so relieved to have stopped the active stage of their treatment, be it radiotherapy or chemotherapy, that they are happy to live with compromises in function for a time. However, it is common to become frustrated with these compromises once your energy returns. We passionately  believe that you should not be defined by your diagnosis, and will work hard with you to facilitate and maximise your return to function; be it to improve your shoulder range of movement post breast surgery so that you can reach the top cupboards, or return to tennis and swimming again.\",\"21\":\"Post Cancer Rehabilitation\"}}', '2015-12-02 23:41:37', '2015-12-02 23:41:37', 'c024fc49-52d6-47a9-b17c-ec08d76b797a'),
 ('140', '35', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Osteoporosis\",\"slug\":\"osteoporosis\",\"postDate\":1447415870,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for one hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Having been the principle investigator for Exeter on the PROVE trial (2014-16) looking into rehabilitation of patients with osteoporosis who have vertebral fractures, I am well qualified to help you manage your condition, and to keep you as fit and active as possible.\",\"21\":\"Osteoporosis\"}}', '2015-12-02 23:42:05', '2015-12-02 23:42:05', 'bfd47280-acd6-431f-b377-619cc770cdce');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('141', '35', '11', '124', 'en_gb', '3', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Osteoporosis\",\"slug\":\"osteoporosis\",\"postDate\":1447415870,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for one hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Having been the principle investigator for Exeter on the PROVE trial (2014-16) looking into rehabilitation of patients with osteoporosis who have vertebral fractures, I am well qualified to help you manage your condition, and to keep you as fit and active as possible.\",\"21\":\"Osteoporosis\"}}', '2015-12-02 23:42:06', '2015-12-02 23:42:06', 'c65565b9-2ee2-435e-af0a-76834ba55ff4'),
 ('142', '35', '11', '124', 'en_gb', '4', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Osteoporosis\",\"slug\":\"osteoporosis\",\"postDate\":1447415870,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for one hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Having been the principle investigator for Exeter on the PROVE trial (2014-16) looking into rehabilitation of patients with osteoporosis who have vertebral fractures, I am well qualified to help you manage your condition, and to keep you as fit and active as possible.\",\"21\":\"Osteoporosis\"}}', '2015-12-02 23:42:19', '2015-12-02 23:42:19', 'ea269eda-e0f8-43bd-af73-af7841a8c32c'),
 ('143', '36', '11', '124', 'en_gb', '3', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Post Cancer Rehabilitation\",\"slug\":\"post-cancer-rehabilitation\",\"postDate\":1447415883,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for one hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Most people are so relieved to have stopped the active stage of their treatment, be it radiotherapy or chemotherapy, that they are happy to live with compromises in function for a time. However, it is common to become frustrated with these compromises once your energy returns. We passionately  believe that you should not be defined by your diagnosis, and will work hard with you to facilitate and maximise your return to function; be it to improve your shoulder range of movement post breast surgery so that you can reach the top cupboards, or return to tennis and swimming again.\",\"21\":\"Post Cancer Rehabilitation\"}}', '2015-12-02 23:42:25', '2015-12-02 23:42:25', 'd784ce67-92f0-48ab-afde-45a143ba7679'),
 ('144', '34', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Joint Replacements\",\"slug\":\"joint-replacements\",\"postDate\":1447415859,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Following total or partial knee replacement, hip replacement or shoulder replacement, good quality regular physiotherapy is important to decrease swelling and pain and increase range of movement, muscle power and function. We are a lower ground premises, therefore you need to be able to complete one flight of stairs, however if access is an issue, contact us and we will discuss the possibility of a domiciliary visit.\",\"21\":\"Joint Replacements\"}}', '2015-12-02 23:42:46', '2015-12-02 23:42:46', 'cfa00982-960b-4f62-9412-54e7413613c6'),
 ('145', '33', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Osteoarthritis\",\"slug\":\"osteoarthritis\",\"postDate\":1447415848,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for one hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Osteoarthritis is a common type of arthritis, a painful condition which can affect the joints especially the hips, knees, neck, lower back, hand or feet. Although it can occur at any age, it is more likely to appear between the ages of 45-75 years, and often in women more than men. There is much evidence showing that a combination of non steroidal anti-inflammatories and exercise or physiotherapy will help to reduce the symptoms of pain and stiffness, allowing you not to be restricted by your symptoms.\",\"21\":\"Osteoarthritis\"}}', '2015-12-02 23:43:03', '2015-12-02 23:43:03', '5bb9d955-6698-4cf8-bb2d-2da8ab600bdd'),
 ('146', '32', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Rheumatological conditions\",\"slug\":\"rheumatological-conditions\",\"postDate\":1447415831,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Although consisting of a variety of diagnosis, for instance Rheumatoid Arthritis, Ankylosing Spondylitis, Psoriatic Arthritis etc, many of these diseases follow a period of flare and recovery. At Cathedral Physiotherapy we can help you not to be defined by your diagnosis, assist you through your flares, and maximise your return to function so that you continue to lead and full and fruitful life.\",\"21\":\"Rheumatological conditions\"}}', '2015-12-02 23:43:18', '2015-12-02 23:43:18', '87cf77b7-6116-466a-bb0c-5a3bf56b3428'),
 ('147', '31', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Management of long term conditions\",\"slug\":\"management-of-long-term-conditions\",\"postDate\":1447415815,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Some people are diagnosed with long term conditions, be it persistent pain generated by the nervous system, or on-going musculoskeletal problems following a car crash. At Cathedral Physiotherapy we believe in working with you to assist you to maximise your physical potential. \",\"21\":\"Management of long term conditions\"}}', '2015-12-02 23:43:36', '2015-12-02 23:43:36', 'd175a1a5-6e18-4a62-ae6e-80c89c52139b'),
 ('148', '63', '16', '124', 'en_gb', '7', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. Click on the conditions below for examples of what we can offer.\",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-02 23:44:47', '2015-12-02 23:44:47', '3f52ebce-f89f-4b03-a6d2-151974a20f12'),
 ('149', '99', '2', '124', 'en_gb', '8', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-02 23:45:28', '2015-12-02 23:45:28', 'e99b7934-4ba1-49db-919e-a5b486e6c794'),
 ('150', '99', '2', '124', 'en_gb', '9', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-02 23:45:29', '2015-12-02 23:45:29', '9c931481-0623-49b1-9f55-067a34688cef'),
 ('151', '99', '2', '124', 'en_gb', '10', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-02 23:45:31', '2015-12-02 23:45:31', '5ad615cd-4295-4533-9638-7da327779f4e'),
 ('152', '99', '2', '124', 'en_gb', '11', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-02 23:45:54', '2015-12-02 23:45:54', '7956716c-ed30-4551-8625-9c4893a7233a'),
 ('153', '19', '11', '124', 'en_gb', '4', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Work-related pain\",\"slug\":\"work-related-pain\",\"postDate\":1447415580,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health, 2008).\",\"21\":\"Work-related pain\"}}', '2015-12-02 23:59:44', '2015-12-02 23:59:44', 'd2497547-acfd-4e76-8b82-04a439494457'),
 ('154', '21', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Back Pain\",\"slug\":\"back-pain\",\"postDate\":1447415628,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Low back pain is reported by 80% of people at sometime in their life. A large percentage of this will improve with basic advice and exercises, but some people need more specific treatment (work-related advice, functional exercises, manual therapy, or acupuncture). Come and be assessed today so that we can help you on your road to recovery, and to help prevent recurrence.\",\"21\":\"Back Pain\"}}', '2015-12-03 00:00:00', '2015-12-03 00:00:00', '088da6d0-5254-403a-b551-e487c828c139'),
 ('155', '22', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Neck Pain\",\"slug\":\"neck-pain\",\"postDate\":1447415641,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Neck pain is common but most cases aren\\u2019t caused by a serious problem. Some people get it after an accident or injury, whilst others find it appears if they are stressed, or inactive, or it can be related to age-related changes in the structures of the neck. Commonly felt locally in the neck, it can also refer to the shoulder \\/ arm, and sometimes may cause pins and needles \\/ numbness. With good advice, reassurance, specific exercises and sometimes manual therapy, the majority of neck pain improved within about six weeks.\",\"21\":\"Neck Pain\"}}', '2015-12-03 00:00:18', '2015-12-03 00:00:18', '5d003671-6bb7-4089-ac8b-8ce4e34c0c5d'),
 ('156', '23', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Shoulder \\/ Elbow \\/ Wrist pain\",\"slug\":\"shoulder-elbow-wrist-pain\",\"postDate\":1447415655,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether your pain is work or hobby related it is important to get the correct advice early to prevent chronicity. \\r\\n\\r\\nArm pain can be referred from the neck, but is more commonly related to impingement of the tendons, or tears of the muscle, but can also be due to \\u2018frozen shoulder\\u2019. \\r\\n\\r\\nElbow complaints include tennis elbow, golfers elbow, or nerve irritation. \\r\\n\\r\\nWrist pain is commonly related to the position of the wrist at work or during hobbies, but can be due to stiffness post fracture, or carpal tunnel syndrome. \\r\\n\\r\\nAn excellent assessment will differentiate the problem and help you to manage and improve your symptoms.\",\"21\":\"Shoulder \\/ Elbow \\/ Wrist pain\"}}', '2015-12-03 00:01:04', '2015-12-03 00:01:04', 'f13bf4a7-70ac-43e1-8d87-4470c1585913'),
 ('157', '24', '11', '124', 'en_gb', '3', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Hip \\/ Knee \\/ Ankle pain\",\"slug\":\"hip-knee-ankle-pain\",\"postDate\":1447415640,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 fo 1\\/2 hour\",\"22\":\"Hip pain - Problems with cartilage, early osteoarthritis, tendonopathy, sprains and muscle imbalances can all cause hip pain, but it can also be referred from the back. Accurate assessment is crucial to ensure you have the right treatment to improve your problem.\\r\\n\\r\\nKnee pain \\u2013 Be it local pain, swelling or stiffness secondary to an acute injury to the ligaments of the joint, more insidious in nature, or referred pain, once diagnosed, the majority of problems will significantly improve with a specific functional exercise program, but if necessary it can also be treated with manual therapy, ultrasound, taping or acupuncture too.\\r\\n\\r\\nAnkle pain \\u2013 The majority of people have sustained a sprained ankle at some point, and we can offer acute treatment for this with ultrasound, soft tissie therapy, taping and exercises. However, we rely on our legs heavily, and the key is to prevent it recurring again through specific rehabilitation, so that you can stay as fit and active as you wish.\",\"21\":\"Hip \\/ Knee \\/ Ankle pain\"}}', '2015-12-03 00:01:26', '2015-12-03 00:01:26', 'ff73cfd4-6ed9-49e9-a823-b7b48c33a3a4'),
 ('158', '26', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Post fracture rehabilitation\",\"slug\":\"post-fracture-rehabilitation\",\"postDate\":1447415743,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"It is quite common to have on-going problems with pain, swelling and stiffness in the joints surrounding the area where you have fractured. However the real issue, is that people often lose their confidence too. Let us rehabilitate you back to your previous level of function or fitness allowing you to live your life to the full.\",\"21\":\"Post fracture rehabilitation\"}}', '2015-12-03 00:02:03', '2015-12-03 00:02:03', '6a0477a6-843d-4a26-8944-8ac63d80aab3'),
 ('159', '27', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Non specific arm pain\",\"slug\":\"non-specific-arm-pain\",\"postDate\":1447415755,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 fo 1\\/2 hour\",\"22\":\"Characterised by ongoing pain, altered sensations in the hand \\/ arm and sometime feelings of weakness, this can be a frustrating condition to have, particularly as commonly many objective medical test are negative. Often, modifications to posture, work stations, gaining an understanding of pain mechanisms, and local tissues techniques can improve symptoms and function.\",\"21\":\"Non specific arm pain\"}}', '2015-12-03 00:02:17', '2015-12-03 00:02:17', 'c0661975-ef6f-4d4d-a4f6-5b5c6e5d2f11'),
 ('160', '28', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Thoracic Outlet Syndrome\",\"slug\":\"thoracic-outlet-syndrome\",\"postDate\":1447415768,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Characterised by neck \\/ shoulder \\/ arm pain, feelings of weakness in the arm (particularly with overhead activities), and possible discolouration of the hand, this condition can be debilitating. With good quality conservative physiotherapy, symptoms and function can be significantly improved, thereby improving your quality of life.\",\"21\":\"Thoracic Outlet Syndrome\"}}', '2015-12-03 00:02:34', '2015-12-03 00:02:34', '2a4f307c-d6ad-4ed5-971d-0509fbe86c06'),
 ('161', '29', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Headaches and Dizziness\",\"slug\":\"headaches-and-dizziness\",\"postDate\":1447415786,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Benign headaches can be caused by tension in the muscles, stiffness in the neck or muscle imbalance. Often characterised by being one-sided, or in a band around the head, and associated with neck pain, or certain movements, symptoms can be improved significantly with a combination of exercise, manual therapy, acupuncture and an understanding of pain pathways.\\r\\n\\r\\nDizziness can be generated from the neck, the inner ear or the brain, and accurate differential diagnosis is crucial for appropriate treatment.\",\"21\":\"Headaches and Dizziness\"}}', '2015-12-03 00:02:46', '2015-12-03 00:02:46', '7929342a-b592-4967-880b-6db3f7fcc140'),
 ('162', '30', '11', '124', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Pregnancy related pain\",\"slug\":\"pregnancy-related-pain\",\"postDate\":1447415802,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Pregnancy related pelvic girdle pain is common and affects 1 in 5 women during their pregnancy. There are a wide range of symptoms, some of which improve naturally during the course of the pregnancy as your body adapts, some which need advice and \\/or treatment early on to keep you as active as possible. Don\\u2019t suffer in silence, get help early.\",\"21\":\"Pregnancy related pain\"}}', '2015-12-03 00:03:03', '2015-12-03 00:03:03', 'c66f0000-4d4a-4774-8604-cf1bf54dd738'),
 ('163', '61', '14', '124', 'en_gb', '8', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"127\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"128\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Balancing busy jobs and a home life is difficult enough, let alone trying to keep fit and healthy, so it doesn\'t take much to upset the equilibrium. However getting pain associated with your job, or preventing you from exercising easily can disrupt those scales making it harder to achieve everything you need to do. At Cathedral Physiotherapy we are here to help you improve any symptoms you may have so that you can get back to being superhuman! Click on the links below for examples of what we can help you with.\",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"77\"]}}', '2015-12-03 00:03:38', '2015-12-03 00:03:38', 'a0689044-707b-49a6-bea3-2842328fe0b1'),
 ('164', '19', '11', '124', 'en_gb', '5', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Work-related pain\",\"slug\":\"work-related-pain\",\"postDate\":1447415580,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health, 2008).\",\"21\":\"Work-related pain\"}}', '2015-12-03 00:04:29', '2015-12-03 00:04:29', '1fa08036-a6e8-475b-a43b-9a84d8e689ac'),
 ('165', '21', '11', '124', 'en_gb', '3', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Back Pain\",\"slug\":\"back-pain\",\"postDate\":1447415628,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Low back pain is reported by 80% of people at sometime in their life. A large percentage of this will improve with basic advice and exercises, but some people need more specific treatment (work-related advice, functional exercises, manual therapy, or acupuncture). Come and be assessed today so that we can help you on your road to recovery, and to help prevent recurrence.\",\"21\":\"Back Pain\"}}', '2015-12-03 00:04:33', '2015-12-03 00:04:33', '7b69e8b9-3242-41fa-bedf-34ea2ac03e74'),
 ('166', '22', '11', '124', 'en_gb', '3', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Neck Pain\",\"slug\":\"neck-pain\",\"postDate\":1447415641,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Neck pain is common but most cases aren\\u2019t caused by a serious problem. Some people get it after an accident or injury, whilst others find it appears if they are stressed, or inactive, or it can be related to age-related changes in the structures of the neck. Commonly felt locally in the neck, it can also refer to the shoulder \\/ arm, and sometimes may cause pins and needles \\/ numbness. With good advice, reassurance, specific exercises and sometimes manual therapy, the majority of neck pain improved within about six weeks.\",\"21\":\"Neck Pain\"}}', '2015-12-03 00:04:37', '2015-12-03 00:04:37', '02911928-e8f0-4dcc-a3f1-9f7050e2c19b'),
 ('167', '23', '11', '124', 'en_gb', '3', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Shoulder \\/ Elbow \\/ Wrist pain\",\"slug\":\"shoulder-elbow-wrist-pain\",\"postDate\":1447415655,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether your pain is work or hobby related it is important to get the correct advice early to prevent chronicity. \\r\\n\\r\\nArm pain can be referred from the neck, but is more commonly related to impingement of the tendons, or tears of the muscle, but can also be due to \\u2018frozen shoulder\\u2019. \\r\\n\\r\\nElbow complaints include tennis elbow, golfers elbow, or nerve irritation. \\r\\n\\r\\nWrist pain is commonly related to the position of the wrist at work or during hobbies, but can be due to stiffness post fracture, or carpal tunnel syndrome. \\r\\n\\r\\nAn excellent assessment will differentiate the problem and help you to manage and improve your symptoms.\",\"21\":\"Shoulder \\/ Elbow \\/ Wrist pain\"}}', '2015-12-03 00:04:43', '2015-12-03 00:04:43', 'b9d25e6b-b6c4-4583-a8d0-3a372302f899'),
 ('168', '24', '11', '124', 'en_gb', '4', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Hip \\/ Knee \\/ Ankle pain\",\"slug\":\"hip-knee-ankle-pain\",\"postDate\":1447415640,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 fo 1\\/2 hour\",\"22\":\"Hip pain - Problems with cartilage, early osteoarthritis, tendonopathy, sprains and muscle imbalances can all cause hip pain, but it can also be referred from the back. Accurate assessment is crucial to ensure you have the right treatment to improve your problem.\\r\\n\\r\\nKnee pain \\u2013 Be it local pain, swelling or stiffness secondary to an acute injury to the ligaments of the joint, more insidious in nature, or referred pain, once diagnosed, the majority of problems will significantly improve with a specific functional exercise program, but if necessary it can also be treated with manual therapy, ultrasound, taping or acupuncture too.\\r\\n\\r\\nAnkle pain \\u2013 The majority of people have sustained a sprained ankle at some point, and we can offer acute treatment for this with ultrasound, soft tissie therapy, taping and exercises. However, we rely on our legs heavily, and the key is to prevent it recurring again through specific rehabilitation, so that you can stay as fit and active as you wish.\",\"21\":\"Hip \\/ Knee \\/ Ankle pain\"}}', '2015-12-03 00:04:47', '2015-12-03 00:04:47', '9048bb8d-c899-4283-b00e-83df75a21a78'),
 ('169', '26', '11', '124', 'en_gb', '3', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Post fracture rehabilitation\",\"slug\":\"post-fracture-rehabilitation\",\"postDate\":1447415743,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"It is quite common to have on-going problems with pain, swelling and stiffness in the joints surrounding the area where you have fractured. However the real issue, is that people often lose their confidence too. Let us rehabilitate you back to your previous level of function or fitness allowing you to live your life to the full.\",\"21\":\"Post fracture rehabilitation\"}}', '2015-12-03 00:04:51', '2015-12-03 00:04:51', 'fc0474ac-2148-491a-a155-f62913783172'),
 ('170', '27', '11', '124', 'en_gb', '3', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Non specific arm pain\",\"slug\":\"non-specific-arm-pain\",\"postDate\":1447415755,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 fo 1\\/2 hour\",\"22\":\"Characterised by ongoing pain, altered sensations in the hand \\/ arm and sometime feelings of weakness, this can be a frustrating condition to have, particularly as commonly many objective medical test are negative. Often, modifications to posture, work stations, gaining an understanding of pain mechanisms, and local tissues techniques can improve symptoms and function.\",\"21\":\"Non specific arm pain\"}}', '2015-12-03 00:04:55', '2015-12-03 00:04:55', '0e23fa22-4da8-457f-8d3b-4701cbfd882a'),
 ('171', '28', '11', '124', 'en_gb', '3', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Thoracic Outlet Syndrome\",\"slug\":\"thoracic-outlet-syndrome\",\"postDate\":1447415768,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Characterised by neck \\/ shoulder \\/ arm pain, feelings of weakness in the arm (particularly with overhead activities), and possible discolouration of the hand, this condition can be debilitating. With good quality conservative physiotherapy, symptoms and function can be significantly improved, thereby improving your quality of life.\",\"21\":\"Thoracic Outlet Syndrome\"}}', '2015-12-03 00:04:59', '2015-12-03 00:04:59', '996c7267-c9d8-43bc-bb15-811531838b86'),
 ('172', '29', '11', '124', 'en_gb', '3', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Headaches and Dizziness\",\"slug\":\"headaches-and-dizziness\",\"postDate\":1447415786,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Benign headaches can be caused by tension in the muscles, stiffness in the neck or muscle imbalance. Often characterised by being one-sided, or in a band around the head, and associated with neck pain, or certain movements, symptoms can be improved significantly with a combination of exercise, manual therapy, acupuncture and an understanding of pain pathways.\\r\\n\\r\\nDizziness can be generated from the neck, the inner ear or the brain, and accurate differential diagnosis is crucial for appropriate treatment.\",\"21\":\"Headaches and Dizziness\"}}', '2015-12-03 00:05:02', '2015-12-03 00:05:02', '13c9f6a4-0484-4179-9bc2-5e7909175c25'),
 ('173', '30', '11', '124', 'en_gb', '3', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Pregnancy related pain\",\"slug\":\"pregnancy-related-pain\",\"postDate\":1447415802,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Pregnancy related pelvic girdle pain is common and affects 1 in 5 women during their pregnancy. There are a wide range of symptoms, some of which improve naturally during the course of the pregnancy as your body adapts, some which need advice and \\/or treatment early on to keep you as active as possible. Don\\u2019t suffer in silence, get help early.\",\"21\":\"Pregnancy related pain\"}}', '2015-12-03 00:05:06', '2015-12-03 00:05:06', '595f1419-6d13-48f6-8c5a-b446c8873c8a'),
 ('174', '61', '14', '124', 'en_gb', '9', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"127\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"128\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Balancing busy jobs and a home life is difficult enough, let alone trying to keep fit and healthy, so it doesn\'t take much to upset the equilibrium. However getting pain associated with your job, or preventing you from exercising easily can disrupt those scales making it harder to achieve everything you need to do. At Cathedral Physiotherapy we are here to help you improve any symptoms you may have so that you can get back to being superhuman! Click on the links below for examples of what we can help you with.\",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"77\"]}}', '2015-12-03 00:05:09', '2015-12-03 00:05:09', '6745ef1a-04c8-4006-86da-f9a2ce5b0e25'),
 ('175', '19', '11', '124', 'en_gb', '6', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Work-related pain\",\"slug\":\"work-related-pain\",\"postDate\":1447415580,\"expiryDate\":null,\"enabled\":\"1\",\"parentId\":null,\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health, 2008).\",\"21\":\"Work-related pain\"}}', '2015-12-03 00:05:55', '2015-12-03 00:05:55', '00caf04c-0422-4b7e-9796-9a0305d7ddd6'),
 ('176', '61', '14', '124', 'en_gb', '10', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"127\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"128\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Balancing busy jobs and a home life is difficult enough, let alone trying to keep fit and healthy, so it doesn\'t take much to upset the equilibrium. However getting pain associated with your job, or preventing you from exercising easily can disrupt those scales making it harder to achieve everything you need to do. At Cathedral Physiotherapy we are here to help you improve any symptoms you may have so that you can get back to being superhuman! Click on the links below for examples of what we can help you with.\",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"77\"]}}', '2015-12-03 00:06:19', '2015-12-03 00:06:19', 'b151b802-fdfb-4d08-a60a-1d0574eddd79'),
 ('177', '18', '11', '124', 'en_gb', '2', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Haemophilia\",\"slug\":\"haemophilia\",\"postDate\":1447415460,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"17\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"For those individuals diagnosed with haemophilia, early access to physiotherapy is crucial following a bleed. This is a niche area that Sarah has worked in as the designated haemophilia physiotherapy specialist at the Royal Devon and Exeter hospital over the last few years, so you can be assured that you are in safe hands\",\"21\":\"Haemophilia\"}}', '2015-12-03 00:07:28', '2015-12-03 00:07:28', '2429bd12-6369-4ce5-9f17-b07728faf30b'),
 ('178', '18', '11', '124', 'en_gb', '3', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Haemophilia\",\"slug\":\"haemophilia\",\"postDate\":1447415460,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"For those individuals diagnosed with haemophilia, early access to physiotherapy is crucial following a bleed. This is a niche area that Sarah has worked in as the designated haemophilia physiotherapy specialist at the Royal Devon and Exeter hospital over the last few years, so you can be assured that you are in safe hands\",\"21\":\"Haemophilia\"}}', '2015-12-03 00:09:39', '2015-12-03 00:09:39', 'c2930b7b-a503-44a2-931e-ceb7aafb7123'),
 ('179', '17', '11', '124', 'en_gb', '2', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Sports Injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447415460,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether you are after prevention or cure, Cathedral Physiotherapy can help you. Excellent assessment will ensure that you receive the treatment you require, be it a combination of functional exercise, manual therapy, ultrasound, taping or acupuncture. We have a small exercise area in the clinic, but can also adapt your training program for your to rehabilitate at your own gym \\/ pool.\",\"21\":\"Sports Injuries\"}}', '2015-12-03 00:10:09', '2015-12-03 00:10:09', '2c0500ca-40d2-488e-9281-1ca4a2589f23'),
 ('180', '17', '11', '124', 'en_gb', '3', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Sports Injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447415460,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether you are after prevention or cure, Cathedral Physiotherapy can help you. Excellent assessment will ensure that you receive the treatment you require, be it a combination of functional exercise, manual therapy, ultrasound, taping or acupuncture. We have a small exercise area in the clinic, but can also adapt your training program for your to rehabilitate at your own gym \\/ pool.\",\"21\":\"Sports Injuries\"}}', '2015-12-03 00:10:43', '2015-12-03 00:10:43', 'e62c7236-2761-47f1-9c7e-c7ad931a3125'),
 ('181', '16', '11', '124', 'en_gb', '2', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Young adult hip pain\",\"slug\":\"young-adult-hip-pain\",\"postDate\":1447415460,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Hip pain in young adults can be caused by a number of issues from muscle imbalance around the hip, cartilage problems within the joint, bony anatomical issues or referred pain from the back or pelvis. The excellent clinical reasoning found at Cathedral Physiotherapy will help to differentiate the causes and formulate a treatment plan or onward referral as required. I have worked closely with the Royal Devon and Exeter NHS Hospital hip consultants with patients with femoral acetabular impingement in particular, including being involved in research, and so am at the cutting edge of treating this group of patients.\",\"21\":\"Young adult hip pain\"}}', '2015-12-03 00:11:05', '2015-12-03 00:11:05', 'd338f4db-ce0b-469b-8c63-f6e7f01bb714'),
 ('182', '15', '11', '124', 'en_gb', '5', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Children\\u2019s Injuries\",\"slug\":\"childrens-injuries\",\"postDate\":1447415400,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Although many children bounce back quickly after injury, if they are particularly sporty, or have lost their confidence after a sprain, strain or fracture they may need some reassurance and treatment \\/ exercises to return to their previous level of care-free fitness.\",\"21\":\"Children\\u2019s Injuries\"}}', '2015-12-03 00:11:34', '2015-12-03 00:11:34', '553cb52e-79e4-40f9-9339-47fb2aa3a089'),
 ('183', '14', '11', '124', 'en_gb', '3', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Fractures\",\"slug\":\"fractures\",\"postDate\":1447415340,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Following a broken bone, the joints around the area will often become stiff and painful, the muscles weak and balance poor. This is easily improved with the advice, manual therapy and exercises provided by Cathedral Physiotherapy.\",\"21\":\"Fractures\"}}', '2015-12-03 00:12:04', '2015-12-03 00:12:04', '1a3f7a74-3178-4ddb-b2f9-e9e7f575ac58'),
 ('184', '19', '11', '124', 'en_gb', '7', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Work-related pain\",\"slug\":\"work-related-pain\",\"postDate\":1447415580,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health, 2008).\",\"21\":\"Work-related pain\"}}', '2015-12-03 00:12:12', '2015-12-03 00:12:12', '943895b0-580d-46dc-b591-ce354bd44e9e'),
 ('185', '20', '11', '124', 'en_gb', '2', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1447415580,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Minor sprains and strains can be managed with PRICE therapy:\\r\\nProtect the area using a support temporarily, Rest the are for the first 48-72 hrs, apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin), Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow and remove the bandage before sleep, Elevate the injured area, supported on a pillow, to reduce the swelling. Ultrasound and taping can also promote healing. Following this we will help rehabilitate you range of movement, strength and balance so that you return to your full function.\",\"21\":\"Sprains and Strains\"}}', '2015-12-03 00:12:37', '2015-12-03 00:12:37', '9a68f1e5-0de4-4541-92c2-f31ce099ac32'),
 ('186', '21', '11', '124', 'en_gb', '4', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Back Pain\",\"slug\":\"back-pain\",\"postDate\":1447415580,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Low back pain is reported by 80% of people at sometime in their life. A large percentage of this will improve with basic advice and exercises, but some people need more specific treatment (work-related advice, functional exercises, manual therapy, or acupuncture). Come and be assessed today so that we can help you on your road to recovery, and to help prevent recurrence.\",\"21\":\"Back Pain\"}}', '2015-12-03 00:12:47', '2015-12-03 00:12:47', '4818dfdd-c66d-46cb-bc89-c9d6250ad091'),
 ('187', '22', '11', '124', 'en_gb', '4', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Neck Pain\",\"slug\":\"neck-pain\",\"postDate\":1447415640,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Neck pain is common but most cases aren\\u2019t caused by a serious problem. Some people get it after an accident or injury, whilst others find it appears if they are stressed, or inactive, or it can be related to age-related changes in the structures of the neck. Commonly felt locally in the neck, it can also refer to the shoulder \\/ arm, and sometimes may cause pins and needles \\/ numbness. With good advice, reassurance, specific exercises and sometimes manual therapy, the majority of neck pain improved within about six weeks.\",\"21\":\"Neck Pain\"}}', '2015-12-03 00:12:55', '2015-12-03 00:12:55', 'caf2ad83-46f9-42fa-9023-f958c12c0002'),
 ('188', '25', '11', '124', 'en_gb', '2', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Orthopaedic post operative care\",\"slug\":\"orthopaedic-post-operative-care\",\"postDate\":1447415700,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Come to Cathedral Physiotherapy for your post operative care. Be it following a fracture, ligament reconstruction, hip arthroscopy, or joint replacement we can help you regain your independence. Having worked at the Royal Devon and Exeter hospital for the last 11 years I have strong links with the orthopaedic teams there.\",\"21\":\"Orthopaedic post operative care\"}}', '2015-12-03 00:13:17', '2015-12-03 00:13:17', 'e59f7e2d-a2bb-48a7-9f36-e7cfa92befb5'),
 ('189', '25', '11', '124', 'en_gb', '3', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Orthopaedic post operative care\",\"slug\":\"orthopaedic-post-operative-care\",\"postDate\":1447415700,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Come to Cathedral Physiotherapy for your post operative care. Be it following a fracture, ligament reconstruction, hip arthroscopy, or joint replacement we can help you regain your independence. Having worked at the Royal Devon and Exeter hospital for the last 11 years I have strong links with the orthopaedic teams there.\",\"21\":\"Orthopaedic post operative care\"}}', '2015-12-03 00:13:52', '2015-12-03 00:13:52', '997ed2a3-93e6-45cd-885a-2c4494811839'),
 ('190', '62', '15', '124', 'en_gb', '5', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it...Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. Click on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-12-03 00:24:08', '2015-12-03 00:24:08', '79bd49f9-760c-4c80-b726-15b94ef4d30d'),
 ('191', '62', '15', '124', 'en_gb', '6', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it.......Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. Click on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-12-03 00:24:46', '2015-12-03 00:24:46', '6ef9c234-15e6-40a0-8e94-30879578abc4'),
 ('192', '8', '9', '124', 'en_gb', '3', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\nDirections:\\r\\nFrom Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\nParking:\\r\\nThere is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\nBuses:\\r\\nWe are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-03 00:34:08', '2015-12-03 00:34:08', '44709fa5-03e3-4db9-b30c-f54dd4ee2d66'),
 ('193', '8', '9', '124', 'en_gb', '4', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\n\\r\\nDirections:\\r\\nFrom Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\n\\r\\nParking:\\r\\nThere is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\n\\r\\nBuses:\\r\\nWe are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-03 00:37:19', '2015-12-03 00:37:19', '5dbb2edd-43e0-4a91-92b2-fb152f04f62f'),
 ('194', '17', '11', '125', 'en_gb', '4', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Sports Injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447415460,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"45\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether you are after prevention or cure, Cathedral Physiotherapy can help you. Excellent assessment will ensure that you receive the treatment you require, be it a combination of functional exercise, manual therapy, ultrasound, taping or acupuncture. We have a small exercise area in the clinic, but can also adapt your training program for your to rehabilitate at your own gym \\/ pool.\",\"21\":\"Sports Injuries\"}}', '2015-12-03 09:38:54', '2015-12-03 09:38:54', 'c606917b-a300-406b-a6f4-340d12f2f746'),
 ('195', '58', '13', '125', 'en_gb', '10', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Great Team of staff with excellent knowledge, care and professionalism\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"After seven years of suffering with arm pain, I went to Sarah to see if there was anything she could do to relieve it. Now three months on, all I can say is a HUGE Thank You, as I am completely clear of all arm and neck pain. For the first time in years I can do \\u2018normal\\u2019 things\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Quickly diagnosed the problem, clearly explained the body\'s reaction and devised an effective remedy both in session and through exercises. All in all I am delighted.\"}}}}}', '2015-12-03 10:13:18', '2015-12-03 10:13:18', 'dd729a08-f3d5-4eb7-9cbd-b0b9c71094b8'),
 ('196', '58', '13', '124', 'en_gb', '11', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffries\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"After seven years of suffering with arm pain, I went to Sarah to see if there was anything she could do to relieve it. Now three months on, all I can say is a HUGE Thank You, as I am completely clear of all arm and neck pain. For the first time in years I can do \\u2018normal\\u2019 things\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Quickly diagnosed the problem, clearly explained the body\'s reaction and devised an effective remedy both in session and through exercises. All in all I am delighted.\"}}}}}', '2015-12-03 16:49:56', '2015-12-03 16:49:56', 'e38eaa27-30cf-4242-9499-585344949314'),
 ('197', '58', '13', '124', 'en_gb', '12', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Don\'t take our word for it, hear from our clients what they think about us\",\"6\":\"Testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffrees\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"After seven years of suffering with arm pain, I went to Sarah to see if there was anything she could do to relieve it. Now three months on, all I can say is a HUGE Thank You, as I am completely clear of all arm and neck pain. For the first time in years I can do \\u2018normal\\u2019 things\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Quickly diagnosed the problem, clearly explained the body\'s reaction and devised an effective remedy both in session and through exercises. All in all I am delighted.\"}}}}}', '2015-12-03 16:57:21', '2015-12-03 16:57:21', '51775a11-c049-4959-ba1b-cd35371d249d'),
 ('198', '58', '13', '124', 'en_gb', '13', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Don\'t take our word for it, hear from our clients what they think about us.........\",\"6\":\"Testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffrees\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"After seven years of suffering with arm pain, I went to Sarah to see if there was anything she could do to relieve it. Now three months on, all I can say is a HUGE Thank You, as I am completely clear of all arm and neck pain. For the first time in years I can do \\u2018normal\\u2019 things\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Quickly diagnosed the problem, clearly explained the body\'s reaction and devised an effective remedy both in session and through exercises. All in all I am delighted.\"}}}}}', '2015-12-03 16:59:34', '2015-12-03 16:59:34', 'ba96ca30-4b8d-49c5-ab19-8d29a5b27e3d'),
 ('199', '58', '13', '124', 'en_gb', '14', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Don\'t take our word for it, hear from our clients what they think about us.........\",\"6\":\"Testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffrees\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"James Pike\",\"location\":\"Exeter\",\"quote\":\"I had a couple of back problems a couple of months ago due to a cycling accident and went to Sarah for some help, she did a great job and wasn\'t bothered about working on me a few times in the week which was great. After a couple of visits it was all fixed and she gave me stretches to do for a month so the pain doesn\'t return. Sarah\'s great and well recommended! Thanks Sarah!\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Jenny Pestridge\",\"location\":\"Devon\",\"quote\":\"I recently visited Cathedral Physiotherapy, which is situated in a convenient city-centre location. I was treated by Sarah Moore. A high standard of care and treatment has resulted in an immediate improvement. I felt confident and reassured by Sarah\'s expertise, because of her thorough explanation of my condition, and appropriate treatment. I would rate my experience of Cathedral Physiotherapy as outstanding.\"}}}}}', '2015-12-03 21:23:01', '2015-12-03 21:23:01', '818425d9-938b-42c5-81bf-90005a7dfc66'),
 ('200', '58', '13', '124', 'en_gb', '15', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Don\'t take our word for it, hear from our clients what they think about us.........\",\"6\":\"Testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffrees\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"James Pike\",\"location\":\"Exeter\",\"quote\":\"I had a couple of back problems a couple of months ago due to a cycling accident and went to Sarah for some help, she did a great job and wasn\'t bothered about working on me a few times in the week which was great. After a couple of visits it was all fixed and she gave me stretches to do for a month so the pain doesn\'t return. Sarah\'s great and well recommended! Thanks Sarah!\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Jenny Pestridge\",\"location\":\"Devon\",\"quote\":\"I recently visited Cathedral Physiotherapy, which is situated in a convenient city-centre location. I was treated by Sarah Moore. A high standard of care and treatment has resulted in an immediate improvement. I felt confident and reassured by Sarah\'s expertise, because of her thorough explanation of my condition, and appropriate treatment. I would rate my experience of Cathedral Physiotherapy as outstanding.\"}}}}}', '2015-12-03 21:23:25', '2015-12-03 21:23:25', '7c82a0e3-16b6-4d87-a4b5-d13db23403f9'),
 ('201', '57', '8', '1', 'en_gb', '7', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: New appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"134\"]}}', '2015-12-04 16:10:44', '2015-12-04 16:10:44', 'ab5fdec6-59d3-49ec-a516-0418ecb59efa'),
 ('202', '57', '8', '1', 'en_gb', '8', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: New appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"134\",\"133\"]}}', '2015-12-04 16:11:11', '2015-12-04 16:11:11', 'e03e2c4c-e48a-40ae-b3f6-94727e5bf7f9'),
 ('203', '4', '3', '1', 'en_gb', '6', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":[\"134\"],\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities which represents cathedral physiotherapy.\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy, who is passionate about providing the best possible care. \",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. Currently her time is split between working as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, where she has been working for the last 12 years, and running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. Sarah is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"140\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute fo rHealth Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and audit a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-04 16:38:53', '2015-12-04 16:38:53', '6bc79ff9-d256-4e0c-ba53-b509a3b318be'),
 ('204', '99', '2', '1', 'en_gb', '12', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"76\":[\"true\"],\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-04 16:40:40', '2015-12-04 16:40:40', '0b5459ea-930b-43ff-acaf-8d69cdcca388'),
 ('205', '109', '2', '1', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Media comment: November\",\"slug\":\"media-comment-november\",\"postDate\":1448875380,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded \\u2018New Year Resolutions\\u2019. Why not take a longer term approach to your health rather than the \\u2018boom and bust\\u2019 which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!\",\"63\":{\"110\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"This November an article was published in Gerontology, reported in the media, which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect \\u2013 is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \\r\\n\\r\\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways \\u2013 heart, lungs, blood pressure, mental health, bone strength\\u2026.. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point. \\r\\n\\r\\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on\\u2026.give the family an exercise make over this year\\u2026..who knows, you might be reaping the benefits on those crosswords in years to come!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"111\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Media comment: November\",\"77\":{\"1\":{\"col1\":\"Related BBC News Article\",\"col2\":\" http:\\/\\/www.bbc.co.uk\\/news\\/health-34764693\"},\"0\":{\"col1\":\"Related Daily Mail Article\",\"col2\":\"http:\\/\\/www.dailymail.co.uk\\/health\\/article-3311222\\/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html\"},\"2\":{\"col1\":\"Related Guardian Article\",\"col2\":\"http:\\/\\/www.theguardian.com\\/uk-news\\/2015\\/nov\\/09\\/strong-legs-healthier-brain-in-old-age\"},\"3\":{\"col1\":\"NHS fitness guide for adults\",\"col2\":\"http:\\/\\/www.nhs.uk\\/Livewell\\/fitness\\/Pages\\/physical-activity-guidelines-for-adults.aspx\"}},\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2015-12-04 16:43:24', '2015-12-04 16:43:24', '25f79fa2-9dd7-4420-8bb3-6b3d841a2c91'),
 ('206', '17', '11', '1', 'en_gb', '5', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Sports Injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447415460,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether you are after prevention or cure, Cathedral Physiotherapy can help you. Excellent assessment will ensure that you receive the treatment you require, be it a combination of functional exercise, manual therapy, ultrasound, taping or acupuncture. We have a small exercise area in the clinic, but can also adapt your training program for your to rehabilitate at your own gym \\/ pool.\",\"21\":\"Sports Injuries\"}}', '2015-12-04 16:46:00', '2015-12-04 16:46:00', '9a560f6e-1048-4061-923b-ed74430d7d20'),
 ('207', '17', '11', '1', 'en_gb', '6', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Sports Injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447415460,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"Test value\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether you are after prevention or cure, Cathedral Physiotherapy can help you. Excellent assessment will ensure that you receive the treatment you require, be it a combination of functional exercise, manual therapy, ultrasound, taping or acupuncture. We have a small exercise area in the clinic, but can also adapt your training program for your to rehabilitate at your own gym \\/ pool.\",\"21\":\"Sports Injuries\"}}', '2015-12-04 16:51:08', '2015-12-04 16:51:08', 'd3ffe115-abf5-4f21-b88f-c89171fb6823'),
 ('208', '17', '11', '1', 'en_gb', '7', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Sports Injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447415460,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether you are after prevention or cure, Cathedral Physiotherapy can help you. Excellent assessment will ensure that you receive the treatment you require, be it a combination of functional exercise, manual therapy, ultrasound, taping or acupuncture. We have a small exercise area in the clinic, but can also adapt your training program for your to rehabilitate at your own gym \\/ pool.\",\"21\":\"Sports Injuries\"}}', '2015-12-04 17:02:16', '2015-12-04 17:02:16', 'fa25cb7f-0679-4f28-bb7c-60559418a6c1'),
 ('209', '8', '9', '1', 'en_gb', '5', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\nDirections:\\r\\nFrom Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\nParking:\\r\\nThere is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\nBuses:\\r\\nWe are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":\"\"}}', '2015-12-04 17:20:34', '2015-12-04 17:20:34', '90bd8bf3-e6ce-41e3-842b-28c6a880d7ed'),
 ('210', '9', '10', '124', 'en_gb', '7', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy Ltd. delivering \'Excellence, Experience, Enthusiasm\' in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\\r\\n\\r\\nPhysiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment. Please look through the lists below and see how we can help you. \",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-04 20:39:41', '2015-12-04 20:39:41', '1caec581-4eaf-48b0-8a92-a19cd5e80ba9'),
 ('211', '9', '10', '124', 'en_gb', '8', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy Ltd. delivering excellence, experience, and enthusiasm\' in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. Please look through the lists below and see how we can help you. \",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-04 20:42:41', '2015-12-04 20:42:41', 'dd3746c4-1885-4929-8aa4-42197e9095d6'),
 ('212', '9', '10', '124', 'en_gb', '9', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment lists below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. Please click on the options below and see how we can help you. \",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-04 20:47:13', '2015-12-04 20:47:13', 'cd6f5910-5c91-4df6-b6ad-52140550a71f'),
 ('213', '9', '10', '124', 'en_gb', '10', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. Please click on the options below and see how we can help you. \",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-04 20:48:40', '2015-12-04 20:48:40', '66e143d4-a507-46c8-bf9a-69b06f203a14'),
 ('214', '4', '3', '124', 'en_gb', '7', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":[\"134\"],\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy, who is passionate about providing the best possible care. \",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"140\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-04 21:05:20', '2015-12-04 21:05:20', 'be63d1fa-2da7-404d-a665-51cda2afeaa4'),
 ('215', '8', '9', '124', 'en_gb', '6', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\nDirections: From Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\nParking: There is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\nBuses: We are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"133\"]}}', '2015-12-04 21:25:06', '2015-12-04 21:25:06', 'a9203b0f-1fe0-4896-b85d-9e2398d52915'),
 ('216', '8', '9', '124', 'en_gb', '7', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\nDirections: From Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\nParking: There is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\nBuses: We are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"133\"]}}', '2015-12-04 22:08:51', '2015-12-04 22:08:51', 'eb7a6d5c-2b11-41fe-a240-365c8c241e5c'),
 ('217', '141', '2', '124', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267911,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"new2\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE......\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see left hand column) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":{\"new1\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\\r\\n\"}},\"new2\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"new3\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"new4\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"new5\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-04 22:25:11', '2015-12-04 22:25:11', 'a1669c40-ef36-429c-ab10-3aec15ae3731'),
 ('218', '141', '2', '124', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE......\",\"sectionParagraph\":\"\\r\\n\\r\\nNo not linked to the cost of the injury, merely a pneumonic (see left hand column) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\\r\\n\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-04 22:26:42', '2015-12-04 22:26:42', '1991453b-aec0-44e2-a343-5788925e5138'),
 ('219', '141', '2', '124', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\\r\\n\\r\\nPRICE........\\r\\n\\r\\nNo not linked to the cost of the injury, merely a pneumonic (see left hand column) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-04 22:30:21', '2015-12-04 22:30:21', '0ace7509-db4f-4494-9c46-e4a96605f5ae'),
 ('220', '141', '2', '124', 'en_gb', '4', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\\r\\n\\r\\nPRICE........\\r\\n\\r\\nNo not linked to the cost of the injury, merely a pneumonic (see left hand column) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-04 22:40:38', '2015-12-04 22:40:38', '13452b9f-2a0a-4934-9e13-e098a2dbe4ca'),
 ('224', '2', '1', '124', 'en_gb', '4', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. Please click on the options below and see how we can help you.  \",\"6\":\"Delivering Excellence, Experience and Enthusiasm \",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-04 23:07:26', '2015-12-04 23:07:26', '232fabbb-6e16-489d-b60c-355d1dadc49d'),
 ('225', '9', '10', '124', 'en_gb', '11', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment. Click the categories below to see how we can help you.\",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-04 23:08:42', '2015-12-04 23:08:42', '130db8b0-0dcd-4b24-9118-1c075323e6e5'),
 ('231', '141', '2', '125', 'en_gb', '5', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\\r\\n\\r\\nPRICE........\\r\\n\\r\\nNo not linked to the cost of the injury, merely a pneumonic (see left hand column) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-06 21:03:33', '2015-12-06 21:03:33', 'a31dc6eb-4c69-444a-8baa-0d034229bb68'),
 ('232', '141', '2', '125', 'en_gb', '6', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\\r\\n\\r\\n\\r\\n\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see left hand column) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-06 21:04:35', '2015-12-06 21:04:35', '2b948b2b-89be-4a29-a605-746fe04e3683'),
 ('233', '141', '2', '125', 'en_gb', '7', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"151\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\\r\\n\\r\\n\\r\\n\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see left hand column) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-06 21:15:09', '2015-12-06 21:15:09', '87b3af57-2181-4bbc-9eef-08718757bdc2'),
 ('234', '141', '2', '125', 'en_gb', '8', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"64\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\\r\\n\\r\\n\\r\\n\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see left hand column) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":[\"151\"],\"photoPosition\":[\"true\"]}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-06 21:21:38', '2015-12-06 21:21:38', '5b917c44-3d67-4d77-bfe0-9e606fb50c99'),
 ('235', '141', '2', '125', 'en_gb', '9', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"64\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\\r\\n\\r\\n\\r\\n\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see left hand column) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-06 21:23:12', '2015-12-06 21:23:12', '80100384-9de7-4fe9-afea-6a9abe3f3dd3'),
 ('241', '109', '2', '125', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Media comment: November\",\"slug\":\"media-comment-november\",\"postDate\":1448875380,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"153\"],\"54\":\"As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded \\u2018New Year Resolutions\\u2019. Why not take a longer term approach to your health rather than the \\u2018boom and bust\\u2019 which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!\",\"63\":{\"110\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"This November an article was published in Gerontology, reported in the media, which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect \\u2013 is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \\r\\n\\r\\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways \\u2013 heart, lungs, blood pressure, mental health, bone strength\\u2026.. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point. \\r\\n\\r\\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on\\u2026.give the family an exercise make over this year\\u2026..who knows, you might be reaping the benefits on those crosswords in years to come!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"111\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Media comment: November\",\"77\":[{\"col1\":\"Related BBC News Article\",\"col2\":\" http:\\/\\/www.bbc.co.uk\\/news\\/health-34764693\"},{\"col1\":\"Related Daily Mail Article\",\"col2\":\"http:\\/\\/www.dailymail.co.uk\\/health\\/article-3311222\\/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html\"},{\"col1\":\"Related Guardian Article\",\"col2\":\"http:\\/\\/www.theguardian.com\\/uk-news\\/2015\\/nov\\/09\\/strong-legs-healthier-brain-in-old-age\"},{\"col1\":\"NHS fitness guide for adults\",\"col2\":\"http:\\/\\/www.nhs.uk\\/Livewell\\/fitness\\/Pages\\/physical-activity-guidelines-for-adults.aspx\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2015-12-06 21:43:29', '2015-12-06 21:43:29', '7a510b1d-e1b4-4b39-ad1d-d0db2ae39b2f'),
 ('242', '99', '2', '125', 'en_gb', '13', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"66\"],\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"76\":[\"true\"],\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-06 21:45:24', '2015-12-06 21:45:24', 'c620092f-3066-44e7-ad14-496d3d7689f8'),
 ('243', '63', '16', '125', 'en_gb', '8', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":\"\",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-06 21:48:03', '2015-12-06 21:48:03', '97876310-421a-47a8-a9fd-198ef23834bb'),
 ('244', '63', '16', '125', 'en_gb', '9', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. \\r\\n\\r\\nI work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":\"\",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-06 21:53:03', '2015-12-06 21:53:03', '9945cc14-839f-4271-b119-f27bd6190a3a'),
 ('245', '63', '16', '125', 'en_gb', '10', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. \\r\\n\\r\\n\\r\\nI work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":\"\",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-06 21:53:36', '2015-12-06 21:53:36', '097e0a2b-a87d-4121-9ca8-d6705c199a65'),
 ('246', '63', '16', '125', 'en_gb', '11', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. \\r\\nI work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":\"\",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-06 21:54:23', '2015-12-06 21:54:23', '09417eae-f814-49bd-8934-6da05f5d0e7e'),
 ('247', '63', '16', '125', 'en_gb', '12', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":\"\",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-06 21:55:04', '2015-12-06 21:55:04', 'e4aead97-c9c4-44c1-a928-fa332b45a6cd'),
 ('248', '63', '16', '125', 'en_gb', '13', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":\"\",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-06 21:55:45', '2015-12-06 21:55:45', '06eae4f5-939c-48fc-bc89-bd8545d8e1be'),
 ('249', '62', '15', '125', 'en_gb', '7', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\",\"14\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it.......Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. Click on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"77\":\"\",\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-12-06 21:57:30', '2015-12-06 21:57:30', '61c7a1c2-4a5e-4e92-9da0-093e929c51d4'),
 ('250', '62', '15', '125', 'en_gb', '8', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\",\"14\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it.......Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. \\r\\n\\r\\nClick on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"77\":\"\",\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-12-06 21:58:37', '2015-12-06 21:58:37', '64962f0e-c74e-4214-90a2-5f81b63a289c'),
 ('251', '62', '15', '125', 'en_gb', '9', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\",\"14\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it.......Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. \\r\\n\\r\\nClick on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"77\":\"\",\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-12-06 22:00:26', '2015-12-06 22:00:26', '6bef26d0-665d-4afd-8ae1-e6cee8e7f764'),
 ('252', '61', '14', '125', 'en_gb', '11', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"127\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"128\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Balancing busy jobs and a home life is difficult enough, let alone trying to keep fit and healthy, so it doesn\'t take much to upset the equilibrium. However getting pain associated with your job, or preventing you from exercising easily can disrupt those scales making it harder to achieve everything you need to do. At Cathedral Physiotherapy we are here to help you improve any symptoms you may have so that you can get back to being superhuman! Click on the links below for examples of what we can help you with.\",\"77\":\"\",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"77\"]}}', '2015-12-06 22:02:24', '2015-12-06 22:02:24', '0dc11119-e0b5-405b-9697-965e757b9317'),
 ('253', '61', '14', '125', 'en_gb', '12', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"127\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"128\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Balancing busy jobs and a home life is difficult enough, let alone trying to keep fit and healthy, so it doesn\'t take much to upset the equilibrium. However getting pain associated with your job, or preventing you from exercising easily can disrupt those scales making it harder to achieve everything you need to do. At Cathedral Physiotherapy we are here to help you improve any symptoms you may have so that you can get back to being superhuman! \\r\\n\\r\\nClick on the links below for examples of what we can help you with.\",\"77\":\"\",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"77\"]}}', '2015-12-06 22:02:42', '2015-12-06 22:02:42', '7fb7f505-1c95-4c11-9ef4-1b5cc56b66ab');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('254', '61', '14', '125', 'en_gb', '13', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"127\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"128\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Balancing busy jobs and a home life is difficult enough, let alone trying to keep fit and healthy, so it doesn\'t take much to upset the equilibrium. However getting pain associated with your job, or preventing you from exercising easily can disrupt those scales making it harder to achieve everything you need to do. At Cathedral Physiotherapy we are here to help you improve any symptoms you may have so that you can get back to being superhuman! \\r\\n\\r\\nClick on the links below for examples of what we can help you with.\",\"77\":\"\",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"77\"]}}', '2015-12-06 22:05:48', '2015-12-06 22:05:48', 'd9cee6b9-2113-4020-a07b-7a7e57db1caf'),
 ('255', '8', '9', '125', 'en_gb', '8', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\nDirections: From Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\nParking: There is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\nBuses: We are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"133\",\"154\"]}}', '2015-12-06 22:08:57', '2015-12-06 22:08:57', '405a3bb4-1041-4876-9ec3-c43524079804'),
 ('256', '57', '8', '125', 'en_gb', '9', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: New appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"133\",\"155\"]}}', '2015-12-06 22:10:32', '2015-12-06 22:10:32', '27cfc590-122e-4a95-acfc-041b6629b233'),
 ('257', '57', '8', '125', 'en_gb', '10', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: \\r\\nNew appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"133\",\"155\"]}}', '2015-12-06 22:11:04', '2015-12-06 22:11:04', '85b9801a-f2d5-499a-82f8-4523536451e4'),
 ('258', '57', '8', '125', 'en_gb', '11', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: \\r\\n\\r\\nNew appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"133\",\"155\"]}}', '2015-12-06 22:11:18', '2015-12-06 22:11:18', '9c5bf32f-ae48-41d1-9bdb-38532cfe1968'),
 ('259', '57', '8', '125', 'en_gb', '12', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: \\r\\n\\r\\nNew appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"133\",\"155\"]}}', '2015-12-06 22:11:40', '2015-12-06 22:11:40', 'e0b0143e-413b-45c8-8e3d-dedd0e689197'),
 ('260', '47', '12', '125', 'en_gb', '4', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to our news page which includes information from self-help advice for what to do as soon as you\\u2019ve hurt yourself, and clips to watch, to topical items in the news. \\r\\n\\r\\nIf there is something that isn\\u2019t here and you would like to see, then please email us as enquiries@cathedralphysiotherapy.co.uk and we will do our best to respond to your suggestions.\",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-06 22:15:44', '2015-12-06 22:15:44', '79571785-9501-4118-8f6c-9af7ad9086e7'),
 ('261', '47', '12', '125', 'en_gb', '5', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to our news page which includes information from self-help advice for what to do as soon as you\\u2019ve hurt yourself, and clips to watch, to topical items in the news. If something isn\\u2019t here that you would like to see, then please email us at enquiries@cathedralphysiotherapy.co.uk and we will do our best to respond to your suggestions.\",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-06 22:17:17', '2015-12-06 22:17:17', 'a92a03c1-3745-4389-a92b-442ac12cdeb9'),
 ('262', '2', '1', '125', 'en_gb', '5', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \\r\\n\\r\\nPlease click on the options below and see how we can help you.  \",\"6\":\"Delivering Excellence, Experience and Enthusiasm \",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-06 22:18:18', '2015-12-06 22:18:18', 'f5de7593-3c9e-4be1-8dea-ba52b0097154'),
 ('263', '2', '1', '125', 'en_gb', '6', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \\r\\n\\r\\nPlease click on the options below and see how we can help you.  \",\"6\":\"Delivering Excellence, Experience and Enthusiasm \",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-06 22:19:28', '2015-12-06 22:19:28', 'ebbb6a66-f9ab-40df-babe-671e65434f63'),
 ('264', '32', '11', '125', 'en_gb', '3', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Rheumatological conditions\",\"slug\":\"rheumatological-conditions\",\"postDate\":1447415820,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Although consisting of a variety of diagnoses, for instance Rheumatoid Arthritis, Ankylosing Spondylitis, Psoriatic Arthritis etc, many of these diseases follow a period of flare and recovery. At Cathedral Physiotherapy we can help you not to be defined by your diagnosis, assist you through your flares, and maximise your return to function so that you continue to lead and full and fruitful life.\",\"21\":\"Rheumatological conditions\"}}', '2015-12-06 22:21:35', '2015-12-06 22:21:35', '54130ab0-6d38-4bcc-bfb0-b577587d0a6d'),
 ('265', '62', '15', '125', 'en_gb', '10', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\",\"14\",\"30\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it.......Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. \\r\\n\\r\\nClick on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"77\":\"\",\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-12-06 22:22:51', '2015-12-06 22:22:51', '63d28013-51c4-4d4c-af5d-9ea2952ff928'),
 ('266', '9', '10', '125', 'en_gb', '12', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment. \\r\\n\\r\\nClick the categories below to see how we can help you.\",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-06 22:23:32', '2015-12-06 22:23:32', 'b674934e-a925-492f-b42b-ac297786f628'),
 ('267', '63', '16', '125', 'en_gb', '14', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"18\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":\"\",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-06 22:25:06', '2015-12-06 22:25:06', 'b097906f-52db-482f-b7c8-4a5228939a23'),
 ('268', '9', '10', '125', 'en_gb', '13', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment. \\r\\n\\r\\nClick the categories below to see how we can help you.\",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-06 22:26:21', '2015-12-06 22:26:21', '075cc40d-1b7d-45af-b9e5-f43a17d880ec'),
 ('269', '5', '5', '125', 'en_gb', '8', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Your safety is paramount to us, and to ensure this you can be assured that the clinic is regulated and governed by the following bodies.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"95\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"94\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"96\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"91\"]}},\"98\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"120\"],\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":[\"119\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"97\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-12-06 22:27:30', '2015-12-06 22:27:30', '6f1e8663-7476-46bf-b6c5-586ea897bb60'),
 ('270', '5', '5', '125', 'en_gb', '9', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"To ensure your safety, Cathedral Physiotherapy is regulated and governed by the following bodies.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"95\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"94\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"96\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"91\"]}},\"98\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"120\"],\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":[\"119\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"97\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-12-06 22:29:34', '2015-12-06 22:29:34', '806f73d5-0ade-4b67-a4ea-499050792a17'),
 ('271', '5', '5', '125', 'en_gb', '10', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"To ensure your safety, Cathedral Physiotherapy is regulated and governed by the following bodies.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"95\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"94\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"96\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"91\"]}},\"98\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"120\"],\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":[\"119\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"97\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-12-06 22:30:32', '2015-12-06 22:30:32', '7fc684f8-3c07-417c-94cb-c53da3e4cb17'),
 ('272', '4', '3', '125', 'en_gb', '8', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":[\"134\"],\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\n\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"140\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-06 22:32:12', '2015-12-06 22:32:12', '03be5206-63b7-4e06-bc6c-65fff0f1119a'),
 ('273', '4', '3', '125', 'en_gb', '9', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":[\"134\",\"155\"],\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\n\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"140\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-06 22:47:58', '2015-12-06 22:47:58', '39a41ffe-ce55-4dcb-b267-1d09f64c8d68'),
 ('274', '4', '3', '125', 'en_gb', '10', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":\"\",\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\n\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"140\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-06 22:55:11', '2015-12-06 22:55:11', '9de90e77-220b-425d-a149-06ea2181446f'),
 ('275', '4', '3', '125', 'en_gb', '11', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":[\"133\",\"155\",\"154\"],\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\n\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"140\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-06 22:57:11', '2015-12-06 22:57:11', '0d62bc8f-ce90-4eae-a63d-e755b46b863d'),
 ('276', '4', '3', '125', 'en_gb', '12', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":[\"133\",\"155\",\"154\"],\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\n\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"140\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-06 23:03:59', '2015-12-06 23:03:59', '5ba33de0-2e29-4870-8efb-909f2726a18c'),
 ('277', '63', '16', '125', 'en_gb', '15', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"18\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy in Exeter we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":\"\",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-06 23:04:20', '2015-12-06 23:04:20', 'cf85e0fb-f2dd-436e-a21f-4f0316265f17'),
 ('278', '57', '8', '125', 'en_gb', '13', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy, Exeter, we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: \\r\\n\\r\\nNew appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"133\",\"155\"]}}', '2015-12-06 23:06:56', '2015-12-06 23:06:56', 'c1cdb00c-5be9-423a-9c6c-d0b2b998c131'),
 ('279', '57', '8', '125', 'en_gb', '14', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy Exeter, we like to keep things simple. Therefore we only have two prices, regardless of the treatment you are having at the clinic: \\r\\n\\r\\nNew appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"133\",\"155\"]}}', '2015-12-06 23:08:02', '2015-12-06 23:08:02', 'c9415e0e-6e89-4c89-af4a-08db9f8b2d5c'),
 ('280', '57', '8', '125', 'en_gb', '15', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy Exeter, we like to keep things simple. Therefore we only have two prices, regardless of the treatment you are having at the clinic: \\r\\n\\r\\nNew appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"133\",\"155\"]}}', '2015-12-06 23:09:38', '2015-12-06 23:09:38', 'c2cf1e5a-c29c-48ca-b659-787b7c52ee22'),
 ('281', '109', '2', '125', 'en_gb', '4', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Media comment: November\",\"slug\":\"media-comment-november\",\"postDate\":1448875380,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"156\"],\"54\":\"As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded \\u2018New Year Resolutions\\u2019. Why not take a longer term approach to your health rather than the \\u2018boom and bust\\u2019 which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!\",\"63\":{\"110\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"This November an article was published in Gerontology, reported in the media, which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect \\u2013 is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \\r\\n\\r\\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways \\u2013 heart, lungs, blood pressure, mental health, bone strength\\u2026.. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point. \\r\\n\\r\\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on\\u2026.give the family an exercise make over this year\\u2026..who knows, you might be reaping the benefits on those crosswords in years to come!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"111\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Media comment: November\",\"77\":[{\"col1\":\"Related BBC News Article\",\"col2\":\" http:\\/\\/www.bbc.co.uk\\/news\\/health-34764693\"},{\"col1\":\"Related Daily Mail Article\",\"col2\":\"http:\\/\\/www.dailymail.co.uk\\/health\\/article-3311222\\/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html\"},{\"col1\":\"Related Guardian Article\",\"col2\":\"http:\\/\\/www.theguardian.com\\/uk-news\\/2015\\/nov\\/09\\/strong-legs-healthier-brain-in-old-age\"},{\"col1\":\"NHS fitness guide for adults\",\"col2\":\"http:\\/\\/www.nhs.uk\\/Livewell\\/fitness\\/Pages\\/physical-activity-guidelines-for-adults.aspx\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2015-12-06 23:14:18', '2015-12-06 23:14:18', '3b2bcb45-1dd7-4860-8e2c-0e72952f79bc'),
 ('282', '109', '2', '125', 'en_gb', '5', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Media comment: November\",\"slug\":\"media-comment-november\",\"postDate\":1448875380,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"156\"],\"54\":\"As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded \\u2018New Year Resolutions\\u2019. Why not take a longer term approach to your health rather than the \\u2018boom and bust\\u2019 which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!\",\"63\":{\"110\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"This November an article was published in Gerontology, reported in the media, which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect \\u2013 is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \\r\\n\\r\\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways \\u2013 heart, lungs, blood pressure, mental health, bone strength\\u2026.. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point. \\r\\n\\r\\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on\\u2026.give the family an exercise make over this year\\u2026..who knows, you might be reaping the benefits on those crosswords in years to come!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"111\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Media comment: November\",\"77\":[{\"col1\":\"Related BBC News Article\",\"col2\":\" http:\\/\\/www.bbc.co.uk\\/news\\/health-34764693\"},{\"col1\":\"Related Daily Mail Article\",\"col2\":\"http:\\/\\/www.dailymail.co.uk\\/health\\/article-3311222\\/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html\"},{\"col1\":\"Related Guardian Article\",\"col2\":\"http:\\/\\/www.theguardian.com\\/uk-news\\/2015\\/nov\\/09\\/strong-legs-healthier-brain-in-old-age\"},{\"col1\":\"NHS fitness guide for adults\",\"col2\":\"http:\\/\\/www.nhs.uk\\/Livewell\\/fitness\\/Pages\\/physical-activity-guidelines-for-adults.aspx\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2015-12-06 23:15:54', '2015-12-06 23:15:54', '0fa41e58-a21c-4f29-8985-e02bf0e1280f'),
 ('283', '99', '2', '125', 'en_gb', '14', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"66\"],\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improved within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"76\":[\"true\"],\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-06 23:16:25', '2015-12-06 23:16:25', '70e2eb36-007c-4d48-9a90-91c604dfb329'),
 ('284', '99', '2', '125', 'en_gb', '15', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"66\"],\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improved within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"76\":[\"true\"],\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely), relaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-06 23:18:12', '2015-12-06 23:18:12', '600e3e41-55f2-4505-85c5-08d4165e2b2c'),
 ('285', '99', '2', '125', 'en_gb', '16', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"66\"],\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improved within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"76\":[\"true\"],\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely), relaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-06 23:21:00', '2015-12-06 23:21:00', '5f02a108-7111-4b62-ad2e-9d115bdfd21b'),
 ('286', '141', '2', '125', 'en_gb', '10', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"64\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\\r\\n\\r\\n\\r\\n\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-06 23:21:41', '2015-12-06 23:21:41', 'd3825855-0378-4c9c-84f6-134d73c0cf4d'),
 ('287', '141', '2', '125', 'en_gb', '11', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"64\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\\r\\n\\r\\n\\r\\n\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-06 23:35:36', '2015-12-06 23:35:36', 'f203b006-9bb5-4983-9918-c86b998c4cd3'),
 ('288', '47', '12', '1', 'en_gb', '6', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to our news page which includes information from self-help advice for what to do as soon as you\\u2019ve hurt yourself, and clips to watch, to topical items in the news. If something isn\\u2019t here that you would like to see, then please email us at enquiries@cathedralphysiotherapy.co.uk and \\r\\n\\r\\nwe will do our best to respond to your suggestions.\",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-07 10:59:05', '2015-12-07 10:59:05', 'd33e9367-16ca-4004-8489-4446fc5a9f19'),
 ('289', '47', '12', '1', 'en_gb', '7', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to our news page which includes information from self-help advice for what to do as soon as you\\u2019ve hurt yourself, and clips to watch, to topical items in the news. If something isn\\u2019t here that you would like to see, then please email us at enquiries@cathedralphysiotherapy.co.uk and we will do our best to respond to your suggestions.\",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-07 11:04:13', '2015-12-07 11:04:13', 'c49206a7-eed1-4d47-880a-ea2a80460875'),
 ('290', '29', '11', '1', 'en_gb', '4', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Headaches and Dizziness\",\"slug\":\"headaches-and-dizziness\",\"postDate\":1447415760,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Benign headaches can be caused by tension in the muscles, stiffness in the neck or muscle imbalance. Often characterised by being one-sided, or in a band around the head, and associated with neck pain, or certain movements, symptoms can be improved significantly with a combination of exercise, manual therapy, acupuncture and an understanding of pain pathways.\\r\\n\\r\\nDizziness can be generated from the neck, the inner ear or the brain, and accurate differential diagnosis is crucial for appropriate treatment.\",\"21\":\"Headaches and Dizziness\"}}', '2015-12-07 11:15:05', '2015-12-07 11:15:05', '4302c34b-1e17-4d3b-b53b-d1c6a3396074'),
 ('291', '141', '2', '1', 'en_gb', '12', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"64\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":[\"177\"],\"photoPosition\":\"\"}},\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"184\"],\"photoPosition\":\"\"}},\"new2\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"171\"],\"photoPosition\":\"\"}},\"new3\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"178\"],\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-07 12:21:29', '2015-12-07 12:21:29', '833c2f38-b00d-4ead-a0c5-e62dee970386'),
 ('293', '109', '2', '124', 'en_gb', '6', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Media comment: November\",\"slug\":\"media-comment-november\",\"postDate\":1448875380,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"190\"],\"54\":\"As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded \\u2018New Year Resolutions\\u2019. Why not take a longer term approach to your health rather than the \\u2018boom and bust\\u2019 which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!\",\"63\":{\"110\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"This November an article was published in Gerontology, reported in the media, which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect \\u2013 is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \\r\\n\\r\\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways \\u2013 heart, lungs, blood pressure, mental health, bone strength\\u2026.. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point. \\r\\n\\r\\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on\\u2026.give the family an exercise make over this year\\u2026..who knows, you might be reaping the benefits on those crosswords in years to come!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"111\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Media comment: November\",\"82\":\"\",\"77\":[{\"col1\":\"Related BBC News Article\",\"col2\":\" http:\\/\\/www.bbc.co.uk\\/news\\/health-34764693\"},{\"col1\":\"Related Daily Mail Article\",\"col2\":\"http:\\/\\/www.dailymail.co.uk\\/health\\/article-3311222\\/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html\"},{\"col1\":\"Related Guardian Article\",\"col2\":\"http:\\/\\/www.theguardian.com\\/uk-news\\/2015\\/nov\\/09\\/strong-legs-healthier-brain-in-old-age\"},{\"col1\":\"NHS fitness guide for adults\",\"col2\":\"http:\\/\\/www.nhs.uk\\/Livewell\\/fitness\\/Pages\\/physical-activity-guidelines-for-adults.aspx\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2015-12-07 13:07:41', '2015-12-07 13:07:41', 'e9e1f24b-e36c-41e1-8735-02934f3b8547'),
 ('294', '23', '11', '124', 'en_gb', '4', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Shoulder \\/ Elbow \\/ Wrist pain\",\"slug\":\"shoulder-elbow-wrist-pain\",\"postDate\":1447415640,\"expiryDate\":null,\"enabled\":1,\"parentId\":\"\",\"fields\":{\"23\":\"\\u00a345 for 1 hour\",\"24\":\"\\u00a335 for 1\\/2 hour\",\"22\":\"Whether your pain is work or hobby related it is important to get the correct advice early to prevent chronicity. An excellent assessment will differentiate the problem and help you to manage and improve your symptoms.\\r\\n\\r\\nArm pain can be referred from the neck, but is more commonly related to impingement of the tendons, or tears of the muscle, but can also be due to \\u2018frozen shoulder\\u2019. \\r\\n\\r\\nElbow complaints include tennis elbow, golfers elbow, or nerve irritation. \\r\\n\\r\\nWrist pain is commonly related to the position of the wrist at work or during hobbies, but can be due to stiffness post fracture, or carpal tunnel syndrome. \\r\\n\",\"21\":\"Shoulder \\/ Elbow \\/ Wrist pain\"}}', '2015-12-07 13:12:43', '2015-12-07 13:12:43', 'bcecd6b0-63d3-4dc2-b441-d0202e769514'),
 ('295', '141', '2', '1', 'en_gb', '13', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"64\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":[\"177\"],\"photoPosition\":\"\"}},\"185\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"184\"],\"photoPosition\":\"\"}},\"186\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"171\"],\"photoPosition\":\"\"}},\"187\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"178\"],\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"82\":\"1\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-07 14:09:46', '2015-12-07 14:09:46', 'f4d2b1ee-e1d9-481c-96e0-aae06014164a'),
 ('296', '141', '2', '1', 'en_gb', '14', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"64\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":[\"177\"],\"photoPosition\":\"\"}},\"185\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"184\"],\"photoPosition\":\"\"}},\"186\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"171\"],\"photoPosition\":\"\"}},\"187\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"178\"],\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"82\":\"\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-07 14:44:00', '2015-12-07 14:44:00', 'c12b6cf6-68ea-46e6-9a28-53d75221295d'),
 ('297', '141', '2', '1', 'en_gb', '15', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"64\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\",\"sectionImage\":[\"177\"],\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":[\"184\"],\"photoPosition\":\"\"}},\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"178\"],\"photoPosition\":\"\"}},\"new2\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"171\"],\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"82\":\"1\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-07 14:53:06', '2015-12-07 14:53:06', '5d19810e-fe8d-44e8-a7e9-b75b43967c91'),
 ('298', '141', '2', '124', 'en_gb', '16', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"64\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\",\"sectionImage\":[\"177\"],\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":[\"184\"],\"photoPosition\":\"\"}},\"191\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"178\"],\"photoPosition\":\"\"}},\"192\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"171\"],\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"82\":\"1\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-07 15:47:18', '2015-12-07 15:47:18', 'e7e42c52-9764-4410-bd8f-0635c287bf93'),
 ('299', '141', '2', '124', 'en_gb', '17', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"64\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\",\"sectionImage\":[\"177\"],\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":[\"184\"],\"photoPosition\":\"\"}},\"191\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"178\"],\"photoPosition\":\"\"}},\"192\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"171\"],\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"82\":\"1\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-07 15:48:06', '2015-12-07 15:48:06', '75535b07-5c5b-49ec-8be2-e9653c949d29'),
 ('300', '99', '2', '124', 'en_gb', '17', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"66\"],\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improved within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"82\":\"\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"76\":[\"true\"],\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely), relaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-07 15:58:04', '2015-12-07 15:58:04', '5204da91-a94b-43f6-b9e1-6a31d3b04a0b'),
 ('301', '57', '8', '1', 'en_gb', '16', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy Exeter, we like to keep things simple. Therefore we only have two prices, regardless of the treatment you are having at the clinic: \\r\\n\\r\\nNew appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"134\",\"164\"]}}', '2015-12-07 16:00:57', '2015-12-07 16:00:57', '29b76e5e-aec9-4649-be85-f395ecd70e4f'),
 ('302', '4', '3', '1', 'en_gb', '13', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":[\"164\",\"166\",\"170\"],\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\n\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"214\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-07 16:02:06', '2015-12-07 16:02:06', 'f6c94d23-9e3f-4485-9ac5-445f41d91a0b'),
 ('303', '58', '13', '124', 'en_gb', '16', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Don\'t take our word for it, hear from our clients what they think about us.........\",\"6\":\"Testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffrees\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"James Pike\",\"location\":\"Exeter\",\"quote\":\"I had a couple of back problems a couple of months ago due to a cycling accident and went to Sarah for some help, she did a great job and wasn\'t bothered about working on me a few times in the week which was great. After a couple of visits it was all fixed and she gave me stretches to do for a month so the pain doesn\'t return. Sarah\'s great and well recommended! Thanks Sarah!\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Jenny Pestridge\",\"location\":\"Devon\",\"quote\":\"I recently visited Cathedral Physiotherapy, which is situated in a convenient city-centre location. I was treated by Sarah Moore. A high standard of care and treatment has resulted in an immediate improvement. I felt confident and reassured by Sarah\'s expertise, because of her thorough explanation of my condition, and appropriate treatment. I would rate my experience of Cathedral Physiotherapy as outstanding.\"}},\"new1\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Nick Hitt\",\"location\":\"Exeter\",\"quote\":\"I found the whole experience at Cathedral Physiotherapy to be outstanding. Not only is it a picturesque location, easy access from the city centre, and nestled in a magnificent Georgian houses in Exeter\\u2019s Southernhay, but the service was exceptional. The clinic was exceptional clean, bright, well laid out and very welcoming. Sarah Moore, the physiotherapist, was simple brilliant. Her caring and professional attitude towards my diagnosis was superb. She made me feel at ease and able to convey my issues to her without any misunderstanding. She took an incredible amount of care and time to ensure she thoroughly understood my concerns. The treatment plan she produced was clear, easy to incorporate into my everyday life; it was like having a consultation from my very own private physiotherapist. If I have any niggles or issues in the future, you can be sure I will be visiting Cathedral Physiotherapist again.\"}}}}}', '2015-12-07 17:03:11', '2015-12-07 17:03:11', '23e63d90-727a-4401-a7ac-8fe7c9ba265b'),
 ('305', '47', '12', '1', 'en_gb', '8', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to our news page which includes information from self-help advice for what to do as soon as you\\u2019ve hurt yourself, and clips to watch, to topical items in the news. If something isn\\u2019t here that you would like to see, then please email us at enquiries@cathedralphysiotherapy.co.uk and we will do our best to respond to your suggestions.\",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-07 17:24:05', '2015-12-07 17:24:05', 'be331c4b-e1dd-492a-9b02-1f899f033d8f'),
 ('306', '8', '9', '124', 'en_gb', '9', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\nDirections: From Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\nParking: There is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\nBuses: We are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"80\":[\"133\",\"164\",\"157\"]}}', '2015-12-07 18:21:15', '2015-12-07 18:21:15', '1c040b0f-540a-4329-8bfb-6488f729d772'),
 ('307', '62', '15', '1', 'en_gb', '11', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\",\"14\",\"30\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it.......Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. \\r\\n\\r\\nClick on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"77\":[{\"col1\":\"The benefits of exercise - 23 1\\/2 hours\",\"col2\":\"https:\\/\\/youtu.be\\/aUaInS6HIGo\"}],\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-12-08 11:04:51', '2015-12-08 11:04:51', '9cf3f79b-46d2-4dd2-bab9-32b1dea44a5a'),
 ('308', '63', '16', '1', 'en_gb', '16', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"18\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy in Exeter we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":[{\"col1\":\"Access self-help exercise leaflets from the Arthritis Research Council and CSP\",\"col2\":\"http:\\/\\/www.csp.org.uk\\/publications\\/exercise-advice-leaflets\"}],\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-12-08 11:06:22', '2015-12-08 11:06:22', 'b22f9099-4afc-49c9-84c1-1c51d9f96fa6'),
 ('309', '62', '15', '1', 'en_gb', '12', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\",\"14\",\"30\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it... Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. \\r\\n\\r\\nClick on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"77\":[{\"col1\":\"The benefits of exercise - 23 1\\/2 hours\",\"col2\":\"https:\\/\\/youtu.be\\/aUaInS6HIGo\"}],\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-12-08 11:35:25', '2015-12-08 11:35:25', 'b082f5cf-3712-4d95-8ab2-6fb056a3ce02'),
 ('310', '58', '13', '1', 'en_gb', '17', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Don\'t take our word for it, hear from our clients what they think about us...\",\"6\":\"Testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffrees\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"James Pike\",\"location\":\"Exeter\",\"quote\":\"I had a couple of back problems a couple of months ago due to a cycling accident and went to Sarah for some help, she did a great job and wasn\'t bothered about working on me a few times in the week which was great. After a couple of visits it was all fixed and she gave me stretches to do for a month so the pain doesn\'t return. Sarah\'s great and well recommended! Thanks Sarah!\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Jenny Pestridge\",\"location\":\"Devon\",\"quote\":\"I recently visited Cathedral Physiotherapy, which is situated in a convenient city-centre location. I was treated by Sarah Moore. A high standard of care and treatment has resulted in an immediate improvement. I felt confident and reassured by Sarah\'s expertise, because of her thorough explanation of my condition, and appropriate treatment. I would rate my experience of Cathedral Physiotherapy as outstanding.\"}},\"225\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Nick Hitt\",\"location\":\"Exeter\",\"quote\":\"I found the whole experience at Cathedral Physiotherapy to be outstanding. Not only is it a picturesque location, easy access from the city centre, and nestled in a magnificent Georgian houses in Exeter\\u2019s Southernhay, but the service was exceptional. The clinic was exceptional clean, bright, well laid out and very welcoming. Sarah Moore, the physiotherapist, was simple brilliant. Her caring and professional attitude towards my diagnosis was superb. She made me feel at ease and able to convey my issues to her without any misunderstanding. She took an incredible amount of care and time to ensure she thoroughly understood my concerns. The treatment plan she produced was clear, easy to incorporate into my everyday life; it was like having a consultation from my very own private physiotherapist. If I have any niggles or issues in the future, you can be sure I will be visiting Cathedral Physiotherapist again.\"}}}}}', '2015-12-08 11:36:01', '2015-12-08 11:36:01', '94d8fe34-b41f-418c-9f81-8ff41ba7d3d2'),
 ('311', '2', '1', '1', 'en_gb', '7', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Delivering Excellence, Experience and Enthusiasm \",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-08 11:37:30', '2015-12-08 11:37:30', '28ba12de-2197-4ad2-9199-44af195a3ec0'),
 ('312', '2', '1', '1', 'en_gb', '8', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Delivering Excellence, Experience and Enthusiasm \",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 11:50:11', '2015-12-08 11:50:11', '93b96ede-504d-45a6-85b1-3ee846dbf054'),
 ('313', '2', '1', '1', 'en_gb', '9', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio, Delivering Excellence, and Enthusiasm\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 11:51:30', '2015-12-08 11:51:30', 'eae71e61-228f-46f6-b678-a89171c66555'),
 ('314', '2', '1', '1', 'en_gb', '10', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio, Delivering Excellence for 18 Years\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 11:52:27', '2015-12-08 11:52:27', 'd9193a36-931e-47e4-9a94-efac0c379af1'),
 ('315', '2', '1', '1', 'en_gb', '11', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio. 18 Years Delivering Excellence!\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 11:53:05', '2015-12-08 11:53:05', '2d2f4014-b8cf-4cbc-bff4-a83199c6af58'),
 ('316', '2', '1', '1', 'en_gb', '12', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio.<br>18+ Years Delivering Excellence! <\\/br>\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 11:54:15', '2015-12-08 11:54:15', '185410f1-526a-4080-8010-3b4ee05ecaf1'),
 ('317', '2', '1', '1', 'en_gb', '13', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio.<br>18+ Years Delivering Excellence. <\\/br>\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 11:54:49', '2015-12-08 11:54:49', '0d9a80b4-cf63-48dc-87c1-90b82203310d'),
 ('318', '2', '1', '1', 'en_gb', '14', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio.<br>18+ Years Delivering Excellence! <\\/br>\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 11:55:24', '2015-12-08 11:55:24', '838f074c-d6a6-4571-9d00-f5b13d1cfd51'),
 ('319', '2', '1', '1', 'en_gb', '15', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio.<\\/br>18+ Years Delivering Excellence.\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 11:57:19', '2015-12-08 11:57:19', '4f555ef8-561c-4dbb-b1ef-7cc4babf2550'),
 ('320', '2', '1', '1', 'en_gb', '16', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio. 18+ Years Delivering Excellence.\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 11:57:44', '2015-12-08 11:57:44', 'd677a0f9-cf19-4acb-bd27-b56553103525'),
 ('321', '2', '1', '1', 'en_gb', '17', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio. <\\/br> 18+ Years Delivering Excellence.\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 11:59:18', '2015-12-08 11:59:18', '4d339f01-152c-435a-be52-f27d78c3c7a0'),
 ('322', '2', '1', '1', 'en_gb', '18', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio\\r\\n18+ Years Delivering Excellence.\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 12:02:36', '2015-12-08 12:02:36', '21eef9ba-1c6f-4a8f-b542-8cf7975fac77'),
 ('323', '2', '1', '1', 'en_gb', '19', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio\\r\\n18+ Years Delivering Excellence\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 12:03:36', '2015-12-08 12:03:36', '449f708f-cfc5-4099-a2ab-9f7348fc3cff'),
 ('324', '62', '15', '1', 'en_gb', '13', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\",\"14\",\"30\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it... Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. \\r\\n\\r\\nClick on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"77\":[{\"col1\":\"The benefits of exercise - 23 1\\/2 hours\",\"col2\":\"https:\\/\\/youtu.be\\/aUaInS6HIGo\"}],\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Young and Active\",\"53\":[\"41\"]}}', '2015-12-08 12:42:54', '2015-12-08 12:42:54', '9ac12152-ffa6-46b9-a56c-a33538c27504'),
 ('325', '63', '16', '1', 'en_gb', '17', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"18\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy in Exeter we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":[{\"col1\":\"Access self-help exercise leaflets from the Arthritis Research Council and CSP\",\"col2\":\"http:\\/\\/www.csp.org.uk\\/publications\\/exercise-advice-leaflets\"}],\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Lifetime Support\",\"53\":[\"76\"]}}', '2015-12-08 12:43:21', '2015-12-08 12:43:21', '00fe9bf1-4ea1-49da-8a1b-28ad686e1692'),
 ('326', '61', '14', '1', 'en_gb', '14', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"127\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"128\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Balancing busy jobs and a home life is difficult enough, let alone trying to keep fit and healthy, so it doesn\'t take much to upset the equilibrium. However getting pain associated with your job, or preventing you from exercising easily can disrupt those scales making it harder to achieve everything you need to do. At Cathedral Physiotherapy we are here to help you improve any symptoms you may have so that you can get back to being superhuman! \\r\\n\\r\\nClick on the links below for examples of what we can help you with.\",\"77\":\"\",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Work and Social\",\"53\":[\"77\"]}}', '2015-12-08 12:43:47', '2015-12-08 12:43:47', '32f066b6-a6be-4d15-95b9-98eb1a149044'),
 ('327', '47', '12', '1', 'en_gb', '9', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to our news page which includes information from self-help advice for what to do as soon as you\\u2019ve hurt yourself, and clips to watch, to topical items in the news. If something isn\\u2019t here that you would like to see, then please email us at enquiries@cathedralphysiotherapy.co.uk and we will do our best to respond to your suggestions.\",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Latest Physio News, Discussion and Advice\"}}', '2015-12-08 12:44:33', '2015-12-08 12:44:33', '2431c09c-7ca5-496c-8f05-32e4fe1b95fd'),
 ('328', '8', '9', '1', 'en_gb', '10', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\nDirections: From Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\nParking: There is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\nBuses: We are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter, Devon based physio\",\"80\":[\"133\",\"164\",\"157\"]}}', '2015-12-08 12:46:04', '2015-12-08 12:46:04', 'c5faa290-6175-430e-a5ae-35edce209da9'),
 ('329', '9', '10', '1', 'en_gb', '14', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment. \\r\\n\\r\\nClick the categories below to see how we can help you.\",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Expert treatments from experienced Exeter Physio\"}}', '2015-12-08 12:47:44', '2015-12-08 12:47:44', 'be9b1251-d50b-4296-b859-9383c194ef7a'),
 ('330', '57', '8', '1', 'en_gb', '17', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy Exeter, we like to keep things simple. Therefore we only have two prices, regardless of the treatment you are having at the clinic: \\r\\n\\r\\nNew appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio treatment costs\",\"80\":[\"134\",\"164\"]}}', '2015-12-08 12:48:23', '2015-12-08 12:48:23', 'bce6258b-bad8-4f6a-8b76-736b7d003c54'),
 ('331', '58', '13', '1', 'en_gb', '18', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Don\'t take our word for it, hear from our clients what they think about us...\",\"6\":\"Testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Reviews for Cathedral Physiotherapy\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffrees\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"James Pike\",\"location\":\"Exeter\",\"quote\":\"I had a couple of back problems a couple of months ago due to a cycling accident and went to Sarah for some help, she did a great job and wasn\'t bothered about working on me a few times in the week which was great. After a couple of visits it was all fixed and she gave me stretches to do for a month so the pain doesn\'t return. Sarah\'s great and well recommended! Thanks Sarah!\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Jenny Pestridge\",\"location\":\"Devon\",\"quote\":\"I recently visited Cathedral Physiotherapy, which is situated in a convenient city-centre location. I was treated by Sarah Moore. A high standard of care and treatment has resulted in an immediate improvement. I felt confident and reassured by Sarah\'s expertise, because of her thorough explanation of my condition, and appropriate treatment. I would rate my experience of Cathedral Physiotherapy as outstanding.\"}},\"225\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Nick Hitt\",\"location\":\"Exeter\",\"quote\":\"I found the whole experience at Cathedral Physiotherapy to be outstanding. Not only is it a picturesque location, easy access from the city centre, and nestled in a magnificent Georgian houses in Exeter\\u2019s Southernhay, but the service was exceptional. The clinic was exceptional clean, bright, well laid out and very welcoming. Sarah Moore, the physiotherapist, was simple brilliant. Her caring and professional attitude towards my diagnosis was superb. She made me feel at ease and able to convey my issues to her without any misunderstanding. She took an incredible amount of care and time to ensure she thoroughly understood my concerns. The treatment plan she produced was clear, easy to incorporate into my everyday life; it was like having a consultation from my very own private physiotherapist. If I have any niggles or issues in the future, you can be sure I will be visiting Cathedral Physiotherapist again.\"}}}}}', '2015-12-08 12:48:54', '2015-12-08 12:48:54', 'e99e24c5-26a2-433d-a96d-cee5ebdf34e1'),
 ('332', '5', '5', '1', 'en_gb', '11', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"To ensure your safety, Cathedral Physiotherapy is regulated and governed by the following bodies.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Full accredited Exeter Physio\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"95\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"94\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"96\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"91\"]}},\"98\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"120\"],\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":[\"119\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"97\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-12-08 12:49:46', '2015-12-08 12:49:46', '729c48f6-6303-4860-9dcf-9fa9240cbd16'),
 ('333', '4', '3', '1', 'en_gb', '14', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":[\"164\",\"166\",\"170\"],\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\n\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\" Exeter physio with 18 years of experience\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"214\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-08 12:52:28', '2015-12-08 12:52:28', '42dfba5c-ec1a-4ccc-a05b-736fe7f09db0'),
 ('334', '141', '2', '1', 'en_gb', '18', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"64\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\",\"sectionImage\":[\"177\"],\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":[\"184\"],\"photoPosition\":\"\"}},\"191\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"178\"],\"photoPosition\":\"\"}},\"192\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":[\"171\"],\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"82\":\"1\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Acupuncture Exeter\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-08 12:56:06', '2015-12-08 12:56:06', '9982e641-55dd-4c28-9ef1-df174db19706'),
 ('335', '99', '2', '1', 'en_gb', '18', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"66\"],\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improved within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"82\":\"\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"How to help back pain\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"76\":[\"true\"],\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely), relaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-08 12:58:49', '2015-12-08 12:58:49', '5302e609-2f58-408b-b58a-5647a0005a35'),
 ('336', '109', '2', '1', 'en_gb', '7', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Media comment: November\",\"slug\":\"media-comment-november\",\"postDate\":1448875380,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"190\"],\"54\":\"As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded \\u2018New Year Resolutions\\u2019. Why not take a longer term approach to your health rather than the \\u2018boom and bust\\u2019 which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!\",\"63\":{\"110\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"This November an article was published in Gerontology, reported in the media, which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect \\u2013 is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \\r\\n\\r\\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways \\u2013 heart, lungs, blood pressure, mental health, bone strength\\u2026.. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point. \\r\\n\\r\\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on\\u2026.give the family an exercise make over this year\\u2026..who knows, you might be reaping the benefits on those crosswords in years to come!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"111\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Media comment: November\",\"82\":\"\",\"77\":[{\"col1\":\"Related BBC News Article\",\"col2\":\" http:\\/\\/www.bbc.co.uk\\/news\\/health-34764693\"},{\"col1\":\"Related Daily Mail Article\",\"col2\":\"http:\\/\\/www.dailymail.co.uk\\/health\\/article-3311222\\/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html\"},{\"col1\":\"Related Guardian Article\",\"col2\":\"http:\\/\\/www.theguardian.com\\/uk-news\\/2015\\/nov\\/09\\/strong-legs-healthier-brain-in-old-age\"},{\"col1\":\"NHS fitness guide for adults\",\"col2\":\"http:\\/\\/www.nhs.uk\\/Livewell\\/fitness\\/Pages\\/physical-activity-guidelines-for-adults.aspx\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio Exeter advice on fitness\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2015-12-08 12:59:22', '2015-12-08 12:59:22', 'b16f7b1c-b674-4d33-adeb-bc1ca09d45c3'),
 ('337', '61', '14', '1', 'en_gb', '15', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"127\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"128\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Balancing busy jobs and a home life is difficult enough, let alone trying to keep fit and healthy, so it doesn\'t take much to upset the equilibrium. However getting pain associated with your job, or preventing you from exercising easily can disrupt those scales making it harder to achieve everything you need to do. At Cathedral Physiotherapy we are here to help you improve any symptoms you may have so that you can get back to being superhuman! \\r\\n\\r\\nClick on the links below for examples of what we can help you with.\",\"77\":\"\",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Work and Social\",\"53\":[\"268\"]}}', '2015-12-08 15:21:44', '2015-12-08 15:21:44', '6b6ac357-ba04-4298-9529-e62ea4b077ff'),
 ('338', '63', '16', '1', 'en_gb', '18', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"18\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy in Exeter we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":[{\"col1\":\"Access self-help exercise leaflets from the Arthritis Research Council and CSP\",\"col2\":\"http:\\/\\/www.csp.org.uk\\/publications\\/exercise-advice-leaflets\"}],\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Lifetime Support\",\"53\":[\"266\"]}}', '2015-12-08 15:22:16', '2015-12-08 15:22:16', '843ea197-b98a-4fd3-a20a-95b946a0b6d3'),
 ('339', '62', '15', '1', 'en_gb', '14', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\",\"14\",\"30\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it... Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. \\r\\n\\r\\nClick on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"77\":[{\"col1\":\"The benefits of exercise - 23 1\\/2 hours\",\"col2\":\"https:\\/\\/youtu.be\\/aUaInS6HIGo\"}],\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Young and Active\",\"53\":[\"267\"]}}', '2015-12-08 15:22:24', '2015-12-08 15:22:24', '03821cc7-8dcc-4198-adcf-5e314d04ce9b'),
 ('340', '4', '3', '1', 'en_gb', '15', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":\"\",\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\n\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\" Exeter physio with 18 years of experience\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"339\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-08 15:23:33', '2015-12-08 15:23:33', 'cf756a27-2231-4d7c-8ac6-9f00a27f030e'),
 ('341', '5', '5', '1', 'en_gb', '12', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"To ensure your safety, Cathedral Physiotherapy is regulated and governed by the following bodies.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Full accredited Exeter Physio\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"277\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"275\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"271\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"270\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"279\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"276\"]}},\"98\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"273\"],\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":[\"274\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"282\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"283\"]}}}}}', '2015-12-08 15:27:06', '2015-12-08 15:27:06', '1c6249b2-6547-4d5f-8c53-416c16a033da'),
 ('342', '57', '8', '1', 'en_gb', '18', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy Exeter, we like to keep things simple. Therefore we only have two prices, regardless of the treatment you are having at the clinic: \\r\\n\\r\\nNew appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio treatment costs\",\"80\":[\"296\",\"233\"]}}', '2015-12-08 15:28:14', '2015-12-08 15:28:14', '37926460-0bec-4fd7-bc22-7bf68206e51d'),
 ('343', '8', '9', '1', 'en_gb', '11', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\nDirections: From Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\nParking: There is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\nBuses: We are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter, Devon based physio\",\"80\":[\"235\"]}}', '2015-12-08 15:28:44', '2015-12-08 15:28:44', '2735b0c1-d575-403e-9982-1f0de884a600'),
 ('344', '4', '3', '1', 'en_gb', '16', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":[\"226\",\"294\",\"235\",\"308\"],\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\n\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\" Exeter physio with 18 years of experience\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"339\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-08 15:29:25', '2015-12-08 15:29:25', '879e9ddf-a505-4ae2-a063-ca06d5b22d84'),
 ('345', '4', '3', '1', 'en_gb', '17', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":[\"226\",\"294\",\"235\",\"308\"],\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\n\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"Find out about Sarah Moore - highly qualified and enthusiastic psyotherapist with over 18 years experience of treating a range of complex conditions.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\" Exeter physio with 18 years of experience\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"339\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-08 16:20:59', '2015-12-08 16:20:59', '81c99bdc-dee6-4217-ab3d-98f7a3f67983'),
 ('346', '5', '5', '1', 'en_gb', '13', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"To ensure your safety, Cathedral Physiotherapy is regulated and governed by the following bodies.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"Accredited and regulated by the Chartered Society of Physiotherapy and other professional bodies to ensure your safety and well being.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Full accredited Exeter Physio\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"277\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"275\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"271\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"270\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"279\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"276\"]}},\"98\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"273\"],\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":[\"274\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"282\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"283\"]}}}}}', '2015-12-08 16:26:23', '2015-12-08 16:26:23', '7f21d91b-1c64-4c02-a75c-37d332a6e5fd'),
 ('347', '8', '9', '1', 'en_gb', '12', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\nDirections: From Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\nParking: There is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\nBuses: We are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"Find us in beautiful Southernhay, located close to the centre of Exeter only a short distance from the Historic Exeter Cathedral.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter, Devon based physio\",\"80\":[\"235\"]}}', '2015-12-08 16:34:44', '2015-12-08 16:34:44', '003ce8a4-9db7-493c-b8ad-b9758cf06a50'),
 ('348', '63', '16', '1', 'en_gb', '19', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"18\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy in Exeter we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":[{\"col1\":\"Access self-help exercise leaflets from the Arthritis Research Council and CSP\",\"col2\":\"http:\\/\\/www.csp.org.uk\\/publications\\/exercise-advice-leaflets\"}],\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"Our lifetime support means that, whatever your age or needs, we can give you the personalised treatment that you require to function better.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Lifetime Support\",\"53\":[\"266\"]}}', '2015-12-08 16:39:33', '2015-12-08 16:39:33', '7d1e804f-fcb2-4fa0-b3c9-1bc23181cb8a'),
 ('349', '47', '12', '1', 'en_gb', '10', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to our news page which includes information from self-help advice for what to do as soon as you\\u2019ve hurt yourself, and clips to watch, to topical items in the news. If something isn\\u2019t here that you would like to see, then please email us at enquiries@cathedralphysiotherapy.co.uk and we will do our best to respond to your suggestions.\",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"Get the latest news about what\'s happening at the practice, as well as get additional information and self-help advice.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Latest Physio News, Discussion and Advice\"}}', '2015-12-08 16:44:57', '2015-12-08 16:44:57', 'd4abdf3d-67c7-4c31-9917-9e925eb8bb86'),
 ('350', '57', '8', '1', 'en_gb', '19', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy Exeter, we like to keep things simple. Therefore we only have two prices, regardless of the treatment you are having at the clinic: \\r\\n\\r\\nNew appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"Get the latest news about what\'s happening at the practice, as well as get additional information and self-help advice.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio treatment costs\",\"80\":[\"296\",\"233\"]}}', '2015-12-08 16:47:04', '2015-12-08 16:47:04', 'e039041b-4c89-4bbf-b644-a77e694fbe88'),
 ('351', '58', '13', '1', 'en_gb', '19', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Don\'t take our word for it, hear from our clients what they think about us...\",\"6\":\"Testimonials\",\"31\":\"\",\"32\":\"Our testimonials page will tell you what our clients think about us at Cathedral Physiotherapy.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Reviews for Cathedral Physiotherapy\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffrees\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"James Pike\",\"location\":\"Exeter\",\"quote\":\"I had a couple of back problems a couple of months ago due to a cycling accident and went to Sarah for some help, she did a great job and wasn\'t bothered about working on me a few times in the week which was great. After a couple of visits it was all fixed and she gave me stretches to do for a month so the pain doesn\'t return. Sarah\'s great and well recommended! Thanks Sarah!\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Jenny Pestridge\",\"location\":\"Devon\",\"quote\":\"I recently visited Cathedral Physiotherapy, which is situated in a convenient city-centre location. I was treated by Sarah Moore. A high standard of care and treatment has resulted in an immediate improvement. I felt confident and reassured by Sarah\'s expertise, because of her thorough explanation of my condition, and appropriate treatment. I would rate my experience of Cathedral Physiotherapy as outstanding.\"}},\"225\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Nick Hitt\",\"location\":\"Exeter\",\"quote\":\"I found the whole experience at Cathedral Physiotherapy to be outstanding. Not only is it a picturesque location, easy access from the city centre, and nestled in a magnificent Georgian houses in Exeter\\u2019s Southernhay, but the service was exceptional. The clinic was exceptional clean, bright, well laid out and very welcoming. Sarah Moore, the physiotherapist, was simple brilliant. Her caring and professional attitude towards my diagnosis was superb. She made me feel at ease and able to convey my issues to her without any misunderstanding. She took an incredible amount of care and time to ensure she thoroughly understood my concerns. The treatment plan she produced was clear, easy to incorporate into my everyday life; it was like having a consultation from my very own private physiotherapist. If I have any niggles or issues in the future, you can be sure I will be visiting Cathedral Physiotherapist again.\"}}}}}', '2015-12-08 16:51:05', '2015-12-08 16:51:05', 'de6ecc2d-fce0-4813-9cce-df459fcbccf0'),
 ('352', '9', '10', '1', 'en_gb', '15', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment. \\r\\n\\r\\nClick the categories below to see how we can help you.\",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"Our treatments are based on a science based approach that looks at the whole person, ensuring that the patient is involved in their own care.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Expert treatments from experienced Exeter Physio\"}}', '2015-12-08 16:55:16', '2015-12-08 16:55:16', '5fd7ec3d-69a7-447b-ac22-bdf247bb8237'),
 ('353', '61', '14', '1', 'en_gb', '16', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"127\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"128\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Balancing busy jobs and a home life is difficult enough, let alone trying to keep fit and healthy, so it doesn\'t take much to upset the equilibrium. However getting pain associated with your job, or preventing you from exercising easily can disrupt those scales making it harder to achieve everything you need to do. At Cathedral Physiotherapy we are here to help you improve any symptoms you may have so that you can get back to being superhuman! \\r\\n\\r\\nClick on the links below for examples of what we can help you with.\",\"77\":\"\",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"Pain can curb to your working and social life. We are help to improve your symptoms, so you can get on with your daily life.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Work and Social\",\"53\":[\"268\"]}}', '2015-12-08 16:59:12', '2015-12-08 16:59:12', '6851cc5b-b0a2-42f1-8474-26caa9d7030e'),
 ('354', '62', '15', '1', 'en_gb', '15', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\",\"14\",\"30\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it... Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. \\r\\n\\r\\nClick on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"77\":[{\"col1\":\"The benefits of exercise - 23 1\\/2 hours\",\"col2\":\"https:\\/\\/youtu.be\\/aUaInS6HIGo\"}],\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"Even if you are young and active, injury can strike. We are here to help improve the situation.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Young and Active\",\"53\":[\"267\"]}}', '2015-12-08 17:02:20', '2015-12-08 17:02:20', 'ed15ac2c-03e3-46df-89b5-b502accb60fe'),
 ('355', '141', '2', '1', 'en_gb', '19', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"191\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"192\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"82\":\"1\",\"77\":\"\",\"31\":\"\",\"32\":\"Learn how to treat sprains and strains, quickly and effectively, in order to limit the pain and inconvenience.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Acupuncture Exeter\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-08 17:06:00', '2015-12-08 17:06:00', '76de1084-26f1-4463-bf6d-e79b59c9e9ab');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('356', '109', '2', '1', 'en_gb', '8', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Media comment: November\",\"slug\":\"media-comment-november\",\"postDate\":1448875380,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded \\u2018New Year Resolutions\\u2019. Why not take a longer term approach to your health rather than the \\u2018boom and bust\\u2019 which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!\",\"63\":{\"110\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"This November an article was published in Gerontology, reported in the media, which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect \\u2013 is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \\r\\n\\r\\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways \\u2013 heart, lungs, blood pressure, mental health, bone strength\\u2026.. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point. \\r\\n\\r\\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on\\u2026.give the family an exercise make over this year\\u2026..who knows, you might be reaping the benefits on those crosswords in years to come!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"111\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Media comment: November\",\"82\":\"\",\"77\":[{\"col1\":\"Related BBC News Article\",\"col2\":\" http:\\/\\/www.bbc.co.uk\\/news\\/health-34764693\"},{\"col1\":\"Related Daily Mail Article\",\"col2\":\"http:\\/\\/www.dailymail.co.uk\\/health\\/article-3311222\\/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html\"},{\"col1\":\"Related Guardian Article\",\"col2\":\"http:\\/\\/www.theguardian.com\\/uk-news\\/2015\\/nov\\/09\\/strong-legs-healthier-brain-in-old-age\"},{\"col1\":\"NHS fitness guide for adults\",\"col2\":\"http:\\/\\/www.nhs.uk\\/Livewell\\/fitness\\/Pages\\/physical-activity-guidelines-for-adults.aspx\"}],\"31\":\"\",\"32\":\"Take a long term approach to improving your health through taking up exercise and fitting it into your own lifestyle.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio Exeter advice on fitness\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2015-12-08 17:09:40', '2015-12-08 17:09:40', 'b9f32825-5ebe-48e3-8002-b6df1b01b326'),
 ('357', '99', '2', '1', 'en_gb', '19', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improved within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"82\":\"\",\"77\":\"\",\"31\":\"\",\"32\":\"Back pain can seriously impact your life. Learn what you need to know and what you should do when back pain strikes.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"How to help back pain\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"76\":[\"true\"],\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely), relaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-08 17:12:59', '2015-12-08 17:12:59', '27dd9d4e-79ee-48a5-a7eb-4362ff9641ec'),
 ('358', '4', '3', '1', 'en_gb', '18', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"81\":[\"226\",\"294\",\"235\",\"308\"],\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities delivered by Cathedral Physiotherapy.\\r\\n\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy.\",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"Find out about Sarah Moore - highly qualified and enthusiastic physiotherapist with over 18 years experience of treating a range of complex conditions.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\" Exeter physio with 18 years of experience\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"339\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-12-08 17:18:10', '2015-12-08 17:18:10', '477786e4-d733-48ea-b626-845925facf9a'),
 ('359', '5', '5', '1', 'en_gb', '14', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"To ensure your safety, Cathedral Physiotherapy is regulated and governed by the following bodies.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"Accredited and regulated by the Chartered Society of Physiotherapy and other professional bodies to ensure your safety and well being.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Full accredited Exeter Physio\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"277\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"275\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"271\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"270\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"279\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"276\"]}},\"98\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"273\"],\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":[\"274\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"282\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"283\"]}}}}}', '2015-12-08 17:18:30', '2015-12-08 17:18:30', '4ee3eca4-872d-4711-b47e-a376e1da9cec'),
 ('360', '5', '5', '1', 'en_gb', '15', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"To ensure your safety, Cathedral Physiotherapy is regulated and governed by the following bodies.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"Accredited and regulated by the Chartered Society of Physiotherapy and other professional bodies to ensure your safety and well being.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Full accredited Exeter Physio\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"277\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"275\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"271\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"270\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"279\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"276\"]}},\"98\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"273\"],\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":[\"274\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"282\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"283\"]}}}}}', '2015-12-08 17:18:34', '2015-12-08 17:18:34', 'd73853dd-9b35-4e2a-a2c6-b65778a07abd'),
 ('361', '8', '9', '1', 'en_gb', '13', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\nDirections: From Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\nParking: There is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\nBuses: We are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"Find us in beautiful Southernhay, located close to the centre of Exeter only a short distance from the historic Exeter Cathedral.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter, Devon based physio\",\"80\":[\"235\"]}}', '2015-12-08 17:18:58', '2015-12-08 17:18:58', 'de60ab85-abae-4ffe-8b7f-fe7858f7fc5f'),
 ('362', '8', '9', '1', 'en_gb', '14', '', '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447770025,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter Physio Sarah Moore. \\r\\n\\r\\nDirections: From Princess Hay, walk past Debenhams with it on your left and Crew clothing on your right. When you reach the main road turn right on to Southernhay West. We are based in the lower ground floor of number 22.\\r\\n\\r\\nParking: There is metered road side parking close to the clinic (1 hour maximum), or there are four car parks close by - Magdalen Street Car Park and Princess Hay amongst others.\\r\\n\\r\\nBuses: We are a 5-10 minute walk from the central bus station.\",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"Find us in beautiful Southernhay, located close to the centre of Exeter only a short distance from the historic Exeter Cathedral.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter, Devon based physio\",\"80\":[\"235\"]}}', '2015-12-08 17:19:00', '2015-12-08 17:19:00', 'c55472cc-9a18-480c-abc7-a49164aaaba5'),
 ('363', '63', '16', '1', 'en_gb', '20', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"18\"],\"70\":{\"121\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"122\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"123\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Sometimes we need a little bit of extra help to enable us to carry on our busy lives. Here at Cathedral Physiotherapy in Exeter we pride ourselves on being able to quickly determine what assistance you need to get back your function. Some people may need a longer course of treatment, but at other times it may be that you only need a one-off session of advice and modification to your regular exercise regime to get you back to where you want to be. \\r\\n\\r\\nClick on the conditions below for examples of what we can offer.\",\"77\":[{\"col1\":\"Access self-help exercise leaflets from the Arthritis Research Council and CSP\",\"col2\":\"http:\\/\\/www.csp.org.uk\\/publications\\/exercise-advice-leaflets\"}],\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"Our lifetime support means that, whatever your age or needs, we can give you the personalised treatment that you require to function better.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Lifetime Support\",\"53\":[\"266\"]}}', '2015-12-08 17:19:20', '2015-12-08 17:19:20', '4e946862-02ee-4c1f-87be-50760fd24b97'),
 ('364', '47', '12', '1', 'en_gb', '11', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to our news page which includes information from self-help advice for what to do as soon as you\\u2019ve hurt yourself, and clips to watch, to topical items in the news. If something isn\\u2019t here that you would like to see, then please email us at enquiries@cathedralphysiotherapy.co.uk and we will do our best to respond to your suggestions.\",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"Get the latest news about what\'s happening at the practice, as well as get additional information and a wealth of self-help advice.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Latest Physio News, Discussion and Advice\"}}', '2015-12-08 17:19:51', '2015-12-08 17:19:51', '5a9d0c26-4e6c-4777-a073-05b5e3b42bab'),
 ('365', '57', '8', '1', 'en_gb', '20', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"At Cathedral Physiotherapy Exeter, we like to keep things simple. Therefore we only have two prices, regardless of the treatment you are having at the clinic: \\r\\n\\r\\nNew appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"Learn more about our clear, simple and transparent pricing structure for all our treatments at the clinic.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio treatment costs\",\"80\":[\"296\",\"233\"]}}', '2015-12-08 17:20:34', '2015-12-08 17:20:34', 'd3efb49b-7656-4d36-a33e-c45ea8fd77f8'),
 ('366', '58', '13', '1', 'en_gb', '20', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Don\'t take our word for it, hear from our clients what they think about us...\",\"6\":\"Testimonials\",\"31\":\"\",\"32\":\"Read about what our clients think about us at Cathedral Physiotherapy. Our testimonials page will give you the information you need.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Reviews for Cathedral Physiotherapy\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffrees\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"James Pike\",\"location\":\"Exeter\",\"quote\":\"I had a couple of back problems a couple of months ago due to a cycling accident and went to Sarah for some help, she did a great job and wasn\'t bothered about working on me a few times in the week which was great. After a couple of visits it was all fixed and she gave me stretches to do for a month so the pain doesn\'t return. Sarah\'s great and well recommended! Thanks Sarah!\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Jenny Pestridge\",\"location\":\"Devon\",\"quote\":\"I recently visited Cathedral Physiotherapy, which is situated in a convenient city-centre location. I was treated by Sarah Moore. A high standard of care and treatment has resulted in an immediate improvement. I felt confident and reassured by Sarah\'s expertise, because of her thorough explanation of my condition, and appropriate treatment. I would rate my experience of Cathedral Physiotherapy as outstanding.\"}},\"225\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Nick Hitt\",\"location\":\"Exeter\",\"quote\":\"I found the whole experience at Cathedral Physiotherapy to be outstanding. Not only is it a picturesque location, easy access from the city centre, and nestled in a magnificent Georgian houses in Exeter\\u2019s Southernhay, but the service was exceptional. The clinic was exceptional clean, bright, well laid out and very welcoming. Sarah Moore, the physiotherapist, was simple brilliant. Her caring and professional attitude towards my diagnosis was superb. She made me feel at ease and able to convey my issues to her without any misunderstanding. She took an incredible amount of care and time to ensure she thoroughly understood my concerns. The treatment plan she produced was clear, easy to incorporate into my everyday life; it was like having a consultation from my very own private physiotherapist. If I have any niggles or issues in the future, you can be sure I will be visiting Cathedral Physiotherapist again.\"}}}}}', '2015-12-08 17:22:30', '2015-12-08 17:22:30', '71f28186-048c-4275-bc87-65517e24b997'),
 ('367', '9', '10', '1', 'en_gb', '16', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment. \\r\\n\\r\\nClick the categories below to see how we can help you.\",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"Our treatments are based on a science-based approach that looks at the whole person, ensuring that the patient is involved in their own care.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Expert treatments from experienced Exeter Physio\"}}', '2015-12-08 17:22:58', '2015-12-08 17:22:58', '5806a2c7-ae27-46f8-aa2c-2b7ae7a3bbe6'),
 ('368', '61', '14', '1', 'en_gb', '17', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"70\":{\"126\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"127\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\"}},\"128\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"Balancing busy jobs and a home life is difficult enough, let alone trying to keep fit and healthy, so it doesn\'t take much to upset the equilibrium. However getting pain associated with your job, or preventing you from exercising easily can disrupt those scales making it harder to achieve everything you need to do. At Cathedral Physiotherapy we are here to help you improve any symptoms you may have so that you can get back to being superhuman! \\r\\n\\r\\nClick on the links below for examples of what we can help you with.\",\"77\":\"\",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"Pain can curb both your working and social life. We are help to improve your symptoms, so you can get on and enjoy your daily life.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Work and Social\",\"53\":[\"268\"]}}', '2015-12-08 17:23:51', '2015-12-08 17:23:51', 'ca2fc30c-0109-43af-9421-f976a7ea3db7'),
 ('369', '62', '15', '1', 'en_gb', '16', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\",\"14\",\"30\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it... Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. \\r\\n\\r\\nClick on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"77\":[{\"col1\":\"The benefits of exercise - 23 1\\/2 hours\",\"col2\":\"https:\\/\\/youtu.be\\/aUaInS6HIGo\"}],\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"Even if you are young and active, injury can strike. We are here to help improve the situation and get you moving again.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Young and Active\",\"53\":[\"267\"]}}', '2015-12-08 17:24:55', '2015-12-08 17:24:55', '53274308-3846-4b53-a81f-57be726f435c'),
 ('370', '2', '1', '1', 'en_gb', '20', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio\\r\\n18+ Years Delivering Excellence\",\"31\":\"\",\"32\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 17:40:13', '2015-12-08 17:40:13', '6bbf720f-fe5a-42e8-80d8-74f625855d68'),
 ('371', '2', '1', '1', 'en_gb', '21', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio\\r\\n18+ Years Delivering Excellence\",\"31\":\"\",\"32\":\"We treat a wide range of problems through musculoskeletal physiotherapy and our pricing is competitive. Call 01392 434832\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2015-12-08 17:43:28', '2015-12-08 17:43:28', '811ffef8-a6cb-485a-bd91-af6b62bcdac0'),
 ('372', '58', '13', '124', 'en_gb', '21', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Don\'t take our word for it, hear from our clients what they think about us...\",\"6\":\"Testimonials\",\"31\":\"\",\"32\":\"Read about what our clients think about us at Cathedral Physiotherapy. Our testimonials page will give you the information you need.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Reviews for Cathedral Physiotherapy\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffrees\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"James Pike\",\"location\":\"Exeter\",\"quote\":\"I had a couple of back problems a couple of months ago due to a cycling accident and went to Sarah for some help, she did a great job and wasn\'t bothered about working on me a few times in the week which was great. After a couple of visits it was all fixed and she gave me stretches to do for a month so the pain doesn\'t return. Sarah\'s great and well recommended! Thanks Sarah!\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Jenny Pestridge\",\"location\":\"Devon\",\"quote\":\"I recently visited Cathedral Physiotherapy, which is situated in a convenient city-centre location. I was treated by Sarah Moore. A high standard of care and treatment has resulted in an immediate improvement. I felt confident and reassured by Sarah\'s expertise, because of her thorough explanation of my condition, and appropriate treatment. I would rate my experience of Cathedral Physiotherapy as outstanding.\"}},\"225\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Nick Hitt\",\"location\":\"Exeter\",\"quote\":\"I found the whole experience at Cathedral Physiotherapy to be outstanding. Not only is it a picturesque location, easy access from the city centre, and nestled in a magnificent Georgian houses in Exeter\\u2019s Southernhay, but the service was exceptional. The clinic was exceptional clean, bright, well laid out and very welcoming. Sarah Moore, the physiotherapist, was simple brilliant. Her caring and professional attitude towards my diagnosis was superb. She made me feel at ease and able to convey my issues to her without any misunderstanding. She took an incredible amount of care and time to ensure she thoroughly understood my concerns. The treatment plan she produced was clear, easy to incorporate into my everyday life; it was like having a consultation from my very own private physiotherapist. If I have any niggles or issues in the future, you can be sure I will be visiting Cathedral Physiotherapist again.\"}},\"new1\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Lucy \",\"location\":\"Devon\",\"quote\":\"Following years of sport induced back injury\\/pain and having seen a number of other physiotherapists, I had assumed that back pain was part of my life and to be managed. However Sarah Moore changed all that. Sarah listened fully to my history and made a thorough assessment leading to intervention and exercises. Through Sarah\'s experience and skill I am now back running and cycling and back pain is a thing of the past. I am thrilled with the professional and genuine care Sarah took while seeing her and I would highly recommend her. Particularly having seen other physios, Sarah was able to deal with a more complex issue resolving it fully.\"}}}}}', '2015-12-08 19:13:43', '2015-12-08 19:13:43', 'efef96f3-7652-4924-8ff5-404a69d05c50'),
 ('373', '58', '13', '124', 'en_gb', '22', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Don\'t take our word for it, hear from our clients what they think about us...\",\"6\":\"Testimonials\",\"31\":\"\",\"32\":\"Read about what our clients think about us at Cathedral Physiotherapy. Our testimonials page will give you the information you need.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Reviews for Cathedral Physiotherapy\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Caroline Jeffrees\",\"location\":\"Exeter\",\"quote\":\"Sarah has treated me three times over the last couple of years. She is professional, kind, caring and supportive. She has a friendly manner and explained the treatment I needed, answering all my questions clearly. She has great interpersonal skills\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"James Pike\",\"location\":\"Exeter\",\"quote\":\"I had a couple of back problems a couple of months ago due to a cycling accident and went to Sarah for some help, she did a great job and wasn\'t bothered about working on me a few times in the week which was great. After a couple of visits it was all fixed and she gave me stretches to do for a month so the pain doesn\'t return. Sarah\'s great and well recommended! Thanks Sarah!\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Jenny Pestridge\",\"location\":\"Devon\",\"quote\":\"I recently visited Cathedral Physiotherapy, which is situated in a convenient city-centre location. I was treated by Sarah Moore. A high standard of care and treatment has resulted in an immediate improvement. I felt confident and reassured by Sarah\'s expertise, because of her thorough explanation of my condition, and appropriate treatment. I would rate my experience of Cathedral Physiotherapy as outstanding.\"}},\"225\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Nick Hitt\",\"location\":\"Exeter\",\"quote\":\"I found the whole experience at Cathedral Physiotherapy to be outstanding. Not only is it a picturesque location, easy access from the city centre, and nestled in a magnificent Georgian houses in Exeter\\u2019s Southernhay, but the service was exceptional. The clinic was exceptional clean, bright, well laid out and very welcoming. Sarah Moore, the physiotherapist, was simple brilliant. Her caring and professional attitude towards my diagnosis was superb. She made me feel at ease and able to convey my issues to her without any misunderstanding. She took an incredible amount of care and time to ensure she thoroughly understood my concerns. The treatment plan she produced was clear, easy to incorporate into my everyday life; it was like having a consultation from my very own private physiotherapist. If I have any niggles or issues in the future, you can be sure I will be visiting Cathedral Physiotherapy again.\"}},\"351\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Lucy \",\"location\":\"Devon\",\"quote\":\"Following years of sport induced back injury\\/pain and having seen a number of other physiotherapists, I had assumed that back pain was part of my life and to be managed. However Sarah Moore changed all that. Sarah listened fully to my history and made a thorough assessment leading to intervention and exercises. Through Sarah\'s experience and skill I am now back running and cycling and back pain is a thing of the past. I am thrilled with the professional and genuine care Sarah took while seeing her and I would highly recommend her. Particularly having seen other physios, Sarah was able to deal with a more complex issue resolving it fully.\"}}}}}', '2015-12-08 19:25:20', '2015-12-08 19:25:20', '47653dba-dfb8-486b-ba13-680c72fd18ab'),
 ('374', '141', '2', '124', 'en_gb', '20', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1449267900,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"241\"],\"54\":\"What to do when you strain or sprain yourself\",\"63\":{\"142\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"We\'ve all done it.......\",\"sectionParagraph\":\"Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred, and following a few simple steps will help you get back to normal again.\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"143\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"PRICE\",\"sectionParagraph\":\"No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do\\u2026..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. \",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"191\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"192\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Sprains and Strains\",\"82\":\"1\",\"77\":\"\",\"31\":\"\",\"32\":\"Learn how to treat sprains and strains, quickly and effectively, in order to limit the pain and inconvenience.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Acupuncture Exeter\",\"69\":\"\",\"76\":[\"true\"],\"66\":{\"144\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Protect\",\"paragraph\":\"The first thing to do is protect the area, either by wearing a support, or taking the weight off the limb for a short time, possibly using a stick or crutches if necessary.\"}},\"145\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Rest\",\"paragraph\":\"Try to avoid activity that stresses the limb for the first 48-72 hrs.\\r\\n\"}},\"146\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Ice\",\"paragraph\":\"Apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin).\\r\\n\"}},\"147\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Compression\",\"paragraph\":\"Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow. Remove the bandage before sleep.\\r\\n\"}},\"148\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Elevation\",\"paragraph\":\"Elevate the injured area, supported on a pillow, to reduce the swelling.\\r\\n\"}}}}}', '2015-12-08 21:24:21', '2015-12-08 21:24:21', 'd86b3532-7e09-4cd2-9217-ec6b5e0b581d'),
 ('375', '109', '2', '124', 'en_gb', '9', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Media comment: November\",\"slug\":\"media-comment-november\",\"postDate\":1448875380,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"257\"],\"54\":\"As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded \\u2018New Year Resolutions\\u2019. Why not take a longer term approach to your health rather than the \\u2018boom and bust\\u2019 which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!\",\"63\":{\"110\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"This November an article was published in Gerontology, reported in the media, which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect \\u2013 is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \\r\\n\\r\\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways \\u2013 heart, lungs, blood pressure, mental health, bone strength\\u2026.. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point. \\r\\n\\r\\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on\\u2026.give the family an exercise make over this year\\u2026..who knows, you might be reaping the benefits on those crosswords in years to come!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"111\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Media comment: November\",\"82\":\"\",\"77\":[{\"col1\":\"Related BBC News Article\",\"col2\":\" http:\\/\\/www.bbc.co.uk\\/news\\/health-34764693\"},{\"col1\":\"Related Daily Mail Article\",\"col2\":\"http:\\/\\/www.dailymail.co.uk\\/health\\/article-3311222\\/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html\"},{\"col1\":\"Related Guardian Article\",\"col2\":\"http:\\/\\/www.theguardian.com\\/uk-news\\/2015\\/nov\\/09\\/strong-legs-healthier-brain-in-old-age\"},{\"col1\":\"NHS fitness guide for adults\",\"col2\":\"http:\\/\\/www.nhs.uk\\/Livewell\\/fitness\\/Pages\\/physical-activity-guidelines-for-adults.aspx\"}],\"31\":\"\",\"32\":\"Take a long term approach to improving your health through taking up exercise and fitting it into your own lifestyle.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio Exeter advice on fitness\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2015-12-08 21:25:21', '2015-12-08 21:25:21', 'f7f9516c-3ec2-487d-876b-8004ec2faae9'),
 ('376', '99', '2', '124', 'en_gb', '20', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"250\"],\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improved within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"82\":\"\",\"77\":\"\",\"31\":\"\",\"32\":\"Back pain can seriously impact your life. Learn what you need to know and what you should do when back pain strikes.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"How to help back pain\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"76\":[\"true\"],\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely), relaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-12-08 21:26:02', '2015-12-08 21:26:02', 'c10651db-dfa0-4d31-84f3-021d6cda87bf'),
 ('378', '62', '15', '124', 'en_gb', '17', '', '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1448274363,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"17\",\"16\",\"15\",\"18\",\"14\",\"30\",\"20\",\"26\",\"21\",\"24\",\"23\",\"25\"],\"70\":{\"129\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. \\r\\n\\r\\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"130\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"131\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"7\":\"We\'ve all done it... Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it\\u2019s occurred. \\r\\n\\r\\nClick on the links below for examples of what we can offer at Cathedral Physiotherapy.\",\"77\":[{\"col1\":\"The benefits of exercise - 23 1\\/2 hours\",\"col2\":\"https:\\/\\/youtu.be\\/aUaInS6HIGo\"}],\"6\":\"Young \\/ Active\",\"31\":\"\",\"32\":\"Even if you are young and active, injury can strike. We are here to help improve the situation and get you moving again.\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Physio for Young and Active\",\"53\":[\"267\"]}}', '2016-01-07 11:47:26', '2016-01-07 11:47:26', 'c30f8643-5f7c-4826-afb9-426c358a253c'),
 ('379', '356', '2', '124', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"124\",\"title\":\"10% Discount on initial assessments\",\"slug\":\"10-discount-on-initial-assessments\",\"postDate\":1452168531,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"355\"],\"54\":\"Cathedral Physiotherapy is pleased to announce that members of the Spa Naturel Fitness at The Mercure Southgate Hotel are eligible to receive a 10% discount off their initial assessment. To receive the discount follow the instructions below.\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"To receive the discount simply:\",\"sectionParagraph\":\"Highlight at the time of booking that you are a member of the Spa Naturel Fitness at the Mercure Hotel Southgate.\\r\\n\\r\\nBring proof of membership to your initial appointment.\",\"sectionImage\":[\"352\"],\"photoPosition\":\"\"}}},\"37\":\"10% Discount on initial assessments\",\"82\":\"\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2016-01-07 12:08:52', '2016-01-07 12:08:52', '9e3559bc-473b-4493-aeca-a15a1f94e6a4'),
 ('380', '356', '2', '124', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"10% Discount on initial assessments\",\"slug\":\"10-discount-on-initial-assessments\",\"postDate\":1452168480,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"355\"],\"54\":\"Cathedral Physiotherapy is pleased to announce that members of the Spa Naturel Fitness at The Mercure Southgate Hotel are eligible to receive a 10% discount off their initial assessment. To receive the discount follow the instructions below.\",\"63\":{\"357\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"To receive the discount simply:\",\"sectionParagraph\":\"Highlight at the time of booking that you are a member of the Spa Naturel Fitness at the Mercure Hotel Southgate.\\r\\n\\r\\nBring proof of membership to your initial appointment.\",\"sectionImage\":[\"352\"],\"photoPosition\":\"\"}}},\"37\":\"10% Discount on initial assessments\",\"82\":\"\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2016-01-07 12:19:35', '2016-01-07 12:19:35', '2832895f-1e39-4ce4-9477-ce653a82fc3e'),
 ('381', '356', '2', '1', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"10% Discount on initial assessments\",\"slug\":\"10-discount-on-initial-assessments\",\"postDate\":1452168480,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"355\"],\"54\":\"Cathedral Physiotherapy is pleased to announce that members of the Spa Naturel Fitness at The Mercure Southgate Hotel are eligible to receive a 10% discount off their initial assessment. To receive the discount follow the instructions below.\",\"63\":{\"357\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"To receive the discount simply:\",\"sectionParagraph\":\"Highlight at the time of booking that you are a member of the Spa Naturel Fitness at the Mercure Hotel Southgate.\\r\\n\\r\\nBring proof of membership to your initial appointment.\",\"sectionImage\":[\"352\"],\"photoPosition\":\"\"}}},\"37\":\"10% Discount on initial assessments\",\"82\":\"\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2016-01-12 11:35:14', '2016-01-12 11:35:14', 'c22785dc-c764-4f76-89b5-463cc7f414da'),
 ('382', '356', '2', '1', 'en_gb', '4', '', '{\"typeId\":\"2\",\"authorId\":\"124\",\"title\":\"10% Discount on initial assessments\",\"slug\":\"10-discount-on-initial-assessments\",\"postDate\":1452168480,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"355\"],\"54\":\"Cathedral Physiotherapy is pleased to announce that members of the Spa Naturel Fitness at The Mercure Southgate Hotel are eligible to receive a 10% discount off their initial assessment. To receive the discount follow the instructions below.\",\"63\":{\"357\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"To receive the discount simply:\",\"sectionParagraph\":\"Highlight at the time of booking that you are a member of the Spa Naturel Fitness at the Mercure Hotel Southgate.\\r\\n\\r\\nBring proof of membership to your initial appointment.\",\"sectionImage\":[\"358\"],\"photoPosition\":\"\"}}},\"37\":\"10% Discount on initial assessments\",\"82\":\"\",\"77\":\"\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2016-01-12 11:35:55', '2016-01-12 11:35:55', 'e9a6c13b-8d35-4610-a826-afba2582277d'),
 ('383', '360', '2', '125', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"125\",\"title\":\"Recent Advertorial in Exeter Living Jan 2016\",\"slug\":\"recent-advertorial-in-exeter-living-jan-2016\",\"postDate\":1452633512,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"359\"],\"54\":\"Cathedral Physiotherapy has recently featured in an advertorial in Exeter Living. Click below to read.\",\"63\":\"\",\"37\":\"Recent Advertorial in Exeter Living Jan 2016\",\"82\":\"\",\"77\":[{\"col1\":\"Exeter Living advertorial\",\"col2\":\"http:\\/\\/flickread.com\\/edition\\/PensordFreeLibrary\\/5669c3398db6c\\/\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2016-01-12 21:18:33', '2016-01-12 21:18:33', '5c6762bf-ce9c-4255-bfd5-9e67672a0d31'),
 ('384', '360', '2', '125', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"125\",\"title\":\"Recent Advertorial in Exeter Living Jan 2016\",\"slug\":\"recent-advertorial-in-exeter-living-jan-2016\",\"postDate\":1452633480,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"359\"],\"54\":\"Cathedral Physiotherapy has recently featured in an advertorial in Exeter Living. Click link below to read, page 28.\",\"63\":\"\",\"37\":\"Recent Advertorial in Exeter Living Jan 2016\",\"82\":\"\",\"77\":[{\"col1\":\"Exeter Living advertorial\",\"col2\":\"http:\\/\\/flickread.com\\/edition\\/PensordFreeLibrary\\/5669c3398db6c\\/\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2016-01-12 21:20:52', '2016-01-12 21:20:52', 'cd902b21-6887-44a9-bd36-d3d0b1e71d30'),
 ('385', '2', '1', '1', 'en_gb', '22', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"Welcome to Cathedral Physiotherapy, delivering excellence, experience, and enthusiasm in Exeter. Based in the leafy central location of Southernhay, Cathedral Physiotherapy is directed by the Exeter physio Sarah Moore, who has 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy. We treat a wide range of problems (see the treatment categories below for more information), and our pricing is competitive. For self-help information when you become injured, then go to our news page. \",\"6\":\"Experienced Exeter Physio\\r\\n18+ Years Delivering Excellence\",\"31\":\"\",\"32\":\"We treat a wide range of problems through musculoskeletal physiotherapy and our pricing is competitive. Call 01392 434832\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"Exeter Physio - Cathedral Physiotherapy, Devon\"}}', '2016-01-15 09:33:12', '2016-01-15 09:33:12', '672dbeab-6163-4158-9bd3-7728af603ae2'),
 ('386', '367', '2', '125', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"125\",\"title\":\"Private Health Insurance\",\"slug\":\"private-health-insurance\",\"postDate\":1455055300,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"365\"],\"54\":\"Cathedral Physiotherapy has \'Approved Provider\' status for various private health insurance companies\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Cathedral Physiotherapy is pleased to announce that is has obtained \'Approved Provider\' status for a variety of private health insurance companies including Bupa, WPA, MDG and Vitality health (previously known as Prudential Health). This means that individuals who have health insurance cover with policies that include physiotherapy, may be able to claim the cost of treatment under their policy (see your specific policy for details). If you have health insurance with a company not listed here then please contact the clinic, as we may still be able to treat you under this agreement, and if not then we are happy to treat you independently under our usual pricing system.\",\"sectionImage\":\"\",\"photoPosition\":[\"true\"]}},\"new2\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"new3\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"new4\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Private Health Insurance\",\"82\":\"\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2016-02-09 22:01:42', '2016-02-09 22:01:42', 'f1a1ce60-a91c-465b-9f60-97d2bf21ebe8'),
 ('387', '367', '2', '125', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"125\",\"title\":\"Private Health Insurance\",\"slug\":\"private-health-insurance\",\"postDate\":1455055260,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"38\":[\"365\"],\"54\":\"Cathedral Physiotherapy has \'Approved Provider\' status for various private health insurance companies\",\"63\":{\"368\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Cathedral Physiotherapy is pleased to announce that is has obtained \'Approved Provider\' status for a variety of private health insurance companies including Bupa, WPA, MDG and Vitality health (previously known as Prudential Health). This means that individuals who have health insurance cover with policies that include physiotherapy, may be able to claim the cost of treatment under their policy (see your specific policy for details). If you have health insurance with a company not listed here then please contact the clinic, as we may still be able to treat you under this agreement, and if not then we are happy to treat you independently under our usual pricing system.\",\"sectionImage\":\"\",\"photoPosition\":[\"true\"]}},\"369\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"370\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}},\"371\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\",\"sectionImage\":\"\",\"photoPosition\":\"\"}}},\"37\":\"Private Health Insurance\",\"82\":\"\",\"77\":[{\"col1\":\"\",\"col2\":\"\"}],\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"76\":\"\",\"66\":\"\"}}', '2016-02-09 22:01:56', '2016-02-09 22:01:56', '151a2ba2-6d12-447b-b669-0171d59c45b3');



DROP TABLE IF EXISTS `craft_fieldgroups`;


--
-- Schema for table `craft_fieldgroups`
--
CREATE TABLE `craft_fieldgroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_fieldgroups_name_unq_idx` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_fieldgroups`
--

INSERT INTO `craft_fieldgroups` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', 'Globals', '2015-11-04 11:36:31', '2015-11-10 16:29:13', '272b033f-a0e0-4bcc-8f8d-e3207cb4f1ff'),
 ('3', 'Generic fields', '2015-11-10 16:20:38', '2015-11-10 16:20:38', 'd1343a49-4a93-430c-9fc1-fdcd4041df48'),
 ('4', 'Homepage', '2015-11-10 16:20:48', '2015-11-10 16:20:48', '67fa5925-1a28-4be3-a403-96e8b7479bf3'),
 ('5', 'Testomonials', '2015-11-13 09:50:10', '2015-11-13 09:50:10', '1fe06795-06f0-4d93-8620-624e49c17b7f'),
 ('6', 'Treatments', '2015-11-13 09:50:22', '2015-11-13 09:50:22', 'cf7c62d3-048d-4699-a803-4b895571335f'),
 ('7', 'Quick Links', '2015-11-13 09:50:52', '2015-11-13 09:50:52', '8cfe3a34-4c46-4e83-97f3-c4249e375151'),
 ('8', 'News', '2015-11-13 09:51:14', '2015-11-13 09:51:14', '5aece28a-c561-4fe1-af6b-e2b708c12b81'),
 ('9', 'SEO', '2015-11-13 14:42:48', '2015-11-13 14:42:48', '1f425ab7-fb1f-47fb-9527-01893565c362'),
 ('10', 'About', '2015-11-17 11:08:30', '2015-11-17 11:08:30', '35fe8449-adad-43a4-acfb-04f57791e108'),
 ('11', 'Accreditations', '2015-11-25 13:52:39', '2015-11-25 13:52:39', '530128c1-ee4e-4d22-9210-2830910fef99');



DROP TABLE IF EXISTS `craft_fieldlayoutfields`;


--
-- Schema for table `craft_fieldlayoutfields`
--
CREATE TABLE `craft_fieldlayoutfields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `tabId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sortOrder` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_fieldlayoutfields_layoutId_fieldId_unq_idx` (`layoutId`,`fieldId`),
  KEY `craft_fieldlayoutfields_sortOrder_idx` (`sortOrder`),
  KEY `craft_fieldlayoutfields_tabId_fk` (`tabId`),
  KEY `craft_fieldlayoutfields_fieldId_fk` (`fieldId`)
) ENGINE=InnoDB AUTO_INCREMENT=673 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_fieldlayoutfields`
--

INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('9', '17', '5', '15', '1', '1', '2015-11-13 10:01:49', '2015-11-13 10:01:49', '17acaedf-b468-418c-a13d-6c8f31e78e39'),
 ('10', '17', '5', '16', '1', '2', '2015-11-13 10:01:49', '2015-11-13 10:01:49', '416d73a4-3aaa-4fd8-b9c5-193e25d255af'),
 ('11', '17', '5', '17', '1', '3', '2015-11-13 10:01:49', '2015-11-13 10:01:49', 'fe8afee8-f34c-4fe7-b81d-beb93b5a8f58'),
 ('46', '33', '16', '14', '0', '1', '2015-11-13 12:54:54', '2015-11-13 12:54:54', 'f55cf66f-3ce3-4886-90af-e41d3a804706'),
 ('108', '51', '36', '21', '0', '1', '2015-11-13 14:48:14', '2015-11-13 14:48:14', 'd61dbd8a-3ff1-430d-9e8c-b5e5025473d0'),
 ('109', '51', '36', '22', '0', '2', '2015-11-13 14:48:14', '2015-11-13 14:48:14', 'f05f8a5a-9417-4ac2-a0e5-b4020f6a5f20'),
 ('110', '51', '36', '23', '0', '3', '2015-11-13 14:48:14', '2015-11-13 14:48:14', 'a3949fa5-bafc-444d-9bef-15685a50e635'),
 ('111', '51', '36', '24', '0', '4', '2015-11-13 14:48:14', '2015-11-13 14:48:14', '19e4fc38-6588-4994-b730-6656ea8821c6'),
 ('161', '59', '50', '6', '0', '1', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '38bb6b24-665f-42e3-96fe-a0b8415e1050'),
 ('162', '59', '50', '7', '0', '2', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '43924a08-eb19-42ff-b456-729fbd677ee3'),
 ('163', '59', '51', '31', '0', '1', '2015-11-13 15:24:22', '2015-11-13 15:24:22', 'b1870f1c-f0dc-44ea-a35e-05ae76030a15'),
 ('164', '59', '51', '32', '0', '2', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '91a764e2-f091-4c02-9883-129c82dde9f3'),
 ('165', '59', '51', '35', '0', '3', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '9cdd0742-c8d1-4f03-9eec-accf2354c6dc'),
 ('166', '59', '51', '33', '0', '4', '2015-11-13 15:24:22', '2015-11-13 15:24:22', 'cc697aaa-13c4-4c0e-b147-145cec9ec1f3'),
 ('167', '59', '51', '34', '0', '5', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '0c4dbc18-fa61-46ca-96b0-64e65e3820ec'),
 ('193', '64', '59', '40', '1', '1', '2015-11-17 11:13:44', '2015-11-17 11:13:44', 'c227e402-c808-4e6d-b259-30d2949f4004'),
 ('194', '64', '59', '41', '1', '2', '2015-11-17 11:13:44', '2015-11-17 11:13:44', 'b316e4f5-36e8-41c2-b144-bcb66a48b444'),
 ('345', '92', '99', '6', '0', '1', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '1f83cd62-c087-4de0-ae43-60c0d6e97f76'),
 ('346', '92', '99', '7', '0', '2', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '2134c091-fde2-4117-91fd-24f7371ee416'),
 ('347', '92', '100', '34', '0', '1', '2015-11-23 16:50:06', '2015-11-23 16:50:06', 'da9477a9-6bec-4ab1-826e-34568c7b8226'),
 ('348', '92', '100', '32', '0', '2', '2015-11-23 16:50:06', '2015-11-23 16:50:06', 'd327eb1b-5813-4a5a-aa60-1afd52691419'),
 ('349', '92', '100', '35', '0', '3', '2015-11-23 16:50:06', '2015-11-23 16:50:06', 'e420b20d-efb0-4dd7-aee8-677ab27c2b40'),
 ('350', '92', '100', '33', '0', '4', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '72a3af84-e5ab-4c94-a3c9-039ef92b0662'),
 ('351', '92', '100', '31', '0', '5', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '49418f75-7fa4-4ad2-9d8c-2af29fd8dba3'),
 ('385', '97', '109', '6', '0', '1', '2015-11-23 16:51:51', '2015-11-23 16:51:51', 'a87db14a-6f01-491c-a9da-1a8c5ffe93b3'),
 ('386', '97', '109', '7', '0', '2', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '6a8f54a7-e10e-4e47-ac01-c6cd1e2dfb24'),
 ('387', '97', '110', '34', '0', '1', '2015-11-23 16:51:51', '2015-11-23 16:51:51', 'a5f94e4b-632e-4da8-b1af-cb9dfe251dc5'),
 ('388', '97', '110', '32', '0', '2', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '3429a028-27cd-4044-9bd0-1c6075672e58'),
 ('389', '97', '110', '35', '0', '3', '2015-11-23 16:51:51', '2015-11-23 16:51:51', 'aa28ca2b-bb3d-4a52-8659-6852e0b2a523'),
 ('390', '97', '110', '33', '0', '4', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '53ba7254-d836-45fa-872a-5c4aece150ce'),
 ('391', '97', '110', '31', '0', '5', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '2863e0e5-56f8-40ef-adc8-9aa1dc063e70'),
 ('425', '104', '119', '6', '0', '1', '2015-11-25 13:58:40', '2015-11-25 13:58:40', 'bfcf5857-6088-4264-8043-6d7de3112538'),
 ('426', '104', '119', '7', '0', '2', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '7469edad-e457-4501-9c8a-0b191305f9c4'),
 ('427', '104', '119', '58', '0', '3', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '295cc99b-52fb-418d-9419-d08575f4e18e'),
 ('428', '104', '120', '34', '0', '1', '2015-11-25 13:58:40', '2015-11-25 13:58:40', 'dec981e7-d725-4f00-a580-c09193fc5f53'),
 ('429', '104', '120', '32', '0', '2', '2015-11-25 13:58:40', '2015-11-25 13:58:40', 'f12f5c09-1c84-4437-b637-830e69100696'),
 ('430', '104', '120', '35', '0', '3', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '073d39e4-2927-4fe0-baaf-e6b2f2d62e98'),
 ('431', '104', '120', '33', '0', '4', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '92dfcab9-8db2-46be-9cba-833a2c4822fa'),
 ('432', '104', '120', '31', '0', '5', '2015-11-25 13:58:40', '2015-11-25 13:58:40', 'bca98e57-dfe7-4631-a095-cace92167f9b'),
 ('437', '106', '122', '59', '0', '1', '2015-11-25 14:19:53', '2015-11-25 14:19:53', 'cf3902fc-61a6-4a96-bfb3-fa8d637e8c5e'),
 ('438', '106', '122', '60', '1', '2', '2015-11-25 14:19:53', '2015-11-25 14:19:53', '0bc8c225-e1a9-4887-9922-c15fb1af2e8f'),
 ('439', '106', '122', '61', '0', '3', '2015-11-25 14:19:53', '2015-11-25 14:19:53', '50419906-5534-42e2-9231-62f5c3fc9b6a'),
 ('440', '106', '122', '62', '0', '4', '2015-11-25 14:19:53', '2015-11-25 14:19:53', '17132c58-0ad5-4fd1-8e01-55bf3898b85f'),
 ('441', '107', '123', '6', '0', '1', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '998c1d7b-c0dc-43aa-bb02-809216e39e91'),
 ('442', '107', '123', '7', '0', '2', '2015-11-25 15:15:43', '2015-11-25 15:15:43', 'd67b9c47-9535-4c45-af2b-b363de998cee'),
 ('443', '107', '123', '48', '0', '3', '2015-11-25 15:15:43', '2015-11-25 15:15:43', 'b3822d22-73af-4367-8556-965d0907a0ad'),
 ('444', '107', '124', '34', '0', '1', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '76ff5926-80ec-4bdf-925d-cdae20f0462f'),
 ('445', '107', '124', '32', '0', '2', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '28f30c5a-dcce-4f3f-bcec-c4e4a5966ada'),
 ('446', '107', '124', '35', '0', '3', '2015-11-25 15:15:43', '2015-11-25 15:15:43', 'f0957290-471d-4f02-8aac-a04d432c017d'),
 ('447', '107', '124', '33', '0', '4', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '78a4c9a8-ab04-4b3d-9dc4-3f3f157aa423'),
 ('448', '107', '124', '31', '0', '5', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '2b7cf3d7-f2ea-4bab-8fe5-7998a8ae9f83'),
 ('461', '110', '128', '67', '0', '1', '2015-11-26 14:23:00', '2015-11-26 14:23:00', 'a5c3db45-f6a9-4855-9150-53968f722a26'),
 ('462', '110', '128', '68', '0', '2', '2015-11-26 14:23:00', '2015-11-26 14:23:00', '362851be-8c47-4815-9065-f7d5eafe7f4f'),
 ('561', '122', '149', '73', '0', '1', '2015-12-04 10:05:14', '2015-12-04 10:05:14', '973839e7-b075-4dd7-8f0b-4cdb771b0487'),
 ('562', '122', '149', '74', '0', '2', '2015-12-04 10:05:14', '2015-12-04 10:05:14', 'db9c5fd8-6e2f-4407-bd34-c1690da511ba'),
 ('563', '122', '149', '8', '0', '3', '2015-12-04 10:05:14', '2015-12-04 10:05:14', 'ecb5562f-d008-471c-854b-d80c9245fc14'),
 ('564', '122', '149', '3', '0', '4', '2015-12-04 10:05:14', '2015-12-04 10:05:14', 'd20d0043-bf19-4dae-aaa2-be02bab67544'),
 ('565', '122', '149', '4', '0', '5', '2015-12-04 10:05:14', '2015-12-04 10:05:14', '932bb7f0-9c35-47a8-a467-15ac7eda6fe9'),
 ('566', '122', '149', '13', '0', '6', '2015-12-04 10:05:14', '2015-12-04 10:05:14', '914f11f3-d2f9-415f-b4d3-ccdeaf5fede3'),
 ('567', '122', '149', '5', '0', '7', '2015-12-04 10:05:14', '2015-12-04 10:05:14', '5a625eca-e57f-4e62-984d-9e835fc8912d'),
 ('568', '122', '149', '55', '0', '8', '2015-12-04 10:05:14', '2015-12-04 10:05:14', 'a935b361-a42d-429c-a8b6-5485f51a9c36'),
 ('569', '129', '150', '71', '0', '1', '2015-12-04 10:33:01', '2015-12-04 10:33:01', '85516808-ea5a-48df-989b-e95ae5e2c593'),
 ('570', '129', '150', '72', '0', '2', '2015-12-04 10:33:01', '2015-12-04 10:33:01', 'f878e8a2-9f7b-45e2-b85b-6fc1ed7e1483'),
 ('571', '130', '151', '49', '0', '1', '2015-12-04 10:33:29', '2015-12-04 10:33:29', 'e16f2147-516f-4c8f-86ae-cc73763f1307'),
 ('572', '130', '151', '50', '0', '2', '2015-12-04 10:33:29', '2015-12-04 10:33:29', 'c13ee2b6-43fa-4024-a40b-3f2e9613f22d'),
 ('573', '130', '151', '51', '0', '3', '2015-12-04 10:33:29', '2015-12-04 10:33:29', '33e936e6-83bf-4646-b76a-08ac2a9381bf'),
 ('574', '131', '152', '9', '1', '1', '2015-12-04 11:58:18', '2015-12-04 11:58:18', '54361ea5-bab8-4da7-bdc8-962899cb030d'),
 ('575', '131', '152', '10', '1', '2', '2015-12-04 11:58:18', '2015-12-04 11:58:18', 'bc23a232-d8ee-4d44-b8f5-693a1edc50db'),
 ('576', '131', '152', '11', '0', '3', '2015-12-04 11:58:18', '2015-12-04 11:58:18', '8e1751ab-b56c-4640-a124-3247b9af3999'),
 ('577', '131', '152', '75', '0', '4', '2015-12-04 11:58:18', '2015-12-04 11:58:18', 'e573718d-148f-4fb6-ac44-59c166118ffd'),
 ('578', '131', '152', '12', '1', '5', '2015-12-04 11:58:18', '2015-12-04 11:58:18', '8aca5b6a-4345-4af1-827c-a698e3ab891a'),
 ('579', '133', '153', '64', '0', '1', '2015-12-04 15:36:21', '2015-12-04 15:36:21', '64fee347-be73-4715-ae1d-e68e9721d4b7'),
 ('580', '133', '153', '65', '0', '2', '2015-12-04 15:36:21', '2015-12-04 15:36:21', 'fbe86707-8ea1-4af4-bd38-75795c400061'),
 ('581', '133', '153', '78', '0', '3', '2015-12-04 15:36:21', '2015-12-04 15:36:21', '39f80467-682a-4fec-bd4a-87ebf4096cc8'),
 ('582', '133', '153', '79', '0', '4', '2015-12-04 15:36:21', '2015-12-04 15:36:21', 'c006859d-3c29-4baa-a2e3-0721d41bf147'),
 ('596', '135', '156', '6', '0', '1', '2015-12-04 15:44:42', '2015-12-04 15:44:42', 'b2031281-d055-408f-a289-406bf5dfb8bb'),
 ('597', '135', '156', '7', '0', '2', '2015-12-04 15:44:42', '2015-12-04 15:44:42', '1ce187e8-4801-49b2-9140-349fba60500f'),
 ('598', '135', '156', '52', '0', '3', '2015-12-04 15:44:42', '2015-12-04 15:44:42', '78ee67ee-698b-49a2-9ff7-07bb1235dcd9'),
 ('599', '135', '156', '53', '0', '4', '2015-12-04 15:44:43', '2015-12-04 15:44:43', '35093169-5c5c-4d2e-af80-92ba7b87f272'),
 ('600', '135', '156', '70', '0', '5', '2015-12-04 15:44:43', '2015-12-04 15:44:43', '01d783fa-fd10-43ac-b27f-53ad508e03d0'),
 ('601', '135', '156', '77', '0', '6', '2015-12-04 15:44:43', '2015-12-04 15:44:43', 'ae173901-4254-46ed-972f-7f5948ee8798'),
 ('602', '135', '157', '34', '0', '1', '2015-12-04 15:44:43', '2015-12-04 15:44:43', 'b376ec07-af03-4bb6-b610-fb8d0c6505b8'),
 ('603', '135', '157', '32', '0', '2', '2015-12-04 15:44:43', '2015-12-04 15:44:43', '1b176acd-9031-450a-841d-a33f583699a4'),
 ('604', '135', '157', '35', '0', '3', '2015-12-04 15:44:43', '2015-12-04 15:44:43', 'dde60705-d60a-442f-947a-e10c251fb743'),
 ('605', '135', '157', '33', '0', '4', '2015-12-04 15:44:43', '2015-12-04 15:44:43', '4fae4ca8-22dd-4138-bea3-ec255797b365'),
 ('606', '135', '157', '31', '0', '5', '2015-12-04 15:44:43', '2015-12-04 15:44:43', '3b2600b0-af46-42b5-9e20-8bce3bd0b833'),
 ('607', '136', '158', '6', '0', '1', '2015-12-04 15:45:00', '2015-12-04 15:45:00', 'bd7f6f37-b003-468c-bef9-8a467b150063'),
 ('608', '136', '158', '7', '0', '2', '2015-12-04 15:45:00', '2015-12-04 15:45:00', '6ab6054f-8995-443d-9bf5-dced907dc90c'),
 ('609', '136', '158', '52', '0', '3', '2015-12-04 15:45:00', '2015-12-04 15:45:00', '63762512-fb2b-4526-b6e4-329e95c80990'),
 ('610', '136', '158', '53', '0', '4', '2015-12-04 15:45:00', '2015-12-04 15:45:00', 'd6cc0703-6edb-4391-82ec-ee3d6135156f'),
 ('611', '136', '158', '70', '0', '5', '2015-12-04 15:45:00', '2015-12-04 15:45:00', '0046d565-fd54-4a34-bf48-9fa4c37e642a'),
 ('612', '136', '158', '77', '0', '6', '2015-12-04 15:45:00', '2015-12-04 15:45:00', '638cc8cf-7fb4-4621-aefa-96f1fea69905'),
 ('613', '136', '159', '34', '0', '1', '2015-12-04 15:45:00', '2015-12-04 15:45:00', '11b4cde3-2b66-48d3-bd27-ab40543aeeb9'),
 ('614', '136', '159', '32', '0', '2', '2015-12-04 15:45:00', '2015-12-04 15:45:00', '014e9321-f8a4-4800-addb-143ceea3b1dc'),
 ('615', '136', '159', '35', '0', '3', '2015-12-04 15:45:00', '2015-12-04 15:45:00', 'f20c9f00-f30a-4120-8a8c-94a4baba6a54'),
 ('616', '136', '159', '33', '0', '4', '2015-12-04 15:45:00', '2015-12-04 15:45:00', '5924e27e-86b9-4220-80a3-6bc19d02ae17'),
 ('617', '136', '159', '31', '0', '5', '2015-12-04 15:45:00', '2015-12-04 15:45:00', '03318c80-d010-4e96-8a6d-f386f7b4c478'),
 ('618', '137', '160', '6', '0', '1', '2015-12-04 15:45:12', '2015-12-04 15:45:12', '6999f668-2c13-450e-a3d7-87af094d3e7d'),
 ('619', '137', '160', '7', '0', '2', '2015-12-04 15:45:12', '2015-12-04 15:45:12', '0f89e015-ba14-4da1-a278-30588a157c3c'),
 ('620', '137', '160', '52', '0', '3', '2015-12-04 15:45:12', '2015-12-04 15:45:12', 'fabb349c-886d-45c0-b4f4-f3f298335141');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('621', '137', '160', '53', '0', '4', '2015-12-04 15:45:12', '2015-12-04 15:45:12', '3cb579e4-19aa-4d7e-8c96-20ba3f24ff89'),
 ('622', '137', '160', '70', '0', '5', '2015-12-04 15:45:12', '2015-12-04 15:45:12', '96a01c25-0d92-4dfd-a61a-030aed1fb35e'),
 ('623', '137', '160', '77', '0', '6', '2015-12-04 15:45:12', '2015-12-04 15:45:12', 'd751b5f9-cf3c-4827-82de-374b7d567fb9'),
 ('624', '137', '161', '34', '0', '1', '2015-12-04 15:45:12', '2015-12-04 15:45:12', '69a774aa-dde2-4d05-9575-a788d3498ec3'),
 ('625', '137', '161', '32', '0', '2', '2015-12-04 15:45:12', '2015-12-04 15:45:12', '081bbec5-d727-4ec5-b952-f6037b928393'),
 ('626', '137', '161', '35', '0', '3', '2015-12-04 15:45:12', '2015-12-04 15:45:12', '8f3bb7b1-5002-4b06-935d-0e563ff4a951'),
 ('627', '137', '161', '33', '0', '4', '2015-12-04 15:45:12', '2015-12-04 15:45:12', 'ae7b83fe-b609-46c4-b716-d979f7c37afc'),
 ('628', '137', '161', '31', '0', '5', '2015-12-04 15:45:12', '2015-12-04 15:45:12', '8b31cd21-6166-4371-9011-c7706a76e29c'),
 ('629', '138', '162', '6', '0', '1', '2015-12-04 15:49:57', '2015-12-04 15:49:57', '97d21a8e-aabf-4074-899e-57dd86f9dc29'),
 ('630', '138', '162', '7', '0', '2', '2015-12-04 15:49:57', '2015-12-04 15:49:57', 'a89e9d86-1c0f-4548-9ba0-de90a76dd5fc'),
 ('631', '138', '162', '80', '0', '3', '2015-12-04 15:49:57', '2015-12-04 15:49:57', '3871ea89-8766-4a41-b6ab-ff75d3fc0702'),
 ('632', '138', '163', '34', '0', '1', '2015-12-04 15:49:57', '2015-12-04 15:49:57', '162d3e20-1718-4382-9abc-394e11d65add'),
 ('633', '138', '163', '32', '0', '2', '2015-12-04 15:49:57', '2015-12-04 15:49:57', '9aa3b2fc-b5a3-4a75-84e7-ee31c8fb574a'),
 ('634', '138', '163', '35', '0', '3', '2015-12-04 15:49:57', '2015-12-04 15:49:57', '721182cf-a483-4958-9198-de9a30a14ebc'),
 ('635', '138', '163', '33', '0', '4', '2015-12-04 15:49:57', '2015-12-04 15:49:57', '9690e5c7-921c-4a70-9cbf-7721eeec4127'),
 ('636', '138', '163', '31', '0', '5', '2015-12-04 15:49:57', '2015-12-04 15:49:57', '2ec742db-94bd-418f-97b6-cc2677449a8e'),
 ('637', '139', '164', '6', '0', '1', '2015-12-04 15:50:26', '2015-12-04 15:50:26', '87b7d0da-ac51-485a-8cde-103fdf22dd25'),
 ('638', '139', '164', '7', '0', '2', '2015-12-04 15:50:26', '2015-12-04 15:50:26', '887ef97a-a36d-42aa-998e-4f2b7273644d'),
 ('639', '139', '164', '80', '0', '3', '2015-12-04 15:50:26', '2015-12-04 15:50:26', '395d5f2b-7035-448d-a7d8-d393e69b3f19'),
 ('640', '139', '165', '34', '0', '1', '2015-12-04 15:50:26', '2015-12-04 15:50:26', '95fa7475-da11-4e73-bbed-4781757b43d8'),
 ('641', '139', '165', '32', '0', '2', '2015-12-04 15:50:26', '2015-12-04 15:50:26', '54a78a99-1d36-429b-82be-f59ee5ec142c'),
 ('642', '139', '165', '35', '0', '3', '2015-12-04 15:50:26', '2015-12-04 15:50:26', '79053c48-9b5a-4118-8c01-7221529560dc'),
 ('643', '139', '165', '33', '0', '4', '2015-12-04 15:50:26', '2015-12-04 15:50:26', 'e3709deb-ef92-464e-ab62-5f885dba5dc7'),
 ('644', '139', '165', '31', '0', '5', '2015-12-04 15:50:26', '2015-12-04 15:50:26', 'e5dba2eb-0745-43a2-bba2-1e257e27fb5f'),
 ('645', '140', '166', '6', '0', '1', '2015-12-04 15:50:57', '2015-12-04 15:50:57', 'fe5493bb-117b-4d29-8e18-af0280138ccf'),
 ('646', '140', '166', '7', '0', '2', '2015-12-04 15:50:57', '2015-12-04 15:50:57', 'ef55c87f-3a5f-4cc6-81f8-05cea5db101c'),
 ('647', '140', '166', '39', '0', '3', '2015-12-04 15:50:57', '2015-12-04 15:50:57', '836046d3-e972-4737-b1f8-196b03a09958'),
 ('648', '140', '166', '42', '0', '4', '2015-12-04 15:50:57', '2015-12-04 15:50:57', '8fb0714e-7cbc-4152-9aaa-17783de4eb4e'),
 ('649', '140', '166', '81', '0', '5', '2015-12-04 15:50:57', '2015-12-04 15:50:57', '86ea2c8c-ef3b-4232-829d-2f731c057c4b'),
 ('650', '140', '167', '34', '0', '1', '2015-12-04 15:50:57', '2015-12-04 15:50:57', 'ebe68af6-b793-413b-bbfd-0d70fed225b6'),
 ('651', '140', '167', '32', '0', '2', '2015-12-04 15:50:57', '2015-12-04 15:50:57', 'ab90d8f3-5d74-487a-8903-bf33a1f786c8'),
 ('652', '140', '167', '35', '0', '3', '2015-12-04 15:50:57', '2015-12-04 15:50:57', '5d356132-bcaf-4836-ad04-65949df6ea4f'),
 ('653', '140', '167', '33', '0', '4', '2015-12-04 15:50:57', '2015-12-04 15:50:57', '2a15053b-0172-4e45-8bce-4002a7f20509'),
 ('654', '140', '167', '31', '0', '5', '2015-12-04 15:50:57', '2015-12-04 15:50:57', 'e408f291-b133-4eae-a069-5fefa23a8eb5'),
 ('655', '142', '168', '47', '1', '1', '2015-12-04 16:37:12', '2015-12-04 16:37:12', '7df9706b-609b-43ce-8580-0339d497404c'),
 ('656', '142', '168', '43', '1', '2', '2015-12-04 16:37:12', '2015-12-04 16:37:12', 'd4d5a55e-1501-458e-b908-c667e77a0aba'),
 ('657', '142', '168', '44', '1', '3', '2015-12-04 16:37:12', '2015-12-04 16:37:12', 'd9ac20c5-20ce-4bfc-9064-a52b773ca678'),
 ('658', '142', '168', '45', '1', '4', '2015-12-04 16:37:12', '2015-12-04 16:37:12', '0326b5d7-5c2f-40ea-80ad-36d3263f7bef'),
 ('659', '143', '169', '37', '0', '1', '2015-12-07 12:25:59', '2015-12-07 12:25:59', 'cd01d7eb-a489-4ecf-b112-cc1d395aaaff'),
 ('660', '143', '169', '54', '0', '2', '2015-12-07 12:25:59', '2015-12-07 12:25:59', '3680a2e6-2028-44fd-9531-8ac224a7f70b'),
 ('661', '143', '169', '63', '0', '3', '2015-12-07 12:25:59', '2015-12-07 12:25:59', '340255cb-6999-4503-96fc-e7730ea32ce3'),
 ('662', '143', '169', '82', '0', '4', '2015-12-07 12:25:59', '2015-12-07 12:25:59', '472999e8-54ff-4595-aab2-86202e71cfcd'),
 ('663', '143', '169', '66', '0', '5', '2015-12-07 12:25:59', '2015-12-07 12:25:59', '2fab3b80-6f2a-4565-8490-f97e291b6222'),
 ('664', '143', '169', '76', '0', '6', '2015-12-07 12:25:59', '2015-12-07 12:25:59', '703051eb-553e-402c-8d6c-f07bcdd2a5f6'),
 ('665', '143', '169', '69', '0', '7', '2015-12-07 12:25:59', '2015-12-07 12:25:59', '9d189269-26ec-4267-b3b1-2294aa7c5965'),
 ('666', '143', '169', '38', '0', '8', '2015-12-07 12:25:59', '2015-12-07 12:25:59', 'e468aad1-d21a-4499-864c-f10be2f35e7a'),
 ('667', '143', '169', '77', '0', '9', '2015-12-07 12:25:59', '2015-12-07 12:25:59', 'cad45ea7-a1ec-418d-8465-67597dbb2882'),
 ('668', '143', '170', '34', '0', '1', '2015-12-07 12:25:59', '2015-12-07 12:25:59', '33f11cf9-4dd4-4468-b304-5d8946c59386'),
 ('669', '143', '170', '32', '0', '2', '2015-12-07 12:25:59', '2015-12-07 12:25:59', 'a66654c8-11a8-48d7-aecd-7d4c72534698'),
 ('670', '143', '170', '35', '0', '3', '2015-12-07 12:25:59', '2015-12-07 12:25:59', '06bdf494-8664-423a-aafa-b2dea9b4d77b'),
 ('671', '143', '170', '33', '0', '4', '2015-12-07 12:25:59', '2015-12-07 12:25:59', '92fcef2a-c4dc-4825-9aa0-5422cd78f027'),
 ('672', '143', '170', '31', '0', '5', '2015-12-07 12:25:59', '2015-12-07 12:25:59', '03d11bdb-cd11-4db2-91eb-87707e64970d');



DROP TABLE IF EXISTS `craft_fieldlayouts`;


--
-- Schema for table `craft_fieldlayouts`
--
CREATE TABLE `craft_fieldlayouts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_fieldlayouts_type_idx` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_fieldlayouts`
--

INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', 'Tag', '2015-11-04 11:36:31', '2015-11-04 11:36:31', '4e874080-8e70-48f4-ac2c-50506a61ae23'),
 ('7', 'Entry', '2015-11-10 16:23:51', '2015-11-10 16:23:51', '17c4d114-317a-412a-99f9-a743f7dce435'),
 ('9', 'Entry', '2015-11-10 16:25:04', '2015-11-10 16:25:04', '744c9133-0c14-4451-adbc-9b601190e710'),
 ('17', 'MatrixBlock', '2015-11-13 10:01:49', '2015-11-13 10:01:49', '8fbf4d1e-eb86-4684-b697-5190ffe36e9a'),
 ('33', 'GlobalSet', '2015-11-13 12:54:54', '2015-11-13 12:54:54', '523c6cea-d541-42a7-9ebf-21bff6c4e7ae'),
 ('37', 'Entry', '2015-11-13 14:15:51', '2015-11-13 14:15:51', '03134d53-fe9e-4dcf-af36-35d17ce8e49f'),
 ('51', 'Entry', '2015-11-13 14:48:14', '2015-11-13 14:48:14', '43cee39a-ee1a-4dd0-aab1-7905e10b6584'),
 ('59', 'Entry', '2015-11-13 15:24:22', '2015-11-13 15:24:22', 'dcc69eda-b162-40a6-a206-35fd3cec4277'),
 ('64', 'MatrixBlock', '2015-11-17 11:13:44', '2015-11-17 11:13:44', '3553fa39-7e0f-449e-bd71-9eb6011e36ae'),
 ('92', 'Entry', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '771e1734-6d78-450a-ab8e-699521e57a45'),
 ('97', 'Entry', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '878fefca-f7ed-42fc-9064-5ac2a1a826b2'),
 ('104', 'Entry', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '4cafc6d3-98b9-4161-865d-c71ed0b6d429'),
 ('106', 'MatrixBlock', '2015-11-25 14:19:53', '2015-11-25 14:19:53', 'b4389e31-66f8-4604-9ef1-d5f624670494'),
 ('107', 'Entry', '2015-11-25 15:15:43', '2015-11-25 15:15:43', 'd5efcb9a-b252-4d06-ae80-d512245aba34'),
 ('110', 'MatrixBlock', '2015-11-26 14:23:00', '2015-11-26 14:23:00', 'db67af69-da41-4a02-9175-3ed75c2b6a59'),
 ('122', 'GlobalSet', '2015-12-04 10:05:14', '2015-12-04 10:05:14', '641453d8-ba22-41de-acc9-28612a5a6958'),
 ('125', 'Asset', '2015-12-04 10:22:08', '2015-12-04 10:22:08', '9c36defb-9928-4752-83bf-954d1f6f9bfd'),
 ('126', 'Asset', '2015-12-04 10:22:16', '2015-12-04 10:22:16', '9cebaf1c-16ed-4deb-89a1-1734315445d8'),
 ('127', 'Asset', '2015-12-04 10:22:21', '2015-12-04 10:22:21', '0e45a478-cb91-47a1-814b-f7b8ccbf0389'),
 ('128', 'Asset', '2015-12-04 10:22:32', '2015-12-04 10:22:32', '307f523e-32c2-4d49-95ed-376b0201655d'),
 ('129', 'MatrixBlock', '2015-12-04 10:33:01', '2015-12-04 10:33:01', 'adff7617-a7b5-484e-9d43-0480c96470a0'),
 ('130', 'MatrixBlock', '2015-12-04 10:33:29', '2015-12-04 10:33:29', '0a46169f-b7ad-466e-a4ce-0faf61d62689'),
 ('131', 'MatrixBlock', '2015-12-04 11:58:18', '2015-12-04 11:58:18', '11c57231-dec3-4af6-866b-1a8e895b731b'),
 ('132', 'Asset', '2015-12-04 15:30:16', '2015-12-04 15:30:16', '3aec1e23-1d82-4e4d-97a2-b85ed3a47f8a'),
 ('133', 'MatrixBlock', '2015-12-04 15:36:21', '2015-12-04 15:36:21', '21612e88-21dc-4414-8b25-1b2093f3c319'),
 ('135', 'Entry', '2015-12-04 15:44:42', '2015-12-04 15:44:42', 'ca555376-c482-410d-bfad-158a2ec7d353'),
 ('136', 'Entry', '2015-12-04 15:45:00', '2015-12-04 15:45:00', '10306875-3073-4f42-8f2b-7c991e2c77df'),
 ('137', 'Entry', '2015-12-04 15:45:12', '2015-12-04 15:45:12', 'f4878a1b-53c4-49e7-820d-4f62357ffcb9'),
 ('138', 'Entry', '2015-12-04 15:49:57', '2015-12-04 15:49:57', '2e2eaaf4-cd4d-4283-b17c-ecb551c8b01f'),
 ('139', 'Entry', '2015-12-04 15:50:26', '2015-12-04 15:50:26', '453bf12d-d4b0-4106-9e1d-2d0a6d061132'),
 ('140', 'Entry', '2015-12-04 15:50:57', '2015-12-04 15:50:57', 'e6a34026-512a-4882-b8e9-e727ba650d3d'),
 ('141', 'Asset', '2015-12-04 16:36:37', '2015-12-04 16:36:37', 'febec02f-e939-46f2-a5a5-359d7ac450a6'),
 ('142', 'MatrixBlock', '2015-12-04 16:37:12', '2015-12-04 16:37:12', '68bb7dd1-60e0-4c34-bb12-c110309ad9fb'),
 ('143', 'Entry', '2015-12-07 12:25:59', '2015-12-07 12:25:59', 'e9ee660d-76f3-49bf-9804-38a936164fa8');



DROP TABLE IF EXISTS `craft_fieldlayouttabs`;


--
-- Schema for table `craft_fieldlayouttabs`
--
CREATE TABLE `craft_fieldlayouttabs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_fieldlayouttabs_sortOrder_idx` (`sortOrder`),
  KEY `craft_fieldlayouttabs_layoutId_fk` (`layoutId`)
) ENGINE=InnoDB AUTO_INCREMENT=171 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_fieldlayouttabs`
--

INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('5', '17', 'Content', '1', '2015-11-13 10:01:49', '2015-11-13 10:01:49', 'cf4e9fd8-438e-4812-ac6d-127a3e3d9d6a'),
 ('16', '33', 'Content', '1', '2015-11-13 12:54:54', '2015-11-13 12:54:54', '6e3d452b-3141-4812-baa6-d4371a4e79e9'),
 ('18', '37', 'Testomonials', '1', '2015-11-13 14:15:51', '2015-11-13 14:15:51', 'dabeb776-5db7-44dc-9e13-227b603be856'),
 ('36', '51', 'Treatment Details', '1', '2015-11-13 14:48:14', '2015-11-13 14:48:14', '1a1c204d-150a-472e-ad48-874e40c6410a'),
 ('50', '59', 'Content', '1', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '45275e5b-9dd0-47a8-a5c1-00309b0ff318'),
 ('51', '59', 'SEO', '2', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '73b2303d-69cb-4cfd-ae11-c535a7fab5e6'),
 ('59', '64', 'Content', '1', '2015-11-17 11:13:44', '2015-11-17 11:13:44', '7bb58a32-a9fe-4a73-904a-3cc85986195a'),
 ('99', '92', 'Content', '1', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '4e83b470-c50c-47c3-8f9f-1c0e0feea6b9'),
 ('100', '92', 'SEO', '2', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '46112622-68a1-498b-95cb-5206a108c172'),
 ('109', '97', 'Content', '1', '2015-11-23 16:51:51', '2015-11-23 16:51:51', 'd99bb4ab-661c-48a2-bc49-1122ad8bdab0'),
 ('110', '97', 'SEO', '2', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '9e9ae599-829d-4a14-b49c-355775a7a6bd'),
 ('119', '104', 'Content', '1', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '10a22ca6-26fd-492f-bd0b-01727e521e0a'),
 ('120', '104', 'SEO', '2', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '09afe172-b450-43a8-836b-52ecb6677cfc'),
 ('122', '106', 'Content', '1', '2015-11-25 14:19:53', '2015-11-25 14:19:53', 'bca2e31b-d176-42ed-94dd-3ff958c0f8a7'),
 ('123', '107', 'Content', '1', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '5b5db14b-a836-4c84-a79d-32838a292f05'),
 ('124', '107', 'SEO', '2', '2015-11-25 15:15:43', '2015-11-25 15:15:43', 'dac637f8-6ce2-4558-8439-051f682d7713'),
 ('128', '110', 'Content', '1', '2015-11-26 14:23:00', '2015-11-26 14:23:00', '5efa9806-2920-4807-b80f-16ac354db28a'),
 ('149', '122', 'Content', '1', '2015-12-04 10:05:14', '2015-12-04 10:05:14', '37dc1875-8859-49be-bece-6183af3f188f'),
 ('150', '129', 'Content', '1', '2015-12-04 10:33:01', '2015-12-04 10:33:01', 'f2e0acf3-223d-4e62-80f9-30a0877fb5e5'),
 ('151', '130', 'Content', '1', '2015-12-04 10:33:29', '2015-12-04 10:33:29', 'e1a8eb7c-96b1-474a-bde2-5de4ef50c863'),
 ('152', '131', 'Content', '1', '2015-12-04 11:58:18', '2015-12-04 11:58:18', '3c823e3b-70dd-41c9-8a62-2e1564ddcc2a'),
 ('153', '133', 'Content', '1', '2015-12-04 15:36:21', '2015-12-04 15:36:21', 'b7accc56-f8d3-4e40-990f-b186c0f3e128'),
 ('156', '135', 'Generic fields', '1', '2015-12-04 15:44:42', '2015-12-04 15:44:42', 'add879cc-3b3b-4f2e-bef0-504ce5abd5d6'),
 ('157', '135', 'SEO', '2', '2015-12-04 15:44:43', '2015-12-04 15:44:43', '7b55498f-5f80-48b2-927b-cb164f40f1bf'),
 ('158', '136', 'Generic fields', '1', '2015-12-04 15:45:00', '2015-12-04 15:45:00', '4b76823f-5e08-4404-9459-4d58dec5c783'),
 ('159', '136', 'SEO', '2', '2015-12-04 15:45:00', '2015-12-04 15:45:00', 'b5654043-88d8-42b8-8702-c7998b2e998a'),
 ('160', '137', 'Generic fields', '1', '2015-12-04 15:45:12', '2015-12-04 15:45:12', '3e8ef019-721e-4b05-a915-307bc847ef38'),
 ('161', '137', 'SEO', '2', '2015-12-04 15:45:12', '2015-12-04 15:45:12', 'ff7d6cfa-d5d7-45f4-84d2-1e836fa7cdce'),
 ('162', '138', 'Content', '1', '2015-12-04 15:49:57', '2015-12-04 15:49:57', '976c07bd-f880-40d6-85d1-80b7ef1f0b6b'),
 ('163', '138', 'SEO', '2', '2015-12-04 15:49:57', '2015-12-04 15:49:57', 'c6e1628d-2786-4d97-9ac9-09d793011dbf'),
 ('164', '139', 'Generic fields', '1', '2015-12-04 15:50:26', '2015-12-04 15:50:26', '762e815c-6b38-486d-bc9b-a0fed13fa74a'),
 ('165', '139', 'SEO', '2', '2015-12-04 15:50:26', '2015-12-04 15:50:26', '67c1355e-ee75-4e68-92cf-dd97bece10b3'),
 ('166', '140', 'Content', '1', '2015-12-04 15:50:57', '2015-12-04 15:50:57', '967fd824-1fe0-4bfb-9d98-542389a1e98e'),
 ('167', '140', 'SEO', '2', '2015-12-04 15:50:57', '2015-12-04 15:50:57', '256c8b7b-a471-4469-adcb-585c1f59be4d'),
 ('168', '142', 'Content', '1', '2015-12-04 16:37:12', '2015-12-04 16:37:12', 'd064e65c-3c5e-4e92-8faf-68c5505c874d'),
 ('169', '143', 'News', '1', '2015-12-07 12:25:59', '2015-12-07 12:25:59', 'f2085878-639d-4303-a525-50c21e20d371'),
 ('170', '143', 'SEO', '2', '2015-12-07 12:25:59', '2015-12-07 12:25:59', 'bcdc004e-6216-4f99-9d96-2a0a2fc3e9f9');



DROP TABLE IF EXISTS `craft_fields`;


--
-- Schema for table `craft_fields`
--
CREATE TABLE `craft_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(58) COLLATE utf8_unicode_ci NOT NULL,
  `context` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'global',
  `instructions` text COLLATE utf8_unicode_ci,
  `translatable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `settings` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_fields_handle_context_unq_idx` (`handle`,`context`),
  KEY `craft_fields_context_idx` (`context`),
  KEY `craft_fields_groupId_fk` (`groupId`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_fields`
--

INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('3', '1', 'Telephone', 'telephone', 'global', '', '0', 'PlainText', '{\"placeholder\":\"01382 123 456\",\"maxLength\":\"15\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-10 16:30:42', '2015-11-13 09:43:22', 'fa9f74fc-6d9b-4e77-b008-e7af1dfa7215'),
 ('4', '1', 'Email', 'email', 'global', 'Company email address for new enquiries', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-10 16:31:12', '2015-11-10 16:31:12', '1807186f-4fa0-4254-8325-6ba8787d04ff'),
 ('5', '1', 'Twitter', 'twitter', 'global', '', '0', 'PlainText', '{\"placeholder\":\"@twitter\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-10 16:33:33', '2015-11-13 09:42:50', 'afa251ee-7fa9-4843-8a69-24a36305a710'),
 ('6', '3', 'Main Heading', 'mainHeading', 'global', 'This field is the main capitalised heading in blue', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"2\"}', '2015-11-13 09:39:39', '2015-12-08 12:02:20', '9460f936-23f9-4a32-b3b1-7810b2b650e6'),
 ('7', '3', 'Intro Paragraph', 'introParagraph', 'global', 'This is the intro paragraph under the blue text', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-13 09:40:57', '2015-12-07 09:25:41', '7d0829b4-0a12-4841-8100-ddb20a232dbb'),
 ('8', '1', 'Address', 'address', 'global', 'Company address goes here', '0', 'Matrix', '{\"maxBlocks\":\"1\"}', '2015-11-13 09:47:09', '2015-12-04 11:58:17', '150ee7b7-4c85-408f-af21-4cca3abbbbb0'),
 ('9', NULL, 'Line1', 'line1', 'matrixBlockType:1', 'Address line 1', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 09:47:10', '2015-12-04 11:58:18', '0c9dcf34-a3f9-43c8-9240-a4d0abccc6ad'),
 ('10', NULL, 'Line2', 'line2', 'matrixBlockType:1', 'Address line 2', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 09:48:49', '2015-12-04 11:58:18', '9790dad3-5bab-4e91-bc02-f5b910dcb40c'),
 ('11', NULL, 'Line3', 'line3', 'matrixBlockType:1', 'Address line 3', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 09:48:49', '2015-12-04 11:58:18', '6a1e8a11-29b2-428d-a132-ea41f76e2840'),
 ('12', NULL, 'Post Code', 'postCode', 'matrixBlockType:1', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 09:48:49', '2015-12-04 11:58:18', '0c617b25-f7b7-4988-8ad4-3c44eaac42a8'),
 ('13', '1', 'Facebook', 'facebook', 'global', 'Enter facebook page url', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 09:49:43', '2015-11-13 09:49:43', '72cc37ab-0fdc-415f-b380-7052fb747f6e'),
 ('14', '7', 'Quick Links', 'quickLinks', 'global', '', '0', 'Matrix', '{\"maxBlocks\":\"3\"}', '2015-11-13 10:01:48', '2015-11-13 10:01:48', '2d954197-4bd1-4ee5-b604-908cb05d841d'),
 ('15', NULL, 'Heading', 'heading', 'matrixBlockType:2', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"25\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 10:01:48', '2015-11-13 10:01:48', '34d9e8d3-cb85-4131-980d-490ac655b0cf'),
 ('16', NULL, 'Description', 'description', 'matrixBlockType:2', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"150\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 10:01:48', '2015-11-13 10:01:48', 'd8c77c0c-e9fd-4561-8ea6-18fbd1397e69'),
 ('17', NULL, 'Links to', 'linksTo', 'matrixBlockType:2', 'Select the page this item links to', '0', 'Dropdown', '{\"options\":[{\"label\":\"Treatments\",\"value\":\"\\/treatments\",\"default\":\"\"},{\"label\":\"Pricing\",\"value\":\"\\/pricing\",\"default\":\"\"},{\"label\":\"Testimonials\",\"value\":\"\\/testimonials\",\"default\":\"\"},{\"label\":\"About\",\"value\":\"\\/about\",\"default\":\"\"},{\"label\":\"Accreditations\",\"value\":\"\\/accreditations\",\"default\":\"\"},{\"label\":\"News\",\"value\":\"\\/news\",\"default\":\"\"},{\"label\":\"Find Us\",\"value\":\"\\/find-us\",\"default\":\"\"}]}', '2015-11-13 10:01:49', '2015-11-13 10:01:49', 'dc4f0914-a2a3-46a6-aff6-d87701b4447c'),
 ('21', '6', 'Treatment Name', 'treatmentName', 'global', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 11:18:21', '2015-11-13 11:18:21', '4b991fd1-62d7-4d11-a55e-6a62d53bdeb6'),
 ('22', '6', 'Treatment Description', 'treatmentDescription', 'global', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-13 11:18:37', '2015-12-07 11:14:24', '6d48e72b-7eaf-49b7-9a23-3dd9c69fba5a'),
 ('23', '6', 'Initial Assessment', 'initialAssessment', 'global', 'Price for Initial Assessment', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 11:34:01', '2015-11-13 11:35:00', 'b5e12ae5-5320-4c62-be92-7896e2ed739a'),
 ('24', '6', 'Subsequent Treatments', 'subsequentTreatments', 'global', 'Price for subsequent treatments', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 11:34:39', '2015-11-13 11:34:39', '1495c2a7-1345-4d27-9b24-d205774002d0'),
 ('31', '9', 'Meta Canonical', 'metaCanonical', 'global', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 14:43:31', '2015-11-13 14:43:31', '81482046-68ed-4903-9cf4-ee8acd1bed26'),
 ('32', '9', 'Meta Description', 'metaDescription', 'global', 'Enter meta description', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"160\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 14:43:46', '2015-11-13 14:43:46', '9141de12-0165-48cd-9086-983489ac160b'),
 ('33', '9', 'Meta Robots', 'metaRobots', 'global', 'You can use special HTML <meta> tags to tell search robots not to index the content of a page and/or not scan for links to follow.\r\n\'noindex\' prevents the page from being included in the index.\r\n\'nofollow\' prevents Googlebot from following any links on the page.', '0', 'RadioButtons', '{\"options\":[{\"label\":\"index, follow\",\"value\":\"INDEX, FOLLOW\",\"default\":\"1\"},{\"label\":\"noindex, follow\",\"value\":\"NOINDEX, FOLLOW\",\"default\":\"\"},{\"label\":\"index, nofollow\",\"value\":\"INDEX, NOFOLLOW\",\"default\":\"\"},{\"label\":\"noindex, nofollow\",\"value\":\"NOINDEX, NOFOLLOW\",\"default\":\"\"}]}', '2015-11-13 14:45:15', '2015-11-13 14:45:15', '2ff75076-adff-4413-b85c-f2d454942913'),
 ('34', '9', 'Meta Title', 'metaTitle', 'global', 'Enter the meta page title', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"55\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 14:45:55', '2015-11-13 14:45:55', '2286bd66-1eb9-4288-be99-7a78264aec38'),
 ('35', '9', 'Meta Keywords', 'metaKeywords', 'global', 'Enter meta keywords', '0', 'Tags', '{\"source\":\"taggroup:1\",\"selectionLabel\":\"Add a keyword\"}', '2015-11-13 14:46:33', '2015-11-13 14:46:33', 'eac8ef89-db44-4fad-a3f6-7595a53b3785'),
 ('36', '8', 'Article', 'article', 'global', 'Article body goes here', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"15\"}', '2015-11-13 14:51:01', '2015-11-13 14:51:01', '8c6d3dd2-d28e-4b92-8781-ccbdc7022782'),
 ('37', '8', 'Headline', 'headline', 'global', 'Article headline goes here', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"120\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 15:04:51', '2015-11-13 15:04:51', '48d68835-1120-4da3-bccf-728747411a2c'),
 ('38', '8', 'Article Image', 'articleImage', 'global', '', '0', 'Assets', '{\"useSingleFolder\":\"\",\"sources\":[\"folder:1\"],\"defaultUploadLocationSource\":\"1\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"1\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"1\",\"selectionLabel\":\"Add an image\"}', '2015-11-13 15:11:17', '2015-11-17 11:54:05', '4064ae28-2d32-4b8f-b4ad-dbb1e6d203c4'),
 ('39', '10', 'Principles', 'principles', 'global', 'This text appears in 3 columns underneath the intro paragraph on the \'About\' page', '0', 'Matrix', '{\"maxBlocks\":\"3\"}', '2015-11-17 11:13:43', '2015-11-17 11:13:43', 'c74e588a-5669-4c5c-a15b-a19c7c327b18'),
 ('40', NULL, 'Heading', 'heading', 'matrixBlockType:4', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-17 11:13:43', '2015-11-17 11:13:43', 'b2672dc2-f5c9-47e2-b720-7b183141739f'),
 ('41', NULL, 'Description', 'description', 'matrixBlockType:4', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"5\"}', '2015-11-17 11:13:43', '2015-11-17 11:13:43', 'ff40337e-dff3-462a-9bf5-11958a4b7f58'),
 ('42', '10', 'Profiles', 'profiles', 'global', 'Edit and add team profiles', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-11-17 11:16:05', '2015-12-04 16:37:12', '756acc88-2f32-446d-bece-4bb60fe17e17'),
 ('43', NULL, 'Heading', 'heading', 'matrixBlockType:5', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-17 11:16:06', '2015-12-04 16:37:12', '729272a1-91d2-4608-98af-aec9f766ee08'),
 ('44', NULL, 'Qualifications', 'qualifications', 'matrixBlockType:5', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-17 11:17:02', '2015-12-04 16:37:12', 'd1b4dbc9-5f49-4fd0-94be-74e8b210c372'),
 ('45', NULL, 'Biography', 'bio', 'matrixBlockType:5', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"8\"}', '2015-11-17 11:17:02', '2015-12-04 16:37:12', 'bcb7ab42-ff22-481f-aa29-b3f71328018b'),
 ('47', NULL, 'Profile photo', 'profilePhoto', 'matrixBlockType:5', '', '0', 'Assets', '{\"useSingleFolder\":\"\",\"sources\":[\"folder:6\"],\"defaultUploadLocationSource\":\"6\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"1\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"1\",\"viewMode\":\"list\",\"selectionLabel\":\"Add profile photo\"}', '2015-11-17 11:56:19', '2015-12-04 16:37:12', 'c66a0e29-a355-40c3-9061-1d026866a1c8'),
 ('48', '5', 'Testimonials', 'testimonials', 'global', '', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-11-17 15:41:07', '2015-12-04 10:33:29', '47caeb8c-4b00-4580-b35b-42d1d5d6746d'),
 ('49', NULL, 'Customer Forename', 'customerForename', 'matrixBlockType:6', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-17 15:41:07', '2015-12-04 10:33:29', 'a68bc337-2ec6-4282-b7bc-471bac51f902'),
 ('50', NULL, 'Location', 'location', 'matrixBlockType:6', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-17 15:41:08', '2015-12-04 10:33:29', '63cc5d8a-ed58-483d-8bdb-321a4c90fc0a'),
 ('51', NULL, 'Quote', 'quote', 'matrixBlockType:6', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-17 15:41:08', '2015-12-04 10:33:29', 'e24b96cc-daf8-4eab-959c-b7398cd6fb51'),
 ('52', '6', 'Add Treatments', 'addTreatments', 'global', 'Select treatments to add to this section', '0', 'Entries', '{\"sources\":[\"section:11\"],\"limit\":\"\",\"selectionLabel\":\"Add a treatment\"}', '2015-11-17 16:47:01', '2015-12-04 10:32:46', '193e8a58-c7bf-43bd-8b93-e0faaa3ef372'),
 ('53', '6', 'Treatment Image', 'treatmentImage', 'global', 'This image appears above the treatment name', '0', 'Assets', '{\"useSingleFolder\":\"\",\"sources\":[\"folder:2\"],\"defaultUploadLocationSource\":\"2\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"1\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"1\",\"selectionLabel\":\"Add an image\"}', '2015-11-17 16:48:11', '2015-11-17 16:48:11', 'b6f8b3b2-48bc-4e19-bb47-2f346bdd77f6'),
 ('54', '8', 'Article Intro', 'articleIntro', 'global', 'This is the introductory paragraph for the article and should be a brief one sentence summary - it appears in bold.', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-23 11:16:20', '2015-11-23 11:16:20', 'a6f45cf6-a9e7-4777-ab4e-ff14742f117d'),
 ('55', '1', 'Google Analytics', 'googleAnalytics', 'global', '', '0', 'PlainText', '{\"placeholder\":\"XX-XXXXXXXX-X\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-23 15:34:41', '2015-11-23 15:34:41', '591ebec1-ebda-4244-ab80-76cd7ddac989'),
 ('58', '11', 'Organisations', 'organisations', 'global', '', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-11-25 13:58:14', '2015-11-25 14:19:52', 'f48c084b-ca6d-4ae3-9ad8-9dcc841f30b4'),
 ('59', NULL, 'Organisation Logo', 'organisationLogo', 'matrixBlockType:7', '', '0', 'Assets', '{\"useSingleFolder\":\"1\",\"sources\":\"*\",\"defaultUploadLocationSource\":\"1\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"4\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"1\",\"selectionLabel\":\"Add a logo\"}', '2015-11-25 13:58:14', '2015-11-25 14:19:52', '80c76968-8fae-41a5-bb82-45d64563dae1'),
 ('60', NULL, 'Organisation Name', 'organisationName', 'matrixBlockType:7', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-25 13:58:14', '2015-11-25 14:19:52', '3ae7617f-5b77-476c-a89d-f0248ecc7b33'),
 ('61', NULL, 'Organisation Description', 'organisationDescription', 'matrixBlockType:7', 'Put the organisation in context, explaining the reasons for/advantages of this accreditation', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-25 13:58:15', '2015-11-25 14:19:53', '8c9fadbf-8f9b-482b-a81e-1044201bbc41'),
 ('62', NULL, 'Organisation Logo Reversed', 'organisationLogoReversed', 'matrixBlockType:7', 'Upload a second logo if you would like it to appear in the footer on each page. It must be a pdf with a transparent background.', '0', 'Assets', '{\"useSingleFolder\":\"1\",\"sources\":\"*\",\"defaultUploadLocationSource\":\"1\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"4\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"1\",\"selectionLabel\":\"Add a logo\"}', '2015-11-25 14:11:38', '2015-11-25 14:19:53', '4f62aeac-3cb5-4b67-b2a6-56381b21bd47'),
 ('63', '8', 'Article Sections', 'articleSections', 'global', '', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-11-26 14:08:07', '2015-12-04 15:36:20', '988380d0-fb85-4966-89ff-ee805542e1cb'),
 ('64', NULL, 'Section Heading', 'sectionHeading', 'matrixBlockType:8', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"100\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-26 14:08:07', '2015-12-04 15:36:21', '1ffbf149-abeb-4ece-affe-5b2d33e36738'),
 ('65', NULL, 'Section Paragraph', 'sectionParagraph', 'matrixBlockType:8', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-26 14:08:08', '2015-12-04 15:36:21', '493eaf11-1268-4662-bde4-f47f0411eb64'),
 ('66', '8', 'Sidebar info', 'sidebarInfo', 'global', '', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-11-26 14:23:00', '2015-11-26 14:23:00', '6809d506-8f13-4d4a-87ec-750a274810d5'),
 ('67', NULL, 'Heading', 'heading', 'matrixBlockType:9', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"30\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-26 14:23:00', '2015-11-26 14:23:00', '7f741802-a798-4e5b-b871-5afd0c595459'),
 ('68', NULL, 'Paragraph', 'paragraph', 'matrixBlockType:9', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-26 14:23:00', '2015-11-26 14:23:00', '362a187f-e262-4f15-a479-d6311809b3f1'),
 ('69', '8', 'References', 'references', 'global', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-26 14:59:48', '2015-11-26 14:59:48', '7eb0e52e-bce1-4e98-a0a4-d787b2f11a64'),
 ('70', '6', 'Description', 'sections', 'global', '', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-12-01 09:49:09', '2015-12-04 10:33:01', '0b03e9e4-7492-404b-8846-a64c4b2c98ed'),
 ('71', NULL, 'Section Heading', 'sectionHeading', 'matrixBlockType:10', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-12-01 09:49:10', '2015-12-04 10:33:01', 'e037ab1a-9813-4c6b-a365-44af8a91d797'),
 ('72', NULL, 'Section Paragraph', 'sectionParagraph', 'matrixBlockType:10', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-12-01 09:49:10', '2015-12-04 10:33:01', '661933ac-56e5-4b81-b96e-2ab114825e85'),
 ('73', '1', 'Initial Assessments Cost', 'initialAssess', 'global', 'The global value for initial assessments (you can override this in the individual treatments)', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-12-04 10:03:35', '2015-12-04 10:03:35', '7a712c35-7dd1-4e59-8d3b-30ce4b8dd5dd'),
 ('74', '1', 'Subsequent Treatments Cost', 'subsequentTreat', 'global', 'The global value for subsequent treatments (you can override this in the individual treatments)', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-12-04 10:04:25', '2015-12-04 10:04:49', 'fee0e6c4-d51d-47b0-9f9e-a99e32ed2c12'),
 ('75', NULL, 'Line 4', 'line4', 'matrixBlockType:1', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-12-04 11:58:18', '2015-12-04 11:58:18', '9a1a31f9-c263-4381-922f-0071e33a0d88'),
 ('76', '8', 'Sidebar Display', 'sidebarDisplay', 'global', 'Check this box to display the sidebar at the bottom of the article', '0', 'Checkboxes', '{\"options\":[{\"label\":\"Display side at bottom of article\",\"value\":\"true\",\"default\":\"\"}]}', '2015-12-04 15:33:00', '2015-12-04 15:33:00', 'c8de1f21-0126-4b88-9299-6eaa7ccdb756'),
 ('77', '8', 'Links Section', 'linksSection', 'global', 'Add any useful links you would like to appear at the bottom of the section', '0', 'Table', '{\"columns\":{\"col1\":{\"heading\":\"Link Title\",\"handle\":\"linkTitle\",\"width\":\"\",\"type\":\"singleline\"},\"col2\":{\"heading\":\"Link URL\",\"handle\":\"linkUrl\",\"width\":\"\",\"type\":\"singleline\"}},\"defaults\":{\"row1\":{\"col1\":\"\",\"col2\":\"\"}}}', '2015-12-04 15:34:08', '2015-12-04 15:34:08', '23cff1ac-2e0f-4c06-9b0a-57fb77a196d7'),
 ('78', NULL, 'Section Image', 'sectionImage', 'matrixBlockType:8', '', '0', 'Assets', '{\"useSingleFolder\":\"\",\"sources\":[\"folder:1\"],\"defaultUploadLocationSource\":\"1\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"1\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"1\",\"viewMode\":\"large\",\"selectionLabel\":\"Add an image\"}', '2015-12-04 15:36:21', '2015-12-04 15:36:21', 'c1121c9f-51ea-42f6-a7e5-a69a971adeb1'),
 ('79', NULL, 'Photo Position', 'photoPosition', 'matrixBlockType:8', '', '0', 'Checkboxes', '{\"options\":[{\"label\":\"Display photo under section\",\"value\":\"true\",\"default\":\"\"}]}', '2015-12-04 15:36:21', '2015-12-04 15:36:21', '2001dd37-b457-47b4-9094-d631e7c056df'),
 ('80', '3', 'Photos', 'photos', 'global', '', '0', 'Assets', '{\"useSingleFolder\":\"\",\"sources\":[\"folder:5\"],\"defaultUploadLocationSource\":\"5\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"1\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"3\",\"viewMode\":\"large\",\"selectionLabel\":\"Add an image\"}', '2015-12-04 15:48:52', '2015-12-07 17:14:06', 'bfee58ae-77d9-40ea-9d83-90643bb89da1'),
 ('81', '3', 'Gallery', 'gallery', 'global', '', '0', 'Assets', '{\"useSingleFolder\":\"\",\"sources\":[\"folder:5\"],\"defaultUploadLocationSource\":\"5\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"1\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"\",\"limit\":\"\",\"viewMode\":\"large\",\"selectionLabel\":\"Add an image\"}', '2015-12-04 15:49:28', '2015-12-04 15:49:28', 'd044b749-a387-4ad6-b9b2-d617c729804f'),
 ('82', '8', 'Images Position', 'imagesPosition', 'global', 'Check this box to display the images at the bottom of the article', '0', 'Lightswitch', '{\"default\":\"\"}', '2015-12-07 12:25:15', '2015-12-07 14:08:41', '38445b9b-527f-4876-8126-8fae8c569c61');



DROP TABLE IF EXISTS `craft_globalsets`;


--
-- Schema for table `craft_globalsets`
--
CREATE TABLE `craft_globalsets` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fieldLayoutId` int(10) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_globalsets_name_unq_idx` (`name`),
  UNIQUE KEY `craft_globalsets_handle_unq_idx` (`handle`),
  KEY `craft_globalsets_fieldLayoutId_fk` (`fieldLayoutId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_globalsets`
--

INSERT INTO `craft_globalsets` (`id`, `name`, `handle`, `fieldLayoutId`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('7', 'General info', 'generalInfo', '122', '2015-11-10 16:28:51', '2015-12-04 10:05:14', 'e93a49b5-83bd-439f-90f9-a062bb787de6'),
 ('43', 'Repeated Sections', 'repeatedSections', '33', '2015-11-13 12:54:44', '2015-11-13 12:54:54', '0cbebc7a-d67d-4038-a96d-b4f6e713d23a');



DROP TABLE IF EXISTS `craft_info`;


--
-- Schema for table `craft_info`
--
CREATE TABLE `craft_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `build` int(11) unsigned NOT NULL,
  `schemaVersion` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `releaseDate` datetime NOT NULL,
  `edition` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `siteName` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `siteUrl` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `timezone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `on` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `maintenance` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `track` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_info`
--

INSERT INTO `craft_info` (`id`, `version`, `build`, `schemaVersion`, `releaseDate`, `edition`, `siteName`, `siteUrl`, `timezone`, `on`, `maintenance`, `track`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '2.5', '2757', '2.5.11', '2016-01-06 21:51:21', '1', 'Cathedral Physiotherapy', 'http://www.cathedralphysiotherapy.co.uk', 'Europe/London', '1', '1', 'stable', '2015-11-04 11:36:26', '2016-02-09 22:02:22', '50676890-2f25-46c2-8996-e4e88e74c44a');



DROP TABLE IF EXISTS `craft_locales`;


--
-- Schema for table `craft_locales`
--
CREATE TABLE `craft_locales` (
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`locale`),
  KEY `craft_locales_sortOrder_idx` (`sortOrder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_locales`
--

INSERT INTO `craft_locales` (`locale`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('en_gb', '1', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '0934c33b-9c71-4f24-a565-42850311e078');



DROP TABLE IF EXISTS `craft_matrixblocks`;


--
-- Schema for table `craft_matrixblocks`
--
CREATE TABLE `craft_matrixblocks` (
  `id` int(11) NOT NULL,
  `ownerId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `typeId` int(11) DEFAULT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `ownerLocale` char(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_matrixblocks_ownerId_idx` (`ownerId`),
  KEY `craft_matrixblocks_fieldId_idx` (`fieldId`),
  KEY `craft_matrixblocks_typeId_idx` (`typeId`),
  KEY `craft_matrixblocks_sortOrder_idx` (`sortOrder`),
  KEY `craft_matrixblocks_ownerLocale_fk` (`ownerLocale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixblocks`
--

INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('42', '7', '8', '1', '1', NULL, '2015-11-13 12:54:30', '2015-12-04 22:09:30', '20953397-c477-4383-9bbc-0b8f20f46806'),
 ('44', '43', '14', '2', '1', NULL, '2015-11-13 12:57:48', '2015-12-04 17:02:38', '54c61c3e-7cb2-4456-b08e-0014db9799ec'),
 ('45', '43', '14', '2', '2', NULL, '2015-11-13 12:57:48', '2015-12-04 17:02:38', '144dbcfb-1bb5-43ab-9f40-8b520504e9c6'),
 ('46', '43', '14', '2', '3', NULL, '2015-11-13 12:57:48', '2015-12-04 17:02:38', 'e0fb0e17-da48-43ba-9544-56eaaee7dd58'),
 ('52', '4', '39', '4', '1', NULL, '2015-11-17 11:20:23', '2015-12-08 17:18:10', '278083af-6393-4081-88bd-6368c9efe0ce'),
 ('53', '4', '39', '4', '2', NULL, '2015-11-17 11:20:23', '2015-12-08 17:18:10', '9219d4d9-20f8-4cdf-be52-d9dd5900812d'),
 ('54', '4', '39', '4', '3', NULL, '2015-11-17 11:20:23', '2015-12-08 17:18:10', 'b3d03740-db1b-4845-aa72-ebb1b3afa780'),
 ('55', '4', '42', '5', '1', NULL, '2015-11-17 11:20:23', '2015-12-08 17:18:10', '3c994bd2-e134-41b5-9e31-3948713327c1'),
 ('59', '58', '48', '6', '1', NULL, '2015-11-17 15:45:10', '2015-12-08 19:25:20', 'dd4061cc-670b-4cbc-b4e6-412108d38e44'),
 ('60', '58', '48', '6', '2', NULL, '2015-11-17 15:45:10', '2015-12-08 19:25:20', '5a16367a-4044-463b-b5ed-06c3a2438e1b'),
 ('74', '58', '48', '6', '3', NULL, '2015-11-24 16:38:18', '2015-12-08 19:25:20', 'f6d5efc5-3690-4e8f-9db1-a76a478f6c00'),
 ('75', '58', '48', '6', '4', NULL, '2015-11-24 16:38:18', '2015-12-08 19:25:20', '12e31d4c-70f5-4242-ac4c-a66e5bef786b'),
 ('85', '5', '58', '7', '1', NULL, '2015-11-25 14:09:00', '2015-12-08 17:18:33', '145e738c-dacc-40a9-bdfd-f1145a3a9114'),
 ('86', '5', '58', '7', '2', NULL, '2015-11-25 14:09:00', '2015-12-08 17:18:33', '4fef6fe3-396f-41a4-9d56-d1ded68c53ba'),
 ('87', '5', '58', '7', '3', NULL, '2015-11-25 14:09:00', '2015-12-08 17:18:33', '4a0804be-b44c-4373-ad0e-8c8129b3a6bf'),
 ('88', '5', '58', '7', '5', NULL, '2015-11-25 14:09:00', '2015-12-08 17:18:33', '34dc1371-4c42-4235-9edb-259e190f3f74'),
 ('98', '5', '58', '7', '4', NULL, '2015-11-26 11:46:49', '2015-12-08 17:18:33', '19e7758e-9ae0-4953-afa7-2308cbf5d33a'),
 ('101', '99', '63', '8', '1', NULL, '2015-11-26 14:30:34', '2015-12-08 21:26:02', '3db95ca8-5dd9-4999-8728-a14669a034f4'),
 ('102', '99', '63', '8', '2', NULL, '2015-11-26 14:30:34', '2015-12-08 21:26:02', 'af2c4cf3-78ff-4b58-8eca-d172a1bd41a4'),
 ('103', '99', '63', '8', '3', NULL, '2015-11-26 14:30:34', '2015-12-08 21:26:02', '10c5f8f0-837a-4b59-8dd1-fcbb68c734ae'),
 ('104', '99', '63', '8', '4', NULL, '2015-11-26 14:30:34', '2015-12-08 21:26:02', '2c5b6682-c33a-435d-b1a7-385913a2e93e'),
 ('105', '99', '66', '9', '1', NULL, '2015-11-26 14:46:03', '2015-12-08 21:26:02', 'd68583de-eb79-4e06-a3cb-a7ef057d4227'),
 ('106', '99', '66', '9', '2', NULL, '2015-11-26 14:46:03', '2015-12-08 21:26:02', '07b21e49-a637-4ecc-9e14-e1fb9af69bc4'),
 ('107', '99', '66', '9', '3', NULL, '2015-11-26 14:46:03', '2015-12-08 21:26:02', 'e933bc3c-df06-41e0-a947-82a6fde5578c'),
 ('108', '99', '66', '9', '4', NULL, '2015-11-26 14:46:03', '2015-12-08 21:26:02', 'ecaf0d8f-1cf2-4385-97bc-0f55e78a2415'),
 ('110', '109', '63', '8', '1', NULL, '2015-11-30 09:23:58', '2015-12-08 21:25:20', '4abce45a-8793-455c-9aef-52b311d46689'),
 ('111', '109', '63', '8', '2', NULL, '2015-11-30 09:23:58', '2015-12-08 21:25:20', '2e2d8711-9d0b-4acf-b449-e07e48b4dba4'),
 ('121', '63', '70', '10', '1', NULL, '2015-12-01 09:52:45', '2015-12-08 17:19:19', '5e72e1b6-6b5f-4010-b9dc-11199d67a700'),
 ('122', '63', '70', '10', '2', NULL, '2015-12-01 09:52:45', '2015-12-08 17:19:19', '5410dbf3-6d8f-4998-a2e8-648051ae00a2'),
 ('123', '63', '70', '10', '3', NULL, '2015-12-01 09:52:45', '2015-12-08 17:19:19', '833e85f3-3d9a-40e0-ba95-c614e1648c26'),
 ('126', '61', '70', '10', '1', NULL, '2015-12-02 11:49:33', '2015-12-08 17:23:51', 'a60defd3-1e29-4704-a676-0b130ce6575c'),
 ('127', '61', '70', '10', '2', NULL, '2015-12-02 11:50:18', '2015-12-08 17:23:51', 'b8d366df-1fd2-4401-8680-313dead3de3f'),
 ('128', '61', '70', '10', '3', NULL, '2015-12-02 11:50:18', '2015-12-08 17:23:51', '65d281d4-152c-41a8-bb90-c45342587ab4'),
 ('129', '62', '70', '10', '1', NULL, '2015-12-02 11:51:02', '2016-01-07 11:47:25', 'c1538fe6-c0ad-4ebb-a1aa-2ed0985d66d7'),
 ('130', '62', '70', '10', '2', NULL, '2015-12-02 11:51:02', '2016-01-07 11:47:25', '90e12ab2-bce7-4c97-ab72-140a5f765f34'),
 ('131', '62', '70', '10', '3', NULL, '2015-12-02 11:51:02', '2016-01-07 11:47:25', '96bcfcd1-49da-4e01-b457-cd599622a9b0'),
 ('142', '141', '63', '8', '1', NULL, '2015-12-04 22:25:11', '2015-12-08 21:24:19', 'a655d1d0-8588-4dc3-8e2d-5c8a07ab25e7'),
 ('143', '141', '63', '8', '2', NULL, '2015-12-04 22:25:11', '2015-12-08 21:24:20', 'ae9b31c8-ce8f-4192-a3dc-80d92c9bd2c1'),
 ('144', '141', '66', '9', '1', NULL, '2015-12-04 22:25:11', '2015-12-08 21:24:20', 'ecfbca66-fe13-41e1-bbb4-690601a8d5ac'),
 ('145', '141', '66', '9', '2', NULL, '2015-12-04 22:25:11', '2015-12-08 21:24:20', '90f8e31b-e734-46ec-bfab-debf9dcb1b90'),
 ('146', '141', '66', '9', '3', NULL, '2015-12-04 22:25:11', '2015-12-08 21:24:21', '588554ef-cd68-45cd-b721-e5a2f890f7d7'),
 ('147', '141', '66', '9', '4', NULL, '2015-12-04 22:25:11', '2015-12-08 21:24:21', '5ce88543-80aa-47cb-a014-884adc1a4d03'),
 ('148', '141', '66', '9', '5', NULL, '2015-12-04 22:25:11', '2015-12-08 21:24:21', 'b55b2dae-553a-47ad-a6e7-3fea92badff2'),
 ('191', '141', '63', '8', '3', NULL, '2015-12-07 14:53:05', '2015-12-08 21:24:20', 'b891c219-e15b-49fe-b94a-0cdaef8c39c2'),
 ('192', '141', '63', '8', '4', NULL, '2015-12-07 14:53:05', '2015-12-08 21:24:20', '74f07fc1-c45d-4d45-a912-93113ea05c63'),
 ('225', '58', '48', '6', '5', NULL, '2015-12-07 17:03:11', '2015-12-08 19:25:20', '3e94fb7b-ce31-4084-b438-4234cec06969'),
 ('351', '58', '48', '6', '6', NULL, '2015-12-08 19:13:43', '2015-12-08 19:25:20', 'c1fbe1d8-8898-4431-8b1d-bc307ae90c0f'),
 ('357', '356', '63', '8', '1', NULL, '2016-01-07 12:08:52', '2016-01-12 11:35:55', '39a17fca-027a-40ec-a95b-c74edbb8353e'),
 ('368', '367', '63', '8', '1', NULL, '2016-02-09 22:01:41', '2016-02-09 22:01:55', '8883fd0b-f99b-4a94-b5c5-f266f713bdf7'),
 ('369', '367', '63', '8', '2', NULL, '2016-02-09 22:01:41', '2016-02-09 22:01:55', 'f4da38fd-649f-4406-8137-912623c68e7e'),
 ('370', '367', '63', '8', '3', NULL, '2016-02-09 22:01:41', '2016-02-09 22:01:55', '86812287-9256-4ee1-a1e3-1e38f19fa367'),
 ('371', '367', '63', '8', '4', NULL, '2016-02-09 22:01:41', '2016-02-09 22:01:55', 'f21ff2c9-e0d5-48eb-95b4-27333f3ee9ed');



DROP TABLE IF EXISTS `craft_matrixblocktypes`;


--
-- Schema for table `craft_matrixblocktypes`
--
CREATE TABLE `craft_matrixblocktypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixblocktypes_name_fieldId_unq_idx` (`name`,`fieldId`),
  UNIQUE KEY `craft_matrixblocktypes_handle_fieldId_unq_idx` (`handle`,`fieldId`),
  KEY `craft_matrixblocktypes_fieldId_fk` (`fieldId`),
  KEY `craft_matrixblocktypes_fieldLayoutId_fk` (`fieldLayoutId`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixblocktypes`
--

INSERT INTO `craft_matrixblocktypes` (`id`, `fieldId`, `fieldLayoutId`, `name`, `handle`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '8', '131', 'Address Lines', 'addressLines', '1', '2015-11-13 09:47:09', '2015-12-04 11:58:18', '255d7c85-fcd4-44ab-9fc7-78f93e6782f6'),
 ('2', '14', '17', 'Quick Link', 'quickLink', '1', '2015-11-13 10:01:48', '2015-11-13 10:01:49', '1a3a44fc-bbcb-4c85-8abc-c0be740317d5'),
 ('4', '39', '64', 'Column', 'column', '1', '2015-11-17 11:13:43', '2015-11-17 11:13:44', '906b89dd-5b7d-414c-9ad1-ae8f10328c81'),
 ('5', '42', '142', 'Profile', 'profile', '1', '2015-11-17 11:16:06', '2015-12-04 16:37:12', 'f70e7e2e-b332-4912-b571-ccf584d5320c'),
 ('6', '48', '130', 'Testimonial', 'testimonial', '1', '2015-11-17 15:41:07', '2015-12-04 10:33:29', 'b020ae60-cf00-4954-b7dd-2de4debe9067'),
 ('7', '58', '106', 'Organisation', 'organisation', '1', '2015-11-25 13:58:14', '2015-11-25 14:19:53', '6d13b7b7-2b83-4cf4-90b5-d7ec29a88ffe'),
 ('8', '63', '133', 'Article section', 'articleSection', '1', '2015-11-26 14:08:07', '2015-12-04 15:36:21', '207ac506-5f9c-4003-ac1e-f2ad6ba78709'),
 ('9', '66', '110', 'Sidebar section', 'sidebarSection', '1', '2015-11-26 14:23:00', '2015-11-26 14:23:00', 'b83a7770-57d2-4480-af04-0d1428280f1f'),
 ('10', '70', '129', 'Section', 'mainBody', '1', '2015-12-01 09:49:10', '2015-12-04 10:33:01', '61b45393-dc87-448b-802e-7369c1e7bed1');



DROP TABLE IF EXISTS `craft_matrixcontent_address`;


--
-- Schema for table `craft_matrixcontent_address`
--
CREATE TABLE `craft_matrixcontent_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_addressLines_line1` text COLLATE utf8_unicode_ci,
  `field_addressLines_line2` text COLLATE utf8_unicode_ci,
  `field_addressLines_line3` text COLLATE utf8_unicode_ci,
  `field_addressLines_postCode` text COLLATE utf8_unicode_ci,
  `field_addressLines_line4` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_address_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_address_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_address`
--

INSERT INTO `craft_matrixcontent_address` (`id`, `elementId`, `locale`, `field_addressLines_line1`, `field_addressLines_line2`, `field_addressLines_line3`, `field_addressLines_postCode`, `field_addressLines_line4`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '42', 'en_gb', 'Lower Ground Floor', '22 Southernhay West', 'Southernhay', 'EX1 1PR', 'Exeter', '2015-11-13 12:54:30', '2015-12-04 22:09:30', '99d141ad-190f-4202-9b5d-31b512df4780');



DROP TABLE IF EXISTS `craft_matrixcontent_articlesections`;


--
-- Schema for table `craft_matrixcontent_articlesections`
--
CREATE TABLE `craft_matrixcontent_articlesections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_articleSection_sectionHeading` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_articleSection_sectionParagraph` text COLLATE utf8_unicode_ci,
  `field_articleSection_photoPosition` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_articlesections_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_articlesections_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_articlesections`
--

INSERT INTO `craft_matrixcontent_articlesections` (`id`, `elementId`, `locale`, `field_articleSection_sectionHeading`, `field_articleSection_sectionParagraph`, `field_articleSection_photoPosition`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('2', '101', 'en_gb', '', 'Well the first thing to say is ‘Don’t panic!’. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered ‘non-specific’ (O’Sullivan and Lin, 2014).', '', '2015-11-26 14:30:34', '2015-12-08 21:26:01', '1e5d002d-b708-430c-9d43-eeaf05558a23'),
 ('3', '102', 'en_gb', 'What have I done?', 'Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a ‘twisted ankle’, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O’Sullivan and Lin, 2014).\r\n', '', '2015-11-26 14:30:34', '2015-12-08 21:26:02', '6cbd2e34-6927-4ce7-a730-2909bb57614e'),
 ('4', '103', 'en_gb', 'Do I need a scan?', 'The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of ‘abnormal findings’ on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become ‘defined by your diagnosis’, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!', '', '2015-11-26 14:30:34', '2015-12-08 21:26:02', '559ff0f8-c55d-41d5-b4ca-94361520b352'),
 ('5', '104', 'en_gb', 'Should I see a doctor?', 'The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven’t improved within the expected time frames, or if you are struggling to stay in work or return to your sport.\r\n\r\nIt is worth seeing your GP if you are needing more effective pain relief, but don’t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\r\n\r\nIf you have any further questions, or wish to have a session with our physiotherapist, please don’t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk', '', '2015-11-26 14:30:34', '2015-12-08 21:26:02', '3b43ed18-6fa9-4ae8-8c95-25fdb098c7a1'),
 ('6', '110', 'en_gb', '', 'This November an article was published in Gerontology, reported in the media, which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect – is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \r\n\r\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways – heart, lungs, blood pressure, mental health, bone strength….. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point. \r\n\r\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on….give the family an exercise make over this year…..who knows, you might be reaping the benefits on those crosswords in years to come!', '', '2015-11-30 09:23:58', '2015-12-08 21:25:20', 'e7dd621d-4114-495a-aa2a-909a68d64311'),
 ('7', '111', 'en_gb', '', '', '', '2015-11-30 09:23:58', '2015-12-08 21:25:20', '4730f919-6c69-4534-88c9-0f1957d07fb2'),
 ('13', '142', 'en_gb', 'We\'ve all done it.......', 'Whether it was wearing those killer heels when you are used to wearing flats, slipping whilst running down a hill, or simply tripping over the kids left out toys, the majority of us have twisted an ankle or knee at some point in our lives! The key is how to improve the situation once it’s occurred, and following a few simple steps will help you get back to normal again.', '', '2015-12-04 22:25:11', '2015-12-08 21:24:19', '6522901c-8230-4400-a2b1-67f80d285c4a'),
 ('14', '143', 'en_gb', 'PRICE', 'No not linked to the cost of the injury, merely a pneumonic (see grey box) to help you remember what to do…..Most minor injuries can be improved at home following this simple advice and taking over the counter medication. Ultrasound and taping can also promote healing, and if you have concerns regarding prevention of recurrence or timescales for return to sport (or when you can put your dancing shoes back on) then contact us on enquiries@cathedralphysiotherapy.co.uk. ', '', '2015-12-04 22:25:11', '2015-12-08 21:24:19', '5f149369-2c6f-46f4-82fd-0c0ab36fb7ba'),
 ('18', '191', 'en_gb', '', '', '', '2015-12-07 14:53:05', '2015-12-08 21:24:20', '85ee482d-1e12-4ae4-bbfc-0b252360b02a'),
 ('19', '192', 'en_gb', '', '', '', '2015-12-07 14:53:05', '2015-12-08 21:24:20', 'e1cd2b78-c43b-4465-b19c-a237064b1143'),
 ('21', '357', 'en_gb', 'To receive the discount simply:', 'Highlight at the time of booking that you are a member of the Spa Naturel Fitness at the Mercure Hotel Southgate.\r\n\r\nBring proof of membership to your initial appointment.', '', '2016-01-07 12:08:51', '2016-01-12 11:35:55', 'fd71c5ee-a7fb-46ed-98f6-6abe6b963f48'),
 ('22', '368', 'en_gb', '', 'Cathedral Physiotherapy is pleased to announce that is has obtained \'Approved Provider\' status for a variety of private health insurance companies including Bupa, WPA, MDG and Vitality health (previously known as Prudential Health). This means that individuals who have health insurance cover with policies that include physiotherapy, may be able to claim the cost of treatment under their policy (see your specific policy for details). If you have health insurance with a company not listed here then please contact the clinic, as we may still be able to treat you under this agreement, and if not then we are happy to treat you independently under our usual pricing system.', '[\"true\"]', '2016-02-09 22:01:41', '2016-02-09 22:01:55', 'a1337449-2c1c-44da-a814-43c82e806df5'),
 ('23', '369', 'en_gb', '', '', '', '2016-02-09 22:01:41', '2016-02-09 22:01:55', '4145b8b4-13dc-4abf-b0fb-73e098244693'),
 ('24', '370', 'en_gb', '', '', '', '2016-02-09 22:01:41', '2016-02-09 22:01:55', 'f79d3665-033d-41cb-bc04-bab27a4e5cbf'),
 ('25', '371', 'en_gb', '', '', '', '2016-02-09 22:01:41', '2016-02-09 22:01:55', '01aac34e-ce67-4b41-8f64-2cd50c78d1e9');



DROP TABLE IF EXISTS `craft_matrixcontent_organisations`;


--
-- Schema for table `craft_matrixcontent_organisations`
--
CREATE TABLE `craft_matrixcontent_organisations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_organisation_organisationName` text COLLATE utf8_unicode_ci,
  `field_organisation_organisationDescription` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_organisations_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_organisations_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_organisations`
--

INSERT INTO `craft_matrixcontent_organisations` (`id`, `elementId`, `locale`, `field_organisation_organisationName`, `field_organisation_organisationDescription`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '85', 'en_gb', 'Chartered Society of Physiotherapy', 'A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http://www.csp.org.uk/your-health/find-physio/choose-chartered', '2015-11-25 14:09:00', '2015-12-08 17:18:33', 'e00b72ac-28ad-489f-80a6-9a0d46116dc2'),
 ('2', '86', 'en_gb', 'British Medical Acupuncture Society', 'The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.', '2015-11-25 14:09:00', '2015-12-08 17:18:33', '984a6a9d-6783-4d6d-9987-244d5599b9fd'),
 ('3', '87', 'en_gb', 'Health Professionals Council', 'The HCPC’s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants’ education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.', '2015-11-25 14:09:00', '2015-12-08 17:18:33', 'd07d2d60-f15d-474b-8902-93f78ca5fec3'),
 ('4', '88', 'en_gb', 'Physio First', 'Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.', '2015-11-25 14:09:00', '2015-12-08 17:18:33', '37284fb2-8c67-42ff-8668-6d387014b9fb'),
 ('5', '98', 'en_gb', 'Musculoskeletal Association of Chartered Physiotherapists', 'The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\r\n\r\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).', '2015-11-26 11:46:49', '2015-12-08 17:18:33', 'b50436b9-7e10-4ef5-8093-3bbffb0d8327');



DROP TABLE IF EXISTS `craft_matrixcontent_principles`;


--
-- Schema for table `craft_matrixcontent_principles`
--
CREATE TABLE `craft_matrixcontent_principles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_column_heading` text COLLATE utf8_unicode_ci,
  `field_column_description` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_principles_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_principles_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_principles`
--

INSERT INTO `craft_matrixcontent_principles` (`id`, `elementId`, `locale`, `field_column_heading`, `field_column_description`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '52', 'en_gb', 'Excellence', 'Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.', '2015-11-17 11:20:23', '2015-12-08 17:18:10', '6b0b1d30-23db-442c-91e0-16361491c7d3'),
 ('2', '53', 'en_gb', 'Experience', 'Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. The last 12 in which she worked as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, prior to running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.', '2015-11-17 11:20:23', '2015-12-08 17:18:10', '1c6fef41-aa77-4ceb-b963-ddee829fcf38'),
 ('3', '54', 'en_gb', 'Enthusiasm', 'Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.', '2015-11-17 11:20:23', '2015-12-08 17:18:10', 'cd43e4a5-3904-4edd-b205-a14729b8fc23');



DROP TABLE IF EXISTS `craft_matrixcontent_profiles`;


--
-- Schema for table `craft_matrixcontent_profiles`
--
CREATE TABLE `craft_matrixcontent_profiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_profile_heading` text COLLATE utf8_unicode_ci,
  `field_profile_qualifications` text COLLATE utf8_unicode_ci,
  `field_profile_bio` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_profiles_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_profiles_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_profiles`
--

INSERT INTO `craft_matrixcontent_profiles` (`id`, `elementId`, `locale`, `field_profile_heading`, `field_profile_qualifications`, `field_profile_bio`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '55', 'en_gb', 'About Sarah Moore', 'BSc (Hons)', 'After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\r\n\r\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy –a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women’s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\r\n\r\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute for Health Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\r\n\r\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio’s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and auditing a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct – a physiotherapy advice line.\r\n\r\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.', '2015-11-17 11:20:23', '2015-12-08 17:18:10', '8f492b83-2a41-406a-a661-7640d133d282');



DROP TABLE IF EXISTS `craft_matrixcontent_quicklinks`;


--
-- Schema for table `craft_matrixcontent_quicklinks`
--
CREATE TABLE `craft_matrixcontent_quicklinks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_quickLink_heading` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_quickLink_description` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_quickLink_linksTo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_quicklinks_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_quicklinks_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_quicklinks`
--

INSERT INTO `craft_matrixcontent_quicklinks` (`id`, `elementId`, `locale`, `field_quickLink_heading`, `field_quickLink_description`, `field_quickLink_linksTo`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '44', 'en_gb', 'Treatments', 'We specialise in complex conditions, but are equally happy to treat any musculoskeletal problem. Click on a description to see how we can help', '/treatments', '2015-11-13 12:57:48', '2015-12-04 17:02:38', '2e053511-5024-45d3-9426-f731626707ad'),
 ('2', '45', 'en_gb', 'About', 'Cathedral Physiotherapy offers 18 years of experience, excellence demonstrated by an MSc and MMACP, and enthusiasm for the personal approach...', '/about', '2015-11-13 12:57:48', '2015-12-04 17:02:38', '314059a2-2fe3-495e-a11d-26e904f782f7'),
 ('3', '46', 'en_gb', 'Accreditations', 'To ensure your safety, Cathedral Physiotherapy is regulated and governed by the following bodies...', '/accreditations', '2015-11-13 12:57:48', '2015-12-04 17:02:38', '4c8d5d00-f7fd-4da1-85a5-5480d3880b64');



DROP TABLE IF EXISTS `craft_matrixcontent_sections`;


--
-- Schema for table `craft_matrixcontent_sections`
--
CREATE TABLE `craft_matrixcontent_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_mainBody_sectionHeading` text COLLATE utf8_unicode_ci,
  `field_mainBody_sectionParagraph` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_sections_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_sections_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_sections`
--

INSERT INTO `craft_matrixcontent_sections` (`id`, `elementId`, `locale`, `field_mainBody_sectionHeading`, `field_mainBody_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '121', 'en_gb', 'Initial assessments', 'Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top/T-shirt and shorts as you will need to remove some items of clothing. \r\n\r\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (acupuncture, mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.', '2015-12-01 09:52:45', '2015-12-08 17:19:19', 'c3dde3da-4be9-470a-aa71-98be8eb68251'),
 ('2', '122', 'en_gb', 'Follow up treatments', 'Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\r\n', '2015-12-01 09:52:45', '2015-12-08 17:19:19', '891e4eac-b21a-472c-a69f-93a4b9ef0ce8'),
 ('3', '123', 'en_gb', 'Acupuncture', 'If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.', '2015-12-01 09:52:45', '2015-12-08 17:19:19', '133fcf96-80b9-48cf-a35b-b88b904b3f72'),
 ('4', '126', 'en_gb', 'Initial assessments', 'Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top/T-shirt and shorts as you will need to remove some items of clothing. \r\n\r\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.', '2015-12-02 11:49:33', '2015-12-08 17:23:51', 'a19f572e-5c34-4eaa-960a-08d6f3933210'),
 ('5', '127', 'en_gb', 'Follow up treatments', 'Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.', '2015-12-02 11:50:18', '2015-12-08 17:23:51', 'a3b893ec-f8b8-4591-bd26-351f107f2a8d'),
 ('6', '128', 'en_gb', 'Acupuncture', 'If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.', '2015-12-02 11:50:18', '2015-12-08 17:23:51', 'f597322c-1848-41fb-8216-3fb040ec2b5d'),
 ('7', '129', 'en_gb', 'Initial assessments', 'Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top/T-shirt and shorts as you will need to remove some items of clothing. \r\n\r\nFollowing the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.', '2015-12-02 11:51:02', '2016-01-07 11:47:24', '2b79e1fb-e2dc-4641-8804-607efb2ebe99'),
 ('8', '130', 'en_gb', 'Follow up treatments', 'Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\r\n', '2015-12-02 11:51:02', '2016-01-07 11:47:25', '560039c9-529b-447f-8338-45039e7f4245'),
 ('9', '131', 'en_gb', 'Acupuncture', 'If you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.', '2015-12-02 11:51:02', '2016-01-07 11:47:25', '86ded130-0327-4ec7-b9a5-f37d3a296e74');



DROP TABLE IF EXISTS `craft_matrixcontent_sidebarinfo`;


--
-- Schema for table `craft_matrixcontent_sidebarinfo`
--
CREATE TABLE `craft_matrixcontent_sidebarinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_sidebarSection_heading` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_sidebarSection_paragraph` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_sidebarinfo_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_sidebarinfo_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_sidebarinfo`
--

INSERT INTO `craft_matrixcontent_sidebarinfo` (`id`, `elementId`, `locale`, `field_sidebarSection_heading`, `field_sidebarSection_paragraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES
 ('1', '105', 'en_gb', 'Active Rest', 'In the initial stages it is important that you have ‘active rest’. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe t